/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.xsp.impl.v1;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.common.utils.DomUtils;
import au.gov.nehta.xsp.KeyMismatchException;
import au.gov.nehta.xsp.XmlEncryptionProfileService;
import au.gov.nehta.xsp.XspException;
import au.gov.nehta.xsp.impl.CertificateUtils;
import au.gov.nehta.xsp.impl.TextUtils;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.x500.X500PrivateCredential;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.EncryptionMethod;
import org.apache.xml.security.encryption.Reference;
import org.apache.xml.security.encryption.ReferenceList;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509SKI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlEncryptionProfileServiceImpl
implements XmlEncryptionProfileService {
    static final /* synthetic */ boolean $assertionsDisabled;

    @Override
    public void encrypt(Element elementToAddEncKeysTo, Element elementToEncrypt, X509Certificate certificate) throws XspException {
        ArgumentUtils.checkNotNull((Object)elementToEncrypt, (String)"elementToEncrypt");
        ArgumentUtils.checkNotNull((Object)certificate, (String)"certificate");
        this.encrypt(elementToAddEncKeysTo, Arrays.asList(elementToEncrypt), Arrays.asList(certificate));
    }

    @Override
    public void encrypt(Element elementToAddEncKeysTo, List<Element> elementsToEncrypt, X509Certificate certificate) throws XspException {
        ArgumentUtils.checkNotNull((Object)certificate, (String)"certificate");
        this.encrypt(elementToAddEncKeysTo, elementsToEncrypt, Arrays.asList(certificate));
    }

    @Override
    public void encrypt(Element elementToAddEncKeysTo, Element elementToEncrypt, List<X509Certificate> certificates) throws XspException {
        ArgumentUtils.checkNotNull((Object)elementToEncrypt, (String)"elementToEncrypt");
        this.encrypt(elementToAddEncKeysTo, Arrays.asList(elementToEncrypt), certificates);
    }

    @Override
    public void encrypt(Element elementToAddEncKeysTo, List<Element> elementsToEncrypt, List<X509Certificate> certificates) throws XspException {
        ArgumentUtils.checkNotNull((Object)elementToAddEncKeysTo, (String)"elementToAddEncKeysTo");
        ArgumentUtils.checkNotNullNorEmpty(elementsToEncrypt, (String)"elementsToEncrypt");
        ArgumentUtils.checkNotNullNorEmpty(certificates, (String)"certificates");
        Document containerDoc = elementToAddEncKeysTo.getOwnerDocument();
        for (Element elementToEncrypt : elementsToEncrypt) {
            if (elementToEncrypt == null) {
                String errMsg = "The 'elementsToEncrypt' list has a null value.";
                throw new IllegalArgumentException(errMsg);
            }
            if (containerDoc.equals(elementToEncrypt.getOwnerDocument())) continue;
            String errMsg = "The element to encryption must belong to the same document as the element to add the EncryptedKeys to.";
            throw new XspException(errMsg);
        }
        SecretKey sessionKey = null;
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(256);
            sessionKey = keyGenerator.generateKey();
        }
        catch (Exception e) {
            throw new XspException("Couldn't generate a random session key.", e);
        }
        ArrayList<String> referenceIdList = new ArrayList<String>();
        for (Element elementToEncrypt : elementsToEncrypt) {
            String referenceId = "_" + UUID.randomUUID().toString();
            referenceIdList.add(referenceId);
            Element encryptedDataElem = null;
            try {
                XMLCipher dataCipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc");
                dataCipher.init(1, (Key)sessionKey);
                EncryptedData encryptedData = dataCipher.encryptData(containerDoc, elementToEncrypt);
                encryptedData.setId(referenceId);
                encryptedDataElem = dataCipher.martial(encryptedData);
            }
            catch (Exception e) {
                throw new XspException("Couldn't encrypt element, " + TextUtils.getDesc(elementToEncrypt) + ".", e);
            }
            Node parentNode = elementToEncrypt.getParentNode();
            if (parentNode == null) {
                throw new XspException("Couldn't retrieve the parent of the element to encrypt, " + TextUtils.getDesc(elementToEncrypt) + ".");
            }
            parentNode.replaceChild(encryptedDataElem, elementToEncrypt);
        }
        for (X509Certificate certificate : certificates) {
            XMLCipher keyCipher = null;
            try {
                keyCipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#rsa-1_5");
                keyCipher.init(3, (Key)certificate.getPublicKey());
            }
            catch (Exception e) {
                throw new XspException("Couldn't create a cipher to encrypt the session key with certificate: " + CertificateUtils.getSubjectName(certificate) + ".", e);
            }
            EncryptedKey encryptedKey = null;
            try {
                encryptedKey = keyCipher.encryptKey(containerDoc, (Key)sessionKey);
            }
            catch (Exception e) {
                throw new XspException("Couldn't create an 'xenc:EncryptedKey' with certificate: " + CertificateUtils.getSubjectName(certificate) + ".", e);
            }
            KeyInfo keyInfo = new KeyInfo(containerDoc);
            encryptedKey.setKeyInfo(keyInfo);
            X509Data x509Data = new X509Data(containerDoc);
            keyInfo.add(x509Data);
            try {
                x509Data.addSKI(certificate);
            }
            catch (Exception e) {
                throw new XspException("Couldn't create the 'SKI' element within the 'X509Data' element for certificate: " + CertificateUtils.getSubjectName(certificate) + ".", e);
            }
            ReferenceList referenceList = keyCipher.createReferenceList(1);
            encryptedKey.setReferenceList(referenceList);
            for (String referenceId : referenceIdList) {
                Reference dataReference = referenceList.newDataReference("#" + referenceId);
                referenceList.add(dataReference);
            }
            Element encryptedKeyElem = keyCipher.martial(encryptedKey);
            elementToAddEncKeysTo.appendChild(encryptedKeyElem);
        }
    }

    @Override
    public void decrypt(Element encryptedKeyElem, Element encryptedDataElem, X500PrivateCredential credential) throws KeyMismatchException, XspException {
        ArgumentUtils.checkNotNull((Object)encryptedKeyElem, (String)"encryptedKeyElem");
        ArgumentUtils.checkNotNull((Object)encryptedDataElem, (String)"encryptedDataElem");
        this.decrypt(Arrays.asList(encryptedKeyElem), Arrays.asList(encryptedDataElem), credential);
    }

    @Override
    public void decrypt(List<Element> encryptedKeyElems, Element encryptedDataElem, X500PrivateCredential credential) throws KeyMismatchException, XspException {
        ArgumentUtils.checkNotNull((Object)encryptedDataElem, (String)"encryptedDataElem");
        this.decrypt(encryptedKeyElems, Arrays.asList(encryptedDataElem), credential);
    }

    @Override
    public void decrypt(Element encryptedKeyElem, List<Element> encryptedDataElems, X500PrivateCredential credential) throws KeyMismatchException, XspException {
        ArgumentUtils.checkNotNull((Object)encryptedKeyElem, (String)"encryptedKeyElem");
        this.decrypt(Arrays.asList(encryptedKeyElem), encryptedDataElems, credential);
    }

    @Override
    public void decrypt(List<Element> encryptedKeyElems, List<Element> encryptedDataElems, X500PrivateCredential credential) throws KeyMismatchException, XspException {
        ArgumentUtils.checkNotNullNorEmpty(encryptedKeyElems, (String)"encryptedKeyElems");
        ArgumentUtils.checkNotNullNorEmpty(encryptedDataElems, (String)"encryptedDataElems");
        ArgumentUtils.checkNotNull((Object)credential, (String)"credential");
        Document containerDoc = encryptedKeyElems.get(0).getOwnerDocument();
        for (Element encryptedKeyElem : encryptedKeyElems) {
            DomUtils.checkElement((Element)encryptedKeyElem, (String)"EncryptedKey", (String)"http://www.w3.org/2001/04/xmlenc#");
            if (containerDoc.equals(encryptedKeyElem.getOwnerDocument())) continue;
            String errMsg = "The 'EncryptedKey' elements must belong to the same DOM document.";
            throw new XspException(errMsg);
        }
        for (Element encryptedDataElem : encryptedDataElems) {
            DomUtils.checkElement((Element)encryptedDataElem, (String)"EncryptedData", (String)"http://www.w3.org/2001/04/xmlenc#");
            if (containerDoc.equals(encryptedDataElem.getOwnerDocument())) continue;
            String errMsg = "The 'EncryptedData' elements must belong to the same DOM document as the 'EncryptedKey' elements.";
            throw new XspException(errMsg);
        }
        PrivateKey decryptKey = credential.getPrivateKey();
        X509Certificate decryptCert = credential.getCertificate();
        EncryptedKey encryptedKey = null;
        for (Element encryptedKeyElem : encryptedKeyElems) {
            EncryptedKey currentEncryptedKey = this.unmarshalEncryptedKey(encryptedKeyElem);
            if (!XmlEncryptionProfileServiceImpl.matchesCertificate(currentEncryptedKey, decryptCert)) continue;
            encryptedKey = currentEncryptedKey;
            break;
        }
        if (encryptedKey == null) {
            throw new KeyMismatchException("The credential (" + TextUtils.getDesc(credential.getCertificate()) + ") wasn't used to encrypt the data.");
        }
        XMLCipher xmlCipher = null;
        try {
            xmlCipher = XMLCipher.getInstance();
            xmlCipher.init(2, null);
        }
        catch (Exception e) {
            throw new XspException("Couldn't create the cipher to decrypt the data.", e);
        }
        for (Element encryptedDataElem : encryptedDataElems) {
            EncryptedData encryptedData = null;
            try {
                encryptedData = xmlCipher.loadEncryptedData(containerDoc, encryptedDataElem);
            }
            catch (Exception e) {
                throw new XspException("Couldn't load the 'xenc:EncryptedData' element.", e);
            }
            EncryptionMethod encryptionMethod = encryptedData.getEncryptionMethod();
            if (encryptionMethod == null) {
                throw new XspException("The 'xenc:EncryptionMethod' wasn't provided in an 'xenc:EncryptedData' element.");
            }
            String dataEncryptionAlgorithm = encryptionMethod.getAlgorithm();
            if (dataEncryptionAlgorithm == null) {
                throw new XspException("The data encryption algorithm for an 'xenc:EncryptedData' element wasn't provided.");
            }
            Key sessionKey = null;
            try {
                xmlCipher.init(2, (Key)decryptKey);
                sessionKey = xmlCipher.decryptKey(encryptedKey, dataEncryptionAlgorithm);
            }
            catch (Exception e) {
                throw new XspException("Couldn't decrypt the session key with the matching 'EncryptedKey'.", e);
            }
            try {
                xmlCipher.init(2, sessionKey);
                xmlCipher.doFinal(containerDoc, encryptedDataElem);
            }
            catch (Exception e) {
                throw new XspException("Couldn't decrypt the data.", e);
            }
        }
    }

    @Override
    public Key getSessionKey(List<Element> encryptedKeyElems, Element encryptedDataElem, X500PrivateCredential credential) throws KeyMismatchException, XspException {
        ArgumentUtils.checkNotNullNorEmpty(encryptedKeyElems, (String)"encryptedKeyElems");
        ArgumentUtils.checkNotNull((Object)encryptedDataElem, (String)"encryptedDataElem");
        ArgumentUtils.checkNotNull((Object)credential, (String)"credential");
        Document containerDoc = encryptedKeyElems.get(0).getOwnerDocument();
        for (Element encryptedKeyElem : encryptedKeyElems) {
            DomUtils.checkElement((Element)encryptedKeyElem, (String)"EncryptedKey", (String)"http://www.w3.org/2001/04/xmlenc#");
            if (containerDoc.equals(encryptedKeyElem.getOwnerDocument())) continue;
            String errMsg = "The 'EncryptedKey' elements must belong to the same DOM document.";
            throw new XspException(errMsg);
        }
        DomUtils.checkElement((Element)encryptedDataElem, (String)"EncryptedData", (String)"http://www.w3.org/2001/04/xmlenc#");
        if (!containerDoc.equals(encryptedDataElem.getOwnerDocument())) {
            String errMsg = "The 'EncryptedData' elements must belong to the same DOM document as the 'EncryptedKey' elements.";
            throw new XspException(errMsg);
        }
        PrivateKey decryptKey = credential.getPrivateKey();
        X509Certificate decryptCert = credential.getCertificate();
        EncryptedKey encryptedKey = null;
        for (Element encryptedKeyElem : encryptedKeyElems) {
            EncryptedKey currentEncryptedKey = this.unmarshalEncryptedKey(encryptedKeyElem);
            if (!XmlEncryptionProfileServiceImpl.matchesCertificate(currentEncryptedKey, decryptCert)) continue;
            encryptedKey = currentEncryptedKey;
            break;
        }
        if (encryptedKey == null) {
            throw new KeyMismatchException("The credential (" + TextUtils.getDesc(credential.getCertificate()) + ") wasn't used to encrypt the data.");
        }
        XMLCipher xmlCipher = null;
        try {
            xmlCipher = XMLCipher.getInstance();
            xmlCipher.init(2, null);
        }
        catch (Exception e) {
            throw new XspException("Couldn't create the cipher to decrypt the data.", e);
        }
        EncryptedData encryptedData = null;
        try {
            encryptedData = xmlCipher.loadEncryptedData(containerDoc, encryptedDataElem);
        }
        catch (Exception e) {
            throw new XspException("Couldn't load the 'xenc:EncryptedData' element.", e);
        }
        EncryptionMethod encryptionMethod = encryptedData.getEncryptionMethod();
        if (encryptionMethod == null) {
            throw new XspException("The 'xenc:EncryptionMethod' wasn't provided in an 'xenc:EncryptedData' element.");
        }
        String dataEncryptionAlgorithm = encryptionMethod.getAlgorithm();
        if (dataEncryptionAlgorithm == null) {
            throw new XspException("The data encryption algorithm for an 'xenc:EncryptedData' element wasn't provided.");
        }
        Key sessionKey = null;
        try {
            xmlCipher.init(2, (Key)decryptKey);
            sessionKey = xmlCipher.decryptKey(encryptedKey, dataEncryptionAlgorithm);
        }
        catch (Exception e) {
            throw new XspException("Couldn't decrypt the session key with the matching 'EncryptedKey'.", e);
        }
        return sessionKey;
    }

    @Override
    public X509Certificate getEncryptingCertificate(Element encryptedKeyElem, KeyStore keyStore) throws XspException {
        ArgumentUtils.checkNotNull((Object)encryptedKeyElem, (String)"encryptedKeyElem");
        ArgumentUtils.checkNotNull((Object)keyStore, (String)"keyStore");
        List<X509Certificate> certificates = this.getEncryptingCertificates(Arrays.asList(encryptedKeyElem), keyStore);
        if (certificates.isEmpty()) {
            return null;
        }
        return certificates.get(0);
    }

    @Override
    public List<X509Certificate> getEncryptingCertificates(List<Element> encryptedKeyElems, KeyStore keyStore) throws XspException {
        ArgumentUtils.checkNotNullNorEmpty(encryptedKeyElems, (String)"encryptedKeyElems");
        ArgumentUtils.checkNotNull((Object)keyStore, (String)"keyStore");
        ArrayList<X509Certificate> resultList = new ArrayList<X509Certificate>();
        try {
            Enumeration<String> e = keyStore.aliases();
            while (e.hasMoreElements()) {
                String currentAlias = e.nextElement();
                X509Certificate currentCert = (X509Certificate)keyStore.getCertificate(currentAlias);
                if (!this.isEncryptingCertificate(encryptedKeyElems, currentCert)) continue;
                resultList.add(currentCert);
            }
        }
        catch (KeyStoreException e) {
            String errorMsg = "Couldn't retrieve certificates from key store.";
            throw new XspException(errorMsg, e);
        }
        return resultList;
    }

    @Override
    public boolean isEncryptingCertificate(List<Element> encryptedKeyElems, X509Certificate certificate) throws XspException {
        ArgumentUtils.checkNotNullNorEmpty(encryptedKeyElems, (String)"encryptedKeyElems");
        ArgumentUtils.checkNotNull((Object)certificate, (String)"certificate");
        for (Element encryptedKeyElem : encryptedKeyElems) {
            EncryptedKey currentEncryptedKey = this.unmarshalEncryptedKey(encryptedKeyElem);
            if (!XmlEncryptionProfileServiceImpl.matchesCertificate(currentEncryptedKey, certificate)) continue;
            return true;
        }
        return false;
    }

    private EncryptedKey unmarshalEncryptedKey(Element encryptedKeyElem) throws XspException {
        EncryptedKey encryptedKey = null;
        try {
            XMLCipher xmlCipher = XMLCipher.getInstance();
            xmlCipher.init(2, null);
            encryptedKey = xmlCipher.loadEncryptedKey(encryptedKeyElem);
        }
        catch (Exception e) {
            throw new XspException("Couldn't unmarshal an 'EncryptedKey' element.", e);
        }
        return encryptedKey;
    }

    private static boolean matchesCertificate(EncryptedKey encryptedKey, X509Certificate certificate) throws XspException {
        if (!$assertionsDisabled && encryptedKey == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && certificate == null) {
            throw new AssertionError();
        }
        byte[] encryptedKeySki = XmlEncryptionProfileServiceImpl.getEncryptedKeySki(encryptedKey);
        byte[] certificateSki = null;
        try {
            certificateSki = XMLX509SKI.getSKIBytesFromCert((X509Certificate)certificate);
        }
        catch (Exception ex) {
            throw new XspException("Error getting the subject key identifier value from from certificate: " + CertificateUtils.getSubjectName(certificate) + ".", ex);
        }
        return Arrays.equals(encryptedKeySki, certificateSki);
    }

    private static byte[] getEncryptedKeySki(EncryptedKey encryptedKey) throws XspException {
        if (!$assertionsDisabled && encryptedKey == null) {
            throw new AssertionError();
        }
        KeyInfo keyInfo = encryptedKey.getKeyInfo();
        if (keyInfo == null) {
            throw new XspException("An 'EncryptedKey' doesn't have a 'KeyInfo'.");
        }
        if (keyInfo.lengthX509Data() == 0) {
            throw new XspException("The 'KeyInfo' in an 'EncryptedKey' doesn't specify an 'X509Data'.");
        }
        if (keyInfo.lengthX509Data() > 1) {
            throw new XspException("The 'KeyInfo' in an 'EncryptedKey' specifies multiple 'X509Data'.");
        }
        X509Data x509Data = null;
        try {
            x509Data = keyInfo.itemX509Data(0);
        }
        catch (Exception ex) {
            throw new XspException("Couldn't retrieve the 'X509Data' from the 'KeyInfo' in an 'EncryptedKey'. " + ex.getMessage(), ex);
        }
        if (x509Data.lengthSKI() == 0) {
            throw new XspException("The 'X509Data' in an 'EncryptedKey' doesn't specify an 'X509SKI'.");
        }
        if (x509Data.lengthSKI() > 1) {
            throw new XspException("The 'X509Data' in an 'EncryptedKey' specifies multiple 'X509SKI'.");
        }
        try {
            return x509Data.itemSKI(0).getSKIBytes();
        }
        catch (Exception ex) {
            throw new XspException("Couldn't retrieve the SKI value from an 'EncryptedKey. " + ex.getMessage(), ex);
        }
    }

    static {
        boolean bl = $assertionsDisabled = !XmlEncryptionProfileServiceImpl.class.desiredAssertionStatus();
        if (!Init.isInitialized()) {
            Init.init();
        }
    }
}

