/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.common;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.common.utils.JaxbUtils;
import au.gov.nehta.vendorlibrary.common.DOMUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;

public final class JAXBUtil {
    private static final Logger LOG = Logger.getLogger(JAXBUtil.class.getName());

    private JAXBUtil() {
    }

    public static <T> String marshaller(Class instanceClass, String qName, String className, T object) throws JAXBException {
        ArgumentUtils.checkNotNull((Object)instanceClass, (String)"instanceClass");
        ArgumentUtils.checkNotNull((Object)className, (String)"className");
        ArgumentUtils.checkNotNull(object, (String)"object");
        String qNameValue = qName;
        if (qNameValue == null) {
            qNameValue = "";
        }
        QName qNameInstance = new QName(qNameValue, className);
        return JaxbUtils.marshalToString((JAXBElement)new JAXBElement(qNameInstance, instanceClass, object));
    }

    public static <T> String marshaller(Class instanceClass, String className, T object) throws JAXBException {
        return JAXBUtil.marshaller(instanceClass, null, className, object);
    }

    public static <T> T unmarshaller(Class parameterObject, String xmlSource) throws JAXBException {
        ArgumentUtils.checkNotNull((Object)parameterObject, (String)"parameterObject");
        ArgumentUtils.checkNotNull((Object)xmlSource, (String)"xmlSource");
        ByteArrayInputStream is = null;
        Object obj = null;
        try {
            is = new ByteArrayInputStream(xmlSource.getBytes("UTF-8"));
            if (is != null) {
                obj = JaxbUtils.unmarshal((Reader)new InputStreamReader(is), (Class)parameterObject);
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new JAXBException("Unsupported encoding format", (Throwable)ex);
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException ex) {
                throw new JAXBException((Throwable)ex);
            }
        }
        return (T)obj;
    }

    public static <T> T unmarshaller(Class parameterObject, Document doc) throws JAXBException {
        ArgumentUtils.checkNotNull((Object)parameterObject, (String)"parameterObject");
        ArgumentUtils.checkNotNull((Object)doc, (String)"doc");
        doc.normalizeDocument();
        try {
            return JAXBUtil.unmarshaller(parameterObject, DOMUtil.serialiseToString(doc));
        }
        catch (TransformerException e) {
            throw new JAXBException("Failed to serialise DOM to XML string data", (Throwable)e);
        }
        catch (IOException e) {
            throw new JAXBException("Failed to serialise DOM to XML string data", (Throwable)e);
        }
    }
}

