/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.hi.readreferencedata;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.hi.handler.message.HIHeaderHandler;
import au.gov.nehta.vendorlibrary.hi.handler.security.HISecurityHandler;
import au.gov.nehta.vendorlibrary.ws.TimeUtility;
import au.gov.nehta.vendorlibrary.ws.WebServiceClientUtil;
import au.gov.nehta.vendorlibrary.ws.handler.LoggingHandler;
import au.net.electronichealth.ns.hi.common.commoncoreelements._3_0.ProductType;
import au.net.electronichealth.ns.hi.common.commoncoreelements._3_0.TimestampType;
import au.net.electronichealth.ns.hi.common.qualifiedidentifier._3_0.QualifiedId;
import au.net.electronichealth.ns.hi.svc.hiproviderreadreferencedata._3_2_0.ProviderReadReferenceDataPortType;
import au.net.electronichealth.ns.hi.svc.hiproviderreadreferencedata._3_2_0.ProviderReadReferenceDataService;
import au.net.electronichealth.ns.hi.svc.hiproviderreadreferencedata._3_2_0.ReadReferenceData;
import au.net.electronichealth.ns.hi.svc.hiproviderreadreferencedata._3_2_0.ReadReferenceDataResponse;
import au.net.electronichealth.ns.hi.svc.hiproviderreadreferencedata._3_2_0.StandardErrorMsg;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;

public class ReadReferenceDataClient {
    public static final String EMPTY = "";
    private static final String SSL_SOCKET_FACTORY = "com.sun.xml.ws.transport.https.client.SSLSocketFactory";
    private static final String HPIO_CSP_HEADER_ELEMENT_NAME = "hpio";
    private ArgumentValidator argumentValidator = new ArgumentValidator();
    private SSLSocketFactory sslSocketFactory;
    private PrivateKey signingPrivateKey;
    private X509Certificate signingCertificate;
    private LoggingHandler loggingHandler;
    private final QualifiedId individualQualifiedId;
    private final QualifiedId organisationQualifiedId;
    private final Holder<ProductType> productHeader;
    private ProviderReadReferenceDataPortType providerReadReferenceDataPort;
    private String lastSoapRequest;
    private String lastSoapResponse;

    public ReadReferenceDataClient(String readReferenceDataServiceEndpoint, QualifiedId individualQualifiedId, Holder<ProductType> productHeader, PrivateKey signingPrivateKey, X509Certificate signingCertificate, SSLSocketFactory sslSocketFactory) {
        this(readReferenceDataServiceEndpoint, individualQualifiedId, null, productHeader, signingPrivateKey, signingCertificate, sslSocketFactory);
    }

    public ReadReferenceDataClient(String readReferenceDataServiceEndpoint, QualifiedId individualQualifiedId, QualifiedId organisationQualifiedId, Holder<ProductType> productHeader, PrivateKey signingPrivateKey, X509Certificate signingCertificate, SSLSocketFactory sslSocketFactory) {
        ArgumentUtils.checkNotNullNorBlank((String)readReferenceDataServiceEndpoint, (String)"readReferenceDataServiceEndpoint");
        ArgumentUtils.checkNotNull((Object)individualQualifiedId, (String)"individualQualifiedId");
        ArgumentUtils.checkNotNull(productHeader, (String)"productHeader");
        ArgumentUtils.checkNotNull((Object)signingPrivateKey, (String)"signingPrivateKey");
        ArgumentUtils.checkNotNull((Object)signingCertificate, (String)"signingPrivateKey");
        ArgumentUtils.checkNotNull((Object)sslSocketFactory, (String)"sslSocketFactory");
        this.signingPrivateKey = signingPrivateKey;
        this.signingCertificate = signingCertificate;
        this.sslSocketFactory = sslSocketFactory;
        this.individualQualifiedId = individualQualifiedId;
        this.organisationQualifiedId = organisationQualifiedId;
        this.productHeader = productHeader;
        this.loggingHandler = new LoggingHandler(false);
        ArrayList<LoggingHandler> handlerChain = new ArrayList<LoggingHandler>();
        handlerChain.add(this.loggingHandler);
        this.providerReadReferenceDataPort = (ProviderReadReferenceDataPortType)WebServiceClientUtil.getPort(ProviderReadReferenceDataPortType.class, ProviderReadReferenceDataService.class, (SocketFactory)sslSocketFactory, handlerChain);
        this.configureEndpoint(this.providerReadReferenceDataPort, readReferenceDataServiceEndpoint);
    }

    public final ReadReferenceDataResponse readReferenceData(ReadReferenceData readReferenceData) throws StandardErrorMsg {
        this.argumentValidator.checkReadReferenceData(readReferenceData);
        TimestampType timestampHeader = new TimestampType();
        timestampHeader.setCreated(TimeUtility.nowXMLGregorianCalendar());
        Holder signatureHeader = null;
        return this.providerReadReferenceDataPort.readReferenceData(readReferenceData, this.productHeader, timestampHeader, signatureHeader, this.individualQualifiedId, this.organisationQualifiedId);
    }

    public final String getLastSoapResponse() {
        if (this.loggingHandler != null) {
            return this.loggingHandler.getLastSoapResponse();
        }
        return EMPTY;
    }

    public final String getLastSoapRequest() {
        if (this.loggingHandler != null) {
            return this.loggingHandler.getLastSoapRequest();
        }
        return EMPTY;
    }

    private void configureEndpoint(Object servicePort, String endpoint) {
        BindingProvider bindingProvider = (BindingProvider)servicePort;
        Map requestContext = bindingProvider.getRequestContext();
        requestContext.put("javax.xml.ws.service.endpoint.address", endpoint.trim());
        requestContext.put(SSL_SOCKET_FACTORY, this.sslSocketFactory);
        if (bindingProvider != null && bindingProvider.getBinding() != null) {
            Binding binding = bindingProvider.getBinding();
            List handlerChain = binding.getHandlerChain();
            if (this.organisationQualifiedId == null) {
                ArrayList<String> headerNames = new ArrayList<String>();
                headerNames.add(HPIO_CSP_HEADER_ELEMENT_NAME);
                handlerChain.add(new HIHeaderHandler(headerNames));
            }
            handlerChain.add(new HISecurityHandler(this.signingCertificate, this.signingPrivateKey));
            handlerChain.add(this.loggingHandler);
            binding.setHandlerChain(handlerChain);
        }
    }

    public static class ArgumentValidator {
        public final void checkReadReferenceData(ReadReferenceData readReferenceData) {
            ArgumentUtils.checkNotNull((Object)readReferenceData, (String)"readReferenceData");
            this.checkElementName(readReferenceData.getElementNames());
        }

        public final void checkElementName(List<String> elementNamesList) {
            if (ArgumentUtils.isNullOrEmpty(elementNamesList)) {
                throw new IllegalArgumentException("The element names list must contain one or more elements");
            }
            for (String elementName : elementNamesList) {
                ArgumentUtils.checkNotNullNorBlank((String)elementName, (String)"elementName");
            }
        }
    }
}

