/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.common.utils;

import au.gov.nehta.common.utils.ArgumentUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public final class PropertyUtils {
    private static final List<String> TRUE_VALUES = Arrays.asList("true", "yes", "on", "1");

    public static String getSystemProperty(String name) {
        assert (name != null) : "'name' is null.";
        assert (name.trim().length() > 0) : "'name' is a blank string.";
        String value = System.getProperty(name);
        if (value == null) {
            throw new IllegalArgumentException("System property '" + name + "' was not set.");
        }
        return value;
    }

    public static String getSystemProperty(String name, String defaultValue) {
        assert (name != null) : "'name' is null.";
        assert (name.trim().length() > 0) : "'name' is a blank string.";
        return System.getProperty(name, defaultValue);
    }

    public static void setSystemProperty(String name, String value) {
        assert (name != null) : "'name' is null.";
        assert (name.trim().length() > 0) : "'name' is a blank string.";
        assert (value != null) : "'value' is null.";
        System.setProperty(name, value);
    }

    public static Properties loadProperties(File file) throws FileNotFoundException, IOException {
        assert (file != null) : "'file' is null.";
        return PropertyUtils.loadProperties(new FileReader(file));
    }

    public static Properties loadProperties(Reader reader) throws IOException {
        assert (reader != null) : "'reader' is null.";
        Properties properties = new Properties();
        properties.load(reader);
        return properties;
    }

    public static Properties loadProperties(InputStream inputStream) throws IOException {
        assert (inputStream != null) : "'inputStream' is null.";
        Properties properties = new Properties();
        properties.load(inputStream);
        return properties;
    }

    public static boolean getBooleanProperty(Properties properties, String name, boolean defaultValue) {
        assert (properties != null) : "'properties' is null.";
        assert (name != null) : "'name' is null.";
        assert (name.trim().length() > 0) : "'name' is a blank string.";
        String propertyValue = properties.getProperty(name);
        if (ArgumentUtils.isNullOrBlank(propertyValue)) {
            return defaultValue;
        }
        propertyValue = propertyValue.trim().toLowerCase();
        return TRUE_VALUES.contains(propertyValue);
    }

    private PropertyUtils() {
    }
}

