/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.xsp;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.xsp.EncryptedContainerProfileService;
import au.gov.nehta.xsp.SignedContainerProfileService;
import au.gov.nehta.xsp.XmlEncryptionProfileService;
import au.gov.nehta.xsp.XmlSignatureProfileService;
import au.gov.nehta.xsp.XspException;
import au.gov.nehta.xsp.XspVersion;
import au.gov.nehta.xsp.impl.v1.EncryptedContainerProfileServiceImpl;
import au.gov.nehta.xsp.impl.v1.SignedContainerProfileServiceImpl;
import au.gov.nehta.xsp.impl.v1.XmlEncryptionProfileServiceImpl;
import au.gov.nehta.xsp.impl.v1.XmlSignatureProfileServiceImpl;
import java.util.HashMap;
import java.util.Map;

public class XspFactory {
    private static final XspFactory instance = new XspFactory();
    private final Map<XspVersion, XmlSignatureProfileService> xmlSigServices = new HashMap<XspVersion, XmlSignatureProfileService>();
    private final Map<XspVersion, SignedContainerProfileService> signedContainerServices = new HashMap<XspVersion, SignedContainerProfileService>();
    private final Map<XspVersion, XmlEncryptionProfileService> xmlEncServices = new HashMap<XspVersion, XmlEncryptionProfileService>();
    private final Map<XspVersion, EncryptedContainerProfileService> encryptedContainerServices = new HashMap<XspVersion, EncryptedContainerProfileService>();

    public static XspFactory getInstance() throws XspException {
        return instance;
    }

    private XspFactory() {
        this.addImplementationVersion1();
    }

    private void addImplementationVersion1() {
        XmlSignatureProfileServiceImpl xmlSigService = new XmlSignatureProfileServiceImpl();
        this.xmlSigServices.put(XspVersion.V_1_2, xmlSigService);
        this.xmlSigServices.put(XspVersion.V_2010, xmlSigService);
        this.signedContainerServices.put(XspVersion.V_1_2, new SignedContainerProfileServiceImpl("http://ns.nehta.gov.au/CoreConnectivity/Xsd/SignedPayload/1.2", xmlSigService));
        this.signedContainerServices.put(XspVersion.V_2010, new SignedContainerProfileServiceImpl("http://ns.electronichealth.net.au/xsp/xsd/SignedPayload/2010", xmlSigService));
        XmlEncryptionProfileServiceImpl xmlEncService = new XmlEncryptionProfileServiceImpl();
        this.xmlEncServices.put(XspVersion.V_1_2, xmlEncService);
        this.xmlEncServices.put(XspVersion.V_2010, xmlEncService);
        this.encryptedContainerServices.put(XspVersion.V_1_2, new EncryptedContainerProfileServiceImpl("http://ns.nehta.gov.au/CoreConnectivity/Xsd/EncryptedPayload/1.2", xmlEncService));
        this.encryptedContainerServices.put(XspVersion.V_2010, new EncryptedContainerProfileServiceImpl("http://ns.electronichealth.net.au/xsp/xsd/EncryptedPayload/2010", xmlEncService));
    }

    public boolean isXmlSignatureProfileServiceSupported(XspVersion version) {
        ArgumentUtils.checkNotNull((Object)((Object)version), (String)"version");
        return this.xmlSigServices.containsKey((Object)version);
    }

    public XmlSignatureProfileService getXmlSignatureProfileService(XspVersion version) throws XspException {
        ArgumentUtils.checkNotNull((Object)((Object)version), (String)"version");
        XmlSignatureProfileService service = this.xmlSigServices.get((Object)version);
        if (service == null) {
            String errMsg = "\"XML Signature Profile\" is not supported by XSP version, " + (Object)((Object)version) + ".";
            throw new XspException(errMsg);
        }
        return service;
    }

    public boolean isSignedContainerProfileServiceSupported(XspVersion version) {
        ArgumentUtils.checkNotNull((Object)((Object)version), (String)"version");
        return this.signedContainerServices.containsKey((Object)version);
    }

    public SignedContainerProfileService getSignedContainerProfileService(XspVersion version) throws XspException {
        ArgumentUtils.checkNotNull((Object)((Object)version), (String)"version");
        SignedContainerProfileService service = this.signedContainerServices.get((Object)version);
        if (service == null) {
            String errMsg = "\"Signed Container Profile\" is not supported by XSP version, " + (Object)((Object)version) + ".";
            throw new XspException(errMsg);
        }
        return service;
    }

    public boolean isXmlEncryptionProfileServiceSupported(XspVersion version) {
        ArgumentUtils.checkNotNull((Object)((Object)version), (String)"version");
        return this.xmlEncServices.containsKey((Object)version);
    }

    public XmlEncryptionProfileService getXmlEncryptionProfileService(XspVersion version) throws XspException {
        ArgumentUtils.checkNotNull((Object)((Object)version), (String)"version");
        XmlEncryptionProfileService service = this.xmlEncServices.get((Object)version);
        if (service == null) {
            String errMsg = "\"XML Encryption Profile\" is not supported by XSP version, " + (Object)((Object)version) + ".";
            throw new XspException(errMsg);
        }
        return service;
    }

    public boolean isEncryptedContainerProfileServiceSupported(XspVersion version) {
        ArgumentUtils.checkNotNull((Object)((Object)version), (String)"version");
        return this.encryptedContainerServices.containsKey((Object)version);
    }

    public EncryptedContainerProfileService getEncryptedContainerProfileService(XspVersion version) throws XspException {
        ArgumentUtils.checkNotNull((Object)((Object)version), (String)"version");
        EncryptedContainerProfileService service = this.encryptedContainerServices.get((Object)version);
        if (service == null) {
            String errMsg = "\"Encrypted Container Profile\" is not supported by XSP version, " + (Object)((Object)version) + ".";
            throw new XspException(errMsg);
        }
        return service;
    }
}

