/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.hi.sample;

import au.gov.nehta.vendorlibrary.common.security.KeystoreUtil;
import au.gov.nehta.vendorlibrary.hi.ihi.ConsumerSearchIHIBatchSyncClient;
import au.gov.nehta.vendorlibrary.ws.TimeUtility;
import au.net.electronichealth.ns.hi.common.commoncoredatatypes._3_0.SexType;
import au.net.electronichealth.ns.hi.common.commoncoreelements._3_0.ProductType;
import au.net.electronichealth.ns.hi.common.qualifiedidentifier._3_0.QualifiedId;
import au.net.electronichealth.ns.hi.consumermessages.searchihibatchmessages._3_0.SearchIHIRequestType;
import au.net.electronichealth.ns.hi.svc.consumersearchihi._3_0.SearchIHI;
import au.net.electronichealth.ns.hi.svc.consumersearchihibatchsync._3_2_0.SearchIHIBatchResponse;
import au.net.electronichealth.ns.hi.svc.consumersearchihibatchsync._3_2_0.StandardErrorMsg;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.UUID;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.Holder;

public final class ConsumerSearchIHIBatchSyncClientSample {
    private static final String PRODUCT_PLATFORM = "Windows XP SP3";
    private static final String PRODUCT_NAME = "Product Name";
    private static final String PRODUCT_VERSION = "Product Version";
    private static final String VENDOR_QUALIFIFER_ID = "NEHTA00001";
    private static final String VENDOR_QUALIFIER = "http://ns.medicareaustralia.gov.au/mcaVendorId/1.0";
    private static final String USER_QUALIFIED_ID = "HIClient-1";
    private static final String USER_QUALIFIER = "http://ns.electronichealth.net.au/hi/xsd/common/QualifiedIdentifier/3.0";
    private static final String PRIVATE_KEY_STORE_TYPE = "JKS";
    private static final String PRIVATE_KEY_STORE_PASSWORD = "changeit";
    private static final String PRIVATE_KEY_STORE_FILE = "keystore.jks";
    private static final String PRIVATE_KEY_ALIAS_NAME = "8003624166667003";
    private static final String PRIVATE_KEY_CERTIFICATE_ALIAS_NAME = "8003624166667003";
    private static final String TRUSTSTORE_TYPE = "JKS";
    private static final String PRIVATE_KEY_PASSWORD = "changeit";
    private static final String TRUSTSTORE_FILE = "truststore.jks";
    private static final String TRUSTSTORE_PASSWORD = "changeit";
    private static final String MEDICARE_ENDPOINT_URL = "https://www5.medicareaustralia.gov.au/cert/soap/services/";
    private static final String INDIVIDUAL_IHI_NUMBER = "http://ns.electronichealth.net.au/id/hi/ihi/1.0/8003601240022579";
    private static final String INDIVIDUAL_FAMILY_NAME = "Wood";
    private static final String INDIVIDUAL_GIVEN_NAME = "Jessica";
    private static final XMLGregorianCalendar INDIVIDUAL_DATE_OF_BIRTH = TimeUtility.getXMLGregorianDate((String)"20021212");
    private static final SexType GENDER = SexType.F;

    private ConsumerSearchIHIBatchSyncClientSample() {
    }

    public static void main(String[] args) throws GeneralSecurityException, IOException {
        QualifiedId userQualifiedId = ConsumerSearchIHIBatchSyncClientSample.getUserQualifedId();
        QualifiedId vendorQualifiedId = ConsumerSearchIHIBatchSyncClientSample.getVendorQualifiedId();
        ProductType productHeader = ConsumerSearchIHIBatchSyncClientSample.getProduct(vendorQualifiedId);
        PrivateKey clientSigningPrivateKey = ConsumerSearchIHIBatchSyncClientSample.getPrivateKey();
        X509Certificate clientSigningCertificate = ConsumerSearchIHIBatchSyncClientSample.getSigningCertificate();
        SSLSocketFactory sslSocketFactory = ConsumerSearchIHIBatchSyncClientSample.getSSLSocketFactory();
        ConsumerSearchIHIBatchSyncClient testClient = new ConsumerSearchIHIBatchSyncClient(MEDICARE_ENDPOINT_URL, userQualifiedId, new Holder((Object)productHeader), clientSigningPrivateKey, clientSigningCertificate, sslSocketFactory);
        ConsumerSearchIHIBatchSyncClient.SearchBatch searchBatch = ConsumerSearchIHIBatchSyncClientSample.getConsumerSearchIHIBatchSyncClient();
        System.setProperty("com.sun.xml.ws.transport.http.client.HttpTransportPipe.dump", "true");
        try {
            SearchIHIBatchResponse batchSearchResponse = testClient.batchSearch(searchBatch);
        }
        catch (StandardErrorMsg standardErrorMsg) {
            standardErrorMsg.printStackTrace();
        }
        String lastSoapRequest = testClient.getLastSoapRequest();
        String lastSoapResponse = testClient.getLastSoapResponse();
    }

    private static ProductType getProduct(QualifiedId vendorQualifiedId) {
        ProductType productHeader = new ProductType();
        productHeader.setPlatform(PRODUCT_PLATFORM);
        productHeader.setProductName(PRODUCT_NAME);
        productHeader.setProductVersion(PRODUCT_VERSION);
        productHeader.setVendor(vendorQualifiedId);
        return productHeader;
    }

    private static QualifiedId getUserQualifedId() {
        QualifiedId userQualifiedId = new QualifiedId();
        userQualifiedId.setId(USER_QUALIFIED_ID);
        userQualifiedId.setQualifier(USER_QUALIFIER);
        return userQualifiedId;
    }

    private static QualifiedId getVendorQualifiedId() {
        QualifiedId vendorQualifiedId = new QualifiedId();
        vendorQualifiedId.setId(VENDOR_QUALIFIFER_ID);
        vendorQualifiedId.setQualifier(VENDOR_QUALIFIER);
        return vendorQualifiedId;
    }

    private static PrivateKey getPrivateKey() throws GeneralSecurityException {
        PrivateKey clientSigningPrivateKey = KeystoreUtil.getSigningPrivateKey((String)"JKS", (String)"changeit", (String)PRIVATE_KEY_STORE_FILE, (String)"8003624166667003");
        return clientSigningPrivateKey;
    }

    private static X509Certificate getSigningCertificate() throws GeneralSecurityException {
        X509Certificate clientSigningCertificate = KeystoreUtil.getSigningCertificate((String)"JKS", (String)"changeit", (String)PRIVATE_KEY_STORE_FILE, (String)"8003624166667003");
        return clientSigningCertificate;
    }

    private static SSLSocketFactory getSSLSocketFactory() throws IOException, GeneralSecurityException {
        SSLSocketFactory sslSocketFactory = KeystoreUtil.getSslSocketFactory((String)"JKS", (String)PRIVATE_KEY_STORE_FILE, (String)"changeit", (String)"changeit", (String)"8003624166667003", (String)"JKS", (String)TRUSTSTORE_FILE, (String)"changeit");
        return sslSocketFactory;
    }

    private static ConsumerSearchIHIBatchSyncClient.SearchBatch getConsumerSearchIHIBatchSyncClient() {
        ConsumerSearchIHIBatchSyncClient.SearchBatch searchBatch = new ConsumerSearchIHIBatchSyncClient.SearchBatch();
        SearchIHI searchIHI = new SearchIHI();
        searchIHI.setIhiNumber(INDIVIDUAL_IHI_NUMBER);
        searchIHI.setFamilyName(INDIVIDUAL_FAMILY_NAME);
        searchIHI.setGivenName(INDIVIDUAL_GIVEN_NAME);
        searchIHI.setDateOfBirth(INDIVIDUAL_DATE_OF_BIRTH);
        searchIHI.setSex(GENDER);
        SearchIHI basicSearchIHI = searchIHI;
        String basicSearchRequestIdentifier = UUID.randomUUID().toString();
        SearchIHIRequestType basicSearchIhiRequestType = new SearchIHIRequestType();
        basicSearchIhiRequestType.setSearchIHI(basicSearchIHI);
        basicSearchIhiRequestType.setRequestIdentifier(basicSearchRequestIdentifier);
        searchBatch.addBasicSearch(basicSearchIhiRequestType);
        return searchBatch;
    }
}

