/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.hi.sample;

import au.gov.nehta.vendorlibrary.common.security.KeystoreUtil;
import au.gov.nehta.vendorlibrary.hi.hpii.ProviderSearchHIProviderDirectoryForIndividualClient;
import au.net.electronichealth.ns.hi.common.commoncoreelements._3_0.ProductType;
import au.net.electronichealth.ns.hi.common.qualifiedidentifier._3_0.QualifiedId;
import au.net.electronichealth.ns.hi.svc.hiproviderdirectoryforindividual._3_2_0.SearchHIProviderDirectoryForIndividual;
import au.net.electronichealth.ns.hi.svc.hiproviderdirectoryforindividual._3_2_0.SearchHIProviderDirectoryForIndividualResponse;
import au.net.electronichealth.ns.hi.svc.hiproviderdirectoryforindividual._3_2_0.StandardErrorMsg;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.ws.Holder;

public final class ProviderSearchHIProviderDirectoryForIndividualClientSample {
    private static final String PRODUCT_PLATFORM = "Windows XP SP3";
    private static final String PRODUCT_NAME = "Product Name";
    private static final String PRODUCT_VERSION = "Product Version";
    private static final String VENDOR_QUALIFIFER_ID = "NEHTA00001";
    private static final String VENDOR_QUALIFIER = "http://ns.medicareaustralia.gov.au/mcaVendorId/1.0";
    private static final String USER_QUALIFIED_ID = "HIClient-1";
    private static final String USER_QUALIFIER = "http://ns.electronichealth.net.au/hi/xsd/common/QualifiedIdentifier/3.0";
    private static final String PRIVATE_KEY_STORE_TYPE = "JKS";
    private static final String PRIVATE_KEY_STORE_PASSWORD = "changeit";
    private static final String PRIVATE_KEY_STORE_FILE = "keystore.jks";
    private static final String PRIVATE_KEY_ALIAS_NAME = "8003624166667003";
    private static final String PRIVATE_KEY_CERTIFICATE_ALIAS_NAME = "8003624166667003";
    private static final String TRUSTSTORE_TYPE = "JKS";
    private static final String PRIVATE_KEY_PASSWORD = "changeit";
    private static final String TRUSTSTORE_FILE = "truststore.jks";
    private static final String TRUSTSTORE_PASSWORD = "changeit";
    private static final String MEDICARE_ENDPOINT_URL = "https://www5.medicareaustralia.gov.au/cert/soap/services/";
    private static final String QUALIFIED_HPII = "http://ns.electronichealth.net.au/id/hi/hpii/1.0/8003619166667284";

    private ProviderSearchHIProviderDirectoryForIndividualClientSample() {
    }

    public static void main(String[] args) throws GeneralSecurityException, IOException {
        QualifiedId userQualifiedId = ProviderSearchHIProviderDirectoryForIndividualClientSample.getUserQualifedId();
        QualifiedId vendorQualifiedId = ProviderSearchHIProviderDirectoryForIndividualClientSample.getVendorQualifiedId();
        ProductType productHeader = ProviderSearchHIProviderDirectoryForIndividualClientSample.getProduct(vendorQualifiedId);
        PrivateKey clientSigningPrivateKey = ProviderSearchHIProviderDirectoryForIndividualClientSample.getPrivateKey();
        X509Certificate clientSigningCertificate = ProviderSearchHIProviderDirectoryForIndividualClientSample.getSigningCertificate();
        SSLSocketFactory sslSocketFactory = ProviderSearchHIProviderDirectoryForIndividualClientSample.getSSLSocketFactory();
        ProviderSearchHIProviderDirectoryForIndividualClient testClient = new ProviderSearchHIProviderDirectoryForIndividualClient(MEDICARE_ENDPOINT_URL, userQualifiedId, (Holder<ProductType>)new Holder((Object)productHeader), clientSigningPrivateKey, clientSigningCertificate, sslSocketFactory);
        SearchHIProviderDirectoryForIndividual request = new SearchHIProviderDirectoryForIndividual();
        request.setHpiiNumber(QUALIFIED_HPII);
        System.setProperty("com.sun.xml.ws.transport.http.client.HttpTransportPipe.dump", "true");
        try {
            SearchHIProviderDirectoryForIndividualResponse searchHIProviderDirectoryForIndividualResponse = testClient.identifierSearch(request);
        }
        catch (StandardErrorMsg standardErrorMsg) {
            standardErrorMsg.printStackTrace();
        }
        String lastSoapRequest = testClient.getLastSoapRequest();
        String lastSoapResponse = testClient.getLastSoapResponse();
    }

    private static ProductType getProduct(QualifiedId vendorQualifiedId) {
        ProductType productHeader = new ProductType();
        productHeader.setPlatform(PRODUCT_PLATFORM);
        productHeader.setProductName(PRODUCT_NAME);
        productHeader.setProductVersion(PRODUCT_VERSION);
        productHeader.setVendor(vendorQualifiedId);
        return productHeader;
    }

    private static QualifiedId getUserQualifedId() {
        QualifiedId userQualifiedId = new QualifiedId();
        userQualifiedId.setId(USER_QUALIFIED_ID);
        userQualifiedId.setQualifier(USER_QUALIFIER);
        return userQualifiedId;
    }

    private static QualifiedId getVendorQualifiedId() {
        QualifiedId vendorQualifiedId = new QualifiedId();
        vendorQualifiedId.setId(VENDOR_QUALIFIFER_ID);
        vendorQualifiedId.setQualifier(VENDOR_QUALIFIER);
        return vendorQualifiedId;
    }

    private static PrivateKey getPrivateKey() throws GeneralSecurityException {
        PrivateKey clientSigningPrivateKey = KeystoreUtil.getSigningPrivateKey((String)"JKS", (String)"changeit", (String)PRIVATE_KEY_STORE_FILE, (String)"8003624166667003");
        return clientSigningPrivateKey;
    }

    private static X509Certificate getSigningCertificate() throws GeneralSecurityException {
        X509Certificate clientSigningCertificate = KeystoreUtil.getSigningCertificate((String)"JKS", (String)"changeit", (String)PRIVATE_KEY_STORE_FILE, (String)"8003624166667003");
        return clientSigningCertificate;
    }

    private static SSLSocketFactory getSSLSocketFactory() throws IOException, GeneralSecurityException {
        SSLSocketFactory sslSocketFactory = KeystoreUtil.getSslSocketFactory((String)"JKS", (String)PRIVATE_KEY_STORE_FILE, (String)"changeit", (String)"changeit", (String)"8003624166667003", (String)"JKS", (String)TRUSTSTORE_FILE, (String)"changeit");
        return sslSocketFactory;
    }
}

