/*
 * Copyright 2008 NEHTA
 * 
 * Licensed under the NEHTA Open Source (Apache) License; you may not use this 
 * file except in compliance with the License. A copy of the License is in the
 * 'license.txt' file, which should be provided with this work.
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations 
 * under the License.
 */
package au.gov.nehta.xsp.impl.v1;

/**
 * Constants storing the the namespaces, namespace prefixes and element tags
 * used by the signed and encrypted payload containers.
 * 
 */
public class XspTagConstants {

  /**
   * Prefix for the encrypted payload container namespace
   */
  public static final String PREFIX_ENCRYPTED_PAYLOAD = "ep";

  /**
   * Prefix for the signed payload container namespace
   */
  public static final String PREFIX_SIGNED_PAYLOAD = "sp";

  /**
   * Tag of the 'ep:encryptedPayload' element
   */
  public static final String TAG_EP_ENCRYPTED_PAYLOAD = "encryptedPayload";

  /**
   * Tag of the 'ep:keys' element
   */
  public static final String TAG_EP_KEYS = "keys";

  /**
   * Tag of the 'ep:encryptedPayloadData' element
   */
  public static final String TAG_EP_ENCRYPTED_PAYLOAD_DATA = "encryptedPayloadData";

  /**
   * Tag of the 'sp:signedPayload' element
   */
  public static final String TAG_SP_SIGNED_PAYLOAD = "signedPayload";

  /**
   * Tag of the 'sp:signatures' element
   */
  public static final String TAG_SP_SIGNATURES = "signatures";

  /**
   * Tag of the 'sp:signedPayloadData' element
   */
  public static final String TAG_SP_SIGNED_PAYLOAD_DATA = "signedPayloadData";

}
