 
PRINT N'Dropping index [IX_ClinicalDocumentVersion_Source] from [hips].[ClinicalDocumentVersion]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_ClinicalDocumentVersion_Source' AND object_id = OBJECT_ID(N'[hips].[ClinicalDocumentVersion]'))
DROP INDEX [IX_ClinicalDocumentVersion_Source] ON [hips].[ClinicalDocumentVersion]
GO 
PRINT N'Creating index [IX_ClinicalDocumentVersion_Source] ON [hips].[ClinicalDocumentVersion]'
GO
CREATE NONCLUSTERED INDEX [IX_ClinicalDocumentVersion_Source] ON [hips].[ClinicalDocumentVersion] ([SourceSystemDocumentId]) ON INDEXES 
GO

PRINT N'Dropping index [IX_ClinicalDocumentVersion_UploadedDate] from [hips].[ClinicalDocumentVersion]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_ClinicalDocumentVersion_UploadedDate' AND object_id = OBJECT_ID(N'[hips].[ClinicalDocumentVersion]'))
DROP INDEX [IX_ClinicalDocumentVersion_UploadedDate] ON [hips].[ClinicalDocumentVersion]
GO
PRINT N'Creating index [IX_ClinicalDocumentVersion_UploadedDate] ON [hips].[ClinicalDocumentVersion]'
GO
CREATE NONCLUSTERED INDEX [IX_ClinicalDocumentVersion_UploadedDate] ON [hips].[ClinicalDocumentVersion] ([UploadedDate], [DateCreated]) ON INDEXES
GO

PRINT N'Dropping index [IX_Episode_AdmissionDate] from [hips].[Episode]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_Episode_AdmissionDate' AND object_id = OBJECT_ID(N'[hips].[Episode]'))
DROP INDEX [IX_Episode_AdmissionDate] ON [hips].[Episode]
GO
PRINT N'Creating index [IX_Episode_AdmissionDate] ON [hips].[Episode]'
GO
CREATE NONCLUSTERED INDEX [IX_Episode_AdmissionDate] ON [hips].[Episode] ([AdmissionDate]) ON INDEXES
GO

PRINT N'Dropping index [IX_Episode_DateModified] from [hips].[Episode]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_Episode_DateModified' AND object_id = OBJECT_ID(N'[hips].[Episode]'))
DROP INDEX [IX_Episode_DateModified] ON [hips].[Episode]
GO
PRINT N'Creating index [IX_Episode_DateModified] ON [hips].[Episode]'
GO
CREATE NONCLUSTERED INDEX [IX_Episode_DateModified] ON [hips].[Episode] ([DateModified]) ON INDEXES
GO

PRINT N'Dropping index [IX_Episode_Discharge] from [hips].[Episode]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_Episode_Discharge' AND object_id = OBJECT_ID(N'[hips].[Episode]'))
DROP INDEX [IX_Episode_Discharge] ON [hips].[Episode]
GO
PRINT N'Creating index [IX_Episode_Discharge] ON [hips].[Episode]'
GO
CREATE NONCLUSTERED INDEX [IX_Episode_Discharge] ON [hips].[Episode] ([PatientId], [DischargeDate]) ON INDEXES
GO

PRINT N'Dropping index [IX_Episode_PatientId] from [hips].[Episode]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_Episode_PatientId' AND object_id = OBJECT_ID(N'[hips].[Episode]'))
DROP INDEX [IX_Episode_PatientId] ON [hips].[Episode]
GO
PRINT N'Creating index [IX_Episode_PatientId] ON [hips].[Episode]'
GO
CREATE NONCLUSTERED INDEX [IX_Episode_PatientId] ON [hips].[Episode] ([PatientId]) ON INDEXES
GO

PRINT N'Dropping index [IX_Episode_ResponsibleProvider] from [hips].[Episode]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_Episode_ResponsibleProvider' AND object_id = OBJECT_ID(N'[hips].[Episode]'))
DROP INDEX [IX_Episode_ResponsibleProvider] ON [hips].[Episode]
GO
PRINT N'Creating index [IX_Episode_ResponsibleProvider] ON [hips].[Episode]'
GO
CREATE NONCLUSTERED INDEX [IX_Episode_ResponsibleProvider] ON [hips].[Episode] ([ResponsibleProviderId], [EpisodeTypeId], [EpisodeLifecycleId]) ON INDEXES
GO

PRINT N'Dropping index [IX_Episode_SourceEpisode] from [hips].[Episode]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_Episode_SourceEpisode' AND object_id = OBJECT_ID(N'[hips].[Episode]'))
DROP INDEX [IX_Episode_SourceEpisode] ON [hips].[Episode]
GO
PRINT N'Creating index [IX_Episode_SourceEpisode] ON [hips].[Episode]'
GO
CREATE NONCLUSTERED INDEX [IX_Episode_SourceEpisode] ON [hips].[Episode] ([SourceSystemEpisodeId], [AdmissionDate]) ON INDEXES
GO

PRINT N'Dropping index [IX_Episode_Type_Lifecycle] from [hips].[Episode]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_Episode_Type_Lifecycle' AND object_id = OBJECT_ID(N'[hips].[Episode]'))
DROP INDEX [IX_Episode_Type_Lifecycle] ON [hips].[Episode]
GO
PRINT N'Creating index [IX_Episode_Type_Lifecycle] ON [hips].[Episode]'
GO
CREATE NONCLUSTERED INDEX [IX_Episode_Type_Lifecycle] ON [hips].[Episode] ([EpisodeTypeId], [EpisodeLifecycleId]) ON INDEXES
GO

PRINT N'Dropping index [IX_HealthProviderIndividual_Hpii] from [hips].[HealthProviderIndividual]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_HealthProviderIndividual_Hpii' AND object_id = OBJECT_ID(N'[hips].[HealthProviderIndividual]'))
DROP INDEX [IX_HealthProviderIndividual_Hpii] ON [hips].[HealthProviderIndividual]
GO
PRINT N'Creating index [IX_HealthProviderIndividual_Hpii] ON [hips].[HealthProviderIndividual]'
GO
CREATE NONCLUSTERED INDEX [IX_HealthProviderIndividual_Hpii] ON [hips].[HealthProviderIndividual] ([HpiI], [HpiILastValidatedDate]) ON INDEXES
GO

PRINT N'Dropping index [IX_HealthProviderIndividual_Names] from [hips].[HealthProviderIndividual]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_HealthProviderIndividual_Names' AND object_id = OBJECT_ID(N'[hips].[HealthProviderIndividual]'))
DROP INDEX [IX_HealthProviderIndividual_Names] ON [hips].[HealthProviderIndividual]
GO
PRINT N'Creating index [IX_HealthProviderIndividual_Names] ON [hips].[HealthProviderIndividual]'
GO
CREATE NONCLUSTERED INDEX [IX_HealthProviderIndividual_Names] ON [hips].[HealthProviderIndividual] ([FamilyName], [GivenNames], [TitleId]) ON INDEXES
GO 

PRINT N'Dropping index [IX_HealthProviderIndividual_Provider] from [hips].[HealthProviderIndividual]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_HealthProviderIndividual_Provider' AND object_id = OBJECT_ID(N'[hips].[HealthProviderIndividual]'))
DROP INDEX [IX_HealthProviderIndividual_Provider] ON [hips].[HealthProviderIndividual]
GO
PRINT N'Creating index [IX_HealthProviderIndividual_Provider] ON [hips].[HealthProviderIndividual]'
GO
CREATE NONCLUSTERED INDEX [IX_HealthProviderIndividual_Provider] ON [hips].[HealthProviderIndividual] ([IamProviderIdentifier]) ON INDEXES
GO

PRINT N'Dropping index [IX_HealthProviderIndividual_Title_Suffix] from [hips].[HealthProviderIndividual]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_HealthProviderIndividual_Title_Suffix' AND object_id = OBJECT_ID(N'[hips].[HealthProviderIndividual]'))
DROP INDEX [IX_HealthProviderIndividual_Title_Suffix] ON [hips].[HealthProviderIndividual]
GO
PRINT N'Creating index [IX_HealthProviderIndividual_Title_Suffix] ON [hips].[HealthProviderIndividual]'
GO
CREATE NONCLUSTERED INDEX [IX_HealthProviderIndividual_Title_Suffix] ON [hips].[HealthProviderIndividual] ([HealthProviderIndividualId], [TitleId], [SuffixId]) ON INDEXES
GO

PRINT N'Dropping index [IX_HealthProviderOrganisationPatient_PcehrAdvertised] from [hips].[HealthProviderOrganisationPatient]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_HealthProviderOrganisationPatient_PcehrAdvertised' AND object_id = OBJECT_ID(N'[hips].[HealthProviderOrganisationPatient]'))
DROP INDEX [IX_HealthProviderOrganisationPatient_PcehrAdvertised] ON [hips].[HealthProviderOrganisationPatient]
GO
PRINT N'Creating index [IX_HealthProviderOrganisationPatient_PcehrAdvertised] ON [hips].[HealthProviderOrganisationPatient]'
GO
CREATE NONCLUSTERED INDEX [IX_HealthProviderOrganisationPatient_PcehrAdvertised] ON [hips].[HealthProviderOrganisationPatient] ([PatientMasterId], [PcehrAdvertised]) ON INDEXES
GO

PRINT N'Dropping index [IX_HL7MessageLog] from [hips].[HL7MessageLog]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_HL7MessageLog' AND object_id = OBJECT_ID(N'[hips].[HL7MessageLog]'))
DROP INDEX [IX_HL7MessageLog] ON [hips].[HL7MessageLog]
GO
PRINT N'Creating index [IX_HL7MessageLog] ON [hips].[HL7MessageLog]'
GO
CREATE NONCLUSTERED INDEX [IX_HL7MessageLog] ON [hips].[HL7MessageLog] ([HL7MessageLogId], [DateCreated]) ON INDEXES
GO

PRINT N'Dropping index [IX_HL7MessageLog_DateCreated] from [hips].[HL7MessageLog]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_HL7MessageLog_DateCreated' AND object_id = OBJECT_ID(N'[hips].[HL7MessageLog]'))
DROP INDEX [IX_HL7MessageLog_DateCreated] ON [hips].[HL7MessageLog]
GO
PRINT N'Creating index [IX_HL7MessageLog_DateCreated] ON [hips].[HL7MessageLog]'
GO
CREATE NONCLUSTERED INDEX [IX_HL7MessageLog_DateCreated] ON [hips].[HL7MessageLog] ([DateCreated]) ON INDEXES
GO

PRINT N'Dropping index [IX_HL7MessageLog_FailureReason] from [hips].[HL7MessageLog]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_HL7MessageLog_FailureReason' AND object_id = OBJECT_ID(N'[hips].[HL7MessageLog]'))
DROP INDEX [IX_HL7MessageLog_FailureReason] ON [hips].[HL7MessageLog]
GO
PRINT N'Creating index [IX_HL7MessageLog_FailureReason] ON [hips].[HL7MessageLog]'
GO
CREATE NONCLUSTERED INDEX [IX_HL7MessageLog_FailureReason] ON [hips].[HL7MessageLog] ([FailureReason]) ON INDEXES
GO

PRINT N'Dropping index [IX_HL7MessageLog_Message] from [hips].[HL7MessageLog]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_HL7MessageLog_Message' AND object_id = OBJECT_ID(N'[hips].[HL7MessageLog]'))
DROP INDEX [IX_HL7MessageLog_Message] ON [hips].[HL7MessageLog]
GO
PRINT N'Creating index [IX_HL7MessageLog_Message] ON [hips].[HL7MessageLog]'
GO
CREATE NONCLUSTERED INDEX [IX_HL7MessageLog_Message] ON [hips].[HL7MessageLog] ([SendingApplication], [SendingFacility], [MessageControlId], [DateTimeOfMessage]) ON INDEXES
GO

PRINT N'Dropping index [IX_HL7MessageLogTime] from [hips].[HL7MessageLog]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_HL7MessageLogTime' AND object_id = OBJECT_ID(N'[hips].[HL7MessageLog]'))
DROP INDEX [IX_HL7MessageLogTime] ON [hips].[HL7MessageLog]
GO
PRINT N'Creating index [IX_HL7MessageLogTime] ON [hips].[HL7MessageLog]'
GO
CREATE NONCLUSTERED INDEX [IX_HL7MessageLogTime] ON [hips].[HL7MessageLog] ([HL7MessageLogId], [MessageControlId]) ON INDEXES
GO

PRINT N'Dropping index [IX_HospitalCode] from [hips].[HospitalCode]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_HospitalCode' AND object_id = OBJECT_ID(N'[hips].[HospitalCode]'))
DROP INDEX [IX_HospitalCode] ON [hips].[HospitalCode]
GO
PRINT N'Creating index [IX_HospitalCode] ON [hips].[HospitalCode]'
GO
CREATE NONCLUSTERED INDEX [IX_HospitalCode] ON [hips].[HospitalCode] ([CodeSystemId], [Code]) ON INDEXES
GO

PRINT N'Dropping index [IX_HospitalPatient_HidMrn] from [hips].[HospitalPatient]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_HospitalPatient_HidMrn' AND object_id = OBJECT_ID(N'[hips].[HospitalPatient]'))
DROP INDEX [IX_HospitalPatient_HidMrn] ON [hips].[HospitalPatient]
GO
PRINT N'Creating index [IX_HospitalPatient_HidMrn] ON [hips].[HospitalPatient]'
GO
CREATE NONCLUSTERED INDEX [IX_HospitalPatient_HidMrn] ON [hips].[HospitalPatient] ([HospitalId], [Mrn]) ON INDEXES
GO

PRINT N'Dropping index [IX_HospitalPatient_Mrn] from [hips].[HospitalPatient]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_HospitalPatient_Mrn' AND object_id = OBJECT_ID(N'[hips].[HospitalPatient]'))
DROP INDEX [IX_HospitalPatient_Mrn] ON [hips].[HospitalPatient]
GO
PRINT N'Creating index [IX_HospitalPatient_Mrn] ON [hips].[HospitalPatient]'
GO
CREATE NONCLUSTERED INDEX [IX_HospitalPatient_Mrn] ON [hips].[HospitalPatient] ([Mrn]) ON INDEXES
GO

PRINT N'Dropping index [IX_HospitalPatient_PMID] from [hips].[HospitalPatient]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_HospitalPatient_PMID' AND object_id = OBJECT_ID(N'[hips].[HospitalPatient]'))
DROP INDEX [IX_HospitalPatient_PMID] ON [hips].[HospitalPatient]
GO
PRINT N'Creating index [IX_HospitalPatient_PMID] ON [hips].[HospitalPatient]'
GO
CREATE NONCLUSTERED INDEX [IX_HospitalPatient_PMID] ON [hips].[HospitalPatient] ([PatientMasterId]) ON INDEXES
GO

PRINT N'Dropping index [IX_IhiLookupAudit] from [hips].[IhiLookupAudit]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_IhiLookupAudit' AND object_id = OBJECT_ID(N'[hips].[IhiLookupAudit]'))
DROP INDEX [IX_IhiLookupAudit] ON [hips].[IhiLookupAudit]
GO
PRINT N'Creating index [IX_IhiLookupAudit] ON [hips].[IhiLookupAudit]'
GO
CREATE NONCLUSTERED INDEX [IX_IhiLookupAudit] ON [hips].[IhiLookupAudit] ([PatientMasterId], [SequenceNumber]) ON INDEXES
GO

PRINT N'Dropping index [IX_IhiLookupAudit_Date] from [hips].[IhiLookupAudit]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_IhiLookupAudit_Date' AND object_id = OBJECT_ID(N'[hips].[IhiLookupAudit]'))
DROP INDEX [IX_IhiLookupAudit_Date] ON [hips].[IhiLookupAudit]
GO
PRINT N'Creating index [IX_IhiLookupAudit_Date] ON [hips].[IhiLookupAudit]'
GO
CREATE NONCLUSTERED INDEX [IX_IhiLookupAudit_Date] ON [hips].[IhiLookupAudit] ([DateCreated]) ON INDEXES
GO

PRINT N'Dropping index [IX_PatientMaster_DateTime] from [hips].[PatientMaster]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_PatientMaster_DateTime' AND object_id = OBJECT_ID(N'[hips].[PatientMaster]'))
DROP INDEX [IX_PatientMaster_DateTime] ON [hips].[PatientMaster]
GO
PRINT N'Creating index [IX_PatientMaster_DateTime] ON [hips].[PatientMaster]'
GO
CREATE NONCLUSTERED INDEX [IX_PatientMaster_DateTime] ON [hips].[PatientMaster] ([PatientMasterId], [DateModified]) ON INDEXES
GO

PRINT N'Dropping index [IX_PatientMaster_DOB] from [hips].[PatientMaster]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_PatientMaster_DOB' AND object_id = OBJECT_ID(N'[hips].[PatientMaster]'))
DROP INDEX [IX_PatientMaster_DOB] ON [hips].[PatientMaster]
GO
PRINT N'Creating index [IX_PatientMaster_DOB] ON [hips].[PatientMaster]'
GO
CREATE NONCLUSTERED INDEX [IX_PatientMaster_DOB] ON [hips].[PatientMaster] ([DateOfBirth]) ON INDEXES
GO

PRINT N'Dropping index [IX_PatientMaster_DVA] from [hips].[PatientMaster]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_PatientMaster_DVA' AND object_id = OBJECT_ID(N'[hips].[PatientMaster]'))
DROP INDEX [IX_PatientMaster_DVA] ON [hips].[PatientMaster]
GO
PRINT N'Creating index [IX_PatientMaster_DVA] ON [hips].[PatientMaster]'
GO
CREATE NONCLUSTERED INDEX [IX_PatientMaster_DVA] ON [hips].[PatientMaster] ([DvaNumber]) ON INDEXES
GO

PRINT N'Dropping index [IX_PatientMaster_Medicare] from [hips].[PatientMaster]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_PatientMaster_Medicare' AND object_id = OBJECT_ID(N'[hips].[PatientMaster]'))
DROP INDEX [IX_PatientMaster_Medicare] ON [hips].[PatientMaster]
GO
PRINT N'Creating index [IX_PatientMaster_Medicare] ON [hips].[PatientMaster]'
GO
CREATE NONCLUSTERED INDEX [IX_PatientMaster_Medicare] ON [hips].[PatientMaster] ([MedicareNumber], [MedicareIrn]) ON INDEXES
GO

PRINT N'Dropping index [IX_PatientMasterContact] from [hips].[PatientMasterContact]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_PatientMasterContact' AND object_id = OBJECT_ID(N'[hips].[PatientMasterContact]'))
DROP INDEX [IX_PatientMasterContact] ON [hips].[PatientMasterContact]
GO
PRINT N'Creating index [IX_PatientMasterContact] ON [hips].[PatientMasterContact]'
GO
CREATE NONCLUSTERED INDEX [IX_PatientMasterContact] ON [hips].[PatientMasterContact] ([PatientMasterId], [ContactId]) ON INDEXES
GO

PRINT N'Dropping index [IX_PatientMasterIhi_Ihi] from [hips].[PatientMasterIhi]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_PatientMasterIhi_Ihi' AND object_id = OBJECT_ID(N'[hips].[PatientMasterIhi]'))
DROP INDEX [IX_PatientMasterIhi_Ihi] ON [hips].[PatientMasterIhi]
GO
PRINT N'Creating index [IX_PatientMasterIhi_Ihi] ON [hips].[PatientMasterIhi]'
GO
CREATE NONCLUSTERED INDEX [IX_PatientMasterIhi_Ihi] ON [hips].[PatientMasterIhi] ([Ihi], [DateLastValidated]) ON INDEXES
GO

PRINT N'Dropping index [IX_PatientMasterIhi_LastVisited] from [hips].[PatientMasterIhi]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_PatientMasterIhi_LastVisited' AND object_id = OBJECT_ID(N'[hips].[PatientMasterIhi]'))
DROP INDEX [IX_PatientMasterIhi_LastVisited] ON [hips].[PatientMasterIhi]
GO
PRINT N'Creating index [IX_PatientMasterIhi_LastVisited] ON [hips].[PatientMasterIhi]'
GO
CREATE NONCLUSTERED INDEX [IX_PatientMasterIhi_LastVisited] ON [hips].[PatientMasterIhi] ([DateLastValidated]) ON INDEXES
GO

PRINT N'Dropping index [IX_PatientMasterIhi_Name] from [hips].[PatientMasterIhi]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_PatientMasterIhi_Name' AND object_id = OBJECT_ID(N'[hips].[PatientMasterIhi]'))
DROP INDEX [IX_PatientMasterIhi_Name] ON [hips].[PatientMasterIhi]
GO
PRINT N'Creating index [IX_PatientMasterIhi_Name] ON [hips].[PatientMasterIhi]'
GO
CREATE NONCLUSTERED INDEX [IX_PatientMasterIhi_Name] ON [hips].[PatientMasterIhi] ([RegisteredFamilyName], [RegisteredGivenName]) ON INDEXES
GO

PRINT N'Dropping index [IX_PatientMasterIhi_Status] from [hips].[PatientMasterIhi]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_PatientMasterIhi_Status' AND object_id = OBJECT_ID(N'[hips].[PatientMasterIhi]'))
DROP INDEX [IX_PatientMasterIhi_Status] ON [hips].[PatientMasterIhi]
GO
PRINT N'Creating index [IX_PatientMasterIhi_Status] ON [hips].[PatientMasterIhi]'
GO
CREATE NONCLUSTERED INDEX [IX_PatientMasterIhi_Status] ON [hips].[PatientMasterIhi] ([IhiRecordStatusId], [IhiStatusId]) ON INDEXES
GO

PRINT N'Dropping index [IX_PatientMasterName_Id] from [hips].[PatientMasterName]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_PatientMasterName_Id' AND object_id = OBJECT_ID(N'[hips].[PatientMasterName]'))
DROP INDEX [IX_PatientMasterName_Id] ON [hips].[PatientMasterName]
GO
PRINT N'Creating index [IX_PatientMasterName_Id] ON [hips].[PatientMasterName]'
GO
CREATE NONCLUSTERED INDEX [IX_PatientMasterName_Id] ON [hips].[PatientMasterName] ([PatientMasterId], [PatientMasterNameId]) ON INDEXES
GO

PRINT N'Dropping index [IX_PatientMasterName_Name] from [hips].[PatientMasterName]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_PatientMasterName_Name' AND object_id = OBJECT_ID(N'[hips].[PatientMasterName]'))
DROP INDEX [IX_PatientMasterName_Name] ON [hips].[PatientMasterName]
GO
PRINT N'Creating index [IX_PatientMasterName_Name] ON [hips].[PatientMasterName]'
GO
CREATE NONCLUSTERED INDEX [IX_PatientMasterName_Name] ON [hips].[PatientMasterName] ([FamilyName], [GivenNames], [NameTypeId]) ON INDEXES
GO

PRINT N'Dropping index [IX_PatientMasterName_NameType] from [hips].[PatientMasterName]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_PatientMasterName_NameType' AND object_id = OBJECT_ID(N'[hips].[PatientMasterName]'))
DROP INDEX [IX_PatientMasterName_NameType] ON [hips].[PatientMasterName]
GO
PRINT N'Creating index [IX_PatientMasterName_NameType] ON [hips].[PatientMasterName]'
GO
CREATE NONCLUSTERED INDEX [IX_PatientMasterName_NameType] ON [hips].[PatientMasterName] ([NameTypeId]) ON INDEXES
GO

PRINT N'Dropping index [IX_PcehrAudit] from [hips].[PcehrAudit]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_PcehrAudit' AND object_id = OBJECT_ID(N'[hips].[PcehrAudit]'))
DROP INDEX [IX_PcehrAudit] ON [hips].[PcehrAudit]
GO
PRINT N'Creating index [IX_PcehrAudit] ON [hips].[PcehrAudit]'
GO
CREATE NONCLUSTERED INDEX [IX_PcehrAudit] ON [hips].[PcehrAudit] ([DateCreated]) ON INDEXES
GO

PRINT N'Dropping index [IX_PcehrAudit_IHI] from [hips].[PcehrAudit]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_PcehrAudit_IHI' AND object_id = OBJECT_ID(N'[hips].[PcehrAudit]'))
DROP INDEX [IX_PcehrAudit_IHI] ON [hips].[PcehrAudit]
GO
PRINT N'Creating index [IX_PcehrAudit_IHI] ON [hips].[PcehrAudit]'
GO
CREATE NONCLUSTERED INDEX [IX_PcehrAudit_IHI] ON [hips].[PcehrAudit] ([Ihi], [DateCreated]) ON INDEXES
GO

PRINT N'Dropping index [IX_PcehrAudit_ServiceName] from [hips].[PcehrAudit]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_PcehrAudit_ServiceName' AND object_id = OBJECT_ID(N'[hips].[PcehrAudit]'))
DROP INDEX [IX_PcehrAudit_ServiceName] ON [hips].[PcehrAudit]
GO
PRINT N'Creating index [IX_PcehrAudit_ServiceName] ON [hips].[PcehrAudit]'
GO
CREATE NONCLUSTERED INDEX [IX_PcehrAudit_ServiceName] ON [hips].[PcehrAudit] ([ServiceName], [PatientMasterId], [UserName], [DateCreated]) ON INDEXES
GO

PRINT N'Dropping index [IX_PcehrMessageQueue_DateCreated] from [hips].[PcehrMessageQueue]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_PcehrMessageQueue_DateCreated' AND object_id = OBJECT_ID(N'[hips].[PcehrMessageQueue]'))
DROP INDEX [IX_PcehrMessageQueue_DateCreated] ON [hips].[PcehrMessageQueue]
GO
PRINT N'Creating index [IX_PcehrMessageQueue_DateCreated] ON [hips].[PcehrMessageQueue]'
GO
CREATE NONCLUSTERED INDEX [IX_PcehrMessageQueue_DateCreated] ON [hips].[PcehrMessageQueue] ([DateCreated]) ON INDEXES
GO

PRINT N'Dropping index [IX_PcehrMessageQueue_Episode] from [hips].[PcehrMessageQueue]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_PcehrMessageQueue_Episode' AND object_id = OBJECT_ID(N'[hips].[PcehrMessageQueue]'))
DROP INDEX [IX_PcehrMessageQueue_Episode] ON [hips].[PcehrMessageQueue]
GO
PRINT N'Creating index [IX_PcehrMessageQueue_Episode] ON [hips].[PcehrMessageQueue]'
GO
CREATE NONCLUSTERED INDEX [IX_PcehrMessageQueue_Episode] ON [hips].[PcehrMessageQueue] ([EpisodeId]) ON INDEXES
GO

PRINT N'Dropping index [IX_PcehrMessageQueue_Status] from [hips].[PcehrMessageQueue]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_PcehrMessageQueue_Status' AND object_id = OBJECT_ID(N'[hips].[PcehrMessageQueue]'))
DROP INDEX [IX_PcehrMessageQueue_Status] ON [hips].[PcehrMessageQueue]
GO
PRINT N'Creating index [IX_PcehrMessageQueue_Status] ON [hips].[PcehrMessageQueue]'
GO
CREATE NONCLUSTERED INDEX [IX_PcehrMessageQueue_Status] ON [hips].[PcehrMessageQueue] ([QueueStatusId], [DateCreated]) ON INDEXES
GO

PRINT N'Dropping index [IX_SystemErrorLog] from [hips].[SystemErrorLog]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_SystemErrorLog' AND object_id = OBJECT_ID(N'[hips].[SystemErrorLog]'))
DROP INDEX [IX_SystemErrorLog] ON [hips].[SystemErrorLog]
GO
PRINT N'Creating index [IX_SystemErrorLog] ON [hips].[SystemErrorLog]'
GO
CREATE NONCLUSTERED INDEX [IX_SystemErrorLog] ON [hips].[SystemErrorLog] ([LogMessageId]) ON INDEXES
GO

PRINT N'Dropping index [IX_SystemErrorLog_LogDateCreated] from [hips].[SystemErrorLog]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_SystemErrorLog_LogDateCreated' AND object_id = OBJECT_ID(N'[hips].[SystemErrorLog]'))
DROP INDEX [IX_SystemErrorLog_LogDateCreated] ON [hips].[SystemErrorLog]
GO
PRINT N'Creating index [IX_SystemErrorLog_LogDateCreated] ON [hips].[SystemErrorLog]'
GO
CREATE NONCLUSTERED INDEX [IX_SystemErrorLog_LogDateCreated] ON [hips].[SystemErrorLog] ([LogMessageId], [DateCreated]) ON INDEXES
GO

PRINT N'Dropping index [IX_SystemErrorLog_DateCreated] from [hips].[SystemErrorLog]'
GO
IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IX_SystemErrorLog_DateCreated' AND object_id = OBJECT_ID(N'[hips].[SystemErrorLog]'))
DROP INDEX [IX_SystemErrorLog_DateCreated] ON [hips].[SystemErrorLog]
GO
PRINT N'Creating index [IX_SystemErrorLog_DateCreated] ON [hips].[SystemErrorLog]'
GO
CREATE NONCLUSTERED INDEX [IX_SystemErrorLog_DateCreated] ON [hips].[SystemErrorLog] ([DateCreated]) ON INDEXES
GO