/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.hi.handler.security;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.xsp.CertificateVerificationException;
import au.gov.nehta.xsp.CertificateVerifier;
import au.gov.nehta.xsp.SignatureValidationException;
import au.gov.nehta.xsp.XmlSignatureProfileService;
import au.gov.nehta.xsp.XspException;
import au.gov.nehta.xsp.XspFactory;
import au.gov.nehta.xsp.XspVersion;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.security.auth.x500.X500PrivateCredential;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPPart;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class HISecurityHandler
implements SOAPHandler<SOAPMessageContext> {
    public static final String PRODUCT = "product";
    public static final String TIMESTAMP = "timestamp";
    public static final String USER = "user";
    public static final String COMMON_COREELEMENTS_NS = "http://ns.electronichealth.net.au/hi/xsd/common/CommonCoreElements/3.0";
    public static final String DIG_NS = "http://www.w3.org/2000/09/xmldsig#";
    public static final String SIGNATURE_ELEM = "signature";
    public static final CertificateVerifier NULL_CERTIFICATE_VERIFIER = new CertificateVerifier(){

        public void verify(X509Certificate certificate) throws CertificateVerificationException, XspException {
        }
    };
    private static final String USER_PREFIX = "user_";
    private static final String TS_PREFIX = "ts_";
    private static final String DATA_PREFIX = "data_";
    private static final String ID_ATTR = "xml:id";
    private static final String XMLNS = "xmlns:xml";
    private X509Certificate x509Certificate;
    private PrivateKey privateKey;

    public HISecurityHandler(X509Certificate x509Certificate, PrivateKey privateKey) {
        ArgumentUtils.checkNotNull((Object)x509Certificate, (String)"x509Certificate");
        ArgumentUtils.checkNotNull((Object)privateKey, (String)"privateKey");
        this.x509Certificate = x509Certificate;
        this.privateKey = privateKey;
    }

    public final boolean handleMessage(SOAPMessageContext context) {
        Boolean isOutgoing = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
        if (isOutgoing.booleanValue()) {
            this.signBodyAndSOAPHeaders(context);
        } else {
            this.extractElementsAndVerifyingSignature(context);
        }
        return true;
    }

    public final boolean handleFault(SOAPMessageContext context) {
        if (!((Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound")).booleanValue()) {
            this.extractElementsAndVerifyingSignature(context);
        }
        return true;
    }

    public final Set<QName> getHeaders() {
        return null;
    }

    public void close(MessageContext context) {
    }

    private void signBodyAndSOAPHeaders(SOAPMessageContext context) {
        ArgumentUtils.checkNotNull((Object)context, (String)"context");
        SOAPMessageContext localContext = context;
        try {
            Object envelope = null;
            SOAPHeader header = null;
            SOAPBody body = null;
            SOAPPart soapPart = this.getSoapPartFromLocalContext(localContext);
            ArgumentUtils.checkNotNull((Object)soapPart, (String)"Outgoing message soapPart");
            ArgumentUtils.checkNotNull((Object)soapPart.getEnvelope(), (String)"Outgoing message soapPart.getEnvelope()");
            header = soapPart.getEnvelope().getHeader();
            body = soapPart.getEnvelope().getBody();
            this.extractAndSignSoapElements(header, (Element)body);
        }
        catch (SOAPException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (XspException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private SOAPPart getSoapPartFromLocalContext(SOAPMessageContext localContext) {
        ArgumentUtils.checkNotNull((Object)localContext, (String)"SOAPMessageContext");
        ArgumentUtils.checkNotNull((Object)localContext.getMessage(), (String)"SOAPMessageContext.getMessage()");
        return localContext.getMessage().getSOAPPart();
    }

    private void extractAndSignSoapElements(SOAPHeader header, Element body) throws XspException {
        ArgumentUtils.checkNotNull((Object)header, (String)"Outgoing message SOAP header");
        ArgumentUtils.checkNotNull((Object)body, (String)"Outgoing message SOAP body");
        NodeList userNodeList = header.getElementsByTagNameNS(COMMON_COREELEMENTS_NS, USER);
        NodeList prodNodeList = header.getElementsByTagNameNS(COMMON_COREELEMENTS_NS, PRODUCT);
        NodeList timestampNodeList = header.getElementsByTagNameNS(COMMON_COREELEMENTS_NS, TIMESTAMP);
        NodeList sigNodeList = header.getElementsByTagNameNS(COMMON_COREELEMENTS_NS, SIGNATURE_ELEM);
        Element userElem = this.getFirstElementFromNodeList(userNodeList);
        Element prodElem = this.getFirstElementFromNodeList(prodNodeList);
        Element timestampElem = this.getFirstElementFromNodeList(timestampNodeList);
        Element sigElem = this.getFirstElementFromNodeList(sigNodeList);
        HISecurityHandler.removeXMLNS(userElem);
        HISecurityHandler.removeXMLNS(prodElem);
        HISecurityHandler.removeXMLNS(timestampElem);
        HISecurityHandler.removeXMLNS(sigElem);
        this.addSignatureReferenceId(body, timestampElem, userElem);
        this.signSoapElements(timestampElem, userElem, body, sigElem);
    }

    private void signSoapElements(Element timestampElem, Element userElem, Element body, Element sigElem) throws XspException {
        List<Element> elementsToSign = Arrays.asList(timestampElem, userElem, body);
        List<X500PrivateCredential> certificateKeyPairs = Arrays.asList(new X500PrivateCredential(this.x509Certificate, this.privateKey));
        XmlSignatureProfileService xmlSignatureProfileService = XspFactory.getInstance().getXmlSignatureProfileService(XspVersion.V_2010);
        xmlSignatureProfileService.sign(sigElem, elementsToSign, certificateKeyPairs);
    }

    private Element getFirstElementFromNodeList(NodeList nodeList) {
        Element element = null;
        ArgumentUtils.checkNotNull((Object)nodeList, (String)"nodeList");
        if (nodeList.getLength() > 0) {
            ArgumentUtils.checkNotNull((Object)nodeList.item(0), (String)"nodeList.item(0)");
            element = (Element)nodeList.item(0);
        }
        return element;
    }

    private void addSignatureReferenceId(Element body, Element timestampElem, Element userElem) {
        ArgumentUtils.checkNotNull((Object)body, (String)"bodyElement");
        ArgumentUtils.checkNotNull((Object)timestampElem, (String)"timestampElem");
        ArgumentUtils.checkNotNull((Object)userElem, (String)"userElem");
        body.setAttribute(ID_ATTR, DATA_PREFIX + UUID.randomUUID().toString());
        timestampElem.setAttribute(ID_ATTR, TS_PREFIX + UUID.randomUUID().toString());
        userElem.setAttribute(ID_ATTR, USER_PREFIX + UUID.randomUUID().toString());
    }

    private static void removeXMLNS(Element elem) {
        ArgumentUtils.checkNotNull((Object)elem, (String)"elem");
        if (elem.hasAttribute(XMLNS)) {
            elem.removeAttribute(XMLNS);
        }
    }

    private void extractElementsAndVerifyingSignature(SOAPMessageContext context) {
        SOAPMessageContext localContext = context;
        SOAPEnvelope envelope = null;
        Object header = null;
        SOAPPart soapPart = this.getSoapPartFromLocalContext(localContext);
        try {
            if (soapPart == null || soapPart.getEnvelope() == null) {
                throw new IllegalArgumentException("SOAP missing envelope");
            }
            soapPart = localContext.getMessage().getSOAPPart();
            envelope = soapPart.getEnvelope();
            this.verifySoapElements(envelope.getHeader());
        }
        catch (XspException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (SOAPException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private void verifySoapElements(SOAPHeader header) throws XspException {
        try {
            ArgumentUtils.checkNotNull((Object)header, (String)"Failed to verify incoming signature. Invalid SOAP header");
            NodeList sigList = header.getElementsByTagNameNS(DIG_NS, "Signature");
            List<X500PrivateCredential> certificateKeyPairs = Arrays.asList(new X500PrivateCredential(this.x509Certificate, this.privateKey));
            XmlSignatureProfileService xmlSignatureProfile = XspFactory.getInstance().getXmlSignatureProfileService(XspVersion.V_2010);
            xmlSignatureProfile.check((Element)sigList.item(0), NULL_CERTIFICATE_VERIFIER);
        }
        catch (SignatureValidationException ex) {
            throw new XspException(ex.getMessage(), (Throwable)ex);
        }
        catch (CertificateVerificationException ex) {
            throw new XspException(ex.getMessage(), (Throwable)ex);
        }
    }
}

