/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.hi.hpii;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.hi.handler.message.HIHeaderHandler;
import au.gov.nehta.vendorlibrary.hi.handler.security.HISecurityHandler;
import au.gov.nehta.vendorlibrary.ws.TimeUtility;
import au.gov.nehta.vendorlibrary.ws.WebServiceClientUtil;
import au.gov.nehta.vendorlibrary.ws.handler.LoggingHandler;
import au.net.electronichealth.ns.hi.svc.hiprovidersearchindividual._5_0_0.ProviderSearchForProviderIndividualPortType;
import au.net.electronichealth.ns.hi.svc.hiprovidersearchindividual._5_0_0.ProviderSearchForProviderIndividualService;
import au.net.electronichealth.ns.hi.svc.hiprovidersearchindividual._5_0_0.SearchForProviderIndividual;
import au.net.electronichealth.ns.hi.svc.hiprovidersearchindividual._5_0_0.SearchForProviderIndividualResponse;
import au.net.electronichealth.ns.hi.svc.hiprovidersearchindividual._5_0_0.StandardErrorMsg;
import au.net.electronichealth.ns.hi.xsd.common.addresscore._5_0.SearchAustralianAddressType;
import au.net.electronichealth.ns.hi.xsd.common.addresscore._5_0.SearchInternationalAddressType;
import au.net.electronichealth.ns.hi.xsd.common.commoncoreelements._3.ProductType;
import au.net.electronichealth.ns.hi.xsd.common.commoncoreelements._3.TimestampType;
import au.net.electronichealth.ns.hi.xsd.common.qualifiedidentifier._3.QualifiedId;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;

public class ProviderSearchForProviderIndividualClient {
    public static final String EMPTY = "";
    private static final String SSL_SOCKET_FACTORY = "com.sun.xml.ws.transport.https.client.SSLSocketFactory";
    private SSLSocketFactory sslSocketFactory;
    private static final String HPIO_CSP_HEADER_ELEMENT_NAME = "hpio";
    private PrivateKey signingPrivateKey;
    private X509Certificate signingCertificate;
    private final QualifiedId individualQualifiedId;
    private final QualifiedId organisationQualifiedId;
    private final Holder<ProductType> productHeader;
    private ProviderSearchForProviderIndividualPortType port;
    private LoggingHandler loggingHandler;
    private ArgumentValidator validator = new ArgumentValidator();

    public ProviderSearchForProviderIndividualClient(String serviceEndpoint, QualifiedId individualQualifiedId, Holder<ProductType> productHeader, PrivateKey signingPrivateKey, X509Certificate signingCertificate, SSLSocketFactory sslSocketFactory) {
        this(serviceEndpoint, individualQualifiedId, null, productHeader, signingPrivateKey, signingCertificate, sslSocketFactory);
    }

    public ProviderSearchForProviderIndividualClient(String serviceEndpoint, QualifiedId individualQualifiedId, QualifiedId organisationQualifiedId, Holder<ProductType> productHeader, PrivateKey signingPrivateKey, X509Certificate signingCertificate, SSLSocketFactory sslSocketFactory) {
        ArgumentUtils.checkNotNullNorBlank((String)serviceEndpoint, (String)"serviceEndpoint");
        ArgumentUtils.checkNotNull((Object)individualQualifiedId, (String)"individualQualifiedId");
        ArgumentUtils.checkNotNull(productHeader, (String)"productHeader");
        ArgumentUtils.checkNotNull((Object)signingPrivateKey, (String)"signingPrivateKey");
        ArgumentUtils.checkNotNull((Object)signingCertificate, (String)"signingPrivateKey");
        ArgumentUtils.checkNotNull((Object)sslSocketFactory, (String)"sslSocketFactory");
        this.sslSocketFactory = sslSocketFactory;
        this.individualQualifiedId = individualQualifiedId;
        this.organisationQualifiedId = organisationQualifiedId;
        this.productHeader = productHeader;
        this.signingPrivateKey = signingPrivateKey;
        this.signingCertificate = signingCertificate;
        this.loggingHandler = new LoggingHandler(true);
        ArrayList<LoggingHandler> handlerChain = new ArrayList<LoggingHandler>();
        handlerChain.add(this.loggingHandler);
        this.port = (ProviderSearchForProviderIndividualPortType)WebServiceClientUtil.getPort(ProviderSearchForProviderIndividualPortType.class, ProviderSearchForProviderIndividualService.class, (SocketFactory)sslSocketFactory, handlerChain);
        this.configureEndpoint(this.port, serviceEndpoint);
    }

    public final SearchForProviderIndividualResponse demographicSearch(SearchForProviderIndividual request) throws StandardErrorMsg {
        this.validator.demographicSearchCheck(request);
        Holder signatureHeader = null;
        return this.getPort().searchForProviderIndividual(request, this.productHeader, this.getTimestampHeader(), signatureHeader, this.individualQualifiedId, this.organisationQualifiedId);
    }

    public final SearchForProviderIndividualResponse identifierSearch(SearchForProviderIndividual request) throws StandardErrorMsg {
        this.validator.identifierSearchCheck(request);
        Holder signatureHeader = null;
        return this.getPort().searchForProviderIndividual(request, this.productHeader, this.getTimestampHeader(), signatureHeader, this.individualQualifiedId, this.organisationQualifiedId);
    }

    private TimestampType getTimestampHeader() {
        TimestampType timestampHeader = new TimestampType();
        timestampHeader.setCreated(TimeUtility.nowXMLGregorianCalendar());
        return timestampHeader;
    }

    private void configureEndpoint(Object servicePort, String endpoint) {
        BindingProvider bindingProvider = (BindingProvider)servicePort;
        Map requestContext = bindingProvider.getRequestContext();
        requestContext.put("javax.xml.ws.service.endpoint.address", endpoint.trim());
        requestContext.put(SSL_SOCKET_FACTORY, this.sslSocketFactory);
        if (bindingProvider != null && bindingProvider.getBinding() != null) {
            Binding binding = bindingProvider.getBinding();
            List handlerChain = binding.getHandlerChain();
            if (this.organisationQualifiedId == null) {
                ArrayList<String> headerNames = new ArrayList<String>();
                headerNames.add(HPIO_CSP_HEADER_ELEMENT_NAME);
                handlerChain.add(new HIHeaderHandler(headerNames));
            }
            handlerChain.add(new HISecurityHandler(this.signingCertificate, this.signingPrivateKey));
            handlerChain.add(this.loggingHandler);
            binding.setHandlerChain(handlerChain);
        }
    }

    public final ProviderSearchForProviderIndividualPortType getPort() {
        return this.port;
    }

    public final String getLastSoapResponse() {
        if (this.loggingHandler != null) {
            return this.loggingHandler.getLastSoapResponse();
        }
        return EMPTY;
    }

    public final String getLastSoapRequest() {
        if (this.loggingHandler != null) {
            return this.loggingHandler.getLastSoapRequest();
        }
        return EMPTY;
    }

    private static final boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static class ArgumentValidator {
        public static final int AUSTRALIAN_POSTCODE_LENGTH = 4;

        public final void identifierSearchCheck(SearchForProviderIndividual request) {
            ArgumentUtils.checkNotNull((Object)request, (String)"Request must be supplied");
            ArgumentUtils.checkNotNull((Object)request.getFamilyName(), (String)"Family name must be supplied");
            ArgumentUtils.checkMaxLength((String)request.getFamilyName(), (int)40, (String)"FamilyName");
            boolean isHPIIEmpty = ProviderSearchForProviderIndividualClient.isEmpty(request.getHpiiNumber());
            boolean isRegistrationIDEmpty = ProviderSearchForProviderIndividualClient.isEmpty(request.getRegistrationId());
            if (!isRegistrationIDEmpty && !isHPIIEmpty) {
                throw new IllegalArgumentException("You must not supply either HPII or RegistraionId");
            }
        }

        public final void demographicSearchCheck(SearchForProviderIndividual request) {
            ArgumentUtils.checkNotNull((Object)request, (String)"Request must be supplied");
            ArgumentUtils.checkNotNull((Object)request.getFamilyName(), (String)"Family name must be supplied");
            ArgumentUtils.checkMaxLength((String)request.getFamilyName(), (int)40, (String)"FamilyName");
            this.ensureNull(request.getHpiiNumber(), "HPII Number");
            this.ensureEitherOneOrBothAreNull(request.getSearchAustralianAddress(), "Australian Address Criteria", request.getSearchInternationalAddress(), "International Address Criteria");
            if (ProviderSearchForProviderIndividualClient.isEmpty(request.getFamilyName())) {
                if (request.getSearchAustralianAddress() != null) {
                    this.checkAustralianAddressCriteria(request.getSearchAustralianAddress());
                } else if (request.getSearchInternationalAddress() != null) {
                    this.checkInternationalAddressCriteria(request.getSearchInternationalAddress());
                }
            }
        }

        private void checkAustralianAddressCriteria(SearchAustralianAddressType searchAustralianAddressType) {
            ArgumentUtils.checkNotNullNorBlank((String)searchAustralianAddressType.getSuburb(), (String)"Australian Address Criteria: Suburb");
            ArgumentUtils.checkNotNull((Object)searchAustralianAddressType.getState(), (String)"Australian Address Criteria: State");
            ArgumentUtils.checkNotNullNorBlank((String)searchAustralianAddressType.getPostcode(), (String)"Australian Address Criteria: Postcode");
            this.ensureExactStringLength(searchAustralianAddressType.getPostcode(), 4, "Post Code");
        }

        private void checkInternationalAddressCriteria(SearchInternationalAddressType searchInternationalAddressType) {
            ArgumentUtils.checkNotNullNorBlank((String)searchInternationalAddressType.getInternationalAddressLine(), (String)"International Address Criteria: Address Line");
            ArgumentUtils.checkNotNullNorBlank((String)searchInternationalAddressType.getInternationalStateProvince(), (String)"International Address Criteria: State Province");
            ArgumentUtils.checkNotNullNorBlank((String)searchInternationalAddressType.getInternationalPostcode(), (String)"International Address Criteria: Postcode");
            ArgumentUtils.checkNotNull((Object)searchInternationalAddressType.getCountry(), (String)"International Address Criteria: Country");
        }

        private void ensureEitherOneOrBothAreNull(Object obj1, String obj1Name, Object ob2, String obj2Name) {
            if (obj1 != null && ob2 != null) {
                throw new IllegalArgumentException("Both " + obj1Name + " and " + obj2Name + " are set. Only one of them may be set");
            }
        }

        private void ensureNull(Object theObject, String objectName) {
            if (theObject != null) {
                throw new IllegalArgumentException(objectName + " may not be not-null");
            }
        }

        private void ensureExactStringLength(String theString, Integer length, String stringName) {
            if (theString.length() != length.intValue()) {
                throw new IllegalArgumentException(stringName + " must have a length of " + length);
            }
        }
    }
}

