/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.hi.hpio;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.hi.handler.message.HIHeaderHandler;
import au.gov.nehta.vendorlibrary.hi.handler.security.HISecurityHandler;
import au.gov.nehta.vendorlibrary.ws.TimeUtility;
import au.gov.nehta.vendorlibrary.ws.WebServiceClientUtil;
import au.gov.nehta.vendorlibrary.ws.handler.LoggingHandler;
import au.net.electronichealth.ns.hi.svc.hiprovidersearchorg._5_0_0.ProviderSearchForProviderOrganisationPortType;
import au.net.electronichealth.ns.hi.svc.hiprovidersearchorg._5_0_0.ProviderSearchForProviderOrganisationService;
import au.net.electronichealth.ns.hi.svc.hiprovidersearchorg._5_0_0.SearchForProviderOrganisation;
import au.net.electronichealth.ns.hi.svc.hiprovidersearchorg._5_0_0.SearchForProviderOrganisationResponse;
import au.net.electronichealth.ns.hi.svc.hiprovidersearchorg._5_0_0.StandardErrorMsg;
import au.net.electronichealth.ns.hi.xsd.common.commoncoreelements._3.ProductType;
import au.net.electronichealth.ns.hi.xsd.common.commoncoreelements._3.TimestampType;
import au.net.electronichealth.ns.hi.xsd.common.qualifiedidentifier._3.QualifiedId;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;

public class ProviderSearchForProviderOrganisationClient {
    public static final String EMPTY = "";
    private static final String SSL_SOCKET_FACTORY = "com.sun.xml.ws.transport.https.client.SSLSocketFactory";
    private SSLSocketFactory sslSocketFactory;
    private static final String HPIO_CSP_HEADER_ELEMENT_NAME = "hpio";
    private PrivateKey signingPrivateKey;
    private X509Certificate signingCertificate;
    private final QualifiedId individualQualifiedId;
    private final QualifiedId organisationQualifiedId;
    private final Holder<ProductType> productHeader;
    private ProviderSearchForProviderOrganisationPortType port;
    private LoggingHandler loggingHandler;

    public ProviderSearchForProviderOrganisationClient(String serviceEndpoint, QualifiedId individualQualifiedId, Holder<ProductType> productHeader, PrivateKey signingPrivateKey, X509Certificate signingCertificate, SSLSocketFactory sslSocketFactory) {
        this(serviceEndpoint, individualQualifiedId, null, productHeader, signingPrivateKey, signingCertificate, sslSocketFactory);
    }

    public ProviderSearchForProviderOrganisationClient(String serviceEndpoint, QualifiedId individualQualifiedId, QualifiedId organisationQualifiedId, Holder<ProductType> productHeader, PrivateKey signingPrivateKey, X509Certificate signingCertificate, SSLSocketFactory sslSocketFactory) {
        ArgumentUtils.checkNotNullNorBlank((String)serviceEndpoint, (String)"serviceEndpoint");
        ArgumentUtils.checkNotNull((Object)individualQualifiedId, (String)"individualQualifiedId");
        ArgumentUtils.checkNotNull(productHeader, (String)"productHeader");
        ArgumentUtils.checkNotNull((Object)signingPrivateKey, (String)"signingPrivateKey");
        ArgumentUtils.checkNotNull((Object)signingCertificate, (String)"signingPrivateKey");
        ArgumentUtils.checkNotNull((Object)sslSocketFactory, (String)"sslSocketFactory");
        this.sslSocketFactory = sslSocketFactory;
        this.individualQualifiedId = individualQualifiedId;
        this.organisationQualifiedId = organisationQualifiedId;
        this.productHeader = productHeader;
        this.signingPrivateKey = signingPrivateKey;
        this.signingCertificate = signingCertificate;
        this.loggingHandler = new LoggingHandler(true);
        ArrayList<LoggingHandler> handlerChain = new ArrayList<LoggingHandler>();
        handlerChain.add(this.loggingHandler);
        this.port = (ProviderSearchForProviderOrganisationPortType)WebServiceClientUtil.getPort(ProviderSearchForProviderOrganisationPortType.class, ProviderSearchForProviderOrganisationService.class, (SocketFactory)sslSocketFactory, handlerChain);
        this.configureEndpoint(this.port, serviceEndpoint);
    }

    public final SearchForProviderOrganisationResponse identifierSearch(SearchForProviderOrganisation request) throws StandardErrorMsg {
        ArgumentUtils.checkNotNull((Object)request, (String)"request");
        ArgumentUtils.checkNotNullNorBlank((String)request.getHpioNumber(), (String)"HPI-O Number");
        Holder signatureHeader = null;
        return this.port.searchForProviderOrganisation(request, this.productHeader, this.getTimestampHeader(), signatureHeader, this.individualQualifiedId, this.organisationQualifiedId);
    }

    private TimestampType getTimestampHeader() {
        TimestampType timestampHeader = new TimestampType();
        timestampHeader.setCreated(TimeUtility.nowXMLGregorianCalendar());
        return timestampHeader;
    }

    private void configureEndpoint(Object servicePort, String endpoint) {
        BindingProvider bindingProvider = (BindingProvider)servicePort;
        Map requestContext = bindingProvider.getRequestContext();
        requestContext.put("javax.xml.ws.service.endpoint.address", endpoint.trim());
        requestContext.put(SSL_SOCKET_FACTORY, this.sslSocketFactory);
        if (bindingProvider != null && bindingProvider.getBinding() != null) {
            Binding binding = bindingProvider.getBinding();
            List handlerChain = binding.getHandlerChain();
            if (this.organisationQualifiedId == null) {
                ArrayList<String> headerNames = new ArrayList<String>();
                headerNames.add(HPIO_CSP_HEADER_ELEMENT_NAME);
                handlerChain.add(new HIHeaderHandler(headerNames));
            }
            handlerChain.add(new HISecurityHandler(this.signingCertificate, this.signingPrivateKey));
            handlerChain.add(this.loggingHandler);
            binding.setHandlerChain(handlerChain);
        }
    }

    public final String getLastSoapResponse() {
        if (this.loggingHandler != null) {
            return this.loggingHandler.getLastSoapResponse();
        }
        return EMPTY;
    }

    public final String getLastSoapRequest() {
        if (this.loggingHandler != null) {
            return this.loggingHandler.getLastSoapRequest();
        }
        return EMPTY;
    }

    public ProviderSearchForProviderOrganisationPortType getPort() {
        return this.port;
    }
}

