/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.common.utils;

import au.gov.nehta.common.utils.ArgumentUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;

public class ResourceLocator {
    private static final List<SearchOrderItem> DEFAULT_SEARCH_ORDER = Arrays.asList(SearchOrderItem.FILE_SYSTEM, SearchOrderItem.CLASSPATH);
    private static final ResourceLocator instance = new ResourceLocator();

    public static ResourceLocator getInstance() {
        return instance;
    }

    private ResourceLocator() {
    }

    public InputStream find(String resourcePath) {
        return this.find(resourcePath, null, DEFAULT_SEARCH_ORDER);
    }

    public InputStream find(String resourcePath, Class referenceClass) {
        return this.find(resourcePath, referenceClass, DEFAULT_SEARCH_ORDER);
    }

    public InputStream find(String resourcePath, List<SearchOrderItem> searchOrder) {
        return this.find(resourcePath, null, searchOrder);
    }

    public InputStream find(String resourcePath, Class referenceClass, List<SearchOrderItem> searchOrder) {
        assert (resourcePath != null) : "'resourcePath' is null.";
        assert (resourcePath.trim().length() > 0) : "'resourcePath' is a blank string.";
        List<SearchOrderItem> actualSearchOrder = searchOrder;
        if (ArgumentUtils.isNullOrEmpty(searchOrder)) {
            actualSearchOrder = DEFAULT_SEARCH_ORDER;
        }
        for (SearchOrderItem currSearchOrderItem : actualSearchOrder) {
            InputStream in;
            if (currSearchOrderItem == SearchOrderItem.FILE_SYSTEM) {
                try {
                    in = new FileInputStream(resourcePath);
                    return in;
                }
                catch (FileNotFoundException e) {
                    continue;
                }
            }
            if (currSearchOrderItem == SearchOrderItem.CLASSPATH) {
                in = this.getStreamFromClasspath(resourcePath, referenceClass);
                if (in == null) continue;
                return in;
            }
            if (currSearchOrderItem != SearchOrderItem.REMOTE_URL) continue;
            try {
                URL url = new URL(resourcePath);
                return url.openStream();
            }
            catch (MalformedURLException e) {
            }
            catch (IOException e) {
            }
        }
        return null;
    }

    public InputStream getStreamFromClasspath(String resourcePath) {
        return this.getStreamFromClasspath(resourcePath, null);
    }

    public InputStream getStreamFromClasspath(String resourcePath, Class referenceClass) {
        assert (resourcePath != null) : "'resourcePath' is null.";
        assert (resourcePath.trim().length() > 0) : "'resourcePath' is a blank string.";
        ClassLoader classLoader = this.getClassLoader(referenceClass);
        return classLoader.getResourceAsStream(resourcePath);
    }

    public URL getUrlFromClasspath(String resourcePath) {
        return this.getUrlFromClasspath(resourcePath, null);
    }

    public URL getUrlFromClasspath(String resourcePath, Class referenceClass) {
        assert (resourcePath != null) : "'resourcePath' is null.";
        assert (resourcePath.trim().length() > 0) : "'resourcePath' is a blank string.";
        ClassLoader classLoader = this.getClassLoader(referenceClass);
        return classLoader.getResource(resourcePath);
    }

    private ClassLoader getClassLoader(Class referenceClass) {
        ClassLoader classLoader = null;
        if (referenceClass != null) {
            classLoader = referenceClass.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static enum SearchOrderItem {
        CLASSPATH,
        FILE_SYSTEM,
        REMOTE_URL;

    }
}

