/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.hi.hpio;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.hi.handler.message.HIHeaderHandler;
import au.gov.nehta.vendorlibrary.hi.handler.security.HISecurityHandler;
import au.gov.nehta.vendorlibrary.ws.TimeUtility;
import au.gov.nehta.vendorlibrary.ws.WebServiceClientUtil;
import au.gov.nehta.vendorlibrary.ws.handler.LoggingHandler;
import au.net.electronichealth.ns.hi.common.commoncoreelements._3_0.ProductType;
import au.net.electronichealth.ns.hi.common.commoncoreelements._3_0.TimestampType;
import au.net.electronichealth.ns.hi.common.qualifiedidentifier._3_0.QualifiedId;
import au.net.electronichealth.ns.hi.providercore.address._3_2_0.AustralianAddressCriteriaType;
import au.net.electronichealth.ns.hi.providercore.address._3_2_0.InternationalAddressCriteriaType;
import au.net.electronichealth.ns.hi.svc.hiproviderdirectoryfororganisation._3_2_0.ProviderSearchHIProviderDirectoryForOrganisationPortType;
import au.net.electronichealth.ns.hi.svc.hiproviderdirectoryfororganisation._3_2_0.ProviderSearchHIProviderDirectoryForOrganisationService;
import au.net.electronichealth.ns.hi.svc.hiproviderdirectoryfororganisation._3_2_0.SearchHIProviderDirectoryForOrganisation;
import au.net.electronichealth.ns.hi.svc.hiproviderdirectoryfororganisation._3_2_0.SearchHIProviderDirectoryForOrganisationResponse;
import au.net.electronichealth.ns.hi.svc.hiproviderdirectoryfororganisation._3_2_0.StandardErrorMsg;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;

public class ProviderSearchHIProviderDirectoryForOrganisationClient {
    public static final String EMPTY = "";
    private static final String SSL_SOCKET_FACTORY = "com.sun.xml.ws.transport.https.client.SSLSocketFactory";
    private ArgumentValidator argumentValidator = new ArgumentValidator();
    private SSLSocketFactory sslSocketFactory;
    private static final String HPIO_CSP_HEADER_ELEMENT_NAME = "hpio";
    private PrivateKey signingPrivateKey;
    private X509Certificate signingCertificate;
    private final QualifiedId individualQualifiedId;
    private final QualifiedId organisationQualifiedId;
    private final Holder<ProductType> productHeader;
    private ProviderSearchHIProviderDirectoryForOrganisationPortType providerSearchHIProviderDirectoryForOrganisationPort;
    private String lastSoapRequest;
    private String lastSoapResponse;
    private LoggingHandler loggingHandler;

    public ProviderSearchHIProviderDirectoryForOrganisationClient(String serviceEndpoint, QualifiedId individualQualifiedId, Holder<ProductType> productHeader, PrivateKey signingPrivateKey, X509Certificate signingCertificate, SSLSocketFactory sslSocketFactory) {
        this(serviceEndpoint, individualQualifiedId, null, productHeader, signingPrivateKey, signingCertificate, sslSocketFactory);
    }

    public ProviderSearchHIProviderDirectoryForOrganisationClient(String serviceEndpoint, QualifiedId individualQualifiedId, QualifiedId organisationQualifiedId, Holder<ProductType> productHeader, PrivateKey signingPrivateKey, X509Certificate signingCertificate, SSLSocketFactory sslSocketFactory) {
        ArgumentUtils.checkNotNullNorBlank((String)serviceEndpoint, (String)"serviceEndpoint");
        ArgumentUtils.checkNotNull((Object)individualQualifiedId, (String)"individualQualifiedId");
        ArgumentUtils.checkNotNull(productHeader, (String)"productHeader");
        ArgumentUtils.checkNotNull((Object)signingPrivateKey, (String)"signingPrivateKey");
        ArgumentUtils.checkNotNull((Object)signingCertificate, (String)"signingPrivateKey");
        ArgumentUtils.checkNotNull((Object)sslSocketFactory, (String)"sslSocketFactory");
        this.sslSocketFactory = sslSocketFactory;
        this.individualQualifiedId = individualQualifiedId;
        this.organisationQualifiedId = organisationQualifiedId;
        this.productHeader = productHeader;
        this.signingPrivateKey = signingPrivateKey;
        this.signingCertificate = signingCertificate;
        this.loggingHandler = new LoggingHandler(true);
        ArrayList<LoggingHandler> handlerChain = new ArrayList<LoggingHandler>();
        handlerChain.add(this.loggingHandler);
        this.providerSearchHIProviderDirectoryForOrganisationPort = (ProviderSearchHIProviderDirectoryForOrganisationPortType)WebServiceClientUtil.getPort(ProviderSearchHIProviderDirectoryForOrganisationPortType.class, ProviderSearchHIProviderDirectoryForOrganisationService.class, (SocketFactory)sslSocketFactory, handlerChain);
        this.configureEndpoint(this.providerSearchHIProviderDirectoryForOrganisationPort, serviceEndpoint);
    }

    public final SearchHIProviderDirectoryForOrganisationResponse identifierSearch(SearchHIProviderDirectoryForOrganisation request) throws StandardErrorMsg {
        this.argumentValidator.identifierSearchCheck(request);
        Holder signatureHeader = null;
        return this.providerSearchHIProviderDirectoryForOrganisationPort.searchHIProviderDirectoryForOrganisation(request, this.productHeader, this.getTimestampHeader(), signatureHeader, this.individualQualifiedId, this.organisationQualifiedId);
    }

    private TimestampType getTimestampHeader() {
        TimestampType timestampHeader = new TimestampType();
        timestampHeader.setCreated(TimeUtility.nowXMLGregorianCalendar());
        return timestampHeader;
    }

    public final SearchHIProviderDirectoryForOrganisationResponse demographicSearch(SearchHIProviderDirectoryForOrganisation request) throws StandardErrorMsg {
        this.argumentValidator.demographicSearchCheck(request);
        Holder signatureHeader = null;
        return this.providerSearchHIProviderDirectoryForOrganisationPort.searchHIProviderDirectoryForOrganisation(request, this.productHeader, this.getTimestampHeader(), signatureHeader, this.individualQualifiedId, this.organisationQualifiedId);
    }

    private void configureEndpoint(Object servicePort, String endpoint) {
        BindingProvider bindingProvider = (BindingProvider)servicePort;
        Map requestContext = bindingProvider.getRequestContext();
        requestContext.put("javax.xml.ws.service.endpoint.address", endpoint.trim());
        requestContext.put(SSL_SOCKET_FACTORY, this.sslSocketFactory);
        if (bindingProvider != null && bindingProvider.getBinding() != null) {
            Binding binding = bindingProvider.getBinding();
            List handlerChain = binding.getHandlerChain();
            if (this.organisationQualifiedId == null) {
                ArrayList<String> headerNames = new ArrayList<String>();
                headerNames.add(HPIO_CSP_HEADER_ELEMENT_NAME);
                handlerChain.add(new HIHeaderHandler(headerNames));
            }
            handlerChain.add(new HISecurityHandler(this.signingCertificate, this.signingPrivateKey));
            handlerChain.add(this.loggingHandler);
            binding.setHandlerChain(handlerChain);
        }
    }

    public final String getLastSoapResponse() {
        if (this.loggingHandler != null) {
            return this.loggingHandler.getLastSoapResponse();
        }
        return EMPTY;
    }

    public final String getLastSoapRequest() {
        if (this.loggingHandler != null) {
            return this.loggingHandler.getLastSoapRequest();
        }
        return EMPTY;
    }

    public static class ArgumentValidator {
        public static final int AUSTRALIAN_POSTCODE_LENGTH = 4;

        public final void identifierSearchCheck(SearchHIProviderDirectoryForOrganisation request) {
            ArgumentUtils.checkNotNull((Object)request, (String)"request");
            ArgumentUtils.checkNotNullNorBlank((String)request.getHpioNumber(), (String)"HPI-O Number");
            this.ensureNull(request.getName(), "Name");
            this.ensureNull(request.getOrganisationType(), "Type");
            this.ensureNull(request.getServiceType(), "Service Type");
            this.ensureNull(request.getUnitType(), "Unit Type");
            this.ensureNull(request.getOrganisationDetails(), "Organisation Details");
            this.ensureNull(request.getAustralianAddressCriteria(), "Australian Address Criteria");
            this.ensureNull(request.getInternationalAddressCriteria(), "International Address Criteria");
        }

        public final void demographicSearchCheck(SearchHIProviderDirectoryForOrganisation request) {
            ArgumentUtils.checkNotNull((Object)request, (String)"request");
            this.ensureNull(request.getHpioNumber(), "HPI-O Number");
            this.ensureNull(request.getLinkSearchType(), "Link Search Type");
            this.ensureEitherOneOrBothAreNull(request.getAustralianAddressCriteria(), "Australian Address Criteria", request.getInternationalAddressCriteria(), "International Address Criteria");
            if (request.getAustralianAddressCriteria() != null) {
                this.checkAustralianAddressCriteria(request.getAustralianAddressCriteria());
            } else if (request.getInternationalAddressCriteria() != null) {
                this.checkInternationalAddressCriteria(request.getInternationalAddressCriteria());
            }
        }

        private void checkAustralianAddressCriteria(AustralianAddressCriteriaType address) {
            ArgumentUtils.checkNotNullNorBlank((String)address.getSuburb(), (String)"Australian Address Criteria: Suburb");
            ArgumentUtils.checkNotNull((Object)address.getState(), (String)"Australian Address Criteria: State");
            ArgumentUtils.checkNotNullNorBlank((String)address.getPostcode(), (String)"Australian Address Criteria: Postcode");
            this.ensureExactStringLength(address.getPostcode(), 4, "Post Code");
            if (this.isAddressUnstructured(address)) {
                ArgumentUtils.checkNotNullNorBlank((String)address.getUnstructuredAddressLine(), (String)"Australian Address Criteria: Unstructured Address Line");
            }
        }

        private boolean isAddressUnstructured(AustralianAddressCriteriaType address) {
            return address.getLevelGroup() == null && address.getUnitGroup() == null && address.getAddressSiteName() == null && address.getStreetNumber() == null && address.getLotNumber() == null && address.getStreetName() == null && address.getStreetType() == null && address.getStreetSuffix() == null && address.getPostalDeliveryGroup() == null;
        }

        private void checkInternationalAddressCriteria(InternationalAddressCriteriaType address) {
            ArgumentUtils.checkNotNullNorBlank((String)address.getInternationalAddressLine(), (String)"International Address Criteria: Address Line");
            ArgumentUtils.checkNotNullNorBlank((String)address.getInternationalStateProvince(), (String)"International Address Criteria: State Province");
            ArgumentUtils.checkNotNullNorBlank((String)address.getInternationalPostcode(), (String)"International Address Criteria: Postcode");
            ArgumentUtils.checkNotNull((Object)address.getCountry(), (String)"International Address Criteria: Country");
        }

        private void ensureEitherOneOrBothAreNull(Object obj1, String obj1Name, InternationalAddressCriteriaType obj2, String obj2Name) {
            if (obj1 != null && obj2 != null) {
                throw new IllegalArgumentException("Both " + obj1Name + " and " + obj2Name + " are set. Only one of them may be set");
            }
        }

        private void ensureNull(Object theObject, String objectName) {
            if (theObject != null) {
                throw new IllegalArgumentException(objectName + " may not be not-null");
            }
        }

        private void ensureExactStringLength(String theString, Integer length, String stringName) {
            if (theString.length() != length.intValue()) {
                throw new IllegalArgumentException(stringName + " must have a length of " + length);
            }
        }
    }
}

