/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.hi.ihi;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.hi.handler.message.HIHeaderHandler;
import au.gov.nehta.vendorlibrary.hi.handler.security.HISecurityHandler;
import au.gov.nehta.vendorlibrary.ws.TimeUtility;
import au.gov.nehta.vendorlibrary.ws.WebServiceClientUtil;
import au.gov.nehta.vendorlibrary.ws.handler.LoggingHandler;
import au.net.electronichealth.ns.hi.common.commoncoredatatypes._3_0.SexType;
import au.net.electronichealth.ns.hi.common.commoncoreelements._3_0.ProductType;
import au.net.electronichealth.ns.hi.common.commoncoreelements._3_0.TimestampType;
import au.net.electronichealth.ns.hi.common.qualifiedidentifier._3_0.QualifiedId;
import au.net.electronichealth.ns.hi.consumercore.address._3_0.AustralianPostalAddressType;
import au.net.electronichealth.ns.hi.consumercore.address._3_0.AustralianStreetAddressType;
import au.net.electronichealth.ns.hi.consumercore.address._3_0.InternationalAddressType;
import au.net.electronichealth.ns.hi.svc.consumersearchihi._3_0.ConsumerSearchIHIPortType;
import au.net.electronichealth.ns.hi.svc.consumersearchihi._3_0.ConsumerSearchIHIService;
import au.net.electronichealth.ns.hi.svc.consumersearchihi._3_0.SearchIHI;
import au.net.electronichealth.ns.hi.svc.consumersearchihi._3_0.SearchIHIResponse;
import au.net.electronichealth.ns.hi.svc.consumersearchihi._3_0.StandardErrorMsg;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;

public class ConsumerSearchIHIClient {
    public static final String EMPTY = "";
    private static final String SSL_SOCKET_FACTORY = "com.sun.xml.ws.transport.https.client.SSLSocketFactory";
    private static final String HPIO_CSP_HEADER_ELEMENT_NAME = "hpio";
    private ArgumentValidator argumentValidator = new ArgumentValidator();
    private SSLSocketFactory sslSocketFactory;
    private PrivateKey signingPrivateKey;
    private X509Certificate signingCertificate;
    private LoggingHandler loggingHandler;
    private final QualifiedId individualQualifiedId;
    private final QualifiedId organisationQualifiedId;
    private final Holder<ProductType> productHeader;
    private ConsumerSearchIHIPortType consumerSearchIHIPort;
    private String lastSoapRequest;
    private String lastSoapResponse;

    public ConsumerSearchIHIClient(String searchIhiServiceEndpoint, QualifiedId individualQualifiedId, Holder<ProductType> productHeader, PrivateKey signingPrivateKey, X509Certificate signingCertificate, SSLSocketFactory sslSocketFactory) {
        this(searchIhiServiceEndpoint, individualQualifiedId, null, productHeader, signingPrivateKey, signingCertificate, sslSocketFactory);
    }

    private ConsumerSearchIHIClient(String searchIhiServiceEndpoint, QualifiedId individualQualifiedId, QualifiedId organisationQualifiedId, Holder<ProductType> productHeader, PrivateKey signingPrivateKey, X509Certificate signingCertificate, SSLSocketFactory sslSocketFactory) {
        ArgumentUtils.checkNotNullNorBlank((String)searchIhiServiceEndpoint, (String)"searchIhiServiceEndpoint");
        ArgumentUtils.checkNotNull((Object)individualQualifiedId, (String)"qualifiedId");
        ArgumentUtils.checkNotNull(productHeader, (String)"productHeader");
        ArgumentUtils.checkNotNull((Object)signingPrivateKey, (String)"signingPrivateKey");
        ArgumentUtils.checkNotNull((Object)signingCertificate, (String)"signingPrivateKey");
        ArgumentUtils.checkNotNull((Object)sslSocketFactory, (String)"sslSocketFactory");
        this.signingPrivateKey = signingPrivateKey;
        this.signingCertificate = signingCertificate;
        this.sslSocketFactory = sslSocketFactory;
        this.individualQualifiedId = individualQualifiedId;
        this.organisationQualifiedId = organisationQualifiedId;
        this.productHeader = productHeader;
        this.loggingHandler = new LoggingHandler(false);
        ArrayList<LoggingHandler> handlerChain = new ArrayList<LoggingHandler>();
        handlerChain.add(this.loggingHandler);
        this.consumerSearchIHIPort = (ConsumerSearchIHIPortType)WebServiceClientUtil.getPort(ConsumerSearchIHIPortType.class, ConsumerSearchIHIService.class, (SocketFactory)sslSocketFactory, handlerChain);
        this.configureEndpoint(this.consumerSearchIHIPort, searchIhiServiceEndpoint);
    }

    public final SearchIHIResponse basicSearch(SearchIHI request) throws StandardErrorMsg {
        this.argumentValidator.basicSearchCheck(request);
        TimestampType timestampHeader = new TimestampType();
        timestampHeader.setCreated(TimeUtility.nowXMLGregorianCalendar());
        Holder signatureHeader = null;
        return this.consumerSearchIHIPort.searchIHI(request, this.productHeader, timestampHeader, signatureHeader, this.individualQualifiedId, this.organisationQualifiedId);
    }

    public final SearchIHIResponse basicMedicareSearch(SearchIHI request) throws StandardErrorMsg {
        this.argumentValidator.basicMedicareSearchCheck(request);
        TimestampType timestampHeader = new TimestampType();
        timestampHeader.setCreated(TimeUtility.nowXMLGregorianCalendar());
        Holder signatureHeader = null;
        return this.consumerSearchIHIPort.searchIHI(request, this.productHeader, timestampHeader, signatureHeader, this.individualQualifiedId, this.organisationQualifiedId);
    }

    public final SearchIHIResponse basicDvaSearch(SearchIHI request) throws StandardErrorMsg {
        this.argumentValidator.basicDvaSearchCheck(request);
        TimestampType timestampHeader = new TimestampType();
        timestampHeader.setCreated(TimeUtility.nowXMLGregorianCalendar());
        Holder signatureHeader = null;
        return this.consumerSearchIHIPort.searchIHI(request, this.productHeader, timestampHeader, signatureHeader, this.individualQualifiedId, this.organisationQualifiedId);
    }

    public final SearchIHIResponse detailedSearch(SearchIHI request) throws StandardErrorMsg {
        this.argumentValidator.detailedSearchCheck(request);
        TimestampType timestampHeader = new TimestampType();
        timestampHeader.setCreated(TimeUtility.nowXMLGregorianCalendar());
        Holder signatureHeader = null;
        return this.consumerSearchIHIPort.searchIHI(request, this.productHeader, timestampHeader, signatureHeader, this.individualQualifiedId, this.organisationQualifiedId);
    }

    public final SearchIHIResponse australianPostalAddressSearch(SearchIHI request) throws StandardErrorMsg {
        this.argumentValidator.australianPostalAddressSearchCheck(request);
        TimestampType timestampHeader = new TimestampType();
        timestampHeader.setCreated(TimeUtility.nowXMLGregorianCalendar());
        Holder signatureHeader = null;
        return this.consumerSearchIHIPort.searchIHI(request, this.productHeader, timestampHeader, signatureHeader, this.individualQualifiedId, this.organisationQualifiedId);
    }

    public final SearchIHIResponse australianStreetAddressSearch(SearchIHI request) throws StandardErrorMsg {
        this.argumentValidator.australianStreetAddressSearchCheck(request);
        TimestampType timestampHeader = new TimestampType();
        timestampHeader.setCreated(TimeUtility.nowXMLGregorianCalendar());
        Holder signatureHeader = null;
        return this.consumerSearchIHIPort.searchIHI(request, this.productHeader, timestampHeader, signatureHeader, this.individualQualifiedId, this.organisationQualifiedId);
    }

    public final SearchIHIResponse internationalAddressSearch(SearchIHI request) throws StandardErrorMsg {
        this.argumentValidator.internationalAddressSearchCheck(request);
        TimestampType timestampHeader = new TimestampType();
        timestampHeader.setCreated(TimeUtility.nowXMLGregorianCalendar());
        Holder signatureHeader = null;
        return this.consumerSearchIHIPort.searchIHI(request, this.productHeader, timestampHeader, signatureHeader, this.individualQualifiedId, this.organisationQualifiedId);
    }

    private void configureEndpoint(Object servicePort, String endpoint) {
        BindingProvider bindingProvider = (BindingProvider)servicePort;
        Map requestContext = bindingProvider.getRequestContext();
        requestContext.put("javax.xml.ws.service.endpoint.address", endpoint.trim());
        requestContext.put(SSL_SOCKET_FACTORY, this.sslSocketFactory);
        if (bindingProvider != null && bindingProvider.getBinding() != null) {
            Binding binding = bindingProvider.getBinding();
            List handlerChain = binding.getHandlerChain();
            ArrayList<String> headerNames = new ArrayList<String>();
            headerNames.add(HPIO_CSP_HEADER_ELEMENT_NAME);
            handlerChain.add(new HIHeaderHandler(headerNames));
            handlerChain.add(new HISecurityHandler(this.signingCertificate, this.signingPrivateKey));
            handlerChain.add(this.loggingHandler);
            binding.setHandlerChain(handlerChain);
        }
    }

    public final String getLastSoapResponse() {
        if (this.loggingHandler != null) {
            return this.loggingHandler.getLastSoapResponse();
        }
        return EMPTY;
    }

    public final String getLastSoapRequest() {
        if (this.loggingHandler != null) {
            return this.loggingHandler.getLastSoapRequest();
        }
        return EMPTY;
    }

    public static class ArgumentValidator {
        public static final int POSTAL_DELIVERY_NUMBER_MAX_LENGTH = 11;
        public static final int AUSTRALIAN_POSTCODE_LENGTH = 4;

        public final void basicSearchCheck(SearchIHI request) {
            this.checkCommonMandatoryParameters(request);
            ArgumentUtils.checkNotNullNorBlank((String)request.getIhiNumber(), (String)"IHI Number");
            this.ensureNull(request.getAustralianPostalAddress(), "Australian Postal Address");
            this.ensureNull(request.getDvaFileNumber(), "DVA File Number");
            this.ensureNull(request.getAustralianStreetAddress(), "Australian Street Address");
            this.ensureNull(request.getHistory(), "History");
            this.ensureNull(request.getInternationalAddress(), "International Address");
            this.ensureNull(request.getMedicareCardNumber(), "Medicare Card Number");
            this.ensureNull(request.getMedicareIRN(), "Medicare IRN");
        }

        public final void basicMedicareSearchCheck(SearchIHI request) {
            this.checkCommonMandatoryParameters(request);
            ArgumentUtils.checkNotNullNorBlank((String)request.getMedicareCardNumber(), (String)"Medicare Card Number");
            this.ensureNull(request.getAustralianPostalAddress(), "Australian Postal Address");
            this.ensureNull(request.getDvaFileNumber(), "DVA File Number");
            this.ensureNull(request.getAustralianStreetAddress(), "Australian Street Address");
            this.ensureNull(request.getHistory(), "History");
            this.ensureNull(request.getInternationalAddress(), "International Address");
        }

        public final void basicDvaSearchCheck(SearchIHI request) {
            this.checkCommonMandatoryParameters(request);
            ArgumentUtils.checkNotNullNorBlank((String)request.getDvaFileNumber(), (String)"DVA File Name");
            this.ensureNull(request.getAustralianPostalAddress(), "Australian Postal Address");
            this.ensureNull(request.getMedicareCardNumber(), "Medicare Card Number");
            this.ensureNull(request.getMedicareIRN(), "Medicare IRN");
            this.ensureNull(request.getAustralianStreetAddress(), "Australian Street Address");
            this.ensureNull(request.getHistory(), "History");
            this.ensureNull(request.getInternationalAddress(), "International Address");
        }

        public final void detailedSearchCheck(SearchIHI request) {
            this.checkCommonMandatoryParameters(request);
            this.ensureNull(request.getAustralianPostalAddress(), "Australian Postal Address");
            this.ensureNull(request.getMedicareCardNumber(), "Medicare Card Number");
            this.ensureNull(request.getMedicareIRN(), "Medicare IRN");
            this.ensureNull(request.getDvaFileNumber(), "DVA File Name");
            this.ensureNull(request.getAustralianStreetAddress(), "Australian Street Address");
            this.ensureNull(request.getHistory(), "History");
            this.ensureNull(request.getInternationalAddress(), "International Address");
        }

        public final void australianPostalAddressSearchCheck(SearchIHI request) {
            this.checkCommonMandatoryParameters(request);
            AustralianPostalAddressType australianPostalAddress = request.getAustralianPostalAddress();
            ArgumentUtils.checkNotNull((Object)australianPostalAddress, (String)"Australian Postal Address");
            ArgumentUtils.checkNotNull((Object)australianPostalAddress.getPostalDeliveryGroup(), (String)"Postal Delivery Group");
            ArgumentUtils.checkNotNull((Object)australianPostalAddress.getPostalDeliveryGroup().getPostalDeliveryType(), (String)"Postal Delivery Type");
            if (australianPostalAddress.getPostalDeliveryGroup().getPostalDeliveryNumber() != null) {
                ArgumentUtils.checkMaxLength((String)australianPostalAddress.getPostalDeliveryGroup().getPostalDeliveryNumber(), (int)11, (String)"Postal Delivery Number");
            }
            ArgumentUtils.checkNotNull((Object)australianPostalAddress.getState(), (String)"State");
            ArgumentUtils.checkNotNullNorBlank((String)australianPostalAddress.getPostcode(), (String)"Post Code");
            this.ensureExactStringLength(australianPostalAddress.getPostcode(), 4, "Post Code");
            ArgumentUtils.checkNotNullNorBlank((String)australianPostalAddress.getSuburb(), (String)"Suburb");
            this.ensureNull(request.getAustralianStreetAddress(), "Australian Street Address");
            this.australianAddressNullChecks(request);
        }

        public final void australianStreetAddressSearchCheck(SearchIHI request) {
            this.checkCommonMandatoryParameters(request);
            AustralianStreetAddressType australianStreetAddress = request.getAustralianStreetAddress();
            ArgumentUtils.checkNotNull((Object)australianStreetAddress, (String)"Australian Street Address");
            ArgumentUtils.checkNotNullNorBlank((String)request.getAustralianStreetAddress().getStreetName(), (String)"Street Name");
            ArgumentUtils.checkNotNullNorBlank((String)request.getAustralianStreetAddress().getSuburb(), (String)"Suburb Name");
            ArgumentUtils.checkNotNull((Object)request.getAustralianStreetAddress().getState(), (String)"State");
            ArgumentUtils.checkNotNullNorBlank((String)request.getAustralianStreetAddress().getPostcode(), (String)"Post Code");
            this.ensureExactStringLength(australianStreetAddress.getPostcode(), 4, "Postcode");
            if (request.getAustralianStreetAddress().getUnitGroup() != null) {
                ArgumentUtils.checkNotNull((Object)request.getAustralianStreetAddress().getUnitGroup().getUnitType(), (String)"Unit Type");
            }
            if (request.getAustralianStreetAddress().getLevelGroup() != null) {
                ArgumentUtils.checkNotNull((Object)request.getAustralianStreetAddress().getLevelGroup().getLevelType(), (String)"Level Type");
            }
            this.ensureNull(request.getAustralianPostalAddress(), "Australian Postal Address");
            this.australianAddressNullChecks(request);
        }

        public final void internationalAddressSearchCheck(SearchIHI request) {
            this.checkCommonMandatoryParameters(request);
            InternationalAddressType internationalAddress = request.getInternationalAddress();
            ArgumentUtils.checkNotNull((Object)internationalAddress, (String)"International Address");
            ArgumentUtils.checkNotNullNorBlank((String)internationalAddress.getInternationalAddressLine(), (String)"International Address Line");
            ArgumentUtils.checkNotNullNorBlank((String)internationalAddress.getInternationalPostcode(), (String)"International Post Code");
            ArgumentUtils.checkNotNullNorBlank((String)internationalAddress.getInternationalStateProvince(), (String)"International State Province");
            ArgumentUtils.checkNotNull((Object)internationalAddress.getCountry(), (String)"Country");
            this.ensureNull(request.getMedicareCardNumber(), "Medicare Card Number");
            this.ensureNull(request.getMedicareIRN(), "Medicare IRN");
            this.ensureNull(request.getDvaFileNumber(), "DVA File Name");
            this.ensureNull(request.getAustralianStreetAddress(), "Australian Street Address");
            this.ensureNull(request.getAustralianPostalAddress(), "Australian Postal Address");
            this.ensureNull(request.getHistory(), "History");
        }

        private void australianAddressNullChecks(SearchIHI request) {
            this.ensureNull(request.getMedicareCardNumber(), "Medicare Card Number");
            this.ensureNull(request.getMedicareIRN(), "Medicare IRN");
            this.ensureNull(request.getDvaFileNumber(), "DVA File Name");
            this.ensureNull(request.getHistory(), "History");
            this.ensureNull(request.getInternationalAddress(), "International Address");
        }

        private void checkCommonMandatoryParameters(SearchIHI request) {
            if (request == null) {
                throw new IllegalArgumentException("The request may not be null");
            }
            ArgumentUtils.checkNotNullNorBlank((String)request.getFamilyName(), (String)"Family Name");
            XMLGregorianCalendar dateOfBirth = request.getDateOfBirth();
            if (dateOfBirth == null) {
                throw new IllegalArgumentException("Date of birth may not be null");
            }
            if (!dateOfBirth.isValid()) {
                throw new IllegalArgumentException("Date of birth is invalid");
            }
            SexType sex = request.getSex();
            if (sex == null) {
                throw new IllegalArgumentException("Sex may not be null");
            }
        }

        private void ensureNull(Object theObject, String objectName) {
            if (theObject != null) {
                throw new IllegalArgumentException(objectName + " may not be not-null");
            }
        }

        private void ensureExactStringLength(String theString, Integer length, String stringName) {
            if (theString.length() != length.intValue()) {
                throw new IllegalArgumentException(stringName + " must have a length of " + length);
            }
        }
    }
}

