/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.common.security;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.common.security.EncryptedContainerProfileUtil;
import au.gov.nehta.vendorlibrary.common.security.SignedContainerProfileUtil;
import au.gov.nehta.xsp.XspException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKey;
import javax.security.auth.x500.X500PrivateCredential;
import org.w3c.dom.Document;

public final class SignedEncryptedContainerProfileUtil {
    private SignedEncryptedContainerProfileUtil() {
    }

    public static Document getSignedEncryptedPayload(String sensitivePayload, List<X500PrivateCredential> certificateKeyPairs, X509Certificate encryptingCert) throws XspException {
        ArgumentUtils.checkNotNullNorBlank((String)sensitivePayload, (String)"sensitivePayload");
        ArgumentUtils.checkNotNull(certificateKeyPairs, (String)"certificateKeyPairs");
        ArgumentUtils.checkNotNull((Object)encryptingCert, (String)"encryptingCert");
        Document signedData = SignedContainerProfileUtil.getSignedPayload(sensitivePayload, certificateKeyPairs);
        Document signedEncryptedPayload = EncryptedContainerProfileUtil.getEncryptedPayload(signedData, encryptingCert);
        return signedEncryptedPayload;
    }

    public static Document getSignedEncryptedPayload(String sensitivePayload, SecretKey sessionKey, List<X500PrivateCredential> certificateKeyPairs, List<X509Certificate> encryptingCertificates) throws XspException {
        ArgumentUtils.checkNotNullNorBlank((String)sensitivePayload, (String)"sensitivePayload");
        ArgumentUtils.checkNotNull((Object)sessionKey, (String)"sessionKey");
        ArgumentUtils.checkNotNull(certificateKeyPairs, (String)"certificateKeyPairs");
        ArgumentUtils.checkNotNull(encryptingCertificates, (String)"encryptingCertificates");
        Document signedEncryptedPayload = null;
        Document signedData = SignedContainerProfileUtil.getSignedPayload(sensitivePayload, certificateKeyPairs);
        signedEncryptedPayload = EncryptedContainerProfileUtil.getEncryptedPayload(signedData, sessionKey, encryptingCertificates);
        return signedEncryptedPayload;
    }

    public static Document getSignedEncryptedPayload(String sensitivePayload, SecretKey sessionKey, List<X500PrivateCredential> certificateKeyPairs, X509Certificate encryptingCert) throws XspException {
        ArgumentUtils.checkNotNull((Object)encryptingCert, (String)"encryptingCert");
        ArrayList<X509Certificate> encryptingCertificates = new ArrayList<X509Certificate>();
        encryptingCertificates.add(encryptingCert);
        return SignedEncryptedContainerProfileUtil.getSignedEncryptedPayload(sensitivePayload, sessionKey, certificateKeyPairs, encryptingCertificates);
    }

    public static Document getDataFromSignedEncryptedPayload(Document signedEncryptedPayload, X500PrivateCredential privateCredential) throws XspException {
        ArgumentUtils.checkNotNull((Object)signedEncryptedPayload, (String)"signedEncryptedPayload");
        ArgumentUtils.checkNotNull((Object)privateCredential, (String)"privateCredential");
        Document decryptedDocument = EncryptedContainerProfileUtil.getDecryptedPayload(signedEncryptedPayload, privateCredential);
        Document extractedDocument = SignedContainerProfileUtil.getDataFromSignedPayload(decryptedDocument);
        return extractedDocument;
    }
}

