/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.clinicalpackage.core;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.clinicalpackage.util.MemberException;
import au.gov.nehta.vendorlibrary.clinicalpackage.util.Validation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public final class Member {
    private static final int HASH_VALUE = 31;
    private final String uri;
    private final byte[] fileContent;

    private Member(Builder builder) {
        this.uri = builder.uri;
        this.fileContent = builder.fileContent;
    }

    public byte[] getFileContent() {
        byte[] result = new byte[this.fileContent.length];
        System.arraycopy(this.fileContent, 0, result, 0, result.length);
        return result;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Member that = (Member)obj;
        if (!Arrays.equals(this.fileContent, that.fileContent)) {
            return false;
        }
        return this.uri.compareToIgnoreCase(that.uri) == 0;
    }

    public int hashCode() {
        return 31 * this.uri.hashCode() + Arrays.hashCode(this.fileContent);
    }

    public static class Builder {
        private String uri;
        private byte[] fileContent;

        public final Builder uri(String uri) {
            ArgumentUtils.checkNotNullNorBlank((String)uri, (String)"uri");
            this.uri = uri;
            return this;
        }

        public final Builder fileContent(byte[] fileContent) {
            if (fileContent != null) {
                this.fileContent = new byte[fileContent.length];
                System.arraycopy(fileContent, 0, this.fileContent, 0, fileContent.length);
            }
            return this;
        }

        public final Member build() {
            HashMap<String, List<String>> errors = new HashMap<String, List<String>>();
            errors.putAll(Validation.checkNotNullNorBlank("uri", this.uri));
            errors.putAll(Validation.checkNotNull("fileContent", this.fileContent));
            if (!errors.isEmpty()) {
                throw new MemberException(errors);
            }
            return new Member(this);
        }
    }
}

