/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.clinicalpackage.core;

import au.gov.nehta.vendorlibrary.clinicalpackage.core.Member;
import au.gov.nehta.vendorlibrary.clinicalpackage.enums.UriTypes;
import au.gov.nehta.vendorlibrary.clinicalpackage.util.SubmissionSetException;
import au.gov.nehta.vendorlibrary.clinicalpackage.util.Validation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public final class SubmissionSet {
    private static final int HASH_VALUE = 31;
    private final Member rootDocument;
    private final List<Member> attachments;
    private final Member signature;

    private SubmissionSet(Builder builder) {
        this.rootDocument = builder.rootDocument;
        this.attachments = builder.attachments;
        this.signature = builder.signature;
    }

    public Member getRootDocument() {
        return this.rootDocument;
    }

    public List<Member> getAttachments() {
        return this.attachments;
    }

    public Member getSignature() {
        return this.signature;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SubmissionSet that = (SubmissionSet)obj;
        Collections.sort(this.attachments, new Comparator<Member>(){

            @Override
            public int compare(Member o1, Member o2) {
                return o1.getUri().compareTo(o2.getUri());
            }
        });
        Collections.sort(that.attachments, new Comparator<Member>(){

            @Override
            public int compare(Member o1, Member o2) {
                return o1.getUri().compareTo(o2.getUri());
            }
        });
        if (this.attachments != null ? !((Object)this.attachments).equals(that.attachments) : that.attachments != null) {
            return false;
        }
        if (!this.rootDocument.equals(that.rootDocument)) {
            return false;
        }
        return !(this.signature != null ? !this.signature.equals(that.signature) : that.signature != null);
    }

    public int hashCode() {
        int result = this.rootDocument.hashCode();
        result = 31 * result + (this.attachments != null ? ((Object)this.attachments).hashCode() : 0);
        result = 31 * result + (this.signature != null ? this.signature.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private Member rootDocument;
        private final List<Member> attachments = new ArrayList<Member>();
        private Member signature;

        public final Builder rootDocument(byte[] fileContent) {
            this.rootDocument = new Member.Builder().uri(UriTypes.ROOT_DOCUMENT.getUri()).fileContent(fileContent).build();
            return this;
        }

        public final Builder attachment(String uri, byte[] fileContent) {
            this.attachments.add(new Member.Builder().uri(uri).fileContent(fileContent).build());
            return this;
        }

        public final Builder signature(byte[] fileContent) {
            this.signature = new Member.Builder().uri(UriTypes.SIGNATURE.getUri()).fileContent(fileContent).build();
            return this;
        }

        public final SubmissionSet build() {
            HashMap<String, List<String>> errors = new HashMap<String, List<String>>();
            errors.putAll(Validation.checkNotNull("rootDocument", this.rootDocument));
            if (!this.attachments.isEmpty()) {
                errors.putAll(Validation.checkNotNullNorEmpty("attachments", this.attachments));
            }
            if (errors.isEmpty()) {
                return new SubmissionSet(this);
            }
            throw new SubmissionSetException(errors);
        }
    }
}

