/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.common.utils;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class XsltUtils {
    public static Document transformToDom(Node xsltNode, Node inputNode) throws TransformerException {
        return XsltUtils.transformToDom(xsltNode, inputNode, null, null);
    }

    public static Document transformToDom(Node xsltNode, Node inputNode, Map<String, String> parameters) throws TransformerException {
        return XsltUtils.transformToDom(xsltNode, inputNode, parameters, null);
    }

    public static Document transformToDom(Node xsltNode, Node inputNode, Map<String, String> parameters, URIResolver uriResolver) throws TransformerException {
        assert (xsltNode != null) : "'xsltNode' is null.";
        assert (inputNode != null) : "'inputNode' is null.";
        DOMSource xsltSource = new DOMSource(xsltNode);
        DOMSource inputSource = new DOMSource(inputNode);
        DOMResult result = new DOMResult();
        XsltUtils.transform(xsltSource, inputSource, result, parameters, uriResolver);
        return (Document)result.getNode();
    }

    public static String transformToString(Node xsltNode, Node inputNode) throws TransformerException {
        return XsltUtils.transformToString(xsltNode, inputNode, null, null);
    }

    public static String transformToString(Node xsltNode, Node inputNode, Map<String, String> parameters) throws TransformerException {
        return XsltUtils.transformToString(xsltNode, inputNode, parameters, null);
    }

    public static String transformToString(Node xsltNode, Node inputNode, Map<String, String> parameters, URIResolver uriResolver) throws TransformerException {
        assert (xsltNode != null) : "'xsltNode' is null.";
        assert (inputNode != null) : "'inputNode' is null.";
        DOMSource xsltSource = new DOMSource(xsltNode);
        DOMSource inputSource = new DOMSource(inputNode);
        StringWriter output = new StringWriter();
        StreamResult result = new StreamResult(output);
        XsltUtils.transform(xsltSource, inputSource, result, parameters, uriResolver);
        output.flush();
        return output.toString();
    }

    public static void transform(Node xsltNode, Node inputNode, Writer output) throws TransformerException, IOException {
        XsltUtils.transform(xsltNode, inputNode, output, null, null);
    }

    public static void transform(Node xsltNode, Node inputNode, Writer output, Map<String, String> parameters) throws TransformerException, IOException {
        XsltUtils.transform(xsltNode, inputNode, output, parameters, null);
    }

    public static void transform(Node xsltNode, Node inputNode, Writer output, Map<String, String> parameters, URIResolver uriResolver) throws TransformerException, IOException {
        assert (xsltNode != null) : "'xsltNode' is null.";
        assert (inputNode != null) : "'inputNode' is null.";
        assert (output != null) : "'output' is null.";
        DOMSource xsltSource = new DOMSource(xsltNode);
        DOMSource inputSource = new DOMSource(inputNode);
        StreamResult result = new StreamResult(output);
        XsltUtils.transform(xsltSource, inputSource, result, parameters, uriResolver);
        output.flush();
    }

    public static void transform(Source xsltSource, Source inputSource, Result outputResult, Map<String, String> parameters, URIResolver uriResolver) throws TransformerException {
        assert (xsltSource != null) : "'xsltSource' is null.";
        assert (inputSource != null) : "'inputSource' is null.";
        assert (outputResult != null) : "'outputResult' is null.";
        Transformer transformer = XsltUtils.createTransformer(xsltSource, uriResolver);
        if (parameters != null) {
            for (String paramName : parameters.keySet()) {
                String paramValue = parameters.get(paramName);
                transformer.setParameter(paramName, paramValue);
            }
        }
        transformer.transform(inputSource, outputResult);
    }

    private static Transformer createTransformer(Source xsltSource, URIResolver uriResolver) throws TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        if (uriResolver != null) {
            factory.setURIResolver(uriResolver);
        }
        Transformer transformer = null;
        if (xsltSource == null) {
            transformer = factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        } else {
            transformer = factory.newTransformer(xsltSource);
        }
        return transformer;
    }

    private XsltUtils() {
    }
}

