/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.common.security;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.common.security.EncryptedContainerProfileUtil;
import au.gov.nehta.vendorlibrary.common.security.SignedContainerProfileUtil;
import au.gov.nehta.xsp.XspException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.security.auth.x500.X500PrivateCredential;
import org.w3c.dom.Document;

public class SignedEncryptedContainerProfileUtil {
    public static Document getSignedEncryptedPayload(String sensitivePayload, List<X500PrivateCredential> certificateKeyPairs, X509Certificate encryptingCert) {
        ArgumentUtils.checkNotNullNorBlank((String)sensitivePayload, (String)"sensitivePayload");
        ArgumentUtils.checkNotNull(certificateKeyPairs, (String)"certificateKeyPairs");
        ArgumentUtils.checkNotNull((Object)encryptingCert, (String)"encryptingCert");
        Document signedEncryptedPayload = null;
        try {
            Document signedData = SignedContainerProfileUtil.getSignedPayload(sensitivePayload, certificateKeyPairs);
            signedEncryptedPayload = EncryptedContainerProfileUtil.getEncryptedPayload(signedData, encryptingCert);
        }
        catch (XspException e) {
            // empty catch block
        }
        return signedEncryptedPayload;
    }

    public static Document getDataFromSignedEncryptedPayload(Document signedEncryptedPayload, X500PrivateCredential privateCredential) {
        ArgumentUtils.checkNotNull((Object)signedEncryptedPayload, (String)"signedEncryptedPayload");
        ArgumentUtils.checkNotNull((Object)privateCredential, (String)"privateCredential");
        Document extractedDocument = null;
        try {
            Document decryptedDocument = EncryptedContainerProfileUtil.getDecryptedPayload(signedEncryptedPayload, privateCredential);
            extractedDocument = SignedContainerProfileUtil.getDataFromSignedPayload(decryptedDocument);
        }
        catch (XspException e) {
            e.printStackTrace();
        }
        return extractedDocument;
    }
}

