/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.common.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProcessScheduler
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractProcessScheduler.class);
    private final int interval;
    private boolean stopThread = false;

    public AbstractProcessScheduler(int interval) {
        this.interval = interval;
    }

    @Override
    public void run() {
        this.runPeriodically();
    }

    public void runPeriodically() {
        try {
            this.stopThread = false;
            while (!this.stopThread) {
                Thread.sleep(this.interval);
                this.performThreadTask();
            }
        }
        catch (InterruptedException ex) {
            String errMsg = "The thread running periodic task,'" + this.getClass().getSimpleName() + "', was interrupted while sleeping.";
            LOGGER.warn(errMsg, (Throwable)ex);
        }
    }

    public abstract void performThreadTask();

    public synchronized void stopTimerThread() {
        this.stopThread = true;
    }

    public synchronized void startThread() {
        this.stopThread = false;
        this.runPeriodically();
    }

    public boolean isThreadRunning() {
        return !this.stopThread;
    }
}

