/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.xml;

import java.io.IOException;
import java.io.StringWriter;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public final class XmlUtil {
    private XmlUtil() {
    }

    public static String serialiseSoapXml(SOAPMessage message) {
        SOAPPart soapPart = message.getSOAPPart();
        try {
            SOAPEnvelope soapEnv = soapPart.getEnvelope();
            return XmlUtil.serialiseToString((Node)soapEnv);
        }
        catch (SOAPException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String serialiseToString(Node soapEnv) throws IOException {
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        try {
            DOMSource source = new DOMSource(soapEnv);
            XmlUtil.getTransformer().transform(source, result);
            writer.flush();
        }
        catch (TransformerConfigurationException e) {
            String string = null;
            return string;
        }
        catch (TransformerException e) {
            String string = null;
            return string;
        }
        finally {
            writer.close();
        }
        return writer.toString();
    }

    private static Transformer getTransformer() throws TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        return transformer;
    }
}

