/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.clinicalpackage.util;

import _org.w3.DigestMethodType;
import _org.w3.ManifestType;
import _org.w3.ReferenceType;
import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.clinicalpackage.core.Member;
import au.gov.nehta.vendorlibrary.clinicalpackage.core.SubmissionSet;
import au.gov.nehta.vendorlibrary.clinicalpackage.enums.ExpressionType;
import au.gov.nehta.vendorlibrary.clinicalpackage.enums.UriTypes;
import au.gov.nehta.vendorlibrary.clinicalpackage.enums.XMLNamespaces;
import au.gov.nehta.vendorlibrary.clinicalpackage.util.AttachmentVerificationException;
import au.gov.nehta.vendorlibrary.clinicalpackage.util.CDANamespaceContext;
import au.gov.nehta.vendorlibrary.clinicalpackage.util.PackageExtractionException;
import au.gov.nehta.vendorlibrary.clinicalpackage.util.SignatureGenerationException;
import au.gov.nehta.vendorlibrary.clinicalpackage.util.VerificationException;
import au.gov.nehta.vendorlibrary.common.security.SignedContainerProfileUtil;
import au.gov.nehta.xsp.CertificateVerifier;
import au.gov.nehta.xsp.SignatureValidationException;
import au.gov.nehta.xsp.XspException;
import au.net.electronichealth.ns.cdapackage.xsd.esignature._2012.ApproverType;
import au.net.electronichealth.ns.cdapackage.xsd.esignature._2012.ESignatureType;
import au.net.electronichealth.ns.cdapackage.xsd.esignature._2012.ObjectFactory;
import au.net.electronichealth.ns.cdapackage.xsd.esignature._2012.PersonNameType;
import au.net.electronichealth.ns.xsp.xsd.signedpayload._2010.SignedPayloadDataType;
import au.net.electronichealth.ns.xsp.xsd.signedpayload._2010.SignedPayloadType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.bouncycastle.util.encoders.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class PackagingUtility {
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static final int BUFFER = 2048;
    private static final String FQ_ENTRY_FORMAT = "%s%s";
    private static final String DIGEST_METHOD_SHA1 = "sha1";
    private static final String FQ_PATTERN = ".+[/\\\\].+[/\\\\]";

    private PackagingUtility() {
    }

    public static byte[] createZip(SubmissionSet submissionSet) throws IOException {
        ArgumentUtils.checkNotNull((Object)submissionSet, (String)"submissionSet");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(bos);
        Member rootDocument = submissionSet.getRootDocument();
        List<Member> attachments = submissionSet.getAttachments();
        Member signature = submissionSet.getSignature();
        zip.putNextEntry(new ZipEntry("IHE_XDM/"));
        zip.putNextEntry(new ZipEntry("IHE_XDM/SUBSET01/"));
        zip.putNextEntry(new ZipEntry(String.format(FQ_ENTRY_FORMAT, UriTypes.FQ_SUBSET_DIR.getUri(), rootDocument.getUri())));
        zip.write(rootDocument.getFileContent());
        if (submissionSet.getSignature() != null) {
            zip.putNextEntry(new ZipEntry(String.format(FQ_ENTRY_FORMAT, UriTypes.FQ_SUBSET_DIR.getUri(), signature.getUri())));
            zip.write(signature.getFileContent());
        }
        if (attachments != null && !attachments.isEmpty()) {
            ArrayList<String> entries = new ArrayList<String>();
            for (Member file : attachments) {
                List<String> currentEntries = PackagingUtility.getPathLevels(file.getUri());
                currentEntries.removeAll(entries);
                entries.addAll(currentEntries);
                zip.putNextEntry(new ZipEntry(String.format(FQ_ENTRY_FORMAT, UriTypes.FQ_SUBSET_DIR.getUri(), file.getUri())));
                zip.write(file.getFileContent());
            }
            for (String entry : entries) {
                zip.putNextEntry(new ZipEntry(String.format(FQ_ENTRY_FORMAT, UriTypes.FQ_SUBSET_DIR.getUri(), entry)));
            }
        }
        zip.close();
        return bos.toByteArray();
    }

    public static void writeZip(SubmissionSet submissionSet, String outputFilePath) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(new File(outputFilePath));
            out.write(PackagingUtility.createZip(submissionSet));
            out.flush();
        }
        catch (IOException e) {
            throw new IOException("Error writing package to file", e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private static Map.Entry<String, byte[]> findKnownEntry(Map<String, byte[]> entries, String searchKey) {
        for (Map.Entry<String, byte[]> entry : entries.entrySet()) {
            Pattern pattern = Pattern.compile(FQ_PATTERN + searchKey, 2);
            Matcher matcher = pattern.matcher(entry.getKey());
            if (!matcher.matches()) continue;
            return entry;
        }
        return null;
    }

    private static Map<String, byte[]> findAttachments(Map<String, byte[]> entries) {
        HashMap<String, byte[]> subset = new HashMap<String, byte[]>();
        for (Map.Entry<String, byte[]> entry : entries.entrySet()) {
            Pattern pattern = Pattern.compile(".+[/\\\\].+[/\\\\]*", 2);
            Matcher matcher = pattern.matcher(entry.getKey());
            if (!matcher.matches()) continue;
            subset.put(entry.getKey().replaceAll(UriTypes.FQ_SUBSET_DIR.getUri(), ""), entry.getValue());
        }
        return subset;
    }

    private static Map.Entry<String, byte[]> getDocument(Map<String, byte[]> entries, UriTypes documentUri) {
        return PackagingUtility.findKnownEntry(entries, documentUri.getUri());
    }

    public static SubmissionSet extractPackage(String path) throws IOException {
        Map<String, byte[]> attachments;
        Map.Entry<String, byte[]> signature;
        Map<String, byte[]> entries = PackagingUtility.extractZipEntries(path);
        SubmissionSet.Builder packageBuilder = new SubmissionSet.Builder();
        Map.Entry<String, byte[]> rootDocument = PackagingUtility.getDocument(entries, UriTypes.ROOT_DOCUMENT);
        if (rootDocument != null) {
            packageBuilder.rootDocument(rootDocument.getValue());
            entries.remove(rootDocument.getKey());
        }
        if ((signature = PackagingUtility.getDocument(entries, UriTypes.SIGNATURE)) != null) {
            packageBuilder.signature(signature.getValue());
            entries.remove(signature.getKey());
        }
        if ((attachments = PackagingUtility.findAttachments(entries)) != null && !attachments.isEmpty()) {
            for (Map.Entry<String, byte[]> entry : attachments.entrySet()) {
                packageBuilder.attachment(entry.getKey(), entry.getValue());
            }
        }
        return packageBuilder.build();
    }

    public static Map<String, byte[]> extractZipEntries(String path) throws IOException {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        ZipFile zip = new ZipFile(path);
        Enumeration<? extends ZipEntry> e = zip.entries();
        while (e.hasMoreElements()) {
            ZipEntry zipFile = e.nextElement();
            if (zipFile.isDirectory()) continue;
            result.put(zipFile.getName(), PackagingUtility.readZipEntry(zip.getInputStream(zipFile)));
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    private static byte[] readZipEntry(InputStream zis) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        int count = zis.read(buffer);
        while (count != -1) {
            baos.write(buffer, 0, count);
            count = zis.read(buffer);
        }
        return baos.toByteArray();
    }

    public static byte[] generateSignature(byte[] fileContent, X509Certificate signingCert, PrivateKey privateKey, String approverId, PersonNameType approverName) throws SignatureGenerationException {
        Document signedContainer;
        ArgumentUtils.checkNotNull((Object)fileContent, (String)"fileContent");
        ArgumentUtils.checkNotNull((Object)signingCert, (String)"signingCert");
        ArgumentUtils.checkNotNull((Object)privateKey, (String)"privateKey");
        ArgumentUtils.checkNotNull((Object)approverId, (String)"approverId");
        ArgumentUtils.checkNotNull((Object)approverName, (String)"approverName");
        ESignatureType eSignature = new ESignatureType();
        Calendar signingTime = Calendar.getInstance(UTC_TIME_ZONE);
        eSignature.setSigningTime(signingTime);
        try {
            eSignature.setManifest(PackagingUtility.createManifest(PackagingUtility.createReference(UriTypes.ROOT_DOCUMENT.getUri(), PackagingUtility.calculateSha1Hash(fileContent))));
        }
        catch (URISyntaxException e) {
            throw new SignatureGenerationException("Invalid URI", e);
        }
        eSignature.setApprover(PackagingUtility.createApprover(approverId, approverName));
        try {
            signedContainer = SignedContainerProfileUtil.getSignedPayload((String)PackagingUtility.marshalESignature(eSignature), (X509Certificate)signingCert, (PrivateKey)privateKey);
        }
        catch (XspException e) {
            throw new SignatureGenerationException("Unable to produce signed payload container", (Exception)((Object)e));
        }
        catch (JAXBException e) {
            throw new SignatureGenerationException("Unable to marshal eSignature", (Exception)((Object)e));
        }
        try {
            return PackagingUtility.transform(signedContainer);
        }
        catch (TransformerException e) {
            throw new SignatureGenerationException("Unable to transform container", e);
        }
    }

    private static ManifestType createManifest(ReferenceType reference) {
        ManifestType manifest = new ManifestType();
        manifest.getReference().add(reference);
        return manifest;
    }

    private static ReferenceType createReference(String cdaIdentifier, byte[] digestValue) throws URISyntaxException {
        ArgumentUtils.checkNotNull((Object)cdaIdentifier, (String)"cdaIdentifier");
        ReferenceType reference = new ReferenceType();
        reference.setDigestMethod(PackagingUtility.createDigestMethod(XMLNamespaces.DS.getNamespace() + DIGEST_METHOD_SHA1));
        reference.setURI(cdaIdentifier);
        reference.setDigestValue(digestValue);
        return reference;
    }

    private static DigestMethodType createDigestMethod(String digestMethod) {
        DigestMethodType type = new DigestMethodType();
        type.setAlgorithm(digestMethod);
        return type;
    }

    private static ApproverType createApprover(String personId, PersonNameType personName) {
        ApproverType approver = new ApproverType();
        approver.setPersonId(personId);
        approver.setPersonName(personName);
        return approver;
    }

    private static byte[] transform(Document doc) throws TransformerException {
        Transformer transformer;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new TransformerFactoryConfigurationError(e, "Unexpected problem encountered when configuring the transformer factory.");
        }
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StreamResult transformedDoc = new StreamResult(new StringWriter());
        DOMSource source = new DOMSource(doc);
        try {
            transformer.transform(source, transformedDoc);
        }
        catch (TransformerException e) {
            throw new TransformerException("Unexpected problem encountered when transforming XML.", e);
        }
        return transformedDoc.getWriter().toString().getBytes();
    }

    private static byte[] calculateSha1Hash(byte[] value) {
        try {
            MessageDigest md = MessageDigest.getInstance(DIGEST_METHOD_SHA1);
            return md.digest(value);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unexpected digest method encountered.", e);
        }
    }

    private static String marshalESignature(ESignatureType eSignature) throws JAXBException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ESignatureType.class});
        Marshaller marshaller = jc.createMarshaller();
        ObjectFactory of = new ObjectFactory();
        marshaller.setProperty("jaxb.fragment", (Object)true);
        marshaller.marshal((Object)of.createESignature(eSignature), (OutputStream)outputStream);
        return outputStream.toString();
    }

    public static void verifyPackage(SubmissionSet submissionSet, CertificateVerifier verifier) throws SignatureGenerationException, PackageExtractionException, VerificationException {
        Document signature = PackagingUtility.extractFile(submissionSet.getSignature().getFileContent());
        try {
            PackagingUtility.verifyRootHash(signature, submissionSet.getRootDocument().getFileContent());
        }
        catch (JAXBException e) {
            throw new VerificationException("Unable to verify root document hash.", (Exception)((Object)e));
        }
        try {
            PackagingUtility.verifySignature(signature, verifier);
        }
        catch (SignatureValidationException e) {
            throw new VerificationException("Unable to verify signature.", (Exception)((Object)e));
        }
        if (!submissionSet.getAttachments().isEmpty()) {
            try {
                PackagingUtility.verifyAttachments(submissionSet);
            }
            catch (AttachmentVerificationException e) {
                throw new VerificationException("Unable to verify package attachment(s).", e);
            }
        }
    }

    private static void verifyAttachments(SubmissionSet subset) throws AttachmentVerificationException, PackageExtractionException {
        Document rootDocument;
        try {
            rootDocument = PackagingUtility.extractFile(subset.getRootDocument().getFileContent());
        }
        catch (PackageExtractionException e) {
            throw new PackageExtractionException("Unable to extract root document.", e);
        }
        if (rootDocument == null) {
            throw new PackageExtractionException("Unable to extract root document - null value.");
        }
        try {
            NodeList integrityChecks = PackagingUtility.extractIntegrityChecks(rootDocument);
            Map<String, String> integrityDetails = PackagingUtility.getIntegrityDetails(integrityChecks);
            for (Map.Entry<String, String> entry : integrityDetails.entrySet()) {
                for (Member member : subset.getAttachments()) {
                    String expectedHash;
                    String actualHash;
                    if (entry.getKey().compareToIgnoreCase(member.getUri()) != 0 || (actualHash = new String(Base64.encode((byte[])PackagingUtility.calculateSha1Hash(member.getFileContent())))).compareTo(expectedHash = entry.getValue()) == 0) continue;
                    throw new AttachmentVerificationException(String.format("Attachment verification failed  - integrity check digest value mismatch on '%s'\n\tActual: %s\n\tExpected: %s", entry.getKey(), actualHash, expectedHash));
                }
            }
        }
        catch (XPathExpressionException e) {
            throw new PackageExtractionException("Unexpected error encountered when extracting attachment integrity checks nodes from CDA document XML.");
        }
    }

    private static Map<String, String> getIntegrityDetails(NodeList nodeList) throws AttachmentVerificationException {
        HashMap<String, String> integrityDetails = new HashMap<String, String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String integrityCheck = PackagingUtility.getAttributeValue(node, "integrityCheck");
            String integrityCheckAlgorithm = PackagingUtility.getAttributeValue(node, "integrityCheckAlgorithm");
            if (integrityCheckAlgorithm != null && integrityCheckAlgorithm.compareToIgnoreCase("sha-1") != 0) continue;
            integrityDetails.put(PackagingUtility.getAttachmentReference(node), integrityCheck);
        }
        return integrityDetails;
    }

    private static String getAttachmentReference(Node node) {
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode == null || childNode.getNodeName().compareToIgnoreCase("reference") != 0) continue;
            return PackagingUtility.getAttributeValue(childNode, "value");
        }
        return null;
    }

    private static String getAttributeValue(Node node, String attributeName) {
        Node attribute;
        String result = null;
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null && attributes.getLength() > 0 && (attribute = attributes.getNamedItem(attributeName)) != null) {
            result = attribute.getNodeValue();
        }
        return result;
    }

    private static NodeList extractIntegrityChecks(Document rootDocument) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(new CDANamespaceContext());
        XPathExpression expression = xPath.compile(ExpressionType.INTEGRITY_CHECK.getExpression());
        return (NodeList)expression.evaluate(rootDocument, XPathConstants.NODESET);
    }

    private static void verifyRootHash(Document signature, byte[] rootFileContent) throws JAXBException, SignatureGenerationException, PackageExtractionException, VerificationException {
        Element eSignatureElement;
        byte[] currentRootHash = PackagingUtility.calculateSha1Hash(rootFileContent);
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{SignedPayloadType.class}).createUnmarshaller();
        SignedPayloadType signedPayload = (SignedPayloadType)unmarshaller.unmarshal((Node)signature, SignedPayloadType.class).getValue();
        SignedPayloadDataType signedPayloadData = signedPayload.getSignedPayloadData();
        try {
            eSignatureElement = (Element)signedPayloadData.getAny();
        }
        catch (Exception e) {
            throw new VerificationException("Unexpected XML content encountered when attempting to verify root document hash.", e);
        }
        unmarshaller = JAXBContext.newInstance((Class[])new Class[]{ESignatureType.class}).createUnmarshaller();
        ESignatureType eSignature = (ESignatureType)unmarshaller.unmarshal((Node)eSignatureElement, ESignatureType.class).getValue();
        byte[] expectedRootHash = ((ReferenceType)eSignature.getManifest().getReference().get(0)).getDigestValue();
        if (expectedRootHash == null || !Arrays.equals(expectedRootHash, currentRootHash)) {
            throw new PackageExtractionException("Root hash in the eSignature does not match the package's root document.");
        }
    }

    private static Document extractFile(byte[] fileContent) throws PackageExtractionException {
        Document doc;
        DocumentBuilder domBuilder;
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        try {
            domBuilder = domFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new PackageExtractionException("Unable to extract file.", e);
        }
        try {
            doc = domBuilder.parse(new ByteArrayInputStream(fileContent));
        }
        catch (SAXException e) {
            throw new PackageExtractionException("Unable to parse XML.", e);
        }
        catch (IOException e) {
            throw new PackageExtractionException("Unable to extract file.", e);
        }
        return doc;
    }

    private static void verifySignature(Document signature, CertificateVerifier verifier) throws SignatureValidationException {
        ArgumentUtils.checkNotNull((Object)signature, (String)"signature");
        if (verifier != null) {
            SignedContainerProfileUtil.verifySignature((Document)signature, (CertificateVerifier)verifier);
        } else {
            SignedContainerProfileUtil.verifySignature((Document)signature);
        }
    }

    private static List<String> getPathLevels(String uri) {
        ArgumentUtils.checkNotNull((Object)uri, (String)"uri");
        ArrayList<String> result = new ArrayList<String>();
        String[] dirs = uri.split("/|\\)");
        if (dirs.length != 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < dirs.length - 1; ++i) {
                sb.append(dirs[i]).append("/");
                result.add(sb.toString());
            }
        }
        return result;
    }
}

