/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.clinicalpackage.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Validation {
    private Validation() {
    }

    public static Map<String, List<String>> checkNotNullNorBlank(String name, String value) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        ArrayList<String> messages = new ArrayList<String>();
        if (Validation.isNullOrBlank(value)) {
            messages.add(name + " cannot be null nor blank");
            result.put(name, messages);
        }
        return result;
    }

    public static Map<String, List<String>> checkNotNull(String name, Object value) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        ArrayList<String> messages = new ArrayList<String>();
        if (Validation.isNull(value)) {
            messages.add(name + " cannot be null");
            result.put(name, messages);
        }
        return result;
    }

    public static Map<String, List<String>> checkNotNullNorEmpty(String name, Collection collection) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        ArrayList<String> messages = new ArrayList<String>();
        if (Validation.isNullOrEmpty(collection)) {
            messages.add(name + " collection cannot be null nor empty");
            result.put(name, messages);
        }
        return result;
    }

    public static Map<String, List<String>> checkFileNameOnlyUri(String name, String uri) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        ArrayList<String> messages = new ArrayList<String>();
        if (uri.contains("/") || uri.contains("\\")) {
            messages.add(name + " is not valid. It contains path-specific characters.");
            messages.add("Expected format: <filename>.<file_extension>");
            messages.add("Actual value: " + uri);
            result.put(name, messages);
        }
        return result;
    }

    public static Map<String, List<String>> checkMatches(String name, String actual, String expected) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        ArrayList<String> messages = new ArrayList<String>();
        if (actual.compareTo(expected) != 0) {
            messages.add(name + "is not valid");
            messages.add("Expected value: " + expected);
            messages.add("Actual value: " + actual);
            result.put(name, messages);
        }
        return result;
    }

    public static boolean isNullOrEmpty(Collection collection) {
        return collection == null || collection.size() == 0;
    }

    public static boolean isNullOrBlank(String value) {
        return value == null || value.length() == 0 || value.trim().length() == 0;
    }

    public static boolean isNull(Object value) {
        return value == null;
    }

    public static boolean isNotNull(Object value) {
        return value != null;
    }
}

