/*
* Copyright 2011 NEHTA
*
* Licensed under the NEHTA Open Source (Apache) License; you may not use this
* file except in compliance with the License. A copy of the License is in the
* 'license.txt' file, which should be provided with this work.
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
* WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
* License for the specific language governing permissions and limitations
* under the License.
*/
package au.gov.nehta.vendorlibrary.common.security;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.xsp.XspException;
import org.w3c.dom.Document;

import javax.security.auth.x500.X500PrivateCredential;
import java.security.cert.X509Certificate;
import java.util.List;

public class SignedEncryptedContainerProfileUtil {


  public static Document getSignedEncryptedPayload(final String sensitivePayload,
                                                   List<X500PrivateCredential> certificateKeyPairs,
                                                   X509Certificate encryptingCert) {

    ArgumentUtils.checkNotNullNorBlank(sensitivePayload, "sensitivePayload");
    ArgumentUtils.checkNotNull(certificateKeyPairs, "certificateKeyPairs");
    ArgumentUtils.checkNotNull(encryptingCert, "encryptingCert");

    Document signedEncryptedPayload = null;
    try {
      Document signedData = SignedContainerProfileUtil.getSignedPayload(sensitivePayload, certificateKeyPairs);
      signedEncryptedPayload = EncryptedContainerProfileUtil.getEncryptedPayload(signedData, encryptingCert);
    } catch (XspException e) {

    }
    return signedEncryptedPayload;
  }

  public static Document getDataFromSignedEncryptedPayload(final Document signedEncryptedPayload,
                                                           X500PrivateCredential privateCredential) {
    ArgumentUtils.checkNotNull(signedEncryptedPayload, "signedEncryptedPayload");
    ArgumentUtils.checkNotNull(privateCredential, "privateCredential");

    Document extractedDocument = null;
    try {
      Document decryptedDocument = EncryptedContainerProfileUtil.getDecryptedPayload(signedEncryptedPayload, privateCredential);
      extractedDocument = SignedContainerProfileUtil.getDataFromSignedPayload(decryptedDocument);
    } catch (XspException e) {
      e.printStackTrace();
    }
    return extractedDocument;

  }
}
