﻿using System;
using System.Runtime.Serialization;

namespace Nehta.VendorLibrary.CDA.Common.Enums
{
    /// <summary>
    /// NullFlavor
    /// </summary>
    [Serializable]
    [DataContract]
    public enum NullFlavour
    {
        [EnumMember]
        [Name(Code = "NI", Name = "No Information")]
        NoInformation,

        [EnumMember]
        [Name(Code = "UNK", Name = "Unknown")]
        Unknown,

        [EnumMember]
        [Name(Code = "ASKU", Name = "Asked But Unknown")]
        AskedButUnknown,

        [EnumMember]
        [Name(Code = "NAV", Name = "Temporarily Unavailable")]
        TemporarilyUnavailable,

        [EnumMember]
        [Name(Code = "NASK", Name = "Not Asked")]
        NotAsked,

        [EnumMember]
        [Name(Code = "OTH", Name = "Other")]
        Other,

        [EnumMember]
        [Name(Code = "NINF", Name = "Negative Infinity")]
        NegativeInfinity,

        [EnumMember]
        [Name(Code = "PINF", Name = "Positive Infinity")]
        PositiveInfinity,

        [EnumMember]
        [Name(Code = "TRC", Name = "Trace")]
        Trace,

        [EnumMember]
        [Name(Code = "MSK", Name = "Masked")]
        Masked,

        [EnumMember]
        [Name(Code = "NA", Name = "Not Applicable")]
        NotApplicable,

    }
}
