﻿/*
 * Copyright 2013 NEHTA
 *
 * Licensed under the NEHTA Open Source (Apache) License; you may not use this
 * file except in compliance with the License. A copy of the License is in the
 * 'license.txt' file, which should be provided with this work.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nehta.VendorLibrary.CDA.Common;

namespace Nehta.VendorLibrary.CDA.Generator.Enums
{
    /// <summary>
    /// Media Type
    /// </summary>
    public enum MediaType
    {
        /// <summary>
        /// The undefined enumeration is used to determine if a value has been explicity set.
        /// </summary>
        Undefined,

        /// <summary>
        /// HL7
        /// </summary>
        [Name(Name = "application/hl7-v2")]
        HL7,

        /// <summary>
        /// JPEG is a commonly used method of lossy compression for digital photography (image). 
        /// </summary>
        [Name(Name = "image/jpeg")]
        JPEG,

        /// <summary>
        /// Graphics Interchange Format (GIF)
        /// </summary>
        [Name(Name = "image/gif")]
        GIF,

        /// <summary>
        /// Portable Network Graphic (PNG)
        /// </summary>
        [Name(Name = "image/png")]
        PNG,

        /// <summary>
        /// Tag Image File Format (TIFF)
        /// </summary>
        [Name(Name = "image/tiff")]
        TIFF,

        /// <summary>
        /// Bitmap 
        /// </summary>
        /// 
        [Name(Name = "image/bmp")]
        BMP,

        /// <summary>
        /// Plain text
        /// </summary>
        /// 
        [Name(Name = "text/plain")]
        TXT,

        /// <summary>
        /// Adobe Portable Document Format
        /// </summary>
        /// 
        [Name(Name = "application/pdf")]
        PDF
    }
}
