﻿/*
 * Copyright 2013 NEHTA
 *
 * Licensed under the NEHTA Open Source (Apache) License; you may not use this
 * file except in compliance with the License. A copy of the License is in the
 * 'license.txt' file, which should be provided with this work.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

using System;
using System.Collections.Generic;
using JetBrains.Annotations;
using Nehta.VendorLibrary.CDA.Common;
using Nehta.VendorLibrary.Common;

namespace Nehta.VendorLibrary.CDA.SCSModel
{
    /// <summary>
    /// This interface encapsulates all the SCS specific context for a specialist letter
    /// </summary>
    public interface ISpecialistLetterContext
    {
        /// <summary>
        /// A participation - Author
        /// </summary>
        [CanBeNull]
        IParticipationDocumentAuthor Author { get; set; }

        /// <summary>
        /// A participation - Subject of care
        /// </summary>
        [CanBeNull]
        IParticipationSubjectOfCare SubjectOfCare { get; set; }

        /// <summary>
        /// The usual GP
        /// </summary>
        [CanBeNull]
        IParticipationUsualGP UsualGP { get; set; }

        /// <summary>
        /// The referee
        /// </summary>
        [CanBeNull]
        IParticipationReferrer Referrer { get; set; }

        /// <summary>
        /// The date / time that the subject of care was seen
        /// </summary>
        [CanBeNull]
        ISO8601DateTime DateTimeSubjectSeen { get; set; }

        /// <summary>
        /// Validates this Shared Health Summary context
        /// </summary>
        /// <param name="path">The path to this object as a string</param>
        /// <param name="messages">the validation messages, these may be added to within this method</param>
        void Validate(string path, List<ValidationMessage> messages);
    }
}
