﻿/*
 * Copyright 2013 NEHTA
 *
 * Licensed under the NEHTA Open Source (Apache) License; you may not use this
 * file except in compliance with the License. A copy of the License is in the
 * 'license.txt' file, which should be provided with this work.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

using System;
using System.Runtime.Serialization;

namespace Nehta.VendorLibrary.CDA.Common.Enums
{
    /// <summary>
    /// Occupations
    /// </summary>
    [Serializable]
    [DataContract]
    public enum Occupation
    {
        /// <summary>
        /// Undefined, this is the default value if the enum is left unset.
        /// 
        /// The validation engine uses this to test and assert that the enum has been set (if required)
        /// and is therefore valid.
        /// </summary>
        [EnumMember]
        Undefined,

        [EnumMember]
        [Name(Code = "100000", Name = "Managers nfd")]
        Managersnfd,
        [EnumMember]
        [Name(Code = "111000", Name = "Chief Executives, General Managers and Legislators nfd")]
        ChiefExecutivesGeneralManagersandLegislatorsnfd,
        [EnumMember]
        [Name(Code = "111111", Name = "Chief Executive or Managing Director")]
        ChiefExecutiveorManagingDirector,
        [EnumMember]
        [Name(Code = "111200", Name = "General Managers nfd")]
        GeneralManagersnfd,
        [EnumMember]
        [Name(Code = "111211", Name = "Corporate General Manager")]
        CorporateGeneralManager,
        [EnumMember]
        [Name(Code = "111212", Name = "Defence Force Senior Officer")]
        DefenceForceSeniorOfficer,
        [EnumMember]
        [Name(Code = "111300", Name = "Legislators nfd")]
        Legislatorsnfd,
        [EnumMember]
        [Name(Code = "111311", Name = "Local Government Legislator")]
        LocalGovernmentLegislator,
        [EnumMember]
        [Name(Code = "111312", Name = "Member of Parliament")]
        MemberofParliament,
        [EnumMember]
        [Name(Code = "111399", Name = "Legislators nec")]
        Legislatorsnec,
        [EnumMember]
        [Name(Code = "121000", Name = "Farmers and Farm Managers nfd")]
        FarmersandFarmManagersnfd,
        [EnumMember]
        [Name(Code = "121111", Name = "Aquaculture Farmer")]
        AquacultureFarmer,
        [EnumMember]
        [Name(Code = "121200", Name = "Crop Farmers nfd")]
        CropFarmersnfd,
        [EnumMember]
        [Name(Code = "121211", Name = "Cotton Grower")]
        CottonGrower,
        [EnumMember]
        [Name(Code = "121212", Name = "Flower Grower")]
        FlowerGrower,
        [EnumMember]
        [Name(Code = "121213", Name = "Fruit or Nut Grower")]
        FruitorNutGrower,
        [EnumMember]
        [Name(Code = "121214", Name = "Grain, Oilseed or Pasture Grower")]
        GrainOilseedorPastureGrower,
        [EnumMember]
        [Name(Code = "121215", Name = "Grape Grower")]
        GrapeGrower,
        [EnumMember]
        [Name(Code = "121216", Name = "Mixed Crop Farmer")]
        MixedCropFarmer,
        [EnumMember]
        [Name(Code = "121217", Name = "Sugar Cane Grower")]
        SugarCaneGrower,
        [EnumMember]
        [Name(Code = "121218", Name = "Turf Grower")]
        TurfGrower,
        [EnumMember]
        [Name(Code = "121221", Name = "Vegetable Grower")]
        VegetableGrower,
        [EnumMember]
        [Name(Code = "121299", Name = "Crop Farmers nec")]
        CropFarmersnec,
        [EnumMember]
        [Name(Code = "121300", Name = "Livestock Farmers nfd")]
        LivestockFarmersnfd,
        [EnumMember]
        [Name(Code = "121311", Name = "Apiarist")]
        Apiarist,
        [EnumMember]
        [Name(Code = "121312", Name = "Beef Cattle Farmer")]
        BeefCattleFarmer,
        [EnumMember]
        [Name(Code = "121313", Name = "Dairy Cattle Farmer")]
        DairyCattleFarmer,
        [EnumMember]
        [Name(Code = "121314", Name = "Deer Farmer")]
        DeerFarmer,
        [EnumMember]
        [Name(Code = "121315", Name = "Goat Farmer")]
        GoatFarmer,
        [EnumMember]
        [Name(Code = "121316", Name = "Horse Breeder")]
        HorseBreeder,
        [EnumMember]
        [Name(Code = "121317", Name = "Mixed Livestock Farmer")]
        MixedLivestockFarmer,
        [EnumMember]
        [Name(Code = "121318", Name = "Pig Farmer")]
        PigFarmer,
        [EnumMember]
        [Name(Code = "121321", Name = "Poultry Farmer")]
        PoultryFarmer,
        [EnumMember]
        [Name(Code = "121322", Name = "Sheep Farmer")]
        SheepFarmer,
        [EnumMember]
        [Name(Code = "121399", Name = "Livestock Farmers nec")]
        LivestockFarmersnec,
        [EnumMember]
        [Name(Code = "121411", Name = "Mixed Crop and Livestock Farmer")]
        MixedCropandLivestockFarmer,
        [EnumMember]
        [Name(Code = "130000", Name = "Specialist Managers nfd")]
        SpecialistManagersnfd,
        [EnumMember]
        [Name(Code = "131100", Name = "Advertising, Public Relations and Sales Managers nfd")]
        AdvertisingPublicRelationsandSalesManagersnfd,
        [EnumMember]
        [Name(Code = "131112", Name = "Sales and Marketing Manager")]
        SalesandMarketingManager,
        [EnumMember]
        [Name(Code = "131113", Name = "Advertising Manager")]
        AdvertisingManager,
        [EnumMember]
        [Name(Code = "131114", Name = "Public Relations Manager")]
        PublicRelationsManager,
        [EnumMember]
        [Name(Code = "132000", Name = "Business Administration Managers nfd")]
        BusinessAdministrationManagersnfd,
        [EnumMember]
        [Name(Code = "132111", Name = "Corporate Services Manager")]
        CorporateServicesManager,
        [EnumMember]
        [Name(Code = "132211", Name = "Finance Manager")]
        FinanceManager,
        [EnumMember]
        [Name(Code = "132311", Name = "Human Resource Manager")]
        HumanResourceManager,
        [EnumMember]
        [Name(Code = "132411", Name = "Policy and Planning Manager")]
        PolicyandPlanningManager,
        [EnumMember]
        [Name(Code = "132511", Name = "Research and Development Manager")]
        ResearchandDevelopmentManager,
        [EnumMember]
        [Name(Code = "133000", Name = "Construction, Distribution and Production Managers nfd")]
        ConstructionDistributionandProductionManagersnfd,
        [EnumMember]
        [Name(Code = "133100", Name = "Construction Managers nfd")]
        ConstructionManagersnfd,
        [EnumMember]
        [Name(Code = "133111", Name = "Construction Project Manager")]
        ConstructionProjectManager,
        [EnumMember]
        [Name(Code = "133112", Name = "Project Builder")]
        ProjectBuilder,
        [EnumMember]
        [Name(Code = "133211", Name = "Engineering Manager")]
        EngineeringManager,
        [EnumMember]
        [Name(Code = "133300", Name = "Importers, Exporters and Wholesalers nfd")]
        ImportersExportersandWholesalersnfd,
        [EnumMember]
        [Name(Code = "133311", Name = "Importer or Exporter")]
        ImporterorExporter,
        [EnumMember]
        [Name(Code = "133312", Name = "Wholesaler")]
        Wholesaler,
        [EnumMember]
        [Name(Code = "133411", Name = "Manufacturer")]
        Manufacturer,
        [EnumMember]
        [Name(Code = "133500", Name = "Production Managers nfd")]
        ProductionManagersnfd,
        [EnumMember]
        [Name(Code = "133511", Name = "Production Manager (Forestry)")]
        ProductionManagerForestry,
        [EnumMember]
        [Name(Code = "133512", Name = "Production Manager (Manufacturing)")]
        ProductionManagerManufacturing,
        [EnumMember]
        [Name(Code = "133513", Name = "Production Manager (Mining)")]
        ProductionManagerMining,
        [EnumMember]
        [Name(Code = "133611", Name = "Supply and Distribution Manager")]
        SupplyandDistributionManager,
        [EnumMember]
        [Name(Code = "134000", Name = "Education, Health and Welfare Services Managers nfd")]
        EducationHealthandWelfareServicesManagersnfd,
        [EnumMember]
        [Name(Code = "134111", Name = "Child Care Centre Manager")]
        ChildCareCentreManager,
        [EnumMember]
        [Name(Code = "134200", Name = "Health and Welfare Services Managers nfd")]
        HealthandWelfareServicesManagersnfd,
        [EnumMember]
        [Name(Code = "134211", Name = "Medical Administrator")]
        MedicalAdministrator,
        [EnumMember]
        [Name(Code = "134212", Name = "Nursing Clinical Director")]
        NursingClinicalDirector,
        [EnumMember]
        [Name(Code = "134213", Name = "Primary Health Organisation Manager")]
        PrimaryHealthOrganisationManager,
        [EnumMember]
        [Name(Code = "134214", Name = "Welfare Centre Manager")]
        WelfareCentreManager,
        [EnumMember]
        [Name(Code = "134299", Name = "Health and Welfare Services Managers nec")]
        HealthandWelfareServicesManagersnec,
        [EnumMember]
        [Name(Code = "134311", Name = "School Principal")]
        SchoolPrincipal,
        [EnumMember]
        [Name(Code = "134400", Name = "Other Education Managers nfd")]
        OtherEducationManagersnfd,
        [EnumMember]
        [Name(Code = "134411", Name = "Faculty Head")]
        FacultyHead,
        [EnumMember]
        [Name(Code = "134412", Name = "Regional Education Manager")]
        RegionalEducationManager,
        [EnumMember]
        [Name(Code = "134499", Name = "Education Managers nec")]
        EducationManagersnec,
        [EnumMember]
        [Name(Code = "135100", Name = "ICT Managers nfd")]
        ICTManagersnfd,
        [EnumMember]
        [Name(Code = "135111", Name = "Chief Information Officer")]
        ChiefInformationOfficer,
        [EnumMember]
        [Name(Code = "135112", Name = "ICT Project Manager")]
        ICTProjectManager,
        [EnumMember]
        [Name(Code = "135199", Name = "ICT Managers nec")]
        ICTManagersnec,
        [EnumMember]
        [Name(Code = "139000", Name = "Miscellaneous Specialist Managers nfd")]
        MiscellaneousSpecialistManagersnfd,
        [EnumMember]
        [Name(Code = "139100", Name = "Commissioned Officers (Management) nfd")]
        CommissionedOfficersManagementnfd,
        [EnumMember]
        [Name(Code = "139111", Name = "Commissioned Defence Force Officer")]
        CommissionedDefenceForceOfficer,
        [EnumMember]
        [Name(Code = "139112", Name = "Commissioned Fire Officer")]
        CommissionedFireOfficer,
        [EnumMember]
        [Name(Code = "139113", Name = "Commissioned Police Officer")]
        CommissionedPoliceOfficer,
        [EnumMember]
        [Name(Code = "139211", Name = "Senior Non-commissioned Defence Force Member")]
        SeniorNoncommissionedDefenceForceMember,
        [EnumMember]
        [Name(Code = "139900", Name = "Other Specialist Managers nfd")]
        OtherSpecialistManagersnfd,
        [EnumMember]
        [Name(Code = "139911", Name = "Arts Administrator or Manager")]
        ArtsAdministratororManager,
        [EnumMember]
        [Name(Code = "139912", Name = "Environmental Manager")]
        EnvironmentalManager,
        [EnumMember]
        [Name(Code = "139913", Name = "Laboratory Manager")]
        LaboratoryManager,
        [EnumMember]
        [Name(Code = "139914", Name = "Quality Assurance Manager")]
        QualityAssuranceManager,
        [EnumMember]
        [Name(Code = "139915", Name = "Sports Administrator")]
        SportsAdministrator,
        [EnumMember]
        [Name(Code = "139999", Name = "Specialist Managers nec")]
        SpecialistManagersnec,
        [EnumMember]
        [Name(Code = "140000", Name = "Hospitality, Retail and Service Managers nfd")]
        HospitalityRetailandServiceManagersnfd,
        [EnumMember]
        [Name(Code = "141000", Name = "Accommodation and Hospitality Managers nfd")]
        AccommodationandHospitalityManagersnfd,
        [EnumMember]
        [Name(Code = "141111", Name = "Cafe or Restaurant Manager")]
        CafeorRestaurantManager,
        [EnumMember]
        [Name(Code = "141211", Name = "Caravan Park and Camping Ground Manager")]
        CaravanParkandCampingGroundManager,
        [EnumMember]
        [Name(Code = "141311", Name = "Hotel or Motel Manager")]
        HotelorMotelManager,
        [EnumMember]
        [Name(Code = "141411", Name = "Licensed Club Manager")]
        LicensedClubManager,
        [EnumMember]
        [Name(Code = "141900", Name = "Other Accommodation and Hospitality Managers nfd")]
        OtherAccommodationandHospitalityManagersnfd,
        [EnumMember]
        [Name(Code = "141911", Name = "Bed and Breakfast Operator")]
        BedandBreakfastOperator,
        [EnumMember]
        [Name(Code = "141912", Name = "Retirement Village Manager")]
        RetirementVillageManager,
        [EnumMember]
        [Name(Code = "141999", Name = "Accommodation and Hospitality Managers nec")]
        AccommodationandHospitalityManagersnec,
        [EnumMember]
        [Name(Code = "142100", Name = "Retail Managers nfd")]
        RetailManagersnfd,
        [EnumMember]
        [Name(Code = "142111", Name = "Retail Manager (General)")]
        RetailManagerGeneral,
        [EnumMember]
        [Name(Code = "142112", Name = "Antique Dealer")]
        AntiqueDealer,
        [EnumMember]
        [Name(Code = "142113", Name = "Betting Agency Manager")]
        BettingAgencyManager,
        [EnumMember]
        [Name(Code = "142114", Name = "Hair or Beauty Salon Manager")]
        HairorBeautySalonManager,
        [EnumMember]
        [Name(Code = "142115", Name = "Post Office Manager")]
        PostOfficeManager,
        [EnumMember]
        [Name(Code = "142116", Name = "Travel Agency Manager")]
        TravelAgencyManager,
        [EnumMember]
        [Name(Code = "149000", Name = "Miscellaneous Hospitality, Retail and Service Managers nfd")]
        MiscellaneousHospitalityRetailandServiceManagersnfd,
        [EnumMember]
        [Name(Code = "149100", Name = "Amusement, Fitness and Sports Centre Managers nfd")]
        AmusementFitnessandSportsCentreManagersnfd,
        [EnumMember]
        [Name(Code = "149111", Name = "Amusement Centre Manager")]
        AmusementCentreManager,
        [EnumMember]
        [Name(Code = "149112", Name = "Fitness Centre Manager")]
        FitnessCentreManager,
        [EnumMember]
        [Name(Code = "149113", Name = "Sports Centre Manager")]
        SportsCentreManager,
        [EnumMember]
        [Name(Code = "149200", Name = "Call or Contact Centre and Customer Service Managers nfd")]
        CallorContactCentreandCustomerServiceManagersnfd,
        [EnumMember]
        [Name(Code = "149211", Name = "Call or Contact Centre Manager")]
        CallorContactCentreManager,
        [EnumMember]
        [Name(Code = "149212", Name = "Customer Service Manager")]
        CustomerServiceManager,
        [EnumMember]
        [Name(Code = "149311", Name = "Conference and Event Organiser")]
        ConferenceandEventOrganiser,
        [EnumMember]
        [Name(Code = "149400", Name = "Transport Services Managers nfd")]
        TransportServicesManagersnfd,
        [EnumMember]
        [Name(Code = "149411", Name = "Fleet Manager")]
        FleetManager,
        [EnumMember]
        [Name(Code = "149412", Name = "Railway Station Manager")]
        RailwayStationManager,
        [EnumMember]
        [Name(Code = "149413", Name = "Transport Company Manager")]
        TransportCompanyManager,
        [EnumMember]
        [Name(Code = "149900", Name = "Other Hospitality, Retail and Service Managers nfd")]
        OtherHospitalityRetailandServiceManagersnfd,
        [EnumMember]
        [Name(Code = "149911", Name = "Boarding Kennel or Cattery Operator")]
        BoardingKennelorCatteryOperator,
        [EnumMember]
        [Name(Code = "149912", Name = "Cinema or Theatre Manager")]
        CinemaorTheatreManager,
        [EnumMember]
        [Name(Code = "149913", Name = "Facilities Manager")]
        FacilitiesManager,
        [EnumMember]
        [Name(Code = "149914", Name = "Financial Institution Branch Manager")]
        FinancialInstitutionBranchManager,
        [EnumMember]
        [Name(Code = "149915", Name = "Equipment Hire Manager")]
        EquipmentHireManager,
        [EnumMember]
        [Name(Code = "149999", Name = "Hospitality, Retail and Service Managers nec")]
        HospitalityRetailandServiceManagersnec,
        [EnumMember]
        [Name(Code = "200000", Name = "Professionals nfd")]
        Professionalsnfd,
        [EnumMember]
        [Name(Code = "210000", Name = "Arts and Media Professionals nfd")]
        ArtsandMediaProfessionalsnfd,
        [EnumMember]
        [Name(Code = "211000", Name = "Arts Professionals nfd")]
        ArtsProfessionalsnfd,
        [EnumMember]
        [Name(Code = "211100", Name = "Actors, Dancers and Other Entertainers nfd")]
        ActorsDancersandOtherEntertainersnfd,
        [EnumMember]
        [Name(Code = "211111", Name = "Actor")]
        Actor,
        [EnumMember]
        [Name(Code = "211112", Name = "Dancer or Choreographer")]
        DancerorChoreographer,
        [EnumMember]
        [Name(Code = "211113", Name = "Entertainer or Variety Artist")]
        EntertainerorVarietyArtist,
        [EnumMember]
        [Name(Code = "211199", Name = "Actors, Dancers and Other Entertainers nec")]
        ActorsDancersandOtherEntertainersnec,
        [EnumMember]
        [Name(Code = "211200", Name = "Music Professionals nfd")]
        MusicProfessionalsnfd,
        [EnumMember]
        [Name(Code = "211211", Name = "Composer")]
        Composer,
        [EnumMember]
        [Name(Code = "211212", Name = "Music Director")]
        MusicDirector,
        [EnumMember]
        [Name(Code = "211213", Name = "Musician (Instrumental)")]
        MusicianInstrumental,
        [EnumMember]
        [Name(Code = "211214", Name = "Singer")]
        Singer,
        [EnumMember]
        [Name(Code = "211299", Name = "Music Professionals nec")]
        MusicProfessionalsnec,
        [EnumMember]
        [Name(Code = "211311", Name = "Photographer")]
        Photographer,
        [EnumMember]
        [Name(Code = "211400", Name = "Visual Arts and Crafts Professionals nfd")]
        VisualArtsandCraftsProfessionalsnfd,
        [EnumMember]
        [Name(Code = "211411", Name = "Painter (Visual Arts)")]
        PainterVisualArts,
        [EnumMember]
        [Name(Code = "211412", Name = "Potter or Ceramic Artist")]
        PotterorCeramicArtist,
        [EnumMember]
        [Name(Code = "211413", Name = "Sculptor")]
        Sculptor,
        [EnumMember]
        [Name(Code = "211499", Name = "Visual Arts and Crafts Professionals nec")]
        VisualArtsandCraftsProfessionalsnec,
        [EnumMember]
        [Name(Code = "212000", Name = "Media Professionals nfd")]
        MediaProfessionalsnfd,
        [EnumMember]
        [Name(Code = "212100", Name = "Artistic Directors, and Media Producers and Presenters nfd")]
        ArtisticDirectorsandMediaProducersandPresentersnfd,
        [EnumMember]
        [Name(Code = "212111", Name = "Artistic Director")]
        ArtisticDirector,
        [EnumMember]
        [Name(Code = "212112", Name = "Media Producer (excluding Video)")]
        MediaProducerexcludingVideo,
        [EnumMember]
        [Name(Code = "212113", Name = "Radio Presenter")]
        RadioPresenter,
        [EnumMember]
        [Name(Code = "212114", Name = "Television Presenter")]
        TelevisionPresenter,
        [EnumMember]
        [Name(Code = "212200", Name = "Authors, and Book and Script Editors nfd")]
        AuthorsandBookandScriptEditorsnfd,
        [EnumMember]
        [Name(Code = "212211", Name = "Author")]
        Author,
        [EnumMember]
        [Name(Code = "212212", Name = "Book or Script Editor")]
        BookorScriptEditor,
        [EnumMember]
        [Name(Code = "212300", Name = "Film, Television, Radio and Stage Directors nfd")]
        FilmTelevisionRadioandStageDirectorsnfd,
        [EnumMember]
        [Name(Code = "212311", Name = "Art Director (Film, Television or Stage)")]
        ArtDirectorFilmTelevisionorStage,
        [EnumMember]
        [Name(Code = "212312", Name = "Director (Film, Television, Radio or Stage)")]
        DirectorFilmTelevisionRadioorStage,
        [EnumMember]
        [Name(Code = "212313", Name = "Director of Photography")]
        DirectorofPhotography,
        [EnumMember]
        [Name(Code = "212314", Name = "Film and Video Editor")]
        FilmandVideoEditor,
        [EnumMember]
        [Name(Code = "212315", Name = "Program Director (Television or Radio)")]
        ProgramDirectorTelevisionorRadio,
        [EnumMember]
        [Name(Code = "212316", Name = "Stage Manager")]
        StageManager,
        [EnumMember]
        [Name(Code = "212317", Name = "Technical Director")]
        TechnicalDirector,
        [EnumMember]
        [Name(Code = "212318", Name = "Video Producer")]
        VideoProducer,
        [EnumMember]
        [Name(Code = "212399", Name = "Film, Television, Radio and Stage Directors nec")]
        FilmTelevisionRadioandStageDirectorsnec,
        [EnumMember]
        [Name(Code = "212400", Name = "Journalists and Other Writers nfd")]
        JournalistsandOtherWritersnfd,
        [EnumMember]
        [Name(Code = "212411", Name = "Copywriter")]
        Copywriter,
        [EnumMember]
        [Name(Code = "212412", Name = "Newspaper or Periodical Editor")]
        NewspaperorPeriodicalEditor,
        [EnumMember]
        [Name(Code = "212413", Name = "Print Journalist")]
        PrintJournalist,
        [EnumMember]
        [Name(Code = "212414", Name = "Radio Journalist")]
        RadioJournalist,
        [EnumMember]
        [Name(Code = "212415", Name = "Technical Writer")]
        TechnicalWriter,
        [EnumMember]
        [Name(Code = "212416", Name = "Television Journalist")]
        TelevisionJournalist,
        [EnumMember]
        [Name(Code = "212499", Name = "Journalists and Other Writers nec")]
        JournalistsandOtherWritersnec,
        [EnumMember]
        [Name(Code = "220000", Name = "Business, Human Resource and Marketing Professionals nfd")]
        BusinessHumanResourceandMarketingProfessionalsnfd,
        [EnumMember]
        [Name(Code = "221000", Name = "Accountants, Auditors and Company Secretaries nfd")]
        AccountantsAuditorsandCompanySecretariesnfd,
        [EnumMember]
        [Name(Code = "221100", Name = "Accountants nfd")]
        Accountantsnfd,
        [EnumMember]
        [Name(Code = "221111", Name = "Accountant (General)")]
        AccountantGeneral,
        [EnumMember]
        [Name(Code = "221112", Name = "Management Accountant")]
        ManagementAccountant,
        [EnumMember]
        [Name(Code = "221113", Name = "Taxation Accountant")]
        TaxationAccountant,
        [EnumMember]
        [Name(Code = "221200", Name = "Auditors, Company Secretaries and Corporate Treasurers nfd")]
        AuditorsCompanySecretariesandCorporateTreasurersnfd,
        [EnumMember]
        [Name(Code = "221211", Name = "Company Secretary")]
        CompanySecretary,
        [EnumMember]
        [Name(Code = "221212", Name = "Corporate Treasurer")]
        CorporateTreasurer,
        [EnumMember]
        [Name(Code = "221213", Name = "External Auditor")]
        ExternalAuditor,
        [EnumMember]
        [Name(Code = "221214", Name = "Internal Auditor")]
        InternalAuditor,
        [EnumMember]
        [Name(Code = "222000", Name = "Financial Brokers and Dealers, and Investment Advisers nfd")]
        FinancialBrokersandDealersandInvestmentAdvisersnfd,
        [EnumMember]
        [Name(Code = "222100", Name = "Financial Brokers nfd")]
        FinancialBrokersnfd,
        [EnumMember]
        [Name(Code = "222111", Name = "Commodities Trader")]
        CommoditiesTrader,
        [EnumMember]
        [Name(Code = "222112", Name = "Finance Broker")]
        FinanceBroker,
        [EnumMember]
        [Name(Code = "222113", Name = "Insurance Broker")]
        InsuranceBroker,
        [EnumMember]
        [Name(Code = "222199", Name = "Financial Brokers nec")]
        FinancialBrokersnec,
        [EnumMember]
        [Name(Code = "222200", Name = "Financial Dealers nfd")]
        FinancialDealersnfd,
        [EnumMember]
        [Name(Code = "222211", Name = "Financial Market Dealer")]
        FinancialMarketDealer,
        [EnumMember]
        [Name(Code = "222212", Name = "Futures Trader")]
        FuturesTrader,
        [EnumMember]
        [Name(Code = "222213", Name = "Stockbroking Dealer")]
        StockbrokingDealer,
        [EnumMember]
        [Name(Code = "222299", Name = "Financial Dealers nec")]
        FinancialDealersnec,
        [EnumMember]
        [Name(Code = "222300", Name = "Financial Investment Advisers and Managers nfd")]
        FinancialInvestmentAdvisersandManagersnfd,
        [EnumMember]
        [Name(Code = "222311", Name = "Financial Investment Adviser")]
        FinancialInvestmentAdviser,
        [EnumMember]
        [Name(Code = "222312", Name = "Financial Investment Manager")]
        FinancialInvestmentManager,
        [EnumMember]
        [Name(Code = "223000", Name = "Human Resource and Training Professionals nfd")]
        HumanResourceandTrainingProfessionalsnfd,
        [EnumMember]
        [Name(Code = "223100", Name = "Human Resource Professionals nfd")]
        HumanResourceProfessionalsnfd,
        [EnumMember]
        [Name(Code = "223111", Name = "Human Resource Adviser")]
        HumanResourceAdviser,
        [EnumMember]
        [Name(Code = "223112", Name = "Recruitment Consultant")]
        RecruitmentConsultant,
        [EnumMember]
        [Name(Code = "223113", Name = "Workplace Relations Adviser")]
        WorkplaceRelationsAdviser,
        [EnumMember]
        [Name(Code = "223211", Name = "ICT Trainer")]
        ICTTrainer,
        [EnumMember]
        [Name(Code = "223311", Name = "Training and Development Professional")]
        TrainingandDevelopmentProfessional,
        [EnumMember]
        [Name(Code = "224000", Name = "Information and Organisation Professionals nfd")]
        InformationandOrganisationProfessionalsnfd,
        [EnumMember]
        [Name(Code = "224100", Name = "Actuaries, Mathematicians and Statisticians nfd")]
        ActuariesMathematiciansandStatisticiansnfd,
        [EnumMember]
        [Name(Code = "224111", Name = "Actuary")]
        Actuary,
        [EnumMember]
        [Name(Code = "224112", Name = "Mathematician")]
        Mathematician,
        [EnumMember]
        [Name(Code = "224113", Name = "Statistician")]
        Statistician,
        [EnumMember]
        [Name(Code = "224200", Name = "Archivists, Curators and Records Managers nfd")]
        ArchivistsCuratorsandRecordsManagersnfd,
        [EnumMember]
        [Name(Code = "224211", Name = "Archivist")]
        Archivist,
        [EnumMember]
        [Name(Code = "224212", Name = "Gallery or Museum Curator")]
        GalleryorMuseumCurator,
        [EnumMember]
        [Name(Code = "224213", Name = "Health Information Manager")]
        HealthInformationManager,
        [EnumMember]
        [Name(Code = "224214", Name = "Records Manager")]
        RecordsManager,
        [EnumMember]
        [Name(Code = "224311", Name = "Economist")]
        Economist,
        [EnumMember]
        [Name(Code = "224400", Name = "Intelligence and Policy Analysts nfd")]
        IntelligenceandPolicyAnalystsnfd,
        [EnumMember]
        [Name(Code = "224411", Name = "Intelligence Officer")]
        IntelligenceOfficer,
        [EnumMember]
        [Name(Code = "224412", Name = "Policy Analyst")]
        PolicyAnalyst,
        [EnumMember]
        [Name(Code = "224500", Name = "Land Economists and Valuers nfd")]
        LandEconomistsandValuersnfd,
        [EnumMember]
        [Name(Code = "224511", Name = "Land Economist")]
        LandEconomist,
        [EnumMember]
        [Name(Code = "224512", Name = "Valuer")]
        Valuer,
        [EnumMember]
        [Name(Code = "224611", Name = "Librarian")]
        Librarian,
        [EnumMember]
        [Name(Code = "224700", Name = "Management and Organisation Analysts nfd")]
        ManagementandOrganisationAnalystsnfd,
        [EnumMember]
        [Name(Code = "224711", Name = "Management Consultant")]
        ManagementConsultant,
        [EnumMember]
        [Name(Code = "224712", Name = "Organisation and Methods Analyst")]
        OrganisationandMethodsAnalyst,
        [EnumMember]
        [Name(Code = "224900", Name = "Other Information and Organisation Professionals nfd")]
        OtherInformationandOrganisationProfessionalsnfd,
        [EnumMember]
        [Name(Code = "224911", Name = "Electorate Officer")]
        ElectorateOfficer,
        [EnumMember]
        [Name(Code = "224912", Name = "Liaison Officer")]
        LiaisonOfficer,
        [EnumMember]
        [Name(Code = "224913", Name = "Migration Agent")]
        MigrationAgent,
        [EnumMember]
        [Name(Code = "224914", Name = "Patents Examiner")]
        PatentsExaminer,
        [EnumMember]
        [Name(Code = "224999", Name = "Information and Organisation Professionals nec")]
        InformationandOrganisationProfessionalsnec,
        [EnumMember]
        [Name(Code = "225000", Name = "Sales, Marketing and Public Relations Professionals nfd")]
        SalesMarketingandPublicRelationsProfessionalsnfd,
        [EnumMember]
        [Name(Code = "225100", Name = "Advertising and Marketing Professionals nfd")]
        AdvertisingandMarketingProfessionalsnfd,
        [EnumMember]
        [Name(Code = "225111", Name = "Advertising Specialist")]
        AdvertisingSpecialist,
        [EnumMember]
        [Name(Code = "225112", Name = "Market Research Analyst")]
        MarketResearchAnalyst,
        [EnumMember]
        [Name(Code = "225113", Name = "Marketing Specialist")]
        MarketingSpecialist,
        [EnumMember]
        [Name(Code = "225200", Name = "ICT Sales Professionals nfd")]
        ICTSalesProfessionalsnfd,
        [EnumMember]
        [Name(Code = "225211", Name = "ICT Account Manager")]
        ICTAccountManager,
        [EnumMember]
        [Name(Code = "225212", Name = "ICT Business Development Manager")]
        ICTBusinessDevelopmentManager,
        [EnumMember]
        [Name(Code = "225213", Name = "ICT Sales Representative")]
        ICTSalesRepresentative,
        [EnumMember]
        [Name(Code = "225311", Name = "Public Relations Professional")]
        PublicRelationsProfessional,
        [EnumMember]
        [Name(Code = "225400", Name = "Technical Sales Representatives nfd")]
        TechnicalSalesRepresentativesnfd,
        [EnumMember]
        [Name(Code = "225411", Name = "Sales Representative (Industrial Products)")]
        SalesRepresentativeIndustrialProducts,
        [EnumMember]
        [Name(Code = "225412", Name = "Sales Representative (Medical and Pharmaceutical Products)")]
        SalesRepresentativeMedicalandPharmaceuticalProducts,
        [EnumMember]
        [Name(Code = "225499", Name = "Technical Sales Representatives nec")]
        TechnicalSalesRepresentativesnec,
        [EnumMember]
        [Name(Code = "230000", Name = "Design, Engineering, Science and Transport Professionals nfd")]
        DesignEngineeringScienceandTransportProfessionalsnfd,
        [EnumMember]
        [Name(Code = "231000", Name = "Air and Marine Transport Professionals nfd")]
        AirandMarineTransportProfessionalsnfd,
        [EnumMember]
        [Name(Code = "231100", Name = "Air Transport Professionals nfd")]
        AirTransportProfessionalsnfd,
        [EnumMember]
        [Name(Code = "231111", Name = "Aeroplane Pilot")]
        AeroplanePilot,
        [EnumMember]
        [Name(Code = "231112", Name = "Air Traffic Controller")]
        AirTrafficController,
        [EnumMember]
        [Name(Code = "231113", Name = "Flying Instructor")]
        FlyingInstructor,
        [EnumMember]
        [Name(Code = "231114", Name = "Helicopter Pilot")]
        HelicopterPilot,
        [EnumMember]
        [Name(Code = "231199", Name = "Air Transport Professionals nec")]
        AirTransportProfessionalsnec,
        [EnumMember]
        [Name(Code = "231200", Name = "Marine Transport Professionals nfd")]
        MarineTransportProfessionalsnfd,
        [EnumMember]
        [Name(Code = "231211", Name = "Master Fisher")]
        MasterFisher,
        [EnumMember]
        [Name(Code = "231212", Name = "Ship's Engineer")]
        ShipsEngineer,
        [EnumMember]
        [Name(Code = "231213", Name = "Ship's Master")]
        ShipsMaster,
        [EnumMember]
        [Name(Code = "231214", Name = "Ship's Officer")]
        ShipsOfficer,
        [EnumMember]
        [Name(Code = "231215", Name = "Ship's Surveyor")]
        ShipsSurveyor,
        [EnumMember]
        [Name(Code = "231299", Name = "Marine Transport Professionals nec")]
        MarineTransportProfessionalsnec,
        [EnumMember]
        [Name(Code = "232000", Name = "Architects, Designers, Planners and Surveyors nfd")]
        ArchitectsDesignersPlannersandSurveyorsnfd,
        [EnumMember]
        [Name(Code = "232100", Name = "Architects and Landscape Architects nfd")]
        ArchitectsandLandscapeArchitectsnfd,
        [EnumMember]
        [Name(Code = "232111", Name = "Architect")]
        Architect,
        [EnumMember]
        [Name(Code = "232112", Name = "Landscape Architect")]
        LandscapeArchitect,
        [EnumMember]
        [Name(Code = "232200", Name = "Surveyors and Spatial Scientists nfd")]
        SurveyorsandSpatialScientistsnfd,
        [EnumMember]
        [Name(Code = "232212", Name = "Surveyor")]
        Surveyor,
        [EnumMember]
        [Name(Code = "232213", Name = "Cartographer")]
        Cartographer,
        [EnumMember]
        [Name(Code = "232214", Name = "Other Spatial Scientist")]
        OtherSpatialScientist,
        [EnumMember]
        [Name(Code = "232300", Name = "Fashion, Industrial and Jewellery Designers nfd")]
        FashionIndustrialandJewelleryDesignersnfd,
        [EnumMember]
        [Name(Code = "232311", Name = "Fashion Designer")]
        FashionDesigner,
        [EnumMember]
        [Name(Code = "232312", Name = "Industrial Designer")]
        IndustrialDesigner,
        [EnumMember]
        [Name(Code = "232313", Name = "Jewellery Designer")]
        JewelleryDesigner,
        [EnumMember]
        [Name(Code = "232400", Name = "Graphic and Web Designers, and Illustrators nfd")]
        GraphicandWebDesignersandIllustratorsnfd,
        [EnumMember]
        [Name(Code = "232411", Name = "Graphic Designer")]
        GraphicDesigner,
        [EnumMember]
        [Name(Code = "232412", Name = "Illustrator")]
        Illustrator,
        [EnumMember]
        [Name(Code = "232413", Name = "Multimedia Designer")]
        MultimediaDesigner,
        [EnumMember]
        [Name(Code = "232414", Name = "Web Designer")]
        WebDesigner,
        [EnumMember]
        [Name(Code = "232511", Name = "Interior Designer")]
        InteriorDesigner,
        [EnumMember]
        [Name(Code = "232611", Name = "Urban and Regional Planner")]
        UrbanandRegionalPlanner,
        [EnumMember]
        [Name(Code = "233000", Name = "Engineering Professionals nfd")]
        EngineeringProfessionalsnfd,
        [EnumMember]
        [Name(Code = "233100", Name = "Chemical and Materials Engineers nfd")]
        ChemicalandMaterialsEngineersnfd,
        [EnumMember]
        [Name(Code = "233111", Name = "Chemical Engineer")]
        ChemicalEngineer,
        [EnumMember]
        [Name(Code = "233112", Name = "Materials Engineer")]
        MaterialsEngineer,
        [EnumMember]
        [Name(Code = "233200", Name = "Civil Engineering Professionals nfd")]
        CivilEngineeringProfessionalsnfd,
        [EnumMember]
        [Name(Code = "233211", Name = "Civil Engineer")]
        CivilEngineer,
        [EnumMember]
        [Name(Code = "233212", Name = "Geotechnical Engineer")]
        GeotechnicalEngineer,
        [EnumMember]
        [Name(Code = "233213", Name = "Quantity Surveyor")]
        QuantitySurveyor,
        [EnumMember]
        [Name(Code = "233214", Name = "Structural Engineer")]
        StructuralEngineer,
        [EnumMember]
        [Name(Code = "233215", Name = "Transport Engineer")]
        TransportEngineer,
        [EnumMember]
        [Name(Code = "233311", Name = "Electrical Engineer")]
        ElectricalEngineer,
        [EnumMember]
        [Name(Code = "233411", Name = "Electronics Engineer")]
        ElectronicsEngineer,
        [EnumMember]
        [Name(Code = "233500", Name = "Industrial, Mechanical and Production Engineers nfd")]
        IndustrialMechanicalandProductionEngineersnfd,
        [EnumMember]
        [Name(Code = "233511", Name = "Industrial Engineer")]
        IndustrialEngineer,
        [EnumMember]
        [Name(Code = "233512", Name = "Mechanical Engineer")]
        MechanicalEngineer,
        [EnumMember]
        [Name(Code = "233513", Name = "Production or Plant Engineer")]
        ProductionorPlantEngineer,
        [EnumMember]
        [Name(Code = "233600", Name = "Mining Engineers nfd")]
        MiningEngineersnfd,
        [EnumMember]
        [Name(Code = "233611", Name = "Mining Engineer (excluding Petroleum)")]
        MiningEngineerexcludingPetroleum,
        [EnumMember]
        [Name(Code = "233612", Name = "Petroleum Engineer")]
        PetroleumEngineer,
        [EnumMember]
        [Name(Code = "233900", Name = "Other Engineering Professionals nfd")]
        OtherEngineeringProfessionalsnfd,
        [EnumMember]
        [Name(Code = "233911", Name = "Aeronautical Engineer")]
        AeronauticalEngineer,
        [EnumMember]
        [Name(Code = "233912", Name = "Agricultural Engineer")]
        AgriculturalEngineer,
        [EnumMember]
        [Name(Code = "233913", Name = "Biomedical Engineer")]
        BiomedicalEngineer,
        [EnumMember]
        [Name(Code = "233914", Name = "Engineering Technologist")]
        EngineeringTechnologist,
        [EnumMember]
        [Name(Code = "233915", Name = "Environmental Engineer")]
        EnvironmentalEngineer,
        [EnumMember]
        [Name(Code = "233916", Name = "Naval Architect")]
        NavalArchitect,
        [EnumMember]
        [Name(Code = "233999", Name = "Engineering Professionals nec")]
        EngineeringProfessionalsnec,
        [EnumMember]
        [Name(Code = "234000", Name = "Natural and Physical Science Professionals nfd")]
        NaturalandPhysicalScienceProfessionalsnfd,
        [EnumMember]
        [Name(Code = "234100", Name = "Agricultural and Forestry Scientists nfd")]
        AgriculturalandForestryScientistsnfd,
        [EnumMember]
        [Name(Code = "234111", Name = "Agricultural Consultant")]
        AgriculturalConsultant,
        [EnumMember]
        [Name(Code = "234112", Name = "Agricultural Scientist")]
        AgriculturalScientist,
        [EnumMember]
        [Name(Code = "234113", Name = "Forester")]
        Forester,
        [EnumMember]
        [Name(Code = "234200", Name = "Chemists, and Food and Wine Scientists nfd")]
        ChemistsandFoodandWineScientistsnfd,
        [EnumMember]
        [Name(Code = "234211", Name = "Chemist")]
        Chemist,
        [EnumMember]
        [Name(Code = "234212", Name = "Food Technologist")]
        FoodTechnologist,
        [EnumMember]
        [Name(Code = "234213", Name = "Wine Maker")]
        WineMaker,
        [EnumMember]
        [Name(Code = "234300", Name = "Environmental Scientists nfd")]
        EnvironmentalScientistsnfd,
        [EnumMember]
        [Name(Code = "234311", Name = "Conservation Officer")]
        ConservationOfficer,
        [EnumMember]
        [Name(Code = "234312", Name = "Environmental Consultant")]
        EnvironmentalConsultant,
        [EnumMember]
        [Name(Code = "234313", Name = "Environmental Research Scientist")]
        EnvironmentalResearchScientist,
        [EnumMember]
        [Name(Code = "234314", Name = "Park Ranger")]
        ParkRanger,
        [EnumMember]
        [Name(Code = "234399", Name = "Environmental Scientists nec")]
        EnvironmentalScientistsnec,
        [EnumMember]
        [Name(Code = "234400", Name = "Geologists and Geophysicists nfd")]
        GeologistsandGeophysicistsnfd,
        [EnumMember]
        [Name(Code = "234411", Name = "Geologist")]
        Geologist,
        [EnumMember]
        [Name(Code = "234412", Name = "Geophysicist")]
        Geophysicist,
        [EnumMember]
        [Name(Code = "234500", Name = "Life Scientists nfd")]
        LifeScientistsnfd,
        [EnumMember]
        [Name(Code = "234511", Name = "Life Scientist (General)")]
        LifeScientistGeneral,
        [EnumMember]
        [Name(Code = "234512", Name = "Anatomist or Physiologist")]
        AnatomistorPhysiologist,
        [EnumMember]
        [Name(Code = "234513", Name = "Biochemist")]
        Biochemist,
        [EnumMember]
        [Name(Code = "234514", Name = "Biotechnologist")]
        Biotechnologist,
        [EnumMember]
        [Name(Code = "234515", Name = "Botanist")]
        Botanist,
        [EnumMember]
        [Name(Code = "234516", Name = "Marine Biologist")]
        MarineBiologist,
        [EnumMember]
        [Name(Code = "234517", Name = "Microbiologist")]
        Microbiologist,
        [EnumMember]
        [Name(Code = "234518", Name = "Zoologist")]
        Zoologist,
        [EnumMember]
        [Name(Code = "234599", Name = "Life Scientists nec")]
        LifeScientistsnec,
        [EnumMember]
        [Name(Code = "234611", Name = "Medical Laboratory Scientist")]
        MedicalLaboratoryScientist,
        [EnumMember]
        [Name(Code = "234711", Name = "Veterinarian")]
        Veterinarian,
        [EnumMember]
        [Name(Code = "234900", Name = "Other Natural and Physical Science Professionals nfd")]
        OtherNaturalandPhysicalScienceProfessionalsnfd,
        [EnumMember]
        [Name(Code = "234911", Name = "Conservator")]
        Conservator,
        [EnumMember]
        [Name(Code = "234912", Name = "Metallurgist")]
        Metallurgist,
        [EnumMember]
        [Name(Code = "234913", Name = "Meteorologist")]
        Meteorologist,
        [EnumMember]
        [Name(Code = "234914", Name = "Physicist")]
        Physicist,
        [EnumMember]
        [Name(Code = "234999", Name = "Natural and Physical Science Professionals nec")]
        NaturalandPhysicalScienceProfessionalsnec,
        [EnumMember]
        [Name(Code = "240000", Name = "Education Professionals nfd")]
        EducationProfessionalsnfd,
        [EnumMember]
        [Name(Code = "241000", Name = "School Teachers nfd")]
        SchoolTeachersnfd,
        [EnumMember]
        [Name(Code = "241111", Name = "Early Childhood (Pre-primary School) Teacher")]
        EarlyChildhoodPreprimarySchoolTeacher,
        [EnumMember]
        [Name(Code = "241213", Name = "Primary School Teacher")]
        PrimarySchoolTeacher,
        [EnumMember]
        [Name(Code = "241311", Name = "Middle School Teacher")]
        MiddleSchoolTeacher,
        [EnumMember]
        [Name(Code = "241411", Name = "Secondary School Teacher")]
        SecondarySchoolTeacher,
        [EnumMember]
        [Name(Code = "241500", Name = "Special Education Teachers nfd")]
        SpecialEducationTeachersnfd,
        [EnumMember]
        [Name(Code = "241511", Name = "Special Needs Teacher")]
        SpecialNeedsTeacher,
        [EnumMember]
        [Name(Code = "241512", Name = "Teacher of the Hearing Impaired")]
        TeacheroftheHearingImpaired,
        [EnumMember]
        [Name(Code = "241513", Name = "Teacher of the Sight Impaired")]
        TeacheroftheSightImpaired,
        [EnumMember]
        [Name(Code = "241599", Name = "Special Education Teachers nec")]
        SpecialEducationTeachersnec,
        [EnumMember]
        [Name(Code = "242000", Name = "Tertiary Education Teachers nfd")]
        TertiaryEducationTeachersnfd,
        [EnumMember]
        [Name(Code = "242100", Name = "University Lecturers and Tutors nfd")]
        UniversityLecturersandTutorsnfd,
        [EnumMember]
        [Name(Code = "242111", Name = "University Lecturer")]
        UniversityLecturer,
        [EnumMember]
        [Name(Code = "242112", Name = "University Tutor")]
        UniversityTutor,
        [EnumMember]
        [Name(Code = "242211", Name = "Vocational Education Teacher")]
        VocationalEducationTeacher,
        [EnumMember]
        [Name(Code = "249000", Name = "Miscellaneous Education Professionals nfd")]
        MiscellaneousEducationProfessionalsnfd,
        [EnumMember]
        [Name(Code = "249100", Name = "Education Advisers and Reviewers nfd")]
        EducationAdvisersandReviewersnfd,
        [EnumMember]
        [Name(Code = "249111", Name = "Education Adviser")]
        EducationAdviser,
        [EnumMember]
        [Name(Code = "249112", Name = "Education Reviewer")]
        EducationReviewer,
        [EnumMember]
        [Name(Code = "249200", Name = "Private Tutors and Teachers nfd")]
        PrivateTutorsandTeachersnfd,
        [EnumMember]
        [Name(Code = "249211", Name = "Art Teacher (Private Tuition)")]
        ArtTeacherPrivateTuition,
        [EnumMember]
        [Name(Code = "249212", Name = "Dance Teacher (Private Tuition)")]
        DanceTeacherPrivateTuition,
        [EnumMember]
        [Name(Code = "249213", Name = "Drama Teacher (Private Tuition)")]
        DramaTeacherPrivateTuition,
        [EnumMember]
        [Name(Code = "249214", Name = "Music Teacher (Private Tuition)")]
        MusicTeacherPrivateTuition,
        [EnumMember]
        [Name(Code = "249299", Name = "Private Tutors and Teachers nec")]
        PrivateTutorsandTeachersnec,
        [EnumMember]
        [Name(Code = "249311", Name = "Teacher of English to Speakers of Other Languages")]
        TeacherofEnglishtoSpeakersofOtherLanguages,
        [EnumMember]
        [Name(Code = "250000", Name = "Health Professionals nfd")]
        HealthProfessionalsnfd,
        [EnumMember]
        [Name(Code = "251000", Name = "Health Diagnostic and Promotion Professionals nfd")]
        HealthDiagnosticandPromotionProfessionalsnfd,
        [EnumMember]
        [Name(Code = "251111", Name = "Dietitian")]
        Dietitian,
        [EnumMember]
        [Name(Code = "251200", Name = "Medical Imaging Professionals nfd")]
        MedicalImagingProfessionalsnfd,
        [EnumMember]
        [Name(Code = "251211", Name = "Medical Diagnostic Radiographer")]
        MedicalDiagnosticRadiographer,
        [EnumMember]
        [Name(Code = "251212", Name = "Medical Radiation Therapist")]
        MedicalRadiationTherapist,
        [EnumMember]
        [Name(Code = "251213", Name = "Nuclear Medicine Technologist")]
        NuclearMedicineTechnologist,
        [EnumMember]
        [Name(Code = "251214", Name = "Sonographer")]
        Sonographer,
        [EnumMember]
        [Name(Code = "251300", Name = "Occupational and Environmental Health Professionals nfd")]
        OccupationalandEnvironmentalHealthProfessionalsnfd,
        [EnumMember]
        [Name(Code = "251311", Name = "Environmental Health Officer")]
        EnvironmentalHealthOfficer,
        [EnumMember]
        [Name(Code = "251312", Name = "Occupational Health and Safety Adviser")]
        OccupationalHealthandSafetyAdviser,
        [EnumMember]
        [Name(Code = "251400", Name = "Optometrists and Orthoptists nfd")]
        OptometristsandOrthoptistsnfd,
        [EnumMember]
        [Name(Code = "251411", Name = "Optometrist")]
        Optometrist,
        [EnumMember]
        [Name(Code = "251412", Name = "Orthoptist")]
        Orthoptist,
        [EnumMember]
        [Name(Code = "2515", Name = "Pharmacists")]
        Pharmacists,
        [EnumMember]
        [Name(Code = "251500", Name = "Pharmacists nfd")]
        Pharmacistsnfd,
        [EnumMember]
        [Name(Code = "251511", Name = "Hospital Pharmacist")]
        HospitalPharmacist,
        [EnumMember]
        [Name(Code = "251512", Name = "Industrial Pharmacist")]
        IndustrialPharmacist,
        [EnumMember]
        [Name(Code = "251513", Name = "Retail Pharmacist")]
        RetailPharmacist,
        [EnumMember]
        [Name(Code = "251900", Name = "Other Health Diagnostic and Promotion Professionals nfd")]
        OtherHealthDiagnosticandPromotionProfessionalsnfd,
        [EnumMember]
        [Name(Code = "251911", Name = "Health Promotion Officer")]
        HealthPromotionOfficer,
        [EnumMember]
        [Name(Code = "251912", Name = "Orthotist or Prosthetist")]
        OrthotistorProsthetist,
        [EnumMember]
        [Name(Code = "251999", Name = "Health Diagnostic and Promotion Professionals nec")]
        HealthDiagnosticandPromotionProfessionalsnec,
        [EnumMember]
        [Name(Code = "252000", Name = "Health Therapy Professionals nfd")]
        HealthTherapyProfessionalsnfd,
        [EnumMember]
        [Name(Code = "252100", Name = "Chiropractors and Osteopaths nfd")]
        ChiropractorsandOsteopathsnfd,
        [EnumMember]
        [Name(Code = "252111", Name = "Chiropractor")]
        Chiropractor,
        [EnumMember]
        [Name(Code = "252112", Name = "Osteopath")]
        Osteopath,
        [EnumMember]
        [Name(Code = "252200", Name = "Complementary Health Therapists nfd")]
        ComplementaryHealthTherapistsnfd,
        [EnumMember]
        [Name(Code = "252211", Name = "Acupuncturist")]
        Acupuncturist,
        [EnumMember]
        [Name(Code = "252212", Name = "Homoeopath")]
        Homoeopath,
        [EnumMember]
        [Name(Code = "252213", Name = "Naturopath")]
        Naturopath,
        [EnumMember]
        [Name(Code = "252214", Name = "Traditional Chinese Medicine Practitioner")]
        TraditionalChineseMedicinePractitioner,
        [EnumMember]
        [Name(Code = "252299", Name = "Complementary Health Therapists nec")]
        ComplementaryHealthTherapistsnec,
        [EnumMember]
        [Name(Code = "252300", Name = "Dental Practitioners nfd")]
        DentalPractitionersnfd,
        [EnumMember]
        [Name(Code = "252311", Name = "Dental Specialist")]
        DentalSpecialist,
        [EnumMember]
        [Name(Code = "252312", Name = "Dentist")]
        Dentist,
        [EnumMember]
        [Name(Code = "252411", Name = "Occupational Therapist")]
        OccupationalTherapist,
        [EnumMember]
        [Name(Code = "252511", Name = "Physiotherapist")]
        Physiotherapist,
        [EnumMember]
        [Name(Code = "252611", Name = "Podiatrist")]
        Podiatrist,
        [EnumMember]
        [Name(Code = "252700", Name = "Speech Professionals and Audiologists nfd")]
        SpeechProfessionalsandAudiologistsnfd,
        [EnumMember]
        [Name(Code = "252711", Name = "Audiologist")]
        Audiologist,
        [EnumMember]
        [Name(Code = "252712", Name = "Speech Pathologist")]
        SpeechPathologist,
        [EnumMember]
        [Name(Code = "253000", Name = "Medical Practitioners nfd")]
        MedicalPractitionersnfd,
        [EnumMember]
        [Name(Code = "253100", Name = "Generalist Medical Practitioners nfd")]
        GeneralistMedicalPractitionersnfd,
        [EnumMember]
        [Name(Code = "253111", Name = "General Medical Practitioner")]
        GeneralMedicalPractitioner,
        [EnumMember]
        [Name(Code = "253112", Name = "Resident Medical Officer")]
        ResidentMedicalOfficer,
        [EnumMember]
        [Name(Code = "253211", Name = "Anaesthetist")]
        Anaesthetist,
        [EnumMember]
        [Name(Code = "253300", Name = "Specialist Physicians nfd")]
        SpecialistPhysiciansnfd,
        [EnumMember]
        [Name(Code = "253311", Name = "Specialist Physician (General Medicine)")]
        SpecialistPhysicianGeneralMedicine,
        [EnumMember]
        [Name(Code = "253312", Name = "Cardiologist")]
        Cardiologist,
        [EnumMember]
        [Name(Code = "253313", Name = "Clinical Haematologist")]
        ClinicalHaematologist,
        [EnumMember]
        [Name(Code = "253314", Name = "Medical Oncologist")]
        MedicalOncologist,
        [EnumMember]
        [Name(Code = "253315", Name = "Endocrinologist")]
        Endocrinologist,
        [EnumMember]
        [Name(Code = "253316", Name = "Gastroenterologist")]
        Gastroenterologist,
        [EnumMember]
        [Name(Code = "253317", Name = "Intensive Care Specialist")]
        IntensiveCareSpecialist,
        [EnumMember]
        [Name(Code = "253318", Name = "Neurologist")]
        Neurologist,
        [EnumMember]
        [Name(Code = "253321", Name = "Paediatrician")]
        Paediatrician,
        [EnumMember]
        [Name(Code = "253322", Name = "Renal Medicine Specialist")]
        RenalMedicineSpecialist,
        [EnumMember]
        [Name(Code = "253323", Name = "Rheumatologist")]
        Rheumatologist,
        [EnumMember]
        [Name(Code = "253324", Name = "Thoracic Medicine Specialist")]
        ThoracicMedicineSpecialist,
        [EnumMember]
        [Name(Code = "253399", Name = "Specialist Physicians nec")]
        SpecialistPhysiciansnec,
        [EnumMember]
        [Name(Code = "253411", Name = "Psychiatrist")]
        Psychiatrist,
        [EnumMember]
        [Name(Code = "253500", Name = "Surgeons nfd")]
        Surgeonsnfd,
        [EnumMember]
        [Name(Code = "253511", Name = "Surgeon (General)")]
        SurgeonGeneral,
        [EnumMember]
        [Name(Code = "253512", Name = "Cardiothoracic Surgeon")]
        CardiothoracicSurgeon,
        [EnumMember]
        [Name(Code = "253513", Name = "Neurosurgeon")]
        Neurosurgeon,
        [EnumMember]
        [Name(Code = "253514", Name = "Orthopaedic Surgeon")]
        OrthopaedicSurgeon,
        [EnumMember]
        [Name(Code = "253515", Name = "Otorhinolaryngologist")]
        Otorhinolaryngologist,
        [EnumMember]
        [Name(Code = "253516", Name = "Paediatric Surgeon")]
        PaediatricSurgeon,
        [EnumMember]
        [Name(Code = "253517", Name = "Plastic and Reconstructive Surgeon")]
        PlasticandReconstructiveSurgeon,
        [EnumMember]
        [Name(Code = "253518", Name = "Urologist")]
        Urologist,
        [EnumMember]
        [Name(Code = "253521", Name = "Vascular Surgeon")]
        VascularSurgeon,
        [EnumMember]
        [Name(Code = "253900", Name = "Other Medical Practitioners nfd")]
        OtherMedicalPractitionersnfd,
        [EnumMember]
        [Name(Code = "253911", Name = "Dermatologist")]
        Dermatologist,
        [EnumMember]
        [Name(Code = "253912", Name = "Emergency Medicine Specialist")]
        EmergencyMedicineSpecialist,
        [EnumMember]
        [Name(Code = "253913", Name = "Obstetrician and Gynaecologist")]
        ObstetricianandGynaecologist,
        [EnumMember]
        [Name(Code = "253914", Name = "Ophthalmologist")]
        Ophthalmologist,
        [EnumMember]
        [Name(Code = "253915", Name = "Pathologist")]
        Pathologist,
        [EnumMember]
        [Name(Code = "253917", Name = "Diagnostic and Interventional Radiologist")]
        DiagnosticandInterventionalRadiologist,
        [EnumMember]
        [Name(Code = "253918", Name = "Radiation Oncologist")]
        RadiationOncologist,
        [EnumMember]
        [Name(Code = "253999", Name = "Medical Practitioners nec")]
        MedicalPractitionersnec,
        [EnumMember]
        [Name(Code = "254000", Name = "Midwifery and Nursing Professionals nfd")]
        MidwiferyandNursingProfessionalsnfd,
        [EnumMember]
        [Name(Code = "254111", Name = "Midwife")]
        Midwife,
        [EnumMember]
        [Name(Code = "254200", Name = "Nurse Educators and Researchers nfd")]
        NurseEducatorsandResearchersnfd,
        [EnumMember]
        [Name(Code = "254211", Name = "Nurse Educator")]
        NurseEducator,
        [EnumMember]
        [Name(Code = "254212", Name = "Nurse Researcher")]
        NurseResearcher,
        [EnumMember]
        [Name(Code = "254311", Name = "Nurse Manager")]
        NurseManager,
        [EnumMember]
        [Name(Code = "254400", Name = "Registered Nurses nfd")]
        RegisteredNursesnfd,
        [EnumMember]
        [Name(Code = "254411", Name = "Nurse Practitioner")]
        NursePractitioner,
        [EnumMember]
        [Name(Code = "254412", Name = "Registered Nurse (Aged Care)")]
        RegisteredNurseAgedCare,
        [EnumMember]
        [Name(Code = "254413", Name = "Registered Nurse (Child and Family Health)")]
        RegisteredNurseChildandFamilyHealth,
        [EnumMember]
        [Name(Code = "254414", Name = "Registered Nurse (Community Health)")]
        RegisteredNurseCommunityHealth,
        [EnumMember]
        [Name(Code = "254415", Name = "Registered Nurse (Critical Care and Emergency)")]
        RegisteredNurseCriticalCareandEmergency,
        [EnumMember]
        [Name(Code = "254416", Name = "Registered Nurse (Developmental Disability)")]
        RegisteredNurseDevelopmentalDisability,
        [EnumMember]
        [Name(Code = "254417", Name = "Registered Nurse (Disability and Rehabilitation)")]
        RegisteredNurseDisabilityandRehabilitation,
        [EnumMember]
        [Name(Code = "254418", Name = "Registered Nurse (Medical)")]
        RegisteredNurseMedical,
        [EnumMember]
        [Name(Code = "254421", Name = "Registered Nurse (Medical Practice)")]
        RegisteredNurseMedicalPractice,
        [EnumMember]
        [Name(Code = "254422", Name = "Registered Nurse (Mental Health)")]
        RegisteredNurseMentalHealth,
        [EnumMember]
        [Name(Code = "254423", Name = "Registered Nurse (Perioperative)")]
        RegisteredNursePerioperative,
        [EnumMember]
        [Name(Code = "254424", Name = "Registered Nurse (Surgical)")]
        RegisteredNurseSurgical,
        [EnumMember]
        [Name(Code = "254499", Name = "Registered Nurses nec")]
        RegisteredNursesnec,
        [EnumMember]
        [Name(Code = "260000", Name = "ICT Professionals nfd")]
        ICTProfessionalsnfd,
        [EnumMember]
        [Name(Code = "261000", Name = "Business and Systems Analysts, and Programmers nfd")]
        BusinessandSystemsAnalystsandProgrammersnfd,
        [EnumMember]
        [Name(Code = "261100", Name = "ICT Business and Systems Analysts nfd")]
        ICTBusinessandSystemsAnalystsnfd,
        [EnumMember]
        [Name(Code = "261111", Name = "ICT Business Analyst")]
        ICTBusinessAnalyst,
        [EnumMember]
        [Name(Code = "261112", Name = "Systems Analyst")]
        SystemsAnalyst,
        [EnumMember]
        [Name(Code = "261200", Name = "Multimedia Specialists and Web Developers nfd")]
        MultimediaSpecialistsandWebDevelopersnfd,
        [EnumMember]
        [Name(Code = "261211", Name = "Multimedia Specialist")]
        MultimediaSpecialist,
        [EnumMember]
        [Name(Code = "261212", Name = "Web Developer")]
        WebDeveloper,
        [EnumMember]
        [Name(Code = "261300", Name = "Software and Applications Programmers nfd")]
        SoftwareandApplicationsProgrammersnfd,
        [EnumMember]
        [Name(Code = "261311", Name = "Analyst Programmer")]
        AnalystProgrammer,
        [EnumMember]
        [Name(Code = "261312", Name = "Developer Programmer")]
        DeveloperProgrammer,
        [EnumMember]
        [Name(Code = "261313", Name = "Software Engineer")]
        SoftwareEngineer,
        [EnumMember]
        [Name(Code = "261314", Name = "Software Tester")]
        SoftwareTester,
        [EnumMember]
        [Name(Code = "261399", Name = "Software and Applications Programmers nec")]
        SoftwareandApplicationsProgrammersnec,
        [EnumMember]
        [Name(Code = "262100", Name = "Database and Systems Administrators, and ICT Security Specialists nfd")]
        DatabaseandSystemsAdministratorsandICTSecuritySpecialistsnfd,
        [EnumMember]
        [Name(Code = "262111", Name = "Database Administrator")]
        DatabaseAdministrator,
        [EnumMember]
        [Name(Code = "262112", Name = "ICT Security Specialist")]
        ICTSecuritySpecialist,
        [EnumMember]
        [Name(Code = "262113", Name = "Systems Administrator")]
        SystemsAdministrator,
        [EnumMember]
        [Name(Code = "263000", Name = "ICT Network and Support Professionals nfd")]
        ICTNetworkandSupportProfessionalsnfd,
        [EnumMember]
        [Name(Code = "263100", Name = "Computer Network Professionals nfd")]
        ComputerNetworkProfessionalsnfd,
        [EnumMember]
        [Name(Code = "263111", Name = "Computer Network and Systems Engineer")]
        ComputerNetworkandSystemsEngineer,
        [EnumMember]
        [Name(Code = "263112", Name = "Network Administrator")]
        NetworkAdministrator,
        [EnumMember]
        [Name(Code = "263113", Name = "Network Analyst")]
        NetworkAnalyst,
        [EnumMember]
        [Name(Code = "263200", Name = "ICT Support and Test Engineers nfd")]
        ICTSupportandTestEngineersnfd,
        [EnumMember]
        [Name(Code = "263211", Name = "ICT Quality Assurance Engineer")]
        ICTQualityAssuranceEngineer,
        [EnumMember]
        [Name(Code = "263212", Name = "ICT Support Engineer")]
        ICTSupportEngineer,
        [EnumMember]
        [Name(Code = "263213", Name = "ICT Systems Test Engineer")]
        ICTSystemsTestEngineer,
        [EnumMember]
        [Name(Code = "263299", Name = "ICT Support and Test Engineers nec")]
        ICTSupportandTestEngineersnec,
        [EnumMember]
        [Name(Code = "263300", Name = "Telecommunications Engineering Professionals nfd")]
        TelecommunicationsEngineeringProfessionalsnfd,
        [EnumMember]
        [Name(Code = "263311", Name = "Telecommunications Engineer")]
        TelecommunicationsEngineer,
        [EnumMember]
        [Name(Code = "263312", Name = "Telecommunications Network Engineer")]
        TelecommunicationsNetworkEngineer,
        [EnumMember]
        [Name(Code = "270000", Name = "Legal, Social and Welfare Professionals nfd")]
        LegalSocialandWelfareProfessionalsnfd,
        [EnumMember]
        [Name(Code = "271000", Name = "Legal Professionals nfd")]
        LegalProfessionalsnfd,
        [EnumMember]
        [Name(Code = "271111", Name = "Barrister")]
        Barrister,
        [EnumMember]
        [Name(Code = "271200", Name = "Judicial and Other Legal Professionals nfd")]
        JudicialandOtherLegalProfessionalsnfd,
        [EnumMember]
        [Name(Code = "271211", Name = "Judge")]
        Judge,
        [EnumMember]
        [Name(Code = "271212", Name = "Magistrate")]
        Magistrate,
        [EnumMember]
        [Name(Code = "271213", Name = "Tribunal Member")]
        TribunalMember,
        [EnumMember]
        [Name(Code = "271299", Name = "Judicial and Other Legal Professionals nec")]
        JudicialandOtherLegalProfessionalsnec,
        [EnumMember]
        [Name(Code = "271311", Name = "Solicitor")]
        Solicitor,
        [EnumMember]
        [Name(Code = "272000", Name = "Social and Welfare Professionals nfd")]
        SocialandWelfareProfessionalsnfd,
        [EnumMember]
        [Name(Code = "272100", Name = "Counsellors nfd")]
        Counsellorsnfd,
        [EnumMember]
        [Name(Code = "272111", Name = "Careers Counsellor")]
        CareersCounsellor,
        [EnumMember]
        [Name(Code = "272112", Name = "Drug and Alcohol Counsellor")]
        DrugandAlcoholCounsellor,
        [EnumMember]
        [Name(Code = "272113", Name = "Family and Marriage Counsellor")]
        FamilyandMarriageCounsellor,
        [EnumMember]
        [Name(Code = "272114", Name = "Rehabilitation Counsellor")]
        RehabilitationCounsellor,
        [EnumMember]
        [Name(Code = "272115", Name = "Student Counsellor")]
        StudentCounsellor,
        [EnumMember]
        [Name(Code = "272199", Name = "Counsellors nec")]
        Counsellorsnec,
        [EnumMember]
        [Name(Code = "272211", Name = "Minister of Religion")]
        MinisterofReligion,
        [EnumMember]
        [Name(Code = "272300", Name = "Psychologists nfd")]
        Psychologistsnfd,
        [EnumMember]
        [Name(Code = "272311", Name = "Clinical Psychologist")]
        ClinicalPsychologist,
        [EnumMember]
        [Name(Code = "272312", Name = "Educational Psychologist")]
        EducationalPsychologist,
        [EnumMember]
        [Name(Code = "272313", Name = "Organisational Psychologist")]
        OrganisationalPsychologist,
        [EnumMember]
        [Name(Code = "272314", Name = "Psychotherapist")]
        Psychotherapist,
        [EnumMember]
        [Name(Code = "272399", Name = "Psychologists nec")]
        Psychologistsnec,
        [EnumMember]
        [Name(Code = "272400", Name = "Social Professionals nfd")]
        SocialProfessionalsnfd,
        [EnumMember]
        [Name(Code = "272411", Name = "Historian")]
        Historian,
        [EnumMember]
        [Name(Code = "272412", Name = "Interpreter")]
        Interpreter,
        [EnumMember]
        [Name(Code = "272413", Name = "Translator")]
        Translator,
        [EnumMember]
        [Name(Code = "272499", Name = "Social Professionals nec")]
        SocialProfessionalsnec,
        [EnumMember]
        [Name(Code = "272511", Name = "Social Worker")]
        SocialWorker,
        [EnumMember]
        [Name(Code = "272600", Name = "Welfare, Recreation and Community Arts Workers nfd")]
        WelfareRecreationandCommunityArtsWorkersnfd,
        [EnumMember]
        [Name(Code = "272611", Name = "Community Arts Worker")]
        CommunityArtsWorker,
        [EnumMember]
        [Name(Code = "272612", Name = "Recreation Officer")]
        RecreationOfficer,
        [EnumMember]
        [Name(Code = "272613", Name = "Welfare Worker")]
        WelfareWorker,
        [EnumMember]
        [Name(Code = "300000", Name = "Technicians and Trades Workers nfd")]
        TechniciansandTradesWorkersnfd,
        [EnumMember]
        [Name(Code = "310000", Name = "Engineering, ICT and Science Technicians nfd")]
        EngineeringICTandScienceTechniciansnfd,
        [EnumMember]
        [Name(Code = "311000", Name = "Agricultural, Medical and Science Technicians nfd")]
        AgriculturalMedicalandScienceTechniciansnfd,
        [EnumMember]
        [Name(Code = "311111", Name = "Agricultural Technician")]
        AgriculturalTechnician,
        [EnumMember]
        [Name(Code = "311200", Name = "Medical Technicians nfd")]
        MedicalTechniciansnfd,
        [EnumMember]
        [Name(Code = "311211", Name = "Anaesthetic Technician")]
        AnaestheticTechnician,
        [EnumMember]
        [Name(Code = "311212", Name = "Cardiac Technician")]
        CardiacTechnician,
        [EnumMember]
        [Name(Code = "311213", Name = "Medical Laboratory Technician")]
        MedicalLaboratoryTechnician,
        [EnumMember]
        [Name(Code = "311214", Name = "Operating Theatre Technician")]
        OperatingTheatreTechnician,
        [EnumMember]
        [Name(Code = "311215", Name = "Pharmacy Technician")]
        PharmacyTechnician,
        [EnumMember]
        [Name(Code = "311216", Name = "Pathology Collector")]
        PathologyCollector,
        [EnumMember]
        [Name(Code = "311299", Name = "Medical Technicians nec")]
        MedicalTechniciansnec,
        [EnumMember]
        [Name(Code = "311300", Name = "Primary Products Inspectors nfd")]
        PrimaryProductsInspectorsnfd,
        [EnumMember]
        [Name(Code = "311311", Name = "Fisheries Officer")]
        FisheriesOfficer,
        [EnumMember]
        [Name(Code = "311312", Name = "Meat Inspector")]
        MeatInspector,
        [EnumMember]
        [Name(Code = "311313", Name = "Quarantine Officer")]
        QuarantineOfficer,
        [EnumMember]
        [Name(Code = "311399", Name = "Primary Products Inspectors nec")]
        PrimaryProductsInspectorsnec,
        [EnumMember]
        [Name(Code = "311400", Name = "Science Technicians nfd")]
        ScienceTechniciansnfd,
        [EnumMember]
        [Name(Code = "311411", Name = "Chemistry Technician")]
        ChemistryTechnician,
        [EnumMember]
        [Name(Code = "311412", Name = "Earth Science Technician")]
        EarthScienceTechnician,
        [EnumMember]
        [Name(Code = "311413", Name = "Life Science Technician")]
        LifeScienceTechnician,
        [EnumMember]
        [Name(Code = "311414", Name = "School Laboratory Technician")]
        SchoolLaboratoryTechnician,
        [EnumMember]
        [Name(Code = "311499", Name = "Science Technicians nec")]
        ScienceTechniciansnec,
        [EnumMember]
        [Name(Code = "312000", Name = "Building and Engineering Technicians nfd")]
        BuildingandEngineeringTechniciansnfd,
        [EnumMember]
        [Name(Code = "312100", Name = "Architectural, Building and Surveying Technicians nfd")]
        ArchitecturalBuildingandSurveyingTechniciansnfd,
        [EnumMember]
        [Name(Code = "312111", Name = "Architectural Draftsperson")]
        ArchitecturalDraftsperson,
        [EnumMember]
        [Name(Code = "312112", Name = "Building Associate")]
        BuildingAssociate,
        [EnumMember]
        [Name(Code = "312113", Name = "Building Inspector")]
        BuildingInspector,
        [EnumMember]
        [Name(Code = "312114", Name = "Construction Estimator")]
        ConstructionEstimator,
        [EnumMember]
        [Name(Code = "312115", Name = "Plumbing Inspector")]
        PlumbingInspector,
        [EnumMember]
        [Name(Code = "312116", Name = "Surveying or Spatial Science Technician")]
        SurveyingorSpatialScienceTechnician,
        [EnumMember]
        [Name(Code = "312199", Name = "Architectural, Building and Surveying Technicians nec")]
        ArchitecturalBuildingandSurveyingTechniciansnec,
        [EnumMember]
        [Name(Code = "312200", Name = "Civil Engineering Draftspersons and Technicians nfd")]
        CivilEngineeringDraftspersonsandTechniciansnfd,
        [EnumMember]
        [Name(Code = "312211", Name = "Civil Engineering Draftsperson")]
        CivilEngineeringDraftsperson,
        [EnumMember]
        [Name(Code = "312212", Name = "Civil Engineering Technician")]
        CivilEngineeringTechnician,
        [EnumMember]
        [Name(Code = "312300", Name = "Electrical Engineering Draftspersons and Technicians nfd")]
        ElectricalEngineeringDraftspersonsandTechniciansnfd,
        [EnumMember]
        [Name(Code = "312311", Name = "Electrical Engineering Draftsperson")]
        ElectricalEngineeringDraftsperson,
        [EnumMember]
        [Name(Code = "312312", Name = "Electrical Engineering Technician")]
        ElectricalEngineeringTechnician,
        [EnumMember]
        [Name(Code = "312400", Name = "Electronic Engineering Draftspersons and Technicians nfd")]
        ElectronicEngineeringDraftspersonsandTechniciansnfd,
        [EnumMember]
        [Name(Code = "312411", Name = "Electronic Engineering Draftsperson")]
        ElectronicEngineeringDraftsperson,
        [EnumMember]
        [Name(Code = "312412", Name = "Electronic Engineering Technician")]
        ElectronicEngineeringTechnician,
        [EnumMember]
        [Name(Code = "312500", Name = "Mechanical Engineering Draftspersons and Technicians nfd")]
        MechanicalEngineeringDraftspersonsandTechniciansnfd,
        [EnumMember]
        [Name(Code = "312511", Name = "Mechanical Engineering Draftsperson")]
        MechanicalEngineeringDraftsperson,
        [EnumMember]
        [Name(Code = "312512", Name = "Mechanical Engineering Technician")]
        MechanicalEngineeringTechnician,
        [EnumMember]
        [Name(Code = "312611", Name = "Safety Inspector")]
        SafetyInspector,
        [EnumMember]
        [Name(Code = "312900", Name = "Other Building and Engineering Technicians nfd")]
        OtherBuildingandEngineeringTechniciansnfd,
        [EnumMember]
        [Name(Code = "312911", Name = "Maintenance Planner")]
        MaintenancePlanner,
        [EnumMember]
        [Name(Code = "312912", Name = "Metallurgical or Materials Technician")]
        MetallurgicalorMaterialsTechnician,
        [EnumMember]
        [Name(Code = "312913", Name = "Mine Deputy")]
        MineDeputy,
        [EnumMember]
        [Name(Code = "312999", Name = "Building and Engineering Technicians nec")]
        BuildingandEngineeringTechniciansnec,
        [EnumMember]
        [Name(Code = "313000", Name = "ICT and Telecommunications Technicians nfd")]
        ICTandTelecommunicationsTechniciansnfd,
        [EnumMember]
        [Name(Code = "313100", Name = "ICT Support Technicians nfd")]
        ICTSupportTechniciansnfd,
        [EnumMember]
        [Name(Code = "313111", Name = "Hardware Technician")]
        HardwareTechnician,
        [EnumMember]
        [Name(Code = "313112", Name = "ICT Customer Support Officer")]
        ICTCustomerSupportOfficer,
        [EnumMember]
        [Name(Code = "313113", Name = "Web Administrator")]
        WebAdministrator,
        [EnumMember]
        [Name(Code = "313199", Name = "ICT Support Technicians nec")]
        ICTSupportTechniciansnec,
        [EnumMember]
        [Name(Code = "313200", Name = "Telecommunications Technical Specialists nfd")]
        TelecommunicationsTechnicalSpecialistsnfd,
        [EnumMember]
        [Name(Code = "313211", Name = "Radiocommunications Technician")]
        RadiocommunicationsTechnician,
        [EnumMember]
        [Name(Code = "313212", Name = "Telecommunications Field Engineer")]
        TelecommunicationsFieldEngineer,
        [EnumMember]
        [Name(Code = "313213", Name = "Telecommunications Network Planner")]
        TelecommunicationsNetworkPlanner,
        [EnumMember]
        [Name(Code = "313214", Name = "Telecommunications Technical Officer or Technologist")]
        TelecommunicationsTechnicalOfficerorTechnologist,
        [EnumMember]
        [Name(Code = "320000", Name = "Automotive and Engineering Trades Workers nfd")]
        AutomotiveandEngineeringTradesWorkersnfd,
        [EnumMember]
        [Name(Code = "321000", Name = "Automotive Electricians and Mechanics nfd")]
        AutomotiveElectriciansandMechanicsnfd,
        [EnumMember]
        [Name(Code = "321111", Name = "Automotive Electrician")]
        AutomotiveElectrician,
        [EnumMember]
        [Name(Code = "321200", Name = "Motor Mechanics nfd")]
        MotorMechanicsnfd,
        [EnumMember]
        [Name(Code = "321211", Name = "Motor Mechanic (General)")]
        MotorMechanicGeneral,
        [EnumMember]
        [Name(Code = "321212", Name = "Diesel Motor Mechanic")]
        DieselMotorMechanic,
        [EnumMember]
        [Name(Code = "321213", Name = "Motorcycle Mechanic")]
        MotorcycleMechanic,
        [EnumMember]
        [Name(Code = "321214", Name = "Small Engine Mechanic")]
        SmallEngineMechanic,
        [EnumMember]
        [Name(Code = "322000", Name = "Fabrication Engineering Trades Workers nfd")]
        FabricationEngineeringTradesWorkersnfd,
        [EnumMember]
        [Name(Code = "322100", Name = "Metal Casting, Forging and Finishing Trades Workers nfd")]
        MetalCastingForgingandFinishingTradesWorkersnfd,
        [EnumMember]
        [Name(Code = "322111", Name = "Blacksmith")]
        Blacksmith,
        [EnumMember]
        [Name(Code = "322112", Name = "Electroplater")]
        Electroplater,
        [EnumMember]
        [Name(Code = "322113", Name = "Farrier")]
        Farrier,
        [EnumMember]
        [Name(Code = "322114", Name = "Metal Casting Trades Worker")]
        MetalCastingTradesWorker,
        [EnumMember]
        [Name(Code = "322115", Name = "Metal Polisher")]
        MetalPolisher,
        [EnumMember]
        [Name(Code = "322211", Name = "Sheetmetal Trades Worker")]
        SheetmetalTradesWorker,
        [EnumMember]
        [Name(Code = "322300", Name = "Structural Steel and Welding Trades Workers nfd")]
        StructuralSteelandWeldingTradesWorkersnfd,
        [EnumMember]
        [Name(Code = "322311", Name = "Metal Fabricator")]
        MetalFabricator,
        [EnumMember]
        [Name(Code = "322312", Name = "Pressure Welder")]
        PressureWelder,
        [EnumMember]
        [Name(Code = "322313", Name = "Welder (First Class)")]
        WelderFirstClass,
        [EnumMember]
        [Name(Code = "323000", Name = "Mechanical Engineering Trades Workers nfd")]
        MechanicalEngineeringTradesWorkersnfd,
        [EnumMember]
        [Name(Code = "323100", Name = "Aircraft Maintenance Engineers nfd")]
        AircraftMaintenanceEngineersnfd,
        [EnumMember]
        [Name(Code = "323111", Name = "Aircraft Maintenance Engineer (Avionics)")]
        AircraftMaintenanceEngineerAvionics,
        [EnumMember]
        [Name(Code = "323112", Name = "Aircraft Maintenance Engineer (Mechanical)")]
        AircraftMaintenanceEngineerMechanical,
        [EnumMember]
        [Name(Code = "323113", Name = "Aircraft Maintenance Engineer (Structures)")]
        AircraftMaintenanceEngineerStructures,
        [EnumMember]
        [Name(Code = "323200", Name = "Metal Fitters and Machinists nfd")]
        MetalFittersandMachinistsnfd,
        [EnumMember]
        [Name(Code = "323211", Name = "Fitter (General)")]
        FitterGeneral,
        [EnumMember]
        [Name(Code = "323212", Name = "Fitter and Turner")]
        FitterandTurner,
        [EnumMember]
        [Name(Code = "323213", Name = "Fitter-Welder")]
        FitterWelder,
        [EnumMember]
        [Name(Code = "323214", Name = "Metal Machinist (First Class)")]
        MetalMachinistFirstClass,
        [EnumMember]
        [Name(Code = "323215", Name = "Textile, Clothing and Footwear Mechanic")]
        TextileClothingandFootwearMechanic,
        [EnumMember]
        [Name(Code = "323299", Name = "Metal Fitters and Machinists nec")]
        MetalFittersandMachinistsnec,
        [EnumMember]
        [Name(Code = "323300", Name = "Precision Metal Trades Workers nfd")]
        PrecisionMetalTradesWorkersnfd,
        [EnumMember]
        [Name(Code = "323311", Name = "Engraver")]
        Engraver,
        [EnumMember]
        [Name(Code = "323312", Name = "Gunsmith")]
        Gunsmith,
        [EnumMember]
        [Name(Code = "323313", Name = "Locksmith")]
        Locksmith,
        [EnumMember]
        [Name(Code = "323314", Name = "Precision Instrument Maker and Repairer")]
        PrecisionInstrumentMakerandRepairer,
        [EnumMember]
        [Name(Code = "323315", Name = "Saw Maker and Repairer")]
        SawMakerandRepairer,
        [EnumMember]
        [Name(Code = "323316", Name = "Watch and Clock Maker and Repairer")]
        WatchandClockMakerandRepairer,
        [EnumMember]
        [Name(Code = "323400", Name = "Toolmakers and Engineering Patternmakers nfd")]
        ToolmakersandEngineeringPatternmakersnfd,
        [EnumMember]
        [Name(Code = "323411", Name = "Engineering Patternmaker")]
        EngineeringPatternmaker,
        [EnumMember]
        [Name(Code = "323412", Name = "Toolmaker")]
        Toolmaker,
        [EnumMember]
        [Name(Code = "324000", Name = "Panelbeaters, and Vehicle Body Builders, Trimmers and Painters nfd")]
        PanelbeatersandVehicleBodyBuildersTrimmersandPaintersnfd,
        [EnumMember]
        [Name(Code = "324111", Name = "Panelbeater")]
        Panelbeater,
        [EnumMember]
        [Name(Code = "324200", Name = "Vehicle Body Builders and Trimmers nfd")]
        VehicleBodyBuildersandTrimmersnfd,
        [EnumMember]
        [Name(Code = "324211", Name = "Vehicle Body Builder")]
        VehicleBodyBuilder,
        [EnumMember]
        [Name(Code = "324212", Name = "Vehicle Trimmer")]
        VehicleTrimmer,
        [EnumMember]
        [Name(Code = "324311", Name = "Vehicle Painter")]
        VehiclePainter,
        [EnumMember]
        [Name(Code = "330000", Name = "Construction Trades Workers nfd")]
        ConstructionTradesWorkersnfd,
        [EnumMember]
        [Name(Code = "331000", Name = "Bricklayers, and Carpenters and Joiners nfd")]
        BricklayersandCarpentersandJoinersnfd,
        [EnumMember]
        [Name(Code = "331100", Name = "Bricklayers and Stonemasons nfd")]
        BricklayersandStonemasonsnfd,
        [EnumMember]
        [Name(Code = "331111", Name = "Bricklayer")]
        Bricklayer,
        [EnumMember]
        [Name(Code = "331112", Name = "Stonemason")]
        Stonemason,
        [EnumMember]
        [Name(Code = "331211", Name = "Carpenter and Joiner")]
        CarpenterandJoiner,
        [EnumMember]
        [Name(Code = "331212", Name = "Carpenter")]
        Carpenter,
        [EnumMember]
        [Name(Code = "331213", Name = "Joiner")]
        Joiner,
        [EnumMember]
        [Name(Code = "332000", Name = "Floor Finishers and Painting Trades Workers nfd")]
        FloorFinishersandPaintingTradesWorkersnfd,
        [EnumMember]
        [Name(Code = "332111", Name = "Floor Finisher")]
        FloorFinisher,
        [EnumMember]
        [Name(Code = "332211", Name = "Painting Trades Worker")]
        PaintingTradesWorker,
        [EnumMember]
        [Name(Code = "333000", Name = "Glaziers, Plasterers and Tilers nfd")]
        GlaziersPlasterersandTilersnfd,
        [EnumMember]
        [Name(Code = "333111", Name = "Glazier")]
        Glazier,
        [EnumMember]
        [Name(Code = "333200", Name = "Plasterers nfd")]
        Plasterersnfd,
        [EnumMember]
        [Name(Code = "333211", Name = "Fibrous Plasterer")]
        FibrousPlasterer,
        [EnumMember]
        [Name(Code = "333212", Name = "Solid Plasterer")]
        SolidPlasterer,
        [EnumMember]
        [Name(Code = "333311", Name = "Roof Tiler")]
        RoofTiler,
        [EnumMember]
        [Name(Code = "333411", Name = "Wall and Floor Tiler")]
        WallandFloorTiler,
        [EnumMember]
        [Name(Code = "334100", Name = "Plumbers nfd")]
        Plumbersnfd,
        [EnumMember]
        [Name(Code = "334111", Name = "Plumber (General)")]
        PlumberGeneral,
        [EnumMember]
        [Name(Code = "334112", Name = "Airconditioning and Mechanical Services Plumber")]
        AirconditioningandMechanicalServicesPlumber,
        [EnumMember]
        [Name(Code = "334113", Name = "Drainer")]
        Drainer,
        [EnumMember]
        [Name(Code = "334114", Name = "Gasfitter")]
        Gasfitter,
        [EnumMember]
        [Name(Code = "334115", Name = "Roof Plumber")]
        RoofPlumber,
        [EnumMember]
        [Name(Code = "340000", Name = "Electrotechnology and Telecommunications Trades Workers nfd")]
        ElectrotechnologyandTelecommunicationsTradesWorkersnfd,
        [EnumMember]
        [Name(Code = "341100", Name = "Electricians nfd")]
        Electriciansnfd,
        [EnumMember]
        [Name(Code = "341111", Name = "Electrician (General)")]
        ElectricianGeneral,
        [EnumMember]
        [Name(Code = "341112", Name = "Electrician (Special Class)")]
        ElectricianSpecialClass,
        [EnumMember]
        [Name(Code = "341113", Name = "Lift Mechanic")]
        LiftMechanic,
        [EnumMember]
        [Name(Code = "342000", Name = "Electronics and Telecommunications Trades Workers nfd")]
        ElectronicsandTelecommunicationsTradesWorkersnfd,
        [EnumMember]
        [Name(Code = "342111", Name = "Airconditioning and Refrigeration Mechanic")]
        AirconditioningandRefrigerationMechanic,
        [EnumMember]
        [Name(Code = "342200", Name = "Electrical Distribution Trades Workers nfd")]
        ElectricalDistributionTradesWorkersnfd,
        [EnumMember]
        [Name(Code = "342211", Name = "Electrical Linesworker")]
        ElectricalLinesworker,
        [EnumMember]
        [Name(Code = "342212", Name = "Technical Cable Jointer")]
        TechnicalCableJointer,
        [EnumMember]
        [Name(Code = "342300", Name = "Electronics Trades Workers nfd")]
        ElectronicsTradesWorkersnfd,
        [EnumMember]
        [Name(Code = "342311", Name = "Business Machine Mechanic")]
        BusinessMachineMechanic,
        [EnumMember]
        [Name(Code = "342312", Name = "Communications Operator")]
        CommunicationsOperator,
        [EnumMember]
        [Name(Code = "342313", Name = "Electronic Equipment Trades Worker")]
        ElectronicEquipmentTradesWorker,
        [EnumMember]
        [Name(Code = "342314", Name = "Electronic Instrument Trades Worker (General)")]
        ElectronicInstrumentTradesWorkerGeneral,
        [EnumMember]
        [Name(Code = "342315", Name = "Electronic Instrument Trades Worker (Special Class)")]
        ElectronicInstrumentTradesWorkerSpecialClass,
        [EnumMember]
        [Name(Code = "342400", Name = "Telecommunications Trades Workers nfd")]
        TelecommunicationsTradesWorkersnfd,
        [EnumMember]
        [Name(Code = "342411", Name = "Cabler (Data and Telecommunications)")]
        CablerDataandTelecommunications,
        [EnumMember]
        [Name(Code = "342412", Name = "Telecommunications Cable Jointer")]
        TelecommunicationsCableJointer,
        [EnumMember]
        [Name(Code = "342413", Name = "Telecommunications Linesworker")]
        TelecommunicationsLinesworker,
        [EnumMember]
        [Name(Code = "342414", Name = "Telecommunications Technician")]
        TelecommunicationsTechnician,
        [EnumMember]
        [Name(Code = "351000", Name = "Food Trades Workers nfd")]
        FoodTradesWorkersnfd,
        [EnumMember]
        [Name(Code = "351100", Name = "Bakers and Pastrycooks nfd")]
        BakersandPastrycooksnfd,
        [EnumMember]
        [Name(Code = "351111", Name = "Baker")]
        Baker,
        [EnumMember]
        [Name(Code = "351112", Name = "Pastrycook")]
        Pastrycook,
        [EnumMember]
        [Name(Code = "351211", Name = "Butcher or Smallgoods Maker")]
        ButcherorSmallgoodsMaker,
        [EnumMember]
        [Name(Code = "351311", Name = "Chef")]
        Chef,
        [EnumMember]
        [Name(Code = "351411", Name = "Cook")]
        Cook,
        [EnumMember]
        [Name(Code = "360000", Name = "Skilled Animal and Horticultural Workers nfd")]
        SkilledAnimalandHorticulturalWorkersnfd,
        [EnumMember]
        [Name(Code = "361000", Name = "Animal Attendants and Trainers, and Shearers nfd")]
        AnimalAttendantsandTrainersandShearersnfd,
        [EnumMember]
        [Name(Code = "361100", Name = "Animal Attendants and Trainers nfd")]
        AnimalAttendantsandTrainersnfd,
        [EnumMember]
        [Name(Code = "361111", Name = "Dog Handler or Trainer")]
        DogHandlerorTrainer,
        [EnumMember]
        [Name(Code = "361112", Name = "Horse Trainer")]
        HorseTrainer,
        [EnumMember]
        [Name(Code = "361113", Name = "Pet Groomer")]
        PetGroomer,
        [EnumMember]
        [Name(Code = "361114", Name = "Zookeeper")]
        Zookeeper,
        [EnumMember]
        [Name(Code = "361199", Name = "Animal Attendants and Trainers nec")]
        AnimalAttendantsandTrainersnec,
        [EnumMember]
        [Name(Code = "361211", Name = "Shearer")]
        Shearer,
        [EnumMember]
        [Name(Code = "361311", Name = "Veterinary Nurse")]
        VeterinaryNurse,
        [EnumMember]
        [Name(Code = "362000", Name = "Horticultural Trades Workers nfd")]
        HorticulturalTradesWorkersnfd,
        [EnumMember]
        [Name(Code = "362111", Name = "Florist")]
        Florist,
        [EnumMember]
        [Name(Code = "362200", Name = "Gardeners nfd")]
        Gardenersnfd,
        [EnumMember]
        [Name(Code = "362211", Name = "Gardener (General)")]
        GardenerGeneral,
        [EnumMember]
        [Name(Code = "362212", Name = "Arborist")]
        Arborist,
        [EnumMember]
        [Name(Code = "362213", Name = "Landscape Gardener")]
        LandscapeGardener,
        [EnumMember]
        [Name(Code = "362311", Name = "Greenkeeper")]
        Greenkeeper,
        [EnumMember]
        [Name(Code = "362411", Name = "Nurseryperson")]
        Nurseryperson,
        [EnumMember]
        [Name(Code = "390000", Name = "Other Technicians and Trades Workers nfd")]
        OtherTechniciansandTradesWorkersnfd,
        [EnumMember]
        [Name(Code = "391111", Name = "Hairdresser")]
        Hairdresser,
        [EnumMember]
        [Name(Code = "392000", Name = "Printing Trades Workers nfd")]
        PrintingTradesWorkersnfd,
        [EnumMember]
        [Name(Code = "392100", Name = "Print Finishers and Screen Printers nfd")]
        PrintFinishersandScreenPrintersnfd,
        [EnumMember]
        [Name(Code = "392111", Name = "Print Finisher")]
        PrintFinisher,
        [EnumMember]
        [Name(Code = "392112", Name = "Screen Printer")]
        ScreenPrinter,
        [EnumMember]
        [Name(Code = "392211", Name = "Graphic Pre-press Trades Worker")]
        GraphicPrepressTradesWorker,
        [EnumMember]
        [Name(Code = "392300", Name = "Printers nfd")]
        Printersnfd,
        [EnumMember]
        [Name(Code = "392311", Name = "Printing Machinist")]
        PrintingMachinist,
        [EnumMember]
        [Name(Code = "392312", Name = "Small Offset Printer")]
        SmallOffsetPrinter,
        [EnumMember]
        [Name(Code = "393000", Name = "Textile, Clothing and Footwear Trades Workers nfd")]
        TextileClothingandFootwearTradesWorkersnfd,
        [EnumMember]
        [Name(Code = "393100", Name = "Canvas and Leather Goods Makers nfd")]
        CanvasandLeatherGoodsMakersnfd,
        [EnumMember]
        [Name(Code = "393111", Name = "Canvas Goods Fabricator")]
        CanvasGoodsFabricator,
        [EnumMember]
        [Name(Code = "393112", Name = "Leather Goods Maker")]
        LeatherGoodsMaker,
        [EnumMember]
        [Name(Code = "393113", Name = "Sail Maker")]
        SailMaker,
        [EnumMember]
        [Name(Code = "393114", Name = "Shoemaker")]
        Shoemaker,
        [EnumMember]
        [Name(Code = "393200", Name = "Clothing Trades Workers nfd")]
        ClothingTradesWorkersnfd,
        [EnumMember]
        [Name(Code = "393211", Name = "Apparel Cutter")]
        ApparelCutter,
        [EnumMember]
        [Name(Code = "393212", Name = "Clothing Patternmaker")]
        ClothingPatternmaker,
        [EnumMember]
        [Name(Code = "393213", Name = "Dressmaker or Tailor")]
        DressmakerorTailor,
        [EnumMember]
        [Name(Code = "393299", Name = "Clothing Trades Workers nec")]
        ClothingTradesWorkersnec,
        [EnumMember]
        [Name(Code = "393311", Name = "Upholsterer")]
        Upholsterer,
        [EnumMember]
        [Name(Code = "394000", Name = "Wood Trades Workers nfd")]
        WoodTradesWorkersnfd,
        [EnumMember]
        [Name(Code = "394111", Name = "Cabinetmaker")]
        Cabinetmaker,
        [EnumMember]
        [Name(Code = "394200", Name = "Wood Machinists and Other Wood Trades Workers nfd")]
        WoodMachinistsandOtherWoodTradesWorkersnfd,
        [EnumMember]
        [Name(Code = "394211", Name = "Furniture Finisher")]
        FurnitureFinisher,
        [EnumMember]
        [Name(Code = "394212", Name = "Picture Framer")]
        PictureFramer,
        [EnumMember]
        [Name(Code = "394213", Name = "Wood Machinist")]
        WoodMachinist,
        [EnumMember]
        [Name(Code = "394214", Name = "Wood Turner")]
        WoodTurner,
        [EnumMember]
        [Name(Code = "394299", Name = "Wood Machinists and Other Wood Trades Workers nec")]
        WoodMachinistsandOtherWoodTradesWorkersnec,
        [EnumMember]
        [Name(Code = "399000", Name = "Miscellaneous Technicians and Trades Workers nfd")]
        MiscellaneousTechniciansandTradesWorkersnfd,
        [EnumMember]
        [Name(Code = "399100", Name = "Boat Builders and Shipwrights nfd")]
        BoatBuildersandShipwrightsnfd,
        [EnumMember]
        [Name(Code = "399111", Name = "Boat Builder and Repairer")]
        BoatBuilderandRepairer,
        [EnumMember]
        [Name(Code = "399112", Name = "Shipwright")]
        Shipwright,
        [EnumMember]
        [Name(Code = "399200", Name = "Chemical, Gas, Petroleum and Power Generation Plant Operators nfd")]
        ChemicalGasPetroleumandPowerGenerationPlantOperatorsnfd,
        [EnumMember]
        [Name(Code = "399211", Name = "Chemical Plant Operator")]
        ChemicalPlantOperator,
        [EnumMember]
        [Name(Code = "399212", Name = "Gas or Petroleum Operator")]
        GasorPetroleumOperator,
        [EnumMember]
        [Name(Code = "399213", Name = "Power Generation Plant Operator")]
        PowerGenerationPlantOperator,
        [EnumMember]
        [Name(Code = "399300", Name = "Gallery, Library and Museum Technicians nfd")]
        GalleryLibraryandMuseumTechniciansnfd,
        [EnumMember]
        [Name(Code = "399311", Name = "Gallery or Museum Technician")]
        GalleryorMuseumTechnician,
        [EnumMember]
        [Name(Code = "399312", Name = "Library Technician")]
        LibraryTechnician,
        [EnumMember]
        [Name(Code = "399411", Name = "Jeweller")]
        Jeweller,
        [EnumMember]
        [Name(Code = "399500", Name = "Performing Arts Technicians nfd")]
        PerformingArtsTechniciansnfd,
        [EnumMember]
        [Name(Code = "399511", Name = "Broadcast Transmitter Operator")]
        BroadcastTransmitterOperator,
        [EnumMember]
        [Name(Code = "399512", Name = "Camera Operator (Film, Television or Video)")]
        CameraOperatorFilmTelevisionorVideo,
        [EnumMember]
        [Name(Code = "399513", Name = "Light Technician")]
        LightTechnician,
        [EnumMember]
        [Name(Code = "399514", Name = "Make Up Artist")]
        MakeUpArtist,
        [EnumMember]
        [Name(Code = "399515", Name = "Musical Instrument Maker or Repairer")]
        MusicalInstrumentMakerorRepairer,
        [EnumMember]
        [Name(Code = "399516", Name = "Sound Technician")]
        SoundTechnician,
        [EnumMember]
        [Name(Code = "399517", Name = "Television Equipment Operator")]
        TelevisionEquipmentOperator,
        [EnumMember]
        [Name(Code = "399599", Name = "Performing Arts Technicians nec")]
        PerformingArtsTechniciansnec,
        [EnumMember]
        [Name(Code = "399611", Name = "Signwriter")]
        Signwriter,
        [EnumMember]
        [Name(Code = "399900", Name = "Other Miscellaneous Technicians and Trades Workers nfd")]
        OtherMiscellaneousTechniciansandTradesWorkersnfd,
        [EnumMember]
        [Name(Code = "399911", Name = "Diver")]
        Diver,
        [EnumMember]
        [Name(Code = "399912", Name = "Interior Decorator")]
        InteriorDecorator,
        [EnumMember]
        [Name(Code = "399913", Name = "Optical Dispenser")]
        OpticalDispenser,
        [EnumMember]
        [Name(Code = "399914", Name = "Optical Mechanic")]
        OpticalMechanic,
        [EnumMember]
        [Name(Code = "399915", Name = "Photographer's Assistant")]
        PhotographersAssistant,
        [EnumMember]
        [Name(Code = "399916", Name = "Plastics Technician")]
        PlasticsTechnician,
        [EnumMember]
        [Name(Code = "399917", Name = "Wool Classer")]
        WoolClasser,
        [EnumMember]
        [Name(Code = "399918", Name = "Fire Protection Equipment Technician")]
        FireProtectionEquipmentTechnician,
        [EnumMember]
        [Name(Code = "399999", Name = "Technicians and Trades Workers nec")]
        TechniciansandTradesWorkersnec,
        [EnumMember]
        [Name(Code = "400000", Name = "Community and Personal Service Workers nfd")]
        CommunityandPersonalServiceWorkersnfd,
        [EnumMember]
        [Name(Code = "411000", Name = "Health and Welfare Support Workers nfd")]
        HealthandWelfareSupportWorkersnfd,
        [EnumMember]
        [Name(Code = "411100", Name = "Ambulance Officers and Paramedics nfd")]
        AmbulanceOfficersandParamedicsnfd,
        [EnumMember]
        [Name(Code = "411111", Name = "Ambulance Officer")]
        AmbulanceOfficer,
        [EnumMember]
        [Name(Code = "411112", Name = "Intensive Care Ambulance Paramedic")]
        IntensiveCareAmbulanceParamedic,
        [EnumMember]
        [Name(Code = "411200", Name = "Dental Hygienists, Technicians and Therapists nfd")]
        DentalHygienistsTechniciansandTherapistsnfd,
        [EnumMember]
        [Name(Code = "411211", Name = "Dental Hygienist")]
        DentalHygienist,
        [EnumMember]
        [Name(Code = "411212", Name = "Dental Prosthetist")]
        DentalProsthetist,
        [EnumMember]
        [Name(Code = "411213", Name = "Dental Technician")]
        DentalTechnician,
        [EnumMember]
        [Name(Code = "411214", Name = "Dental Therapist")]
        DentalTherapist,
        [EnumMember]
        [Name(Code = "411311", Name = "Diversional Therapist")]
        DiversionalTherapist,
        [EnumMember]
        [Name(Code = "411400", Name = "Enrolled and Mothercraft Nurses nfd")]
        EnrolledandMothercraftNursesnfd,
        [EnumMember]
        [Name(Code = "411411", Name = "Enrolled Nurse")]
        EnrolledNurse,
        [EnumMember]
        [Name(Code = "411412", Name = "Mothercraft Nurse")]
        MothercraftNurse,
        [EnumMember]
        [Name(Code = "411511", Name = "Aboriginal and Torres Strait Islander Health Worker")]
        AboriginalandTorresStraitIslanderHealthWorker,
        [EnumMember]
        [Name(Code = "411611", Name = "Massage Therapist")]
        MassageTherapist,
        [EnumMember]
        [Name(Code = "411700", Name = "Welfare Support Workers nfd")]
        WelfareSupportWorkersnfd,
        [EnumMember]
        [Name(Code = "411711", Name = "Community Worker")]
        CommunityWorker,
        [EnumMember]
        [Name(Code = "411712", Name = "Disabilities Services Officer")]
        DisabilitiesServicesOfficer,
        [EnumMember]
        [Name(Code = "411713", Name = "Family Support Worker")]
        FamilySupportWorker,
        [EnumMember]
        [Name(Code = "411714", Name = "Parole or Probation Officer")]
        ParoleorProbationOfficer,
        [EnumMember]
        [Name(Code = "411715", Name = "Residential Care Officer")]
        ResidentialCareOfficer,
        [EnumMember]
        [Name(Code = "411716", Name = "Youth Worker")]
        YouthWorker,
        [EnumMember]
        [Name(Code = "420000", Name = "Carers and Aides nfd")]
        CarersandAidesnfd,
        [EnumMember]
        [Name(Code = "421100", Name = "Child Carers nfd")]
        ChildCarersnfd,
        [EnumMember]
        [Name(Code = "421111", Name = "Child Care Worker")]
        ChildCareWorker,
        [EnumMember]
        [Name(Code = "421112", Name = "Family Day Care Worker")]
        FamilyDayCareWorker,
        [EnumMember]
        [Name(Code = "421113", Name = "Nanny")]
        Nanny,
        [EnumMember]
        [Name(Code = "421114", Name = "Out of School Hours Care Worker")]
        OutofSchoolHoursCareWorker,
        [EnumMember]
        [Name(Code = "422100", Name = "Education Aides nfd")]
        EducationAidesnfd,
        [EnumMember]
        [Name(Code = "422111", Name = "Aboriginal and Torres Strait Islander Education Worker")]
        AboriginalandTorresStraitIslanderEducationWorker,
        [EnumMember]
        [Name(Code = "422112", Name = "Integration Aide")]
        IntegrationAide,
        [EnumMember]
        [Name(Code = "422115", Name = "Preschool Aide")]
        PreschoolAide,
        [EnumMember]
        [Name(Code = "422116", Name = "Teachers' Aide")]
        TeachersAide,
        [EnumMember]
        [Name(Code = "423000", Name = "Personal Carers and Assistants nfd")]
        PersonalCarersandAssistantsnfd,
        [EnumMember]
        [Name(Code = "423111", Name = "Aged or Disabled Carer")]
        AgedOrDisabledCarer,
        [EnumMember]
        [Name(Code = "423211", Name = "Dental Assistant")]
        DentalAssistant,
        [EnumMember]
        [Name(Code = "423300", Name = "Nursing Support and Personal Care Workers nfd")]
        NursingSupportandPersonalCareWorkersnfd,
        [EnumMember]
        [Name(Code = "423311", Name = "Hospital Orderly")]
        HospitalOrderly,
        [EnumMember]
        [Name(Code = "423312", Name = "Nursing Support Worker")]
        NursingSupportWorker,
        [EnumMember]
        [Name(Code = "423313", Name = "Personal Care Assistant")]
        PersonalCareAssistant,
        [EnumMember]
        [Name(Code = "423314", Name = "Therapy Aide")]
        TherapyAide,
        [EnumMember]
        [Name(Code = "423400", Name = "Special Care Workers nfd")]
        SpecialCareWorkersnfd,
        [EnumMember]
        [Name(Code = "423411", Name = "Child or Youth Residential Care Assistant")]
        ChildorYouthResidentialCareAssistant,
        [EnumMember]
        [Name(Code = "423412", Name = "Hostel Parent")]
        HostelParent,
        [EnumMember]
        [Name(Code = "423413", Name = "Refuge Worker")]
        RefugeWorker,
        [EnumMember]
        [Name(Code = "431000", Name = "Hospitality Workers nfd")]
        HospitalityWorkersnfd,
        [EnumMember]
        [Name(Code = "431100", Name = "Bar Attendants and Baristas nfd")]
        BarAttendantsandBaristasnfd,
        [EnumMember]
        [Name(Code = "431111", Name = "Bar Attendant")]
        BarAttendant,
        [EnumMember]
        [Name(Code = "431112", Name = "Barista")]
        Barista,
        [EnumMember]
        [Name(Code = "431211", Name = "Cafe Worker")]
        CafeWorker,
        [EnumMember]
        [Name(Code = "431311", Name = "Gaming Worker")]
        GamingWorker,
        [EnumMember]
        [Name(Code = "431411", Name = "Hotel Service Manager")]
        HotelServiceManager,
        [EnumMember]
        [Name(Code = "431511", Name = "Waiter")]
        Waiter,
        [EnumMember]
        [Name(Code = "431900", Name = "Other Hospitality Workers nfd")]
        OtherHospitalityWorkersnfd,
        [EnumMember]
        [Name(Code = "431911", Name = "Bar Useful or Busser")]
        BarUsefulorBusser,
        [EnumMember]
        [Name(Code = "431912", Name = "Doorperson or Luggage Porter")]
        DoorpersonorLuggagePorter,
        [EnumMember]
        [Name(Code = "431999", Name = "Hospitality Workers nec")]
        HospitalityWorkersnec,
        [EnumMember]
        [Name(Code = "440000", Name = "Protective Service Workers nfd")]
        ProtectiveServiceWorkersnfd,
        [EnumMember]
        [Name(Code = "441000", Name = "Defence Force Members, Fire Fighters and Police nfd")]
        DefenceForceMembersFireFightersandPolicenfd,
        [EnumMember]
        [Name(Code = "441111", Name = "Defence Force Member - Other Ranks")]
        DefenceForceMemberOtherRanks,
        [EnumMember]
        [Name(Code = "441200", Name = "Fire and Emergency Workers nfd")]
        FireandEmergencyWorkersnfd,
        [EnumMember]
        [Name(Code = "441211", Name = "Emergency Service Worker")]
        EmergencyServiceWorker,
        [EnumMember]
        [Name(Code = "441212", Name = "Fire Fighter")]
        FireFighter,
        [EnumMember]
        [Name(Code = "441300", Name = "Police nfd")]
        Policenfd,
        [EnumMember]
        [Name(Code = "441311", Name = "Detective")]
        Detective,
        [EnumMember]
        [Name(Code = "441312", Name = "Police Officer")]
        PoliceOfficer,
        [EnumMember]
        [Name(Code = "442000", Name = "Prison and Security Officers nfd")]
        PrisonandSecurityOfficersnfd,
        [EnumMember]
        [Name(Code = "442111", Name = "Prison Officer")]
        PrisonOfficer,
        [EnumMember]
        [Name(Code = "442200", Name = "Security Officers and Guards nfd")]
        SecurityOfficersandGuardsnfd,
        [EnumMember]
        [Name(Code = "442211", Name = "Alarm, Security or Surveillance Monitor")]
        AlarmSecurityorSurveillanceMonitor,
        [EnumMember]
        [Name(Code = "442212", Name = "Armoured Car Escort")]
        ArmouredCarEscort,
        [EnumMember]
        [Name(Code = "442213", Name = "Crowd Controller")]
        CrowdController,
        [EnumMember]
        [Name(Code = "442214", Name = "Private Investigator")]
        PrivateInvestigator,
        [EnumMember]
        [Name(Code = "442215", Name = "Retail Loss Prevention Officer")]
        RetailLossPreventionOfficer,
        [EnumMember]
        [Name(Code = "442216", Name = "Security Consultant")]
        SecurityConsultant,
        [EnumMember]
        [Name(Code = "442217", Name = "Security Officer")]
        SecurityOfficer,
        [EnumMember]
        [Name(Code = "442299", Name = "Security Officers and Guards nec")]
        SecurityOfficersandGuardsnec,
        [EnumMember]
        [Name(Code = "450000", Name = "Sports and Personal Service Workers nfd")]
        SportsandPersonalServiceWorkersnfd,
        [EnumMember]
        [Name(Code = "451000", Name = "Personal Service and Travel Workers nfd")]
        PersonalServiceandTravelWorkersnfd,
        [EnumMember]
        [Name(Code = "451111", Name = "Beauty Therapist")]
        BeautyTherapist,
        [EnumMember]
        [Name(Code = "451211", Name = "Driving Instructor")]
        DrivingInstructor,
        [EnumMember]
        [Name(Code = "451300", Name = "Funeral Workers nfd")]
        FuneralWorkersnfd,
        [EnumMember]
        [Name(Code = "451311", Name = "Funeral Director")]
        FuneralDirector,
        [EnumMember]
        [Name(Code = "451399", Name = "Funeral Workers nec")]
        FuneralWorkersnec,
        [EnumMember]
        [Name(Code = "451400", Name = "Gallery, Museum and Tour Guides nfd")]
        GalleryMuseumandTourGuidesnfd,
        [EnumMember]
        [Name(Code = "451411", Name = "Gallery or Museum Guide")]
        GalleryorMuseumGuide,
        [EnumMember]
        [Name(Code = "451412", Name = "Tour Guide")]
        TourGuide,
        [EnumMember]
        [Name(Code = "451500", Name = "Personal Care Consultants nfd")]
        PersonalCareConsultantsnfd,
        [EnumMember]
        [Name(Code = "451511", Name = "Natural Remedy Consultant")]
        NaturalRemedyConsultant,
        [EnumMember]
        [Name(Code = "451512", Name = "Weight Loss Consultant")]
        WeightLossConsultant,
        [EnumMember]
        [Name(Code = "451600", Name = "Tourism and Travel Advisers nfd")]
        TourismandTravelAdvisersnfd,
        [EnumMember]
        [Name(Code = "451611", Name = "Tourist Information Officer")]
        TouristInformationOfficer,
        [EnumMember]
        [Name(Code = "451612", Name = "Travel Consultant")]
        TravelConsultant,
        [EnumMember]
        [Name(Code = "451700", Name = "Travel Attendants nfd")]
        TravelAttendantsnfd,
        [EnumMember]
        [Name(Code = "451711", Name = "Flight Attendant")]
        FlightAttendant,
        [EnumMember]
        [Name(Code = "451799", Name = "Travel Attendants nec")]
        TravelAttendantsnec,
        [EnumMember]
        [Name(Code = "451800", Name = "Other Personal Service Workers nfd")]
        OtherPersonalServiceWorkersnfd,
        [EnumMember]
        [Name(Code = "451811", Name = "Civil Celebrant")]
        CivilCelebrant,
        [EnumMember]
        [Name(Code = "451812", Name = "Hair or Beauty Salon Assistant")]
        HairorBeautySalonAssistant,
        [EnumMember]
        [Name(Code = "451813", Name = "Sex Worker or Escort")]
        SexWorkerorEscort,
        [EnumMember]
        [Name(Code = "451814", Name = "Body Artist")]
        BodyArtist,
        [EnumMember]
        [Name(Code = "451815", Name = "First Aid Trainer")]
        FirstAidTrainer,
        [EnumMember]
        [Name(Code = "451816", Name = "Religious Assistant")]
        ReligiousAssistant,
        [EnumMember]
        [Name(Code = "451899", Name = "Personal Service Workers nec")]
        PersonalServiceWorkersnec,
        [EnumMember]
        [Name(Code = "452000", Name = "Sports and Fitness Workers nfd")]
        SportsandFitnessWorkersnfd,
        [EnumMember]
        [Name(Code = "452111", Name = "Fitness Instructor")]
        FitnessInstructor,
        [EnumMember]
        [Name(Code = "452200", Name = "Outdoor Adventure Guides nfd")]
        OutdoorAdventureGuidesnfd,
        [EnumMember]
        [Name(Code = "452211", Name = "Bungy Jump Master")]
        BungyJumpMaster,
        [EnumMember]
        [Name(Code = "452212", Name = "Fishing Guide")]
        FishingGuide,
        [EnumMember]
        [Name(Code = "452213", Name = "Hunting Guide")]
        HuntingGuide,
        [EnumMember]
        [Name(Code = "452214", Name = "Mountain or Glacier Guide")]
        MountainorGlacierGuide,
        [EnumMember]
        [Name(Code = "452215", Name = "Outdoor Adventure Instructor")]
        OutdoorAdventureInstructor,
        [EnumMember]
        [Name(Code = "452216", Name = "Trekking Guide")]
        TrekkingGuide,
        [EnumMember]
        [Name(Code = "452217", Name = "Whitewater Rafting Guide")]
        WhitewaterRaftingGuide,
        [EnumMember]
        [Name(Code = "452299", Name = "Outdoor Adventure Guides nec")]
        OutdoorAdventureGuidesnec,
        [EnumMember]
        [Name(Code = "452300", Name = "Sports Coaches, Instructors and Officials nfd")]
        SportsCoachesInstructorsandOfficialsnfd,
        [EnumMember]
        [Name(Code = "452311", Name = "Diving Instructor (Open Water)")]
        DivingInstructorOpenWater,
        [EnumMember]
        [Name(Code = "452312", Name = "Gymnastics Coach or Instructor")]
        GymnasticsCoachorInstructor,
        [EnumMember]
        [Name(Code = "452313", Name = "Horse Riding Coach or Instructor")]
        HorseRidingCoachorInstructor,
        [EnumMember]
        [Name(Code = "452314", Name = "Snowsport Instructor")]
        SnowsportInstructor,
        [EnumMember]
        [Name(Code = "452315", Name = "Swimming Coach or Instructor")]
        SwimmingCoachorInstructor,
        [EnumMember]
        [Name(Code = "452316", Name = "Tennis Coach")]
        TennisCoach,
        [EnumMember]
        [Name(Code = "452317", Name = "Other Sports Coach or Instructor")]
        OtherSportsCoachorInstructor,
        [EnumMember]
        [Name(Code = "452318", Name = "Dog or Horse Racing Official")]
        DogorHorseRacingOfficial,
        [EnumMember]
        [Name(Code = "452321", Name = "Sports Development Officer")]
        SportsDevelopmentOfficer,
        [EnumMember]
        [Name(Code = "452322", Name = "Sports Umpire")]
        SportsUmpire,
        [EnumMember]
        [Name(Code = "452323", Name = "Other Sports Official")]
        OtherSportsOfficial,
        [EnumMember]
        [Name(Code = "452400", Name = "Sportspersons nfd")]
        Sportspersonsnfd,
        [EnumMember]
        [Name(Code = "452411", Name = "Footballer")]
        Footballer,
        [EnumMember]
        [Name(Code = "452412", Name = "Golfer")]
        Golfer,
        [EnumMember]
        [Name(Code = "452413", Name = "Jockey")]
        Jockey,
        [EnumMember]
        [Name(Code = "452414", Name = "Lifeguard")]
        Lifeguard,
        [EnumMember]
        [Name(Code = "452499", Name = "Sportspersons nec")]
        Sportspersonsnec,
        [EnumMember]
        [Name(Code = "500000", Name = "Clerical and Administrative Workers nfd")]
        ClericalandAdministrativeWorkersnfd,
        [EnumMember]
        [Name(Code = "510000", Name = "Office Managers and Program Administrators nfd")]
        OfficeManagersandProgramAdministratorsnfd,
        [EnumMember]
        [Name(Code = "511100", Name = "Contract, Program and Project Administrators nfd")]
        ContractProgramandProjectAdministratorsnfd,
        [EnumMember]
        [Name(Code = "511111", Name = "Contract Administrator")]
        ContractAdministrator,
        [EnumMember]
        [Name(Code = "511112", Name = "Program or Project Administrator")]
        ProgramorProjectAdministrator,
        [EnumMember]
        [Name(Code = "512000", Name = "Office and Practice Managers nfd")]
        OfficeandPracticeManagersnfd,
        [EnumMember]
        [Name(Code = "512111", Name = "Office Manager")]
        OfficeManager,
        [EnumMember]
        [Name(Code = "512200", Name = "Practice Managers nfd")]
        PracticeManagersnfd,
        [EnumMember]
        [Name(Code = "512211", Name = "Health Practice Manager")]
        HealthPracticeManager,
        [EnumMember]
        [Name(Code = "512299", Name = "Practice Managers nec")]
        PracticeManagersnec,
        [EnumMember]
        [Name(Code = "521000", Name = "Personal Assistants and Secretaries nfd")]
        PersonalAssistantsandSecretariesnfd,
        [EnumMember]
        [Name(Code = "521111", Name = "Personal Assistant")]
        PersonalAssistant,
        [EnumMember]
        [Name(Code = "521200", Name = "Secretaries nfd")]
        Secretariesnfd,
        [EnumMember]
        [Name(Code = "521211", Name = "Secretary (General)")]
        SecretaryGeneral,
        [EnumMember]
        [Name(Code = "521212", Name = "Legal Secretary")]
        LegalSecretary,
        [EnumMember]
        [Name(Code = "530000", Name = "General Clerical Workers nfd")]
        GeneralClericalWorkersnfd,
        [EnumMember]
        [Name(Code = "531111", Name = "General Clerk")]
        GeneralClerk,
        [EnumMember]
        [Name(Code = "532100", Name = "Keyboard Operators nfd")]
        KeyboardOperatorsnfd,
        [EnumMember]
        [Name(Code = "532111", Name = "Data Entry Operator")]
        DataEntryOperator,
        [EnumMember]
        [Name(Code = "532112", Name = "Machine Shorthand Reporter")]
        MachineShorthandReporter,
        [EnumMember]
        [Name(Code = "532113", Name = "Word Processing Operator")]
        WordProcessingOperator,
        [EnumMember]
        [Name(Code = "540000", Name = "Inquiry Clerks and Receptionists nfd")]
        InquiryClerksandReceptionistsnfd,
        [EnumMember]
        [Name(Code = "541000", Name = "Call or Contact Centre Information Clerks nfd")]
        CallorContactCentreInformationClerksnfd,
        [EnumMember]
        [Name(Code = "541100", Name = "Call or Contact Centre Workers nfd")]
        CallorContactCentreWorkersnfd,
        [EnumMember]
        [Name(Code = "541111", Name = "Call or Contact Centre Team Leader")]
        CallorContactCentreTeamLeader,
        [EnumMember]
        [Name(Code = "541112", Name = "Call or Contact Centre Operator")]
        CallorContactCentreOperator,
        [EnumMember]
        [Name(Code = "541211", Name = "Inquiry Clerk")]
        InquiryClerk,
        [EnumMember]
        [Name(Code = "542100", Name = "Receptionists nfd")]
        Receptionistsnfd,
        [EnumMember]
        [Name(Code = "542111", Name = "Receptionist (General)")]
        ReceptionistGeneral,
        [EnumMember]
        [Name(Code = "542112", Name = "Admissions Clerk")]
        AdmissionsClerk,
        [EnumMember]
        [Name(Code = "542113", Name = "Hotel or Motel Receptionist")]
        HotelorMotelReceptionist,
        [EnumMember]
        [Name(Code = "542114", Name = "Medical Receptionist")]
        MedicalReceptionist,
        [EnumMember]
        [Name(Code = "550000", Name = "Numerical Clerks nfd")]
        NumericalClerksnfd,
        [EnumMember]
        [Name(Code = "551000", Name = "Accounting Clerks and Bookkeepers nfd")]
        AccountingClerksandBookkeepersnfd,
        [EnumMember]
        [Name(Code = "551100", Name = "Accounting Clerks nfd")]
        AccountingClerksnfd,
        [EnumMember]
        [Name(Code = "551111", Name = "Accounts Clerk")]
        AccountsClerk,
        [EnumMember]
        [Name(Code = "551112", Name = "Cost Clerk")]
        CostClerk,
        [EnumMember]
        [Name(Code = "551211", Name = "Bookkeeper")]
        Bookkeeper,
        [EnumMember]
        [Name(Code = "551311", Name = "Payroll Clerk")]
        PayrollClerk,
        [EnumMember]
        [Name(Code = "552000", Name = "Financial and Insurance Clerks nfd")]
        FinancialandInsuranceClerksnfd,
        [EnumMember]
        [Name(Code = "552111", Name = "Bank Worker")]
        BankWorker,
        [EnumMember]
        [Name(Code = "552211", Name = "Credit or Loans Officer")]
        CreditorLoansOfficer,
        [EnumMember]
        [Name(Code = "552300", Name = "Insurance, Money Market and Statistical Clerks nfd")]
        InsuranceMoneyMarketandStatisticalClerksnfd,
        [EnumMember]
        [Name(Code = "552311", Name = "Bookmaker")]
        Bookmaker,
        [EnumMember]
        [Name(Code = "552312", Name = "Insurance Consultant")]
        InsuranceConsultant,
        [EnumMember]
        [Name(Code = "552313", Name = "Money Market Clerk")]
        MoneyMarketClerk,
        [EnumMember]
        [Name(Code = "552314", Name = "Statistical Clerk")]
        StatisticalClerk,
        [EnumMember]
        [Name(Code = "561000", Name = "Clerical and Office Support Workers nfd")]
        ClericalandOfficeSupportWorkersnfd,
        [EnumMember]
        [Name(Code = "561100", Name = "Betting Clerks nfd")]
        BettingClerksnfd,
        [EnumMember]
        [Name(Code = "561111", Name = "Betting Agency Counter Clerk")]
        BettingAgencyCounterClerk,
        [EnumMember]
        [Name(Code = "561112", Name = "Bookmaker's Clerk")]
        BookmakersClerk,
        [EnumMember]
        [Name(Code = "561113", Name = "Telephone Betting Clerk")]
        TelephoneBettingClerk,
        [EnumMember]
        [Name(Code = "561199", Name = "Betting Clerks nec")]
        BettingClerksnec,
        [EnumMember]
        [Name(Code = "561200", Name = "Couriers and Postal Deliverers nfd")]
        CouriersandPostalDeliverersnfd,
        [EnumMember]
        [Name(Code = "561211", Name = "Courier")]
        Courier,
        [EnumMember]
        [Name(Code = "561212", Name = "Postal Delivery Officer")]
        PostalDeliveryOfficer,
        [EnumMember]
        [Name(Code = "561311", Name = "Filing or Registry Clerk")]
        FilingorRegistryClerk,
        [EnumMember]
        [Name(Code = "561400", Name = "Mail Sorters nfd")]
        MailSortersnfd,
        [EnumMember]
        [Name(Code = "561411", Name = "Mail Clerk")]
        MailClerk,
        [EnumMember]
        [Name(Code = "561412", Name = "Postal Sorting Officer")]
        PostalSortingOfficer,
        [EnumMember]
        [Name(Code = "561511", Name = "Survey Interviewer")]
        SurveyInterviewer,
        [EnumMember]
        [Name(Code = "561611", Name = "Switchboard Operator")]
        SwitchboardOperator,
        [EnumMember]
        [Name(Code = "561900", Name = "Other Clerical and Office Support Workers nfd")]
        OtherClericalandOfficeSupportWorkersnfd,
        [EnumMember]
        [Name(Code = "561911", Name = "Classified Advertising Clerk")]
        ClassifiedAdvertisingClerk,
        [EnumMember]
        [Name(Code = "561912", Name = "Meter Reader")]
        MeterReader,
        [EnumMember]
        [Name(Code = "561913", Name = "Parking Inspector")]
        ParkingInspector,
        [EnumMember]
        [Name(Code = "561999", Name = "Clerical and Office Support Workers nec")]
        ClericalandOfficeSupportWorkersnec,
        [EnumMember]
        [Name(Code = "590000", Name = "Other Clerical and Administrative Workers nfd")]
        OtherClericalandAdministrativeWorkersnfd,
        [EnumMember]
        [Name(Code = "591000", Name = "Logistics Clerks nfd")]
        LogisticsClerksnfd,
        [EnumMember]
        [Name(Code = "591100", Name = "Purchasing and Supply Logistics Clerks nfd")]
        PurchasingandSupplyLogisticsClerksnfd,
        [EnumMember]
        [Name(Code = "591112", Name = "Production Clerk")]
        ProductionClerk,
        [EnumMember]
        [Name(Code = "591113", Name = "Purchasing Officer")]
        PurchasingOfficer,
        [EnumMember]
        [Name(Code = "591115", Name = "Stock Clerk")]
        StockClerk,
        [EnumMember]
        [Name(Code = "591116", Name = "Warehouse Administrator")]
        WarehouseAdministrator,
        [EnumMember]
        [Name(Code = "591117", Name = "Order Clerk")]
        OrderClerk,
        [EnumMember]
        [Name(Code = "591200", Name = "Transport and Despatch Clerks nfd")]
        TransportandDespatchClerksnfd,
        [EnumMember]
        [Name(Code = "591211", Name = "Despatching and Receiving Clerk")]
        DespatchingandReceivingClerk,
        [EnumMember]
        [Name(Code = "591212", Name = "Import-Export Clerk")]
        ImportExportClerk,
        [EnumMember]
        [Name(Code = "599000", Name = "Miscellaneous Clerical and Administrative Workers nfd")]
        MiscellaneousClericalandAdministrativeWorkersnfd,
        [EnumMember]
        [Name(Code = "599100", Name = "Conveyancers and Legal Executives nfd")]
        ConveyancersandLegalExecutivesnfd,
        [EnumMember]
        [Name(Code = "599111", Name = "Conveyancer")]
        Conveyancer,
        [EnumMember]
        [Name(Code = "599112", Name = "Legal Executive")]
        LegalExecutive,
        [EnumMember]
        [Name(Code = "599200", Name = "Court and Legal Clerks nfd")]
        CourtandLegalClerksnfd,
        [EnumMember]
        [Name(Code = "599211", Name = "Clerk of Court")]
        ClerkofCourt,
        [EnumMember]
        [Name(Code = "599212", Name = "Court Bailiff or Sheriff")]
        CourtBailifforSheriff,
        [EnumMember]
        [Name(Code = "599213", Name = "Court Orderly")]
        CourtOrderly,
        [EnumMember]
        [Name(Code = "599214", Name = "Law Clerk")]
        LawClerk,
        [EnumMember]
        [Name(Code = "599215", Name = "Trust Officer")]
        TrustOfficer,
        [EnumMember]
        [Name(Code = "599311", Name = "Debt Collector")]
        DebtCollector,
        [EnumMember]
        [Name(Code = "599411", Name = "Human Resource Clerk")]
        HumanResourceClerk,
        [EnumMember]
        [Name(Code = "599500", Name = "Inspectors and Regulatory Officers nfd")]
        InspectorsandRegulatoryOfficersnfd,
        [EnumMember]
        [Name(Code = "599511", Name = "Customs Officer")]
        CustomsOfficer,
        [EnumMember]
        [Name(Code = "599512", Name = "Immigration Officer")]
        ImmigrationOfficer,
        [EnumMember]
        [Name(Code = "599513", Name = "Motor Vehicle Licence Examiner")]
        MotorVehicleLicenceExaminer,
        [EnumMember]
        [Name(Code = "599514", Name = "Noxious Weeds and Pest Inspector")]
        NoxiousWeedsandPestInspector,
        [EnumMember]
        [Name(Code = "599515", Name = "Social Security Assessor")]
        SocialSecurityAssessor,
        [EnumMember]
        [Name(Code = "599516", Name = "Taxation Inspector")]
        TaxationInspector,
        [EnumMember]
        [Name(Code = "599517", Name = "Train Examiner")]
        TrainExaminer,
        [EnumMember]
        [Name(Code = "599518", Name = "Transport Operations Inspector")]
        TransportOperationsInspector,
        [EnumMember]
        [Name(Code = "599521", Name = "Water Inspector")]
        WaterInspector,
        [EnumMember]
        [Name(Code = "599599", Name = "Inspectors and Regulatory Officers nec")]
        InspectorsandRegulatoryOfficersnec,
        [EnumMember]
        [Name(Code = "599600", Name = "Insurance Investigators, Loss Adjusters and Risk Surveyors nfd")]
        InsuranceInvestigatorsLossAdjustersandRiskSurveyorsnfd,
        [EnumMember]
        [Name(Code = "599611", Name = "Insurance Investigator")]
        InsuranceInvestigator,
        [EnumMember]
        [Name(Code = "599612", Name = "Insurance Loss Adjuster")]
        InsuranceLossAdjuster,
        [EnumMember]
        [Name(Code = "599613", Name = "Insurance Risk Surveyor")]
        InsuranceRiskSurveyor,
        [EnumMember]
        [Name(Code = "599711", Name = "Library Assistant")]
        LibraryAssistant,
        [EnumMember]
        [Name(Code = "599900", Name = "Other Miscellaneous Clerical and Administrative Workers nfd")]
        OtherMiscellaneousClericalandAdministrativeWorkersnfd,
        [EnumMember]
        [Name(Code = "599912", Name = "Production Assistant (Film, Television, Radio or Stage)")]
        ProductionAssistantFilmTelevisionRadioorStage,
        [EnumMember]
        [Name(Code = "599913", Name = "Proof Reader")]
        ProofReader,
        [EnumMember]
        [Name(Code = "599914", Name = "Radio Despatcher")]
        RadioDespatcher,
        [EnumMember]
        [Name(Code = "599915", Name = "Clinical Coder")]
        ClinicalCoder,
        [EnumMember]
        [Name(Code = "599916", Name = "Facilities Administrator")]
        FacilitiesAdministrator,
        [EnumMember]
        [Name(Code = "599999", Name = "Clerical and Administrative Workers nec")]
        ClericalandAdministrativeWorkersnec,
        [EnumMember]
        [Name(Code = "600000", Name = "Sales Workers nfd")]
        SalesWorkersnfd,
        [EnumMember]
        [Name(Code = "610000", Name = "Sales Representatives and Agents nfd")]
        SalesRepresentativesandAgentsnfd,
        [EnumMember]
        [Name(Code = "611000", Name = "Insurance Agents and Sales Representatives nfd")]
        InsuranceAgentsandSalesRepresentativesnfd,
        [EnumMember]
        [Name(Code = "611100", Name = "Auctioneers, and Stock and Station Agents nfd")]
        AuctioneersandStockandStationAgentsnfd,
        [EnumMember]
        [Name(Code = "611111", Name = "Auctioneer")]
        Auctioneer,
        [EnumMember]
        [Name(Code = "611112", Name = "Stock and Station Agent")]
        StockandStationAgent,
        [EnumMember]
        [Name(Code = "611211", Name = "Insurance Agent")]
        InsuranceAgent,
        [EnumMember]
        [Name(Code = "611300", Name = "Sales Representatives nfd")]
        SalesRepresentativesnfd,
        [EnumMember]
        [Name(Code = "611311", Name = "Sales Representative (Building and Plumbing Supplies)")]
        SalesRepresentativeBuildingandPlumbingSupplies,
        [EnumMember]
        [Name(Code = "611312", Name = "Sales Representative (Business Services)")]
        SalesRepresentativeBusinessServices,
        [EnumMember]
        [Name(Code = "611313", Name = "Sales Representative (Motor Vehicle Parts and Accessories)")]
        SalesRepresentativeMotorVehiclePartsandAccessories,
        [EnumMember]
        [Name(Code = "611314", Name = "Sales Representative (Personal and Household Goods)")]
        SalesRepresentativePersonalandHouseholdGoods,
        [EnumMember]
        [Name(Code = "611399", Name = "Sales Representatives nec")]
        SalesRepresentativesnec,
        [EnumMember]
        [Name(Code = "612100", Name = "Real Estate Sales Agents nfd")]
        RealEstateSalesAgentsnfd,
        [EnumMember]
        [Name(Code = "612111", Name = "Business Broker")]
        BusinessBroker,
        [EnumMember]
        [Name(Code = "612112", Name = "Property Manager")]
        PropertyManager,
        [EnumMember]
        [Name(Code = "612113", Name = "Real Estate Agency Principal")]
        RealEstateAgencyPrincipal,
        [EnumMember]
        [Name(Code = "612114", Name = "Real Estate Agent")]
        RealEstateAgent,
        [EnumMember]
        [Name(Code = "612115", Name = "Real Estate Representative")]
        RealEstateRepresentative,
        [EnumMember]
        [Name(Code = "621000", Name = "Sales Assistants and Salespersons nfd")]
        SalesAssistantsandSalespersonsnfd,
        [EnumMember]
        [Name(Code = "621111", Name = "Sales Assistant (General)")]
        SalesAssistantGeneral,
        [EnumMember]
        [Name(Code = "621211", Name = "ICT Sales Assistant")]
        ICTSalesAssistant,
        [EnumMember]
        [Name(Code = "621300", Name = "Motor Vehicle and Vehicle Parts Salespersons nfd")]
        MotorVehicleandVehiclePartsSalespersonsnfd,
        [EnumMember]
        [Name(Code = "621311", Name = "Motor Vehicle or Caravan Salesperson")]
        MotorVehicleorCaravanSalesperson,
        [EnumMember]
        [Name(Code = "621312", Name = "Motor Vehicle Parts Interpreter")]
        MotorVehiclePartsInterpreter,
        [EnumMember]
        [Name(Code = "621411", Name = "Pharmacy Sales Assistant")]
        PharmacySalesAssistant,
        [EnumMember]
        [Name(Code = "621511", Name = "Retail Supervisor")]
        RetailSupervisor,
        [EnumMember]
        [Name(Code = "621611", Name = "Service Station Attendant")]
        ServiceStationAttendant,
        [EnumMember]
        [Name(Code = "621700", Name = "Street Vendors and Related Salespersons nfd")]
        StreetVendorsandRelatedSalespersonsnfd,
        [EnumMember]
        [Name(Code = "621711", Name = "Cash Van Salesperson")]
        CashVanSalesperson,
        [EnumMember]
        [Name(Code = "621712", Name = "Door-to-door Salesperson")]
        DoortodoorSalesperson,
        [EnumMember]
        [Name(Code = "621713", Name = "Street Vendor")]
        StreetVendor,
        [EnumMember]
        [Name(Code = "621900", Name = "Other Sales Assistants and Salespersons nfd")]
        OtherSalesAssistantsandSalespersonsnfd,
        [EnumMember]
        [Name(Code = "621911", Name = "Materials Recycler")]
        MaterialsRecycler,
        [EnumMember]
        [Name(Code = "621912", Name = "Rental Salesperson")]
        RentalSalesperson,
        [EnumMember]
        [Name(Code = "621999", Name = "Sales Assistants and Salespersons nec")]
        SalesAssistantsandSalespersonsnec,
        [EnumMember]
        [Name(Code = "630000", Name = "Sales Support Workers nfd")]
        SalesSupportWorkersnfd,
        [EnumMember]
        [Name(Code = "631100", Name = "Checkout Operators and Office Cashiers nfd")]
        CheckoutOperatorsandOfficeCashiersnfd,
        [EnumMember]
        [Name(Code = "631111", Name = "Checkout Operator")]
        CheckoutOperator,
        [EnumMember]
        [Name(Code = "631112", Name = "Office Cashier")]
        OfficeCashier,
        [EnumMember]
        [Name(Code = "639000", Name = "Miscellaneous Sales Support Workers nfd")]
        MiscellaneousSalesSupportWorkersnfd,
        [EnumMember]
        [Name(Code = "639100", Name = "Models and Sales Demonstrators nfd")]
        ModelsandSalesDemonstratorsnfd,
        [EnumMember]
        [Name(Code = "639111", Name = "Model")]
        Model,
        [EnumMember]
        [Name(Code = "639112", Name = "Sales Demonstrator")]
        SalesDemonstrator,
        [EnumMember]
        [Name(Code = "639200", Name = "Retail and Wool Buyers nfd")]
        RetailandWoolBuyersnfd,
        [EnumMember]
        [Name(Code = "639211", Name = "Retail Buyer")]
        RetailBuyer,
        [EnumMember]
        [Name(Code = "639212", Name = "Wool Buyer")]
        WoolBuyer,
        [EnumMember]
        [Name(Code = "639311", Name = "Telemarketer")]
        Telemarketer,
        [EnumMember]
        [Name(Code = "639400", Name = "Ticket Salespersons nfd")]
        TicketSalespersonsnfd,
        [EnumMember]
        [Name(Code = "639411", Name = "Ticket Seller")]
        TicketSeller,
        [EnumMember]
        [Name(Code = "639412", Name = "Transport Conductor")]
        TransportConductor,
        [EnumMember]
        [Name(Code = "639511", Name = "Visual Merchandiser")]
        VisualMerchandiser,
        [EnumMember]
        [Name(Code = "639911", Name = "Other Sales Support Worker")]
        OtherSalesSupportWorker,
        [EnumMember]
        [Name(Code = "700000", Name = "Machinery Operators and Drivers nfd")]
        MachineryOperatorsandDriversnfd,
        [EnumMember]
        [Name(Code = "710000", Name = "Machine and Stationary Plant Operators nfd")]
        MachineandStationaryPlantOperatorsnfd,
        [EnumMember]
        [Name(Code = "711000", Name = "Machine Operators nfd")]
        MachineOperatorsnfd,
        [EnumMember]
        [Name(Code = "711100", Name = "Clay, Concrete, Glass and Stone Processing Machine Operators nfd")]
        ClayConcreteGlassandStoneProcessingMachineOperatorsnfd,
        [EnumMember]
        [Name(Code = "711111", Name = "Clay Products Machine Operator")]
        ClayProductsMachineOperator,
        [EnumMember]
        [Name(Code = "711112", Name = "Concrete Products Machine Operator")]
        ConcreteProductsMachineOperator,
        [EnumMember]
        [Name(Code = "711113", Name = "Glass Production Machine Operator")]
        GlassProductionMachineOperator,
        [EnumMember]
        [Name(Code = "711114", Name = "Stone Processing Machine Operator")]
        StoneProcessingMachineOperator,
        [EnumMember]
        [Name(Code = "711199", Name = "Clay, Concrete, Glass and Stone Processing Machine Operators nec")]
        ClayConcreteGlassandStoneProcessingMachineOperatorsnec,
        [EnumMember]
        [Name(Code = "711211", Name = "Industrial Spraypainter")]
        IndustrialSpraypainter,
        [EnumMember]
        [Name(Code = "711300", Name = "Paper and Wood Processing Machine Operators nfd")]
        PaperandWoodProcessingMachineOperatorsnfd,
        [EnumMember]
        [Name(Code = "711311", Name = "Paper Products Machine Operator")]
        PaperProductsMachineOperator,
        [EnumMember]
        [Name(Code = "711313", Name = "Sawmilling Operator")]
        SawmillingOperator,
        [EnumMember]
        [Name(Code = "711314", Name = "Other Wood Processing Machine Operator")]
        OtherWoodProcessingMachineOperator,
        [EnumMember]
        [Name(Code = "711411", Name = "Photographic Developer and Printer")]
        PhotographicDeveloperandPrinter,
        [EnumMember]
        [Name(Code = "711500", Name = "Plastics and Rubber Production Machine Operators nfd")]
        PlasticsandRubberProductionMachineOperatorsnfd,
        [EnumMember]
        [Name(Code = "711511", Name = "Plastic Cablemaking Machine Operator")]
        PlasticCablemakingMachineOperator,
        [EnumMember]
        [Name(Code = "711512", Name = "Plastic Compounding and Reclamation Machine Operator")]
        PlasticCompoundingandReclamationMachineOperator,
        [EnumMember]
        [Name(Code = "711513", Name = "Plastics Fabricator or Welder")]
        PlasticsFabricatororWelder,
        [EnumMember]
        [Name(Code = "711514", Name = "Plastics Production Machine Operator (General)")]
        PlasticsProductionMachineOperatorGeneral,
        [EnumMember]
        [Name(Code = "711515", Name = "Reinforced Plastic and Composite Production Worker")]
        ReinforcedPlasticandCompositeProductionWorker,
        [EnumMember]
        [Name(Code = "711516", Name = "Rubber Production Machine Operator")]
        RubberProductionMachineOperator,
        [EnumMember]
        [Name(Code = "711599", Name = "Plastics and Rubber Production Machine Operators nec")]
        PlasticsandRubberProductionMachineOperatorsnec,
        [EnumMember]
        [Name(Code = "711611", Name = "Sewing Machinist")]
        SewingMachinist,
        [EnumMember]
        [Name(Code = "711700", Name = "Textile and Footwear Production Machine Operators nfd")]
        TextileandFootwearProductionMachineOperatorsnfd,
        [EnumMember]
        [Name(Code = "711711", Name = "Footwear Production Machine Operator")]
        FootwearProductionMachineOperator,
        [EnumMember]
        [Name(Code = "711712", Name = "Hide and Skin Processing Machine Operator")]
        HideandSkinProcessingMachineOperator,
        [EnumMember]
        [Name(Code = "711713", Name = "Knitting Machine Operator")]
        KnittingMachineOperator,
        [EnumMember]
        [Name(Code = "711714", Name = "Textile Dyeing and Finishing Machine Operator")]
        TextileDyeingandFinishingMachineOperator,
        [EnumMember]
        [Name(Code = "711715", Name = "Weaving Machine Operator")]
        WeavingMachineOperator,
        [EnumMember]
        [Name(Code = "711716", Name = "Yarn Carding and Spinning Machine Operator")]
        YarnCardingandSpinningMachineOperator,
        [EnumMember]
        [Name(Code = "711799", Name = "Textile and Footwear Production Machine Operators nec")]
        TextileandFootwearProductionMachineOperatorsnec,
        [EnumMember]
        [Name(Code = "711900", Name = "Other Machine Operators nfd")]
        OtherMachineOperatorsnfd,
        [EnumMember]
        [Name(Code = "711911", Name = "Chemical Production Machine Operator")]
        ChemicalProductionMachineOperator,
        [EnumMember]
        [Name(Code = "711912", Name = "Motion Picture Projectionist")]
        MotionPictureProjectionist,
        [EnumMember]
        [Name(Code = "711913", Name = "Sand Blaster")]
        SandBlaster,
        [EnumMember]
        [Name(Code = "711914", Name = "Sterilisation Technician")]
        SterilisationTechnician,
        [EnumMember]
        [Name(Code = "711999", Name = "Machine Operators nec")]
        MachineOperatorsnec,
        [EnumMember]
        [Name(Code = "712000", Name = "Stationary Plant Operators nfd")]
        StationaryPlantOperatorsnfd,
        [EnumMember]
        [Name(Code = "712111", Name = "Crane, Hoist or Lift Operator")]
        CraneHoistorLiftOperator,
        [EnumMember]
        [Name(Code = "712200", Name = "Drillers, Miners and Shot Firers nfd")]
        DrillersMinersandShotFirersnfd,
        [EnumMember]
        [Name(Code = "712211", Name = "Driller")]
        Driller,
        [EnumMember]
        [Name(Code = "712212", Name = "Miner")]
        Miner,
        [EnumMember]
        [Name(Code = "712213", Name = "Shot Firer")]
        ShotFirer,
        [EnumMember]
        [Name(Code = "712311", Name = "Engineering Production Worker")]
        EngineeringProductionWorker,
        [EnumMember]
        [Name(Code = "712900", Name = "Other Stationary Plant Operators nfd")]
        OtherStationaryPlantOperatorsnfd,
        [EnumMember]
        [Name(Code = "712911", Name = "Boiler or Engine Operator")]
        BoilerorEngineOperator,
        [EnumMember]
        [Name(Code = "712912", Name = "Bulk Materials Handling Plant Operator")]
        BulkMaterialsHandlingPlantOperator,
        [EnumMember]
        [Name(Code = "712913", Name = "Cement Production Plant Operator")]
        CementProductionPlantOperator,
        [EnumMember]
        [Name(Code = "712914", Name = "Concrete Batching Plant Operator")]
        ConcreteBatchingPlantOperator,
        [EnumMember]
        [Name(Code = "712915", Name = "Concrete Pump Operator")]
        ConcretePumpOperator,
        [EnumMember]
        [Name(Code = "712916", Name = "Paper and Pulp Mill Operator")]
        PaperandPulpMillOperator,
        [EnumMember]
        [Name(Code = "712917", Name = "Railway Signal Operator")]
        RailwaySignalOperator,
        [EnumMember]
        [Name(Code = "712918", Name = "Train Controller")]
        TrainController,
        [EnumMember]
        [Name(Code = "712921", Name = "Waste Water or Water Plant Operator")]
        WasteWaterorWaterPlantOperator,
        [EnumMember]
        [Name(Code = "712922", Name = "Weighbridge Operator")]
        WeighbridgeOperator,
        [EnumMember]
        [Name(Code = "712999", Name = "Stationary Plant Operators nec")]
        StationaryPlantOperatorsnec,
        [EnumMember]
        [Name(Code = "721000", Name = "Mobile Plant Operators nfd")]
        MobilePlantOperatorsnfd,
        [EnumMember]
        [Name(Code = "721100", Name = "Agricultural, Forestry and Horticultural Plant Operators nfd")]
        AgriculturalForestryandHorticulturalPlantOperatorsnfd,
        [EnumMember]
        [Name(Code = "721111", Name = "Agricultural and Horticultural Mobile Plant Operator")]
        AgriculturalandHorticulturalMobilePlantOperator,
        [EnumMember]
        [Name(Code = "721112", Name = "Logging Plant Operator")]
        LoggingPlantOperator,
        [EnumMember]
        [Name(Code = "721200", Name = "Earthmoving Plant Operators nfd")]
        EarthmovingPlantOperatorsnfd,
        [EnumMember]
        [Name(Code = "721211", Name = "Earthmoving Plant Operator (General)")]
        EarthmovingPlantOperatorGeneral,
        [EnumMember]
        [Name(Code = "721212", Name = "Backhoe Operator")]
        BackhoeOperator,
        [EnumMember]
        [Name(Code = "721213", Name = "Bulldozer Operator")]
        BulldozerOperator,
        [EnumMember]
        [Name(Code = "721214", Name = "Excavator Operator")]
        ExcavatorOperator,
        [EnumMember]
        [Name(Code = "721215", Name = "Grader Operator")]
        GraderOperator,
        [EnumMember]
        [Name(Code = "721216", Name = "Loader Operator")]
        LoaderOperator,
        [EnumMember]
        [Name(Code = "721311", Name = "Forklift Driver")]
        ForkliftDriver,
        [EnumMember]
        [Name(Code = "721900", Name = "Other Mobile Plant Operators nfd")]
        OtherMobilePlantOperatorsnfd,
        [EnumMember]
        [Name(Code = "721911", Name = "Aircraft Baggage Handler and Airline Ground Crew")]
        AircraftBaggageHandlerandAirlineGroundCrew,
        [EnumMember]
        [Name(Code = "721912", Name = "Linemarker")]
        Linemarker,
        [EnumMember]
        [Name(Code = "721913", Name = "Paving Plant Operator")]
        PavingPlantOperator,
        [EnumMember]
        [Name(Code = "721914", Name = "Railway Track Plant Operator")]
        RailwayTrackPlantOperator,
        [EnumMember]
        [Name(Code = "721915", Name = "Road Roller Operator")]
        RoadRollerOperator,
        [EnumMember]
        [Name(Code = "721916", Name = "Streetsweeper Operator")]
        StreetsweeperOperator,
        [EnumMember]
        [Name(Code = "721999", Name = "Mobile Plant Operators nec")]
        MobilePlantOperatorsnec,
        [EnumMember]
        [Name(Code = "730000", Name = "Road and Rail Drivers nfd")]
        RoadandRailDriversnfd,
        [EnumMember]
        [Name(Code = "731000", Name = "Automobile, Bus and Rail Drivers nfd")]
        AutomobileBusandRailDriversnfd,
        [EnumMember]
        [Name(Code = "731100", Name = "Automobile Drivers nfd")]
        AutomobileDriversnfd,
        [EnumMember]
        [Name(Code = "731111", Name = "Chauffeur")]
        Chauffeur,
        [EnumMember]
        [Name(Code = "731112", Name = "Taxi Driver")]
        TaxiDriver,
        [EnumMember]
        [Name(Code = "731199", Name = "Automobile Drivers nec")]
        AutomobileDriversnec,
        [EnumMember]
        [Name(Code = "731200", Name = "Bus and Coach Drivers nfd")]
        BusandCoachDriversnfd,
        [EnumMember]
        [Name(Code = "731211", Name = "Bus Driver")]
        BusDriver,
        [EnumMember]
        [Name(Code = "731212", Name = "Charter and Tour Bus Driver")]
        CharterandTourBusDriver,
        [EnumMember]
        [Name(Code = "731213", Name = "Passenger Coach Driver")]
        PassengerCoachDriver,
        [EnumMember]
        [Name(Code = "731300", Name = "Train and Tram Drivers nfd")]
        TrainandTramDriversnfd,
        [EnumMember]
        [Name(Code = "731311", Name = "Train Driver")]
        TrainDriver,
        [EnumMember]
        [Name(Code = "731312", Name = "Tram Driver")]
        TramDriver,
        [EnumMember]
        [Name(Code = "732111", Name = "Delivery Driver")]
        DeliveryDriver,
        [EnumMember]
        [Name(Code = "733100", Name = "Truck Drivers nfd")]
        TruckDriversnfd,
        [EnumMember]
        [Name(Code = "733111", Name = "Truck Driver (General)")]
        TruckDriverGeneral,
        [EnumMember]
        [Name(Code = "733112", Name = "Aircraft Refueller")]
        AircraftRefueller,
        [EnumMember]
        [Name(Code = "733113", Name = "Furniture Removalist")]
        FurnitureRemovalist,
        [EnumMember]
        [Name(Code = "733114", Name = "Tanker Driver")]
        TankerDriver,
        [EnumMember]
        [Name(Code = "733115", Name = "Tow Truck Driver")]
        TowTruckDriver,
        [EnumMember]
        [Name(Code = "741111", Name = "Storeperson")]
        Storeperson,
        [EnumMember]
        [Name(Code = "800000", Name = "Labourers nfd")]
        Labourersnfd,
        [EnumMember]
        [Name(Code = "811000", Name = "Cleaners and Laundry Workers nfd")]
        CleanersandLaundryWorkersnfd,
        [EnumMember]
        [Name(Code = "811111", Name = "Car Detailer")]
        CarDetailer,
        [EnumMember]
        [Name(Code = "811211", Name = "Commercial Cleaner")]
        CommercialCleaner,
        [EnumMember]
        [Name(Code = "811311", Name = "Domestic Cleaner")]
        DomesticCleaner,
        [EnumMember]
        [Name(Code = "811400", Name = "Housekeepers nfd")]
        Housekeepersnfd,
        [EnumMember]
        [Name(Code = "811411", Name = "Commercial Housekeeper")]
        CommercialHousekeeper,
        [EnumMember]
        [Name(Code = "811412", Name = "Domestic Housekeeper")]
        DomesticHousekeeper,
        [EnumMember]
        [Name(Code = "811500", Name = "Laundry Workers nfd")]
        LaundryWorkersnfd,
        [EnumMember]
        [Name(Code = "811511", Name = "Laundry Worker (General)")]
        LaundryWorkerGeneral,
        [EnumMember]
        [Name(Code = "811512", Name = "Drycleaner")]
        Drycleaner,
        [EnumMember]
        [Name(Code = "811513", Name = "Ironer or Presser")]
        IronerorPresser,
        [EnumMember]
        [Name(Code = "811600", Name = "Other Cleaners nfd")]
        OtherCleanersnfd,
        [EnumMember]
        [Name(Code = "811611", Name = "Carpet Cleaner")]
        CarpetCleaner,
        [EnumMember]
        [Name(Code = "811612", Name = "Window Cleaner")]
        WindowCleaner,
        [EnumMember]
        [Name(Code = "811699", Name = "Cleaners nec")]
        Cleanersnec,
        [EnumMember]
        [Name(Code = "821000", Name = "Construction and Mining Labourers nfd")]
        ConstructionandMiningLabourersnfd,
        [EnumMember]
        [Name(Code = "821100", Name = "Building and Plumbing Labourers nfd")]
        BuildingandPlumbingLabourersnfd,
        [EnumMember]
        [Name(Code = "821111", Name = "Builder's Labourer")]
        BuildersLabourer,
        [EnumMember]
        [Name(Code = "821112", Name = "Drainage, Sewerage and Stormwater Labourer")]
        DrainageSewerageandStormwaterLabourer,
        [EnumMember]
        [Name(Code = "821113", Name = "Earthmoving Labourer")]
        EarthmovingLabourer,
        [EnumMember]
        [Name(Code = "821114", Name = "Plumber's Assistant")]
        PlumbersAssistant,
        [EnumMember]
        [Name(Code = "821211", Name = "Concreter")]
        Concreter,
        [EnumMember]
        [Name(Code = "821311", Name = "Fencer")]
        Fencer,
        [EnumMember]
        [Name(Code = "821400", Name = "Insulation and Home Improvement Installers nfd")]
        InsulationandHomeImprovementInstallersnfd,
        [EnumMember]
        [Name(Code = "821411", Name = "Building Insulation Installer")]
        BuildingInsulationInstaller,
        [EnumMember]
        [Name(Code = "821412", Name = "Home Improvement Installer")]
        HomeImprovementInstaller,
        [EnumMember]
        [Name(Code = "821511", Name = "Paving and Surfacing Labourer")]
        PavingandSurfacingLabourer,
        [EnumMember]
        [Name(Code = "821611", Name = "Railway Track Worker")]
        RailwayTrackWorker,
        [EnumMember]
        [Name(Code = "821700", Name = "Structural Steel Construction Workers nfd")]
        StructuralSteelConstructionWorkersnfd,
        [EnumMember]
        [Name(Code = "821711", Name = "Construction Rigger")]
        ConstructionRigger,
        [EnumMember]
        [Name(Code = "821712", Name = "Scaffolder")]
        Scaffolder,
        [EnumMember]
        [Name(Code = "821713", Name = "Steel Fixer")]
        SteelFixer,
        [EnumMember]
        [Name(Code = "821714", Name = "Structural Steel Erector")]
        StructuralSteelErector,
        [EnumMember]
        [Name(Code = "821900", Name = "Other Construction and Mining Labourers nfd")]
        OtherConstructionandMiningLabourersnfd,
        [EnumMember]
        [Name(Code = "821911", Name = "Crane Chaser")]
        CraneChaser,
        [EnumMember]
        [Name(Code = "821912", Name = "Driller's Assistant")]
        DrillersAssistant,
        [EnumMember]
        [Name(Code = "821913", Name = "Lagger")]
        Lagger,
        [EnumMember]
        [Name(Code = "821914", Name = "Mining Support Worker")]
        MiningSupportWorker,
        [EnumMember]
        [Name(Code = "821915", Name = "Surveyor's Assistant")]
        SurveyorsAssistant,
        [EnumMember]
        [Name(Code = "830000", Name = "Factory Process Workers nfd")]
        FactoryProcessWorkersnfd,
        [EnumMember]
        [Name(Code = "831000", Name = "Food Process Workers nfd")]
        FoodProcessWorkersnfd,
        [EnumMember]
        [Name(Code = "831100", Name = "Food and Drink Factory Workers nfd")]
        FoodandDrinkFactoryWorkersnfd,
        [EnumMember]
        [Name(Code = "831111", Name = "Baking Factory Worker")]
        BakingFactoryWorker,
        [EnumMember]
        [Name(Code = "831112", Name = "Brewery Worker")]
        BreweryWorker,
        [EnumMember]
        [Name(Code = "831113", Name = "Confectionery Maker")]
        ConfectioneryMaker,
        [EnumMember]
        [Name(Code = "831114", Name = "Dairy Products Maker")]
        DairyProductsMaker,
        [EnumMember]
        [Name(Code = "831115", Name = "Fruit and Vegetable Factory Worker")]
        FruitandVegetableFactoryWorker,
        [EnumMember]
        [Name(Code = "831116", Name = "Grain Mill Worker")]
        GrainMillWorker,
        [EnumMember]
        [Name(Code = "831117", Name = "Sugar Mill Worker")]
        SugarMillWorker,
        [EnumMember]
        [Name(Code = "831118", Name = "Winery Cellar Hand")]
        WineryCellarHand,
        [EnumMember]
        [Name(Code = "831199", Name = "Food and Drink Factory Workers nec")]
        FoodandDrinkFactoryWorkersnec,
        [EnumMember]
        [Name(Code = "831200", Name = "Meat Boners and Slicers, and Slaughterers nfd")]
        MeatBonersandSlicersandSlaughterersnfd,
        [EnumMember]
        [Name(Code = "831211", Name = "Meat Boner and Slicer")]
        MeatBonerandSlicer,
        [EnumMember]
        [Name(Code = "831212", Name = "Slaughterer")]
        Slaughterer,
        [EnumMember]
        [Name(Code = "831300", Name = "Meat, Poultry and Seafood Process Workers nfd")]
        MeatPoultryandSeafoodProcessWorkersnfd,
        [EnumMember]
        [Name(Code = "831311", Name = "Meat Process Worker")]
        MeatProcessWorker,
        [EnumMember]
        [Name(Code = "831312", Name = "Poultry Process Worker")]
        PoultryProcessWorker,
        [EnumMember]
        [Name(Code = "831313", Name = "Seafood Process Worker")]
        SeafoodProcessWorker,
        [EnumMember]
        [Name(Code = "832000", Name = "Packers and Product Assemblers nfd")]
        PackersandProductAssemblersnfd,
        [EnumMember]
        [Name(Code = "832100", Name = "Packers nfd")]
        Packersnfd,
        [EnumMember]
        [Name(Code = "832111", Name = "Chocolate Packer")]
        ChocolatePacker,
        [EnumMember]
        [Name(Code = "832112", Name = "Container Filler")]
        ContainerFiller,
        [EnumMember]
        [Name(Code = "832113", Name = "Fruit and Vegetable Packer")]
        FruitandVegetablePacker,
        [EnumMember]
        [Name(Code = "832114", Name = "Meat Packer")]
        MeatPacker,
        [EnumMember]
        [Name(Code = "832115", Name = "Seafood Packer")]
        SeafoodPacker,
        [EnumMember]
        [Name(Code = "832199", Name = "Packers nec")]
        Packersnec,
        [EnumMember]
        [Name(Code = "832211", Name = "Product Assembler")]
        ProductAssembler,
        [EnumMember]
        [Name(Code = "839000", Name = "Miscellaneous Factory Process Workers nfd")]
        MiscellaneousFactoryProcessWorkersnfd,
        [EnumMember]
        [Name(Code = "839111", Name = "Metal Engineering Process Worker")]
        MetalEngineeringProcessWorker,
        [EnumMember]
        [Name(Code = "839200", Name = "Plastics and Rubber Factory Workers nfd")]
        PlasticsandRubberFactoryWorkersnfd,
        [EnumMember]
        [Name(Code = "839211", Name = "Plastics Factory Worker")]
        PlasticsFactoryWorker,
        [EnumMember]
        [Name(Code = "839212", Name = "Rubber Factory Worker")]
        RubberFactoryWorker,
        [EnumMember]
        [Name(Code = "839300", Name = "Product Quality Controllers nfd")]
        ProductQualityControllersnfd,
        [EnumMember]
        [Name(Code = "839311", Name = "Product Examiner")]
        ProductExaminer,
        [EnumMember]
        [Name(Code = "839312", Name = "Product Grader")]
        ProductGrader,
        [EnumMember]
        [Name(Code = "839313", Name = "Product Tester")]
        ProductTester,
        [EnumMember]
        [Name(Code = "839400", Name = "Timber and Wood Process Workers nfd")]
        TimberandWoodProcessWorkersnfd,
        [EnumMember]
        [Name(Code = "839411", Name = "Paper and Pulp Mill Worker")]
        PaperandPulpMillWorker,
        [EnumMember]
        [Name(Code = "839412", Name = "Sawmill or Timber Yard Worker")]
        SawmillorTimberYardWorker,
        [EnumMember]
        [Name(Code = "839413", Name = "Wood and Wood Products Factory Worker")]
        WoodandWoodProductsFactoryWorker,
        [EnumMember]
        [Name(Code = "839900", Name = "Other Factory Process Workers nfd")]
        OtherFactoryProcessWorkersnfd,
        [EnumMember]
        [Name(Code = "839911", Name = "Cement and Concrete Plant Worker")]
        CementandConcretePlantWorker,
        [EnumMember]
        [Name(Code = "839912", Name = "Chemical Plant Worker")]
        ChemicalPlantWorker,
        [EnumMember]
        [Name(Code = "839913", Name = "Clay Processing Factory Worker")]
        ClayProcessingFactoryWorker,
        [EnumMember]
        [Name(Code = "839914", Name = "Fabric and Textile Factory Worker")]
        FabricandTextileFactoryWorker,
        [EnumMember]
        [Name(Code = "839915", Name = "Footwear Factory Worker")]
        FootwearFactoryWorker,
        [EnumMember]
        [Name(Code = "839916", Name = "Glass Processing Worker")]
        GlassProcessingWorker,
        [EnumMember]
        [Name(Code = "839917", Name = "Hide and Skin Processing Worker")]
        HideandSkinProcessingWorker,
        [EnumMember]
        [Name(Code = "839918", Name = "Recycling Worker")]
        RecyclingWorker,
        [EnumMember]
        [Name(Code = "839999", Name = "Factory Process Workers nec")]
        FactoryProcessWorkersnec,
        [EnumMember]
        [Name(Code = "841000", Name = "Farm, Forestry and Garden Workers nfd")]
        FarmForestryandGardenWorkersnfd,
        [EnumMember]
        [Name(Code = "841111", Name = "Aquaculture Worker")]
        AquacultureWorker,
        [EnumMember]
        [Name(Code = "841200", Name = "Crop Farm Workers nfd")]
        CropFarmWorkersnfd,
        [EnumMember]
        [Name(Code = "841211", Name = "Fruit or Nut Farm Worker")]
        FruitorNutFarmWorker,
        [EnumMember]
        [Name(Code = "841212", Name = "Fruit or Nut Picker")]
        FruitorNutPicker,
        [EnumMember]
        [Name(Code = "841213", Name = "Grain, Oilseed or Pasture Farm Worker")]
        GrainOilseedorPastureFarmWorker,
        [EnumMember]
        [Name(Code = "841214", Name = "Vegetable Farm Worker")]
        VegetableFarmWorker,
        [EnumMember]
        [Name(Code = "841215", Name = "Vegetable Picker")]
        VegetablePicker,
        [EnumMember]
        [Name(Code = "841216", Name = "Vineyard Worker")]
        VineyardWorker,
        [EnumMember]
        [Name(Code = "841217", Name = "Mushroom Picker")]
        MushroomPicker,
        [EnumMember]
        [Name(Code = "841299", Name = "Crop Farm Workers nec")]
        CropFarmWorkersnec,
        [EnumMember]
        [Name(Code = "841300", Name = "Forestry and Logging Workers nfd")]
        ForestryandLoggingWorkersnfd,
        [EnumMember]
        [Name(Code = "841311", Name = "Forestry Worker")]
        ForestryWorker,
        [EnumMember]
        [Name(Code = "841312", Name = "Logging Assistant")]
        LoggingAssistant,
        [EnumMember]
        [Name(Code = "841313", Name = "Tree Faller")]
        TreeFaller,
        [EnumMember]
        [Name(Code = "841400", Name = "Garden and Nursery Labourers nfd")]
        GardenandNurseryLabourersnfd,
        [EnumMember]
        [Name(Code = "841411", Name = "Garden Labourer")]
        GardenLabourer,
        [EnumMember]
        [Name(Code = "841412", Name = "Horticultural Nursery Assistant")]
        HorticulturalNurseryAssistant,
        [EnumMember]
        [Name(Code = "841500", Name = "Livestock Farm Workers nfd")]
        LivestockFarmWorkersnfd,
        [EnumMember]
        [Name(Code = "841511", Name = "Beef Cattle Farm Worker")]
        BeefCattleFarmWorker,
        [EnumMember]
        [Name(Code = "841512", Name = "Dairy Cattle Farm Worker")]
        DairyCattleFarmWorker,
        [EnumMember]
        [Name(Code = "841513", Name = "Mixed Livestock Farm Worker")]
        MixedLivestockFarmWorker,
        [EnumMember]
        [Name(Code = "841514", Name = "Poultry Farm Worker")]
        PoultryFarmWorker,
        [EnumMember]
        [Name(Code = "841515", Name = "Sheep Farm Worker")]
        SheepFarmWorker,
        [EnumMember]
        [Name(Code = "841516", Name = "Stablehand")]
        Stablehand,
        [EnumMember]
        [Name(Code = "841517", Name = "Wool Handler")]
        WoolHandler,
        [EnumMember]
        [Name(Code = "841599", Name = "Livestock Farm Workers nec")]
        LivestockFarmWorkersnec,
        [EnumMember]
        [Name(Code = "841611", Name = "Mixed Crop and Livestock Farm Worker")]
        MixedCropandLivestockFarmWorker,
        [EnumMember]
        [Name(Code = "841900", Name = "Other Farm, Forestry and Garden Workers nfd")]
        OtherFarmForestryandGardenWorkersnfd,
        [EnumMember]
        [Name(Code = "841911", Name = "Hunter-Trapper")]
        HunterTrapper,
        [EnumMember]
        [Name(Code = "841913", Name = "Pest Controller")]
        PestController,
        [EnumMember]
        [Name(Code = "841999", Name = "Farm, Forestry and Garden Workers nec")]
        FarmForestryandGardenWorkersnec,
        [EnumMember]
        [Name(Code = "851000", Name = "Food Preparation Assistants nfd")]
        FoodPreparationAssistantsnfd,
        [EnumMember]
        [Name(Code = "851111", Name = "Fast Food Cook")]
        FastFoodCook,
        [EnumMember]
        [Name(Code = "851200", Name = "Food Trades Assistants nfd")]
        FoodTradesAssistantsnfd,
        [EnumMember]
        [Name(Code = "851211", Name = "Pastrycook's Assistant")]
        PastrycooksAssistant,
        [EnumMember]
        [Name(Code = "851299", Name = "Food Trades Assistants nec")]
        FoodTradesAssistantsnec,
        [EnumMember]
        [Name(Code = "851311", Name = "Kitchenhand")]
        Kitchenhand,
        [EnumMember]
        [Name(Code = "890000", Name = "Other Labourers nfd")]
        OtherLabourersnfd,
        [EnumMember]
        [Name(Code = "891000", Name = "Freight Handlers and Shelf Fillers nfd")]
        FreightHandlersandShelfFillersnfd,
        [EnumMember]
        [Name(Code = "891100", Name = "Freight and Furniture Handlers nfd")]
        FreightandFurnitureHandlersnfd,
        [EnumMember]
        [Name(Code = "891111", Name = "Freight Handler (Rail or Road)")]
        FreightHandlerRailOrRoad,
        [EnumMember]
        [Name(Code = "891112", Name = "Truck Driver's Offsider")]
        TruckDriversOffsider,
        [EnumMember]
        [Name(Code = "891113", Name = "Waterside Worker")]
        WatersideWorker,
        [EnumMember]
        [Name(Code = "891211", Name = "Shelf Filler")]
        ShelfFiller,
        [EnumMember]
        [Name(Code = "899000", Name = "Miscellaneous Labourers nfd")]
        MiscellaneousLabourersnfd,
        [EnumMember]
        [Name(Code = "899111", Name = "Caretaker")]
        Caretaker,
        [EnumMember]
        [Name(Code = "899200", Name = "Deck and Fishing Hands nfd")]
        DeckandFishingHandsnfd,
        [EnumMember]
        [Name(Code = "899211", Name = "Deck Hand")]
        DeckHand,
        [EnumMember]
        [Name(Code = "899212", Name = "Fishing Hand")]
        FishingHand,
        [EnumMember]
        [Name(Code = "899311", Name = "Handyperson")]
        Handyperson,
        [EnumMember]
        [Name(Code = "899400", Name = "Motor Vehicle Parts and Accessories Fitters nfd")]
        MotorVehiclePartsandAccessoriesFittersnfd,
        [EnumMember]
        [Name(Code = "899411", Name = "Motor Vehicle Parts and Accessories Fitter (General)")]
        MotorVehiclePartsandAccessoriesFitterGeneral,
        [EnumMember]
        [Name(Code = "899412", Name = "Autoglazier")]
        Autoglazier,
        [EnumMember]
        [Name(Code = "899413", Name = "Exhaust and Muffler Repairer")]
        ExhaustandMufflerRepairer,
        [EnumMember]
        [Name(Code = "899414", Name = "Radiator Repairer")]
        RadiatorRepairer,
        [EnumMember]
        [Name(Code = "899415", Name = "Tyre Fitter")]
        TyreFitter,
        [EnumMember]
        [Name(Code = "899500", Name = "Printing Assistants and Table Workers nfd")]
        PrintingAssistantsandTableWorkersnfd,
        [EnumMember]
        [Name(Code = "899511", Name = "Printer's Assistant")]
        PrintersAssistant,
        [EnumMember]
        [Name(Code = "899512", Name = "Printing Table Worker")]
        PrintingTableWorker,
        [EnumMember]
        [Name(Code = "899611", Name = "Recycling or Rubbish Collector")]
        RecyclingorRubbishCollector,
        [EnumMember]
        [Name(Code = "899711", Name = "Vending Machine Attendant")]
        VendingMachineAttendant,
        [EnumMember]
        [Name(Code = "899900", Name = "Other Miscellaneous Labourers nfd")]
        OtherMiscellaneousLabourersnfd,
        [EnumMember]
        [Name(Code = "899911", Name = "Bicycle Mechanic")]
        BicycleMechanic,
        [EnumMember]
        [Name(Code = "899912", Name = "Car Park Attendant")]
        CarParkAttendant,
        [EnumMember]
        [Name(Code = "899913", Name = "Crossing Supervisor")]
        CrossingSupervisor,
        [EnumMember]
        [Name(Code = "899914", Name = "Electrical or Telecommunications Trades Assistant")]
        ElectricalorTelecommunicationsTradesAssistant,
        [EnumMember]
        [Name(Code = "899915", Name = "Leaflet or Newspaper Deliverer")]
        LeafletorNewspaperDeliverer,
        [EnumMember]
        [Name(Code = "899916", Name = "Mechanic's Assistant")]
        MechanicsAssistant,
        [EnumMember]
        [Name(Code = "899917", Name = "Railways Assistant")]
        RailwaysAssistant,
        [EnumMember]
        [Name(Code = "899918", Name = "Sign Erector")]
        SignErector,
        [EnumMember]
        [Name(Code = "899921", Name = "Ticket Collector or Usher")]
        TicketCollectororUsher,
        [EnumMember]
        [Name(Code = "899922", Name = "Trolley Collector")]
        TrolleyCollector,
        [EnumMember]
        [Name(Code = "899923", Name = "Road Traffic Controller")]
        RoadTrafficController,
        [EnumMember]
        [Name(Code = "899999", Name = "Labourers nec")]
        Labourersnec,
    }
}
