﻿using System;
using System.Runtime.Serialization;
using Nehta.VendorLibrary.CDA.Common;

namespace CDA.Generator.Common.SCSModel.CeHR.Enum
  {
    /// <summary>
    /// Assesment
    /// </summary>
    [Serializable]
    [DataContract]
     public enum HealthCheckAssessmentQuestion
    {
      [EnumMember]
      [Name(Code = "0162", Name = "Head Circumference", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionData")]
      HeadCircumference,

      [EnumMember]
      [Name(Code = "0163", Name = "Body Height", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionData")]
      BodyHeight,

      [EnumMember]
      [Name(Code = "0162", Name = "Body Weight", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionData")]
      BodyWeight,

      [EnumMember]
      [Name(Code = "0151", Name = "Body mass index (BMI)", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionData")]
      BodyMassIndex,

      [EnumMember]
      [Name(Code = "0143", Name = "Eyes: Observation", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionData")]
      EyesObservation,

      [EnumMember]
      [Name(Code = "0144", Name = "Eyes: Fixation", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionData")]
      EyesFixation,

      [EnumMember]
      [Name(Code = "0145", Name = "Eyes: Corneal reflexes", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionData")]
      EyesCornealReflexes,

      [EnumMember]
      [Name(Code = "0146", Name = "Eyes: Response to each eye being covered separately", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionData")]
      EyesResponseToEachEyeBeingCoveredSeparately,

      [EnumMember]
      [Name(Code = "0148", Name = "Eyes: Ocular movements", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionData")]
      EyesOcularMovements,

      [EnumMember]
      [Name(Code = "0149", Name = "Oral health 'Lift the lip' check", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionData")]
      OralHealthLiftTheLipCheck,

      [EnumMember]
      [Name(Code = "0131", Name = "Parent questions completed?", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionData")]
      ParentQuestionsCompleted,

      [EnumMember]
      [Name(Code = "0147", Name = "Age appropriate immunisation completed as per schedule?", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionData")]
      AgeAppropriateImmunisationCompletedAsPerSchedule,

      [EnumMember]
      [Name(Code = "0133", Name = "Are there any risk factors: Hearing", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionData")]
      gAreThereAnyRiskFactorsHearing,

      [EnumMember]
      [Name(Code = "0134", Name = "Are there any risk factors: Vision", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionData")]
      AreThereAnyRiskFactorsVision,

      [EnumMember]
      [Name(Code = "0136", Name = "Are there any risk factors: Oral Health", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionData")]
      AreThereAnyRiskFactorsOralHealth,

      [EnumMember]
      [Name(Code = "0015", Name = "Outcome", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionData")]
      Outcome,

      [EnumMember]
      [Name(Code = "0137", Name = "Appropriate health information discussed?", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionData")]
      AppropriateHealthInformationDiscussed,

      [EnumMember]
      [Name(Code = "0138", Name = "Comments", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionData")]
      Comments,

      [EnumMember]
      [Name(Code = "0139", Name = "Action taken", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionData")]
      ActionTaken,

      [EnumMember]
      [Name(Code = "0140", Name = "Name of doctor or nurse", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionData")]
      NameOfDoctorOrNurse,

      [EnumMember]
      [Name(Code = "0141", Name = "Venue", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionData")]
      Venue,

      [EnumMember]
      [Name(Code = "0142", Name = "Date of check", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionData")]
      DateOfCheck,
    }
  }

