﻿using System;
using System.Runtime.Serialization;
 namespace Nehta.VendorLibrary.CDA.Common.Enums
  {
    /// <summary>
    /// View Record Sections
    /// </summary>
    [Serializable]
    [DataContract]
    public enum PrescribingAndDispensingViewRecordSections
    {
      [EnumMember]
      [Name(Code = "102.16134.179.1.1", Name = "Exclusion Statement", CodeSystem = "NCTIS")]
      ExclusionStatement,

      [EnumMember]
      [Name(Code = "101.16794", Name = "Prescribing and Dispensing Reports", CodeSystem = "NCTIS")]
      PrescribingAndDispensingReports,

      [EnumMember]
      [Name(Code = "101.16795", Name = "MEDICATION ENTRIES WITH SUMMARY", CodeSystem = "NCTIS")]
      MedicationEntriesWithSummary,

      [EnumMember]
      [Name(Code = "102.16798", Name = "SUMMARY OF MEDICATION ENTRIES", CodeSystem = "NCTIS")]
      SummaryOfMedicationEntries,

      [EnumMember]
      [Name(Code = "103.10194", Name = "Therapeutic Good Identification", CodeSystem = "NCTIS")]
      TherapeuticGoodIdentification,

      [EnumMember]
      [Name(Code = "103.16799", Name = "DateTime Prescription Written", CodeSystem = "NCTIS")]
      DateTimePrescriptionWritten,

      [EnumMember]
      [Name(Code = "103.16801", Name = "DateTime of Earliest Dispense Event", CodeSystem = "NCTIS")]
      DateTimeOfEarliestDispenseEvent,

      [EnumMember]
      [Name(Code = "103.16802", Name = "DateTime of Latest Dispense Event", CodeSystem = "NCTIS")]
      DateTimeOfLatestDispenseEvent,

      [EnumMember]
      [Name(Code = "103.16804", Name = "Total Number of Known Supplies", CodeSystem = "NCTIS")]
      TotalNumberOfKnownSupplies,

      [EnumMember]
      [Name(Code = "103.16805", Name = "Maximum Number of Permitted Supplies", CodeSystem = "NCTIS")]
      MaximumNumberOfPermittedSupplies,

      [EnumMember]
      [Name(Code = "102.16692.179.1.1", Name = "Dispense Record Link", CodeSystem = "NCTIS")]
      DispenseRecordLink,

      [EnumMember]
      [Name(Code = "102.16692.179.1.2", Name = "Prescription Record Link", CodeSystem = "NCTIS")]
      PrescriptionRecordLink,

    }
  }
