﻿/*
 * Copyright 2011 NEHTA
 *
 * Licensed under the NEHTA Open Source (Apache) License; you may not use this
 * file except in compliance with the License. A copy of the License is in the
 * 'license.txt' file, which should be provided with this work.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

using Nehta.VendorLibrary.CDA.Common;

namespace Nehta.VendorLibrary.CDA.Generator.Enums
{
    /// <summary>
    /// CDA Document Type
    /// </summary>
    public enum CDADocumentType
    {
        /// <summary>
        /// Undefined, this is the default value if the enum is left unset.
        /// 
        /// The validation engine uses this to test and assert that the enum has been set (if required)
        /// and is therefore valid.
        /// </summary>

      /// <summary>
      /// Patient Summary
      /// </summary>
      [Name(Name = "Patient Summary", CodeSystem = "LOINC", Code = "60591-5", Identifier = "1.2.36.1.2001.1001.101.100.1002.120", Version = "1.3", Title = "Shared Health Summary")]
      SharedHeathSummary,

      /// <summary>
      /// Discharge Summarization Notes
      /// </summary>
      [Name(Name = "Discharge Summarization Note", CodeSystem = "LOINC", Code = "18842-5", Identifier = "1.2.36.1.2001.1001.101.100.1002.4", Version = "3.4", Title = "Discharge Summary")]
      DischargeSummary,

      /// <summary>
      /// SpecialistLetter
      /// </summary>
      [Name(Name = "Letter", CodeSystem = "LOINC", Code = "51852-2", Identifier = "1.2.36.1.2001.1001.101.100.1002.132", Version = "1.3", Title = "Specialist Letter")]
      SpecialistLetter,

      /// <summary>
      /// e-Referral
      /// </summary>
      [Name(Name = "Referral Note", CodeSystem = "LOINC", Code = "57133-1", Identifier = "1.2.36.1.2001.1001.101.100.1002.2", Version = "2.2", Title = "e-Referral")]
      EReferral,

      /// <summary>
      /// EventSummary
      /// </summary>
      [Name(Name = "Summarization of episode note", CodeSystem = "LOINC", Code = "34133-9", Identifier = "1.2.36.1.2001.1001.101.100.1002.136", Version = "1.2", Title = "Event Summary")]
      EventSummary,


      /// <summary>
      /// Medicare DVA Benefits Report
      /// </summary>
      [Name(Name = "Medicare/DVA Benefits Report", CodeSystem = "NCTIS", Code = "100.16644", Identifier = "1.2.36.1.2001.1001.101.100.1002.140", Version = "1.1", Title = "Medicare/DVA Benefits Report")]
      MedicareDvaBenefitsReport,

      /// <summary>
      /// Australian Organ Donor Register
      /// </summary>
      [Name(Name = "Australian Organ Donor Register", CodeSystem = "NCTIS", Code = "100.16671", Identifier = "1.2.36.1.2001.1001.101.100.1002.147", Version = "1.1", Title = "Australian Organ Donor Register")]
      AustralianOrganDonorRegister,

      /// <summary>
      /// Australian Childhood Immunisation Register
      /// </summary>
      [Name(Name = "Australian Childhood Immunisation Register", CodeSystem = "NCTIS", Code = "100.16659", Identifier = "1.2.36.1.2001.1001.101.100.1002.144", Version = "1.1", Title = "Australian Childhood Immunisation Register")]
      AustralianChildhoodImmunisationRegister,

      /// <summary>
      /// Pharmaceutical Benefits Report
      /// </summary>
      [Name(Name = "Pharmaceutical Benefits Report", CodeSystem = "NCTIS", Code = "100.16650", Identifier = "1.2.36.1.2001.1001.101.100.1002.142", Version = "1.1", Title = "Pharmaceutical Benefits Report")]
      PharmaceuticalBenefitsReport,

      /// <summary>
      /// Advance Care Directive Custodian Record
      /// </summary>
      [Name(Name = "Advance Care Directive Custodian Record", CodeSystem = "NCTIS", Code = "100.16696", Identifier = "1.2.36.1.2001.1001.101.100.1002.156", Version = "1.0", Title = "Advance Care Directive Custodian Record")]
      AdvanceCareDirectiveCustodianRecord,

      /// <summary>
      /// Consumer Entered Health Summary
      /// </summary>
      [Name(Name = "Consumer Entered Health Summary", CodeSystem = "NCTIS", Code = "100.16685", Identifier = "1.2.36.1.2001.1001.101.100.1002.153", Version = "1.0", Title = "Consumer Entered Health Summary")]
      ConsumerEnteredHealthSummary,

      /// <summary>
      /// Consumer Entered Notes
      /// </summary>
      [Name(Name = "Consumer Entered Notes", CodeSystem = "NCTIS", Code = "100.16681", Identifier = "1.2.36.1.2001.1001.101.100.1002.151", Version = "1.0", Title = "Consumer Entered Notes")]
      ConsumerEnteredNotes,

      /// <summary>
      /// Consolidated View
      /// </summary>
      [Name(Name = "Consolidated View", CodeSystem = "NCTIS", Code = "100.16725", Identifier = "1.2.36.1.2001.1001.100.1002.160", Version = "1.0", Title = "Consolidated View")]
      ConsolidatedView,

      /// <summary>
      /// Medicare View
      /// </summary>
      [Name(Name = "Medicare Information View", CodeSystem = "NCTIS", Code = "100.16767", Identifier = "1.2.36.1.2001.1001.100.1002.172", Version = "1.0", Title = "Medicare Overview")]
      MedicareInformationView,

      /// <summary>
      /// PCEHR Prescription Record
      /// </summary>
      [Name(Name = "PCEHR Prescription Record", CodeSystem = "NCTIS", Code = "100.16764", Identifier = "1.2.36.1.2001.1001.100.1002.170", Version = "1.0", Title = "PCEHR Prescription Record")]
      PrescriptionRecord,

      /// <summary>
      /// PCEHR Dispense Record
      /// </summary>
      [Name(Name = "PCEHR Dispense Record", CodeSystem = "NCTIS", Code = "100.16765", Identifier = "1.2.36.1.2001.1001.100.1002.171", Version = "1.0", Title = "PCEHR Dispense Record")]
      DispenseRecord,
    }
}
