﻿/*
 * Copyright 2011 NEHTA
 *
 * Licensed under the NEHTA Open Source (Apache) License; you may not use this
 * file except in compliance with the License. A copy of the License is in the
 * 'license.txt' file, which should be provided with this work.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using JetBrains.Annotations;
using Nehta.VendorLibrary.CDA.Common;
using Nehta.VendorLibrary.CDA.Generator.Enums;
using Nehta.VendorLibrary.Common;

namespace Nehta.VendorLibrary.CDA.SCSModel.Common
{
    /// <summary>
    /// This class is designed to encapsulate the properties within a CDA document that make up 
    /// an body height
    /// </summary>
    [Serializable]
    [DataContract]
    [OID(OID = "1.2.36.1.2001.1001.101.102.16123", Identifier = "DG-16123")]
    public class BodyHeight
    {
        #region Properties

        /// <summary>
        /// UnitOfMeasure
        /// </summary>
        [CanBeNull]
        [DataMember]
        public String UnitOfMeasure { get; set; }

        /// <summary>
        /// Height
        /// </summary>
        [CanBeNull]
        [DataMember]
        [OID(OID = "1.2.36.1.2001.1001.101.103.16120", Identifier = "DE-16120")]
        public double? Height { get; set; }

        /// <summary>
        /// Date / Time that the height was recorded
        /// </summary>
        [CanBeNull]
        [DataMember]
        [OID(OID = "1.2.36.1.2001.1001.101.103.15561", Identifier = "DE-15561")]
        public ISO8601DateTime BodyHeightObservationTime { get; set; }
        #endregion

        #region Constructors
        internal BodyHeight()
        {
        }
        #endregion

        #region Validation
        /// <summary>
        /// Validates this entitlement
        /// </summary>
        /// <param name="path">The path to this object as a string</param>
        /// <param name="messages">the validation messages to date, these may be added to within this method</param>
        public void Validate(string path, List<ValidationMessage> messages)
        {
            var vb = new ValidationBuilder(path, messages);

            vb.ArgumentRequiredCheck("UnitOfMeasure", UnitOfMeasure);
            vb.ArgumentRequiredCheck("Height", Height);
            vb.ArgumentRequiredCheck("BodyHeightObservationTime", BodyHeightObservationTime);
        }

        #endregion
    }
}
