﻿/*
 * Copyright 2011 NEHTA
 *
 * Licensed under the NEHTA Open Source (Apache) License; you may not use this
 * file except in compliance with the License. A copy of the License is in the
 * 'license.txt' file, which should be provided with this work.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using JetBrains.Annotations;
using Nehta.VendorLibrary.Common;
using Nehta.VendorLibrary.CDA.SCSModel.DischargeSummary;
using Nehta.VendorLibrary.CDA.SCSModel.Common;

namespace Nehta.VendorLibrary.CDA.SCSModel.DischargeSummary.Interfaces
{
    /// <summary>
    /// This class is designed to encapsulate the properties within a CDA document that make up 
    /// a IDischargeSummaryProblemDiagnosis
    /// </summary>
    public interface IDischargeSummaryProblemDiagnosis
    {
        #region Properties
        /// <summary>
        /// Problem Diagnosis Type
        /// </summary>
        [CanBeNull]
        ICodableText ProblemDiagnosisType { get; set; }

        /// <summary>
        /// Problem Diagnosis Description
        /// </summary>
        [CanBeNull]
        ICodableText ProblemDiagnosisDescription { get; set; }

        #endregion

        #region Validation
        /// <summary>
        /// Validates this IDischargeSummaryProblemDiagnosis
        /// </summary>
        /// <param name="path">The path to this object as a string</param>
        /// <param name="messages">the validation messages to date, these may be added to within this method</param>
        void Validate(string path, List<ValidationMessage> messages);

        #endregion
    }
}
