/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wscompile;

import com.sun.istack.tools.ParallelWorldClassLoader;
import com.sun.tools.ws.processor.util.DirectoryUtil;
import com.sun.tools.ws.resources.WscompileMessages;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wscompile.JavaCompilerHelper;
import com.sun.tools.ws.wscompile.Options;
import com.sun.tools.ws.wscompile.WsimportListener;
import com.sun.tools.ws.wscompile.WsimportOptions;
import com.sun.xml.ws.api.server.Container;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.xml.bind.JAXBPermission;
import javax.xml.ws.EndpointContext;
import org.xml.sax.EntityResolver;

public class WsimportTool {
    private static final String WSIMPORT = "wsimport";
    private final PrintStream out;
    private final Container container;
    private final WsimportOptions options = new WsimportOptions();

    public WsimportTool(OutputStream out) {
        this(out, null);
    }

    public WsimportTool(OutputStream logStream, Container container) {
        this.out = logStream instanceof PrintStream ? (PrintStream)logStream : new PrintStream(logStream);
        this.container = container;
    }

    /*
     * Exception decompiling
     */
    public boolean run(String[] args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteGeneratedFiles() {
        HashSet<File> trackedRootPackages = new HashSet<File>();
        if (this.options.clientjar != null) {
            Iterable<File> generatedFiles;
            Iterable<File> iterable = generatedFiles = this.options.getGeneratedFiles();
            synchronized (iterable) {
                for (File file : generatedFiles) {
                    if (file.getName().endsWith(".java")) continue;
                    file.delete();
                    trackedRootPackages.add(file.getParentFile());
                }
            }
            for (File pkg : trackedRootPackages) {
                while (pkg.list() != null && pkg.list().length == 0 && !pkg.equals(this.options.destDir)) {
                    File parentPkg = pkg.getParentFile();
                    pkg.delete();
                    pkg = parentPkg;
                }
            }
        }
        if (!this.options.keep) {
            this.options.removeGeneratedFiles();
        }
    }

    private void addClassesToGeneratedFiles() throws IOException {
        Iterable<File> generatedFiles = this.options.getGeneratedFiles();
        final ArrayList trackedClassFiles = new ArrayList();
        for (File f : generatedFiles) {
            if (!f.getName().endsWith(".java")) continue;
            String relativeDir = DirectoryUtil.getRelativePathfromCommonBase(f.getParentFile(), this.options.sourceDir);
            final String className = f.getName().substring(0, f.getName().indexOf(".java"));
            File classDir = new File(this.options.destDir, relativeDir);
            if (!classDir.exists()) continue;
            classDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    if (name.equals(className + ".class") || name.startsWith(className + "$") && name.endsWith(".class")) {
                        trackedClassFiles.add(new File(dir, name));
                        return true;
                    }
                    return false;
                }
            });
        }
        for (File f : trackedClassFiles) {
            this.options.addGeneratedFile(f);
        }
    }

    private void jarArtifacts(WsimportListener listener) throws IOException {
        File zipFile = new File(this.options.clientjar);
        if (!zipFile.isAbsolute()) {
            zipFile = new File(this.options.destDir, this.options.clientjar);
        }
        if (zipFile.exists()) {
            // empty if block
        }
        FileOutputStream fos = null;
        if (!this.options.quiet) {
            listener.message(WscompileMessages.WSIMPORT_ARCHIVING_ARTIFACTS(zipFile));
        }
        fos = new FileOutputStream(zipFile);
        JarOutputStream jos = new JarOutputStream(fos);
        String base = this.options.destDir.getCanonicalPath();
        for (File f : this.options.getGeneratedFiles()) {
            int bytesRead;
            if (f.getName().endsWith(".java")) continue;
            if (this.options.verbose) {
                listener.message(WscompileMessages.WSIMPORT_ARCHIVE_ARTIFACT(f, this.options.clientjar));
            }
            String entry = f.getCanonicalPath().substring(base.length() + 1);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
            JarEntry jarEntry = new JarEntry(entry);
            jos.putNextEntry(jarEntry);
            byte[] buffer = new byte[1024];
            while ((bytesRead = bis.read(buffer)) != -1) {
                jos.write(buffer, 0, bytesRead);
            }
            bis.close();
        }
        jos.close();
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.options.entityResolver = resolver;
    }

    private static boolean useBootClasspath(Class clazz) {
        try {
            ParallelWorldClassLoader.toJarUrl(clazz.getResource('/' + clazz.getName().replace('.', '/') + ".class"));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean compileGeneratedClasses(ErrorReceiver receiver, WsimportListener listener) {
        ArrayList<String> sourceFiles = new ArrayList<String>();
        for (File f : this.options.getGeneratedFiles()) {
            if (!f.exists() || !f.getName().endsWith(".java")) continue;
            sourceFiles.add(f.getAbsolutePath());
        }
        if (sourceFiles.size() > 0) {
            String classDir = this.options.destDir.getAbsolutePath();
            String classpathString = this.createClasspathString();
            boolean bootCP = WsimportTool.useBootClasspath(EndpointContext.class) || WsimportTool.useBootClasspath(JAXBPermission.class);
            String[] args = new String[4 + (bootCP ? 1 : 0) + (this.options.debug ? 1 : 0) + sourceFiles.size()];
            args[0] = "-d";
            args[1] = classDir;
            args[2] = "-classpath";
            args[3] = classpathString;
            int baseIndex = 4;
            if (bootCP) {
                args[baseIndex++] = "-Xbootclasspath/p:" + JavaCompilerHelper.getJarFile(EndpointContext.class) + File.pathSeparator + JavaCompilerHelper.getJarFile(JAXBPermission.class);
            }
            if (this.options.debug) {
                args[baseIndex++] = "-g";
            }
            for (int i = 0; i < sourceFiles.size(); ++i) {
                args[baseIndex + i] = (String)sourceFiles.get(i);
            }
            listener.message(WscompileMessages.WSIMPORT_COMPILING_CODE());
            if (this.options.verbose) {
                StringBuffer argstr = new StringBuffer();
                for (String arg : args) {
                    argstr.append(arg).append(" ");
                }
                listener.message("javac " + argstr.toString());
            }
            return JavaCompilerHelper.compile(args, this.out, receiver);
        }
        return true;
    }

    private String createClasspathString() {
        String classpathStr = System.getProperty("java.class.path");
        for (String s : this.options.cmdlineJars) {
            classpathStr = classpathStr + File.pathSeparator + new File(s);
        }
        return classpathStr;
    }

    protected void usage(Options options) {
        System.out.println(WscompileMessages.WSIMPORT_HELP(WSIMPORT));
        System.out.println(WscompileMessages.WSIMPORT_USAGE_EXTENSIONS());
        System.out.println(WscompileMessages.WSIMPORT_USAGE_EXAMPLES());
    }
}

