/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.xsp.impl.v1;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.common.utils.DomUtils;
import au.gov.nehta.xsp.CertificateVerificationException;
import au.gov.nehta.xsp.CertificateVerifier;
import au.gov.nehta.xsp.SignatureValidationException;
import au.gov.nehta.xsp.XmlSignatureProfileService;
import au.gov.nehta.xsp.XspException;
import au.gov.nehta.xsp.impl.CertificateUtils;
import au.gov.nehta.xsp.impl.TextUtils;
import java.io.ByteArrayInputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.security.auth.x500.X500PrivateCredential;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlSignatureProfileServiceImpl
implements XmlSignatureProfileService {
    private static final String XML_ID_LOCAL_NAME = "id";
    private static final String XML_ID_QNAME = "xml:id";
    private static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static final List<String> ID_ATTR_TAGS = Arrays.asList("id", "Id", "ID");
    private static final XMLSignatureFactory XML_SIGNATURE_FACTORY = XMLSignatureFactory.getInstance("DOM");
    private static final KeyInfoFactory KEY_INFO_FACTORY = XML_SIGNATURE_FACTORY.getKeyInfoFactory();

    @Override
    public void sign(Element elementToAddSigTo, Element elementToSign, X500PrivateCredential credential) throws XspException {
        ArgumentUtils.checkNotNull((Object)elementToSign, (String)"elementToSign");
        ArgumentUtils.checkNotNull((Object)credential, (String)"credential");
        this.sign(elementToAddSigTo, Arrays.asList(elementToSign), Arrays.asList(credential));
    }

    @Override
    public void sign(Element elementToAddSigTo, List<Element> elementsToSign, X500PrivateCredential credential) throws XspException {
        ArgumentUtils.checkNotNull((Object)credential, (String)"credential");
        this.sign(elementToAddSigTo, elementsToSign, Arrays.asList(credential));
    }

    @Override
    public void sign(Element elementToAddSigTo, Element elementToSign, List<X500PrivateCredential> credentials) throws XspException {
        ArgumentUtils.checkNotNull((Object)elementToSign, (String)"elementToSign");
        this.sign(elementToAddSigTo, Arrays.asList(elementToSign), credentials);
    }

    @Override
    public void sign(Element elementToAddSigTo, List<Element> elementsToSign, List<X500PrivateCredential> credentials) throws XspException {
        ArgumentUtils.checkNotNull((Object)elementToAddSigTo, (String)"elementToAddSigTo");
        ArgumentUtils.checkNotNullNorEmpty(elementsToSign, (String)"elementsToSign");
        ArgumentUtils.checkNotNullNorEmpty(credentials, (String)"credentials");
        Document containerDoc = elementToAddSigTo.getOwnerDocument();
        for (Element elementToSign : elementsToSign) {
            if (elementToSign == null) {
                String errMsg = "The 'elementsToSign' list has a null value.";
                throw new IllegalArgumentException(errMsg);
            }
            if (containerDoc.equals(elementToSign.getOwnerDocument())) continue;
            String errMsg = "The element to sign, " + TextUtils.getDesc(elementToSign) + ", must belong to the same document as the element to add " + "the signatures to, " + TextUtils.getDesc(elementToAddSigTo) + ".";
            throw new IllegalArgumentException(errMsg);
        }
        for (X500PrivateCredential credential : credentials) {
            if (credential != null) continue;
            String errMsg = "The 'credentials' list has a null value.";
            throw new IllegalArgumentException(errMsg);
        }
        ArrayList<Reference> referenceList = new ArrayList<Reference>();
        for (Element elementToSign : elementsToSign) {
            String referenceId = null;
            List<String> elemIdValues = XmlSignatureProfileServiceImpl.getIdValues(elementToSign);
            if (!elemIdValues.isEmpty()) {
                referenceId = elemIdValues.get(0);
            } else {
                referenceId = "_" + UUID.randomUUID().toString();
                elementToSign.setAttributeNS(XML_NAMESPACE, XML_ID_QNAME, referenceId);
            }
            Reference reference = XmlSignatureProfileServiceImpl.newReference(referenceId);
            referenceList.add(reference);
        }
        SignedInfo signedInfo = XmlSignatureProfileServiceImpl.newSignedInfo(referenceList);
        containerDoc.normalizeDocument();
        CustomUriDereferencer uriDereferencer = new CustomUriDereferencer();
        for (X500PrivateCredential credential : credentials) {
            X509Certificate signingCertificate = credential.getCertificate();
            PrivateKey signingPrivateKey = credential.getPrivateKey();
            KeyInfo keyInfo = XmlSignatureProfileServiceImpl.newKeyInfo(signingCertificate);
            XMLSignature signature = XML_SIGNATURE_FACTORY.newXMLSignature(signedInfo, keyInfo);
            DOMSignContext signContext = new DOMSignContext(signingPrivateKey, (Node)elementToAddSigTo);
            signContext.setURIDereferencer(uriDereferencer);
            signContext.setDefaultNamespacePrefix("ds");
            try {
                signature.sign(signContext);
            }
            catch (Exception e) {
                throw new XspException("Couldn't create signature with credential, " + TextUtils.getDesc(signingCertificate) + ".", e);
            }
        }
    }

    @Override
    public void check(Element signatureElem, CertificateVerifier certificateVerifier) throws SignatureValidationException, CertificateVerificationException, XspException {
        ArgumentUtils.checkNotNull((Object)signatureElem, (String)"signatureElem");
        this.check(Arrays.asList(signatureElem), certificateVerifier);
    }

    @Override
    public void check(List<Element> signatureElems, CertificateVerifier certificateVerifier) throws SignatureValidationException, CertificateVerificationException, XspException {
        ArgumentUtils.checkNotNullNorEmpty(signatureElems, (String)"signatureElems");
        ArgumentUtils.checkNotNull((Object)certificateVerifier, (String)"certificateVerifier");
        for (Element signatureElem : signatureElems) {
            if (signatureElem == null) {
                String errMsg = "The 'signatureElems' list has a null value.";
                throw new IllegalArgumentException(errMsg);
            }
            DomUtils.checkElement((Element)signatureElem, (String)"Signature", (String)"http://www.w3.org/2000/09/xmldsig#");
        }
        CustomUriDereferencer uriDereferencer = new CustomUriDereferencer();
        for (Element signatureElem : signatureElems) {
            XMLSignature signature = XmlSignatureProfileServiceImpl.unmarshalSignature(signatureElem);
            X509Certificate certificate = XmlSignatureProfileServiceImpl.getSigningCertificate(signature);
            DOMValidateContext validateContext = new DOMValidateContext(certificate.getPublicKey(), (Node)signatureElem);
            validateContext.setURIDereferencer(uriDereferencer);
            boolean valid = false;
            try {
                valid = signature.validate(validateContext);
            }
            catch (XMLSignatureException e) {
                throw new XspException("Couldn't do validation on an XML Signature.", e);
            }
            if (!valid) {
                throw new SignatureValidationException("Invalid XML Signature signed by certificate: " + CertificateUtils.getSubjectName(certificate));
            }
            certificateVerifier.verify(certificate);
        }
    }

    @Override
    public X509Certificate getSigningCertificate(Element signatureElem) throws XspException {
        DomUtils.checkElement((Element)signatureElem, (String)"Signature", (String)"http://www.w3.org/2000/09/xmldsig#");
        XMLSignature signature = XmlSignatureProfileServiceImpl.unmarshalSignature(signatureElem);
        return XmlSignatureProfileServiceImpl.getSigningCertificate(signature);
    }

    @Override
    public Map<String, byte[]> getDigestValues(Element signatureElem) throws XspException {
        DomUtils.checkElement((Element)signatureElem, (String)"Signature", (String)"http://www.w3.org/2000/09/xmldsig#");
        XMLSignature signature = XmlSignatureProfileServiceImpl.unmarshalSignature(signatureElem);
        return XmlSignatureProfileServiceImpl.getDigestValues(signature);
    }

    private static List<String> getIdValues(Element element) {
        assert (element != null);
        ArrayList<String> elemIdValues = new ArrayList<String>();
        if (element.hasAttributeNS(XML_NAMESPACE, XML_ID_LOCAL_NAME)) {
            elemIdValues.add(element.getAttributeNS(XML_NAMESPACE, XML_ID_LOCAL_NAME));
        }
        if (element.hasAttribute(XML_ID_QNAME)) {
            elemIdValues.add(element.getAttribute(XML_ID_QNAME));
        }
        for (String idTag : ID_ATTR_TAGS) {
            if (element.hasAttributeNS(null, idTag)) {
                elemIdValues.add(element.getAttributeNS(null, idTag));
            }
            if (!element.hasAttribute(idTag)) continue;
            elemIdValues.add(element.getAttribute(idTag));
        }
        return elemIdValues;
    }

    private static Reference newReference(String referenceId) throws XspException {
        assert (referenceId != null && !referenceId.trim().isEmpty());
        try {
            DigestMethod digestMethod = XML_SIGNATURE_FACTORY.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
            Transform transform = XML_SIGNATURE_FACTORY.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", (TransformParameterSpec)null);
            return XML_SIGNATURE_FACTORY.newReference("#" + referenceId, digestMethod, Collections.singletonList(transform), null, null);
        }
        catch (Exception ex) {
            throw new XspException("Unable to create 'Reference'. " + ex.getMessage());
        }
    }

    private static SignedInfo newSignedInfo(List<Reference> referenceList) throws XspException {
        assert (referenceList != null);
        try {
            SignatureMethod signatureMethod = XML_SIGNATURE_FACTORY.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null);
            CanonicalizationMethod canonicalisationMethod = XML_SIGNATURE_FACTORY.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null);
            return XML_SIGNATURE_FACTORY.newSignedInfo(canonicalisationMethod, signatureMethod, referenceList);
        }
        catch (Exception ex) {
            throw new XspException("Unable to create 'SignedInfo'. " + ex.getMessage(), ex);
        }
    }

    private static KeyInfo newKeyInfo(X509Certificate certificate) {
        assert (certificate != null);
        X509Data x509Data = KEY_INFO_FACTORY.newX509Data(Collections.singletonList(certificate));
        return KEY_INFO_FACTORY.newKeyInfo(Collections.singletonList(x509Data));
    }

    private static X509Certificate getSigningCertificate(XMLSignature signature) throws XspException {
        assert (signature != null);
        KeyInfo keyInfo = signature.getKeyInfo();
        if (keyInfo == null) {
            throw new XspException("A 'Signature' doesn't have a 'KeyInfo'.");
        }
        ArrayList<X509Data> x509DataObjects = new ArrayList<X509Data>();
        for (XMLStructure content : keyInfo.getContent()) {
            if (!(content instanceof X509Data)) continue;
            x509DataObjects.add((X509Data)content);
        }
        if (x509DataObjects.size() == 0) {
            throw new XspException("The 'KeyInfo' in a 'Signature' doesn't specify an 'X509Data'.");
        }
        if (x509DataObjects.size() > 1) {
            throw new XspException("The 'KeyInfo' in a 'Signature' specifies multiple 'X509Data'.");
        }
        X509Data x509Data = (X509Data)x509DataObjects.get(0);
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        for (Object content : x509Data.getContent()) {
            if (!(content instanceof X509Certificate)) continue;
            certificates.add((X509Certificate)content);
        }
        if (certificates.size() == 0) {
            throw new XspException("The 'X509Data' in a 'Signature' doesn't specify an 'X509Certificate'.");
        }
        if (certificates.size() > 1) {
            throw new XspException("The 'X509Data' in a 'Signature' specifies multiple 'X509Certificate'.");
        }
        return (X509Certificate)certificates.get(0);
    }

    private static Map<String, byte[]> getDigestValues(XMLSignature signature) throws XspException {
        assert (signature != null);
        SignedInfo signedInfo = signature.getSignedInfo();
        if (signedInfo == null) {
            throw new XspException("A 'Signature' does not have a 'SignedInfo'.");
        }
        List<Reference> referenceList = signedInfo.getReferences();
        if (referenceList == null || referenceList.size() == 0) {
            throw new XspException("The 'SignedInfo' in a 'Signature' does not have a 'Reference'.");
        }
        HashMap<String, byte[]> resultMap = new HashMap<String, byte[]>();
        for (Reference reference : referenceList) {
            String uri = reference.getURI();
            if (ArgumentUtils.isNullOrBlank((String)uri)) {
                throw new XspException("A 'Reference' in the 'Signature/SignedInfo' does not have a 'URI'.");
            }
            byte[] digestValue = reference.getDigestValue();
            if (digestValue == null) {
                throw new XspException("A 'Reference' in the 'Signature/SignedInfo' does not have a 'DigestValue'.");
            }
            resultMap.put(uri, digestValue);
        }
        return resultMap;
    }

    private static XMLSignature unmarshalSignature(Element signatureElem) throws XspException {
        assert (signatureElem != null);
        try {
            DOMStructure domStructure = new DOMStructure(signatureElem);
            return XML_SIGNATURE_FACTORY.unmarshalXMLSignature(domStructure);
        }
        catch (MarshalException ex) {
            throw new XspException("Couldn't unmarshall signature element. " + ex.getMessage(), ex);
        }
    }

    private class CustomUriDereferencer
    implements URIDereferencer {
        private CustomUriDereferencer() {
        }

        @Override
        public Data dereference(URIReference uriReference, XMLCryptoContext context) throws URIReferenceException {
            assert (uriReference != null);
            assert (uriReference.getURI() != null);
            assert (context != null);
            String uriValue = uriReference.getURI().trim();
            if (!uriValue.startsWith("#")) {
                String errMsg = "Cannot look up the reference to '" + uriValue + "'." + " Only local URI references (starts with '#') are permitted.";
                throw new URIReferenceException(errMsg);
            }
            String idValue = uriValue.substring(1);
            if (idValue.length() == 0) {
                String errMsg = "Cannot look up the reference to '" + uriValue + "'." + " No ID value was provided after the '#'.";
                throw new URIReferenceException(errMsg);
            }
            Document containerDoc = this.getContainerDocument(context);
            if (containerDoc == null) {
                String errMsg = "Cannot look up the reference to '" + uriValue + "'." + " Couldn't retrieve the container document.";
                throw new URIReferenceException(errMsg);
            }
            Element foundElem = this.findElementById(containerDoc, idValue);
            if (foundElem == null) {
                String errMsg = "Cannot look up the reference to '" + uriValue + "'." + " Couldn't find an XML element with the matching ID.";
                throw new URIReferenceException(errMsg);
            }
            try {
                String foundElemStr = DomUtils.serialiseToString((Element)foundElem);
                return new OctetStreamData(new ByteArrayInputStream(foundElemStr.getBytes()));
            }
            catch (Exception e) {
                String errMsg = "Cannot look up the reference to '" + uriValue + "'." + " Couldn't serialse the XML element with the matching ID.";
                throw new URIReferenceException(errMsg);
            }
        }

        private Document getContainerDocument(XMLCryptoContext context) {
            DOMValidateContext domValidateContext;
            Node node;
            if (context instanceof DOMSignContext) {
                DOMSignContext domSignContext = (DOMSignContext)context;
                Node parentNode = domSignContext.getParent();
                if (parentNode != null) {
                    return parentNode.getOwnerDocument();
                }
            } else if (context instanceof DOMValidateContext && (node = (domValidateContext = (DOMValidateContext)context).getNode()) != null) {
                return node.getOwnerDocument();
            }
            return null;
        }

        private Element findElementById(Document doc, String idValue) {
            assert (doc != null);
            assert (idValue != null);
            return this.findElementById(doc.getDocumentElement(), idValue);
        }

        private Element findElementById(Element element, String idValue) {
            assert (element != null);
            assert (idValue != null);
            List elemIdValues = XmlSignatureProfileServiceImpl.getIdValues(element);
            if (elemIdValues.contains(idValue)) {
                return element;
            }
            NodeList nodeList = element.getChildNodes();
            for (int idx = 0; idx < nodeList.getLength(); ++idx) {
                Element foundElem;
                Node childNode = nodeList.item(idx);
                if (!(childNode instanceof Element) || (foundElem = this.findElementById((Element)childNode, idValue)) == null) continue;
                return foundElem;
            }
            return null;
        }
    }
}

