/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.common.utils;

import au.gov.nehta.common.utils.ArgumentUtils;
import java.io.InputStream;
import java.net.URL;

public final class ResourceLocator {
    private static final ResourceLocator instance = new ResourceLocator();

    public static ResourceLocator getInstance() {
        return instance;
    }

    private ResourceLocator() {
    }

    public InputStream findStreamInClasspath(String resourceName) {
        return this.findStreamInClasspath(resourceName, null);
    }

    public InputStream findStreamInClasspath(String resourceName, Class referenceClass) {
        ArgumentUtils.checkNotNullNorBlank(resourceName, "resourceName");
        ClassLoader classLoader = this.getClassLoader(referenceClass);
        return classLoader.getResourceAsStream(resourceName);
    }

    public URL findUrlInClasspath(String resourceName) {
        return this.findUrlInClasspath(resourceName, null);
    }

    public URL findUrlInClasspath(String resourceName, Class referenceClass) {
        ArgumentUtils.checkNotNullNorBlank(resourceName, "resourceName");
        ClassLoader classLoader = this.getClassLoader(referenceClass);
        return classLoader.getResource(resourceName);
    }

    private ClassLoader getClassLoader(Class referenceClass) {
        ClassLoader classLoader = null;
        if (referenceClass != null) {
            classLoader = referenceClass.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }
}

