/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.common.utils;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.common.utils.MappedNamespaceContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathUtils {
    public static <T> T evaluate(String xpath, Node contextNode, Map<String, String> namespaceMap, Class<T> expectedType) throws XPathExpressionException {
        ArgumentUtils.checkNotNullNorBlank(xpath, "xpath");
        ArgumentUtils.checkNotNull(contextNode, "contextNode");
        ArgumentUtils.checkNotNull(expectedType, "expectedType");
        QName returnType = null;
        if (expectedType == String.class) {
            returnType = XPathConstants.STRING;
        } else if (expectedType == Boolean.class) {
            returnType = XPathConstants.BOOLEAN;
        } else if (expectedType == Double.class) {
            returnType = XPathConstants.NUMBER;
        } else if (Node.class.isAssignableFrom(expectedType)) {
            returnType = XPathConstants.NODE;
        } else if (expectedType == NodeList.class) {
            returnType = XPathConstants.NODESET;
        } else {
            throw new IllegalArgumentException("Unknown expected type for result of XPath expression: " + expectedType.getName() + ".");
        }
        Object result = XPathUtils.evaluate(xpath, contextNode, namespaceMap, returnType);
        return expectedType.cast(result);
    }

    public static Object evaluate(String xpath, Node contextNode, Map<String, String> namespaceMap, QName returnType) throws XPathExpressionException {
        ArgumentUtils.checkNotNullNorBlank(xpath, "xpath");
        ArgumentUtils.checkNotNull(contextNode, "contextNode");
        ArgumentUtils.checkNotNull(returnType, "returnType");
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpathObj = factory.newXPath();
        if (namespaceMap != null) {
            xpathObj.setNamespaceContext(new MappedNamespaceContext(namespaceMap));
        }
        return xpathObj.evaluate(xpath, contextNode, returnType);
    }

    public static int getCount(String xpath, Node contextNode, Map<String, String> namespaceMap) throws XPathExpressionException {
        ArgumentUtils.checkNotNullNorBlank(xpath, "xpath");
        double doubleCount = XPathUtils.evaluate("count(" + xpath + ")", contextNode, namespaceMap, Double.class);
        return (int)doubleCount;
    }

    public static List<Element> getElementList(String xpath, Node contextNode, Map<String, String> namespaceMap) throws XPathExpressionException {
        NodeList nodeList = XPathUtils.evaluate(xpath, contextNode, namespaceMap, NodeList.class);
        ArrayList<Element> elementList = new ArrayList<Element>();
        if (nodeList != null) {
            for (int idx = 0; idx < nodeList.getLength(); ++idx) {
                Node node = nodeList.item(idx);
                if (!(node instanceof Element)) continue;
                elementList.add((Element)node);
            }
        }
        return elementList;
    }

    private XPathUtils() {
    }
}

