/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.common.security;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.xsp.EncryptedContainerProfileService;
import au.gov.nehta.xsp.KeyMismatchException;
import au.gov.nehta.xsp.XspException;
import au.gov.nehta.xsp.XspFactory;
import au.gov.nehta.xsp.XspVersion;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKey;
import javax.security.auth.x500.X500PrivateCredential;
import org.w3c.dom.Document;

public final class EncryptedContainerProfileUtil {
    private EncryptedContainerProfileUtil() {
    }

    public static Document getEncryptedPayload(Document signedDocument, X509Certificate encryptingCert) {
        ArgumentUtils.checkNotNull((Object)signedDocument, (String)"signedDocument");
        ArgumentUtils.checkNotNull((Object)encryptingCert, (String)"encryptingCert");
        Document encryptedDocument = null;
        try {
            ArrayList<X509Certificate> certificate = new ArrayList<X509Certificate>();
            certificate.add(encryptingCert);
            encryptedDocument = EncryptedContainerProfileUtil.getEncryptedContainerProfileService().create(signedDocument, certificate);
        }
        catch (XspException e) {
            e.printStackTrace();
        }
        return encryptedDocument;
    }

    public static Document getEncryptedPayload(Document signedDocument, SecretKey sessionKey, List<X509Certificate> encryptingCertificates) {
        ArgumentUtils.checkNotNull((Object)signedDocument, (String)"signedDocument");
        ArgumentUtils.checkNotNull((Object)sessionKey, (String)"sessionKey");
        ArgumentUtils.checkNotNull(encryptingCertificates, (String)"encryptingCertificates");
        Document encryptedDocument = null;
        try {
            encryptedDocument = EncryptedContainerProfileUtil.getEncryptedContainerProfileService().create(signedDocument, sessionKey, encryptingCertificates);
        }
        catch (XspException e) {
            e.printStackTrace();
        }
        return encryptedDocument;
    }

    public static Document getEncryptedPayload(Document signedDocument, SecretKey sessionKey, X509Certificate encryptingCert) {
        ArgumentUtils.checkNotNull((Object)encryptingCert, (String)"encryptingCert");
        ArrayList<X509Certificate> encryptingCertificates = new ArrayList<X509Certificate>();
        encryptingCertificates.add(encryptingCert);
        return EncryptedContainerProfileUtil.getEncryptedPayload(signedDocument, sessionKey, encryptingCertificates);
    }

    public static Document getDecryptedPayload(Document encryptedPayload, X500PrivateCredential decryptingPrivateCredential) throws XspException {
        ArgumentUtils.checkNotNull((Object)encryptedPayload, (String)"encryptedPayload");
        ArgumentUtils.checkNotNull((Object)decryptingPrivateCredential, (String)"decryptingPrivateCredential");
        Document decryptedPayload = null;
        try {
            decryptedPayload = EncryptedContainerProfileUtil.getEncryptedContainerProfileService().getData(encryptedPayload, decryptingPrivateCredential);
        }
        catch (KeyMismatchException e) {
            throw new XspException((Throwable)e);
        }
        return decryptedPayload;
    }

    public static Document getDecryptedPayload(Document encryptedPayload, SecretKey sessionKey) throws XspException {
        ArgumentUtils.checkNotNull((Object)encryptedPayload, (String)"encryptedPayload");
        ArgumentUtils.checkNotNull((Object)sessionKey, (String)"sessionKey");
        Document decryptedPayload = null;
        try {
            decryptedPayload = EncryptedContainerProfileUtil.getEncryptedContainerProfileService().getData(encryptedPayload, sessionKey);
        }
        catch (KeyMismatchException e) {
            throw new XspException((Throwable)e);
        }
        return decryptedPayload;
    }

    private static EncryptedContainerProfileService getEncryptedContainerProfileService() throws XspException {
        return XspFactory.getInstance().getEncryptedContainerProfileService(XspVersion.V_2010);
    }
}

