/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.util;

import au.net.electronichealth.ns.pcehr.xsd.common.commoncoreelements._1.PCEHRHeader;
import java.math.BigInteger;
import org.apache.commons.lang.Validate;

public final class CommonHeaderValidator {
    private static final int EXPECTED_IHI_LENGTH = 16;

    private CommonHeaderValidator() {
    }

    public static void validate(PCEHRHeader commonHeader, boolean requireIHINumber) {
        Validate.notNull((Object)commonHeader, (String)"'commonHeader' cannot be null.");
        if (requireIHINumber) {
            Validate.notEmpty((String)commonHeader.getIhiNumber(), (String)"'commonHeader.IHINumber' cannot be null nor empty.");
            CommonHeaderValidator.validateIhi(commonHeader.getIhiNumber());
        }
        Validate.notNull((Object)commonHeader.getUser(), (String)"'commonHeader.user' cannot be null.");
        Validate.notNull((Object)commonHeader.getUser().getIDType(), (String)"'commonHeader.user.idType' cannot be null.");
        Validate.notEmpty((String)commonHeader.getUser().getID(), (String)"'commonHeader.user.id' cannot be null nor empty.");
        Validate.notEmpty((String)commonHeader.getUser().getUserName(), (String)"'commonHeader.user.userName' cannot be null nor empty.");
        if (commonHeader.getUser().isUseRoleForAudit()) {
            Validate.notEmpty((String)commonHeader.getUser().getRole(), (String)"'commonHeader.user.role' must be specified as 'commonHeader.user.userRoleForAudit' is true.");
        }
        Validate.notNull((Object)commonHeader.getProductType(), (String)"'commonHeader.productType' cannot be null.");
        Validate.notEmpty((String)commonHeader.getProductType().getVendor(), (String)"'commonHeader.productType.vendor' cannot be null nor empty.");
        Validate.notEmpty((String)commonHeader.getProductType().getProductName(), (String)"'commonHeader.productType.productName' cannot be null nor empty.");
        Validate.notEmpty((String)commonHeader.getProductType().getProductVersion(), (String)"'commonHeader.productType.productVersion' cannot be null nor empty.");
        Validate.notEmpty((String)commonHeader.getProductType().getPlatform(), (String)"'commonHeader.productType.platform' cannot be null nor empty.");
        Validate.notNull((Object)commonHeader.getClientSystemType(), (String)"'commonHeader.clientSystemType' cannot be null.");
        if (commonHeader.getAccessingOrganisation() != null) {
            Validate.notEmpty((String)commonHeader.getAccessingOrganisation().getOrganisationID(), (String)"'commonHeader.accessingOrganisation.organisationId' cannot be null nor empty.");
            Validate.notEmpty((String)commonHeader.getAccessingOrganisation().getOrganisationName(), (String)"'commonHeader.accessingOrganisation.organisationName' cannot be null nor empty.");
        }
    }

    private static void validateIhi(String ihi) {
        Validate.notEmpty((String)ihi, (String)"'ihi' must not be null nor empty.");
        if (ihi.length() != 16) {
            throw new IllegalArgumentException("'ihi' length must be 16 digits.");
        }
        try {
            new BigInteger(ihi);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("'ihi' must only contain digits.", e);
        }
        if (!ihi.startsWith("800360")) {
            throw new IllegalArgumentException("'ihi' must be of the format 800360XXXXXXXXXX.");
        }
    }
}

