/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.util;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.DocumentMetadata;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.SubmissionMetadata;
import org.apache.commons.lang.Validate;

public final class MetadataValidator {
    private MetadataValidator() {
    }

    public static void validate(DocumentMetadata documentMetadata) {
        Validate.notNull((Object)documentMetadata, (String)"'documentMetadata' must be specified.");
        Validate.notNull((Object)documentMetadata.getDocumentClass(), (String)"'documentMetadata.documentType' must be specified.");
        Validate.notEmpty((String)documentMetadata.getDocumentClass().getCodeSystem(), (String)"'documentMetadata.documentType.codeSystem' must be specified.");
        Validate.notEmpty((String)documentMetadata.getDocumentClass().getValue(), (String)"'documentMetadata.documentType.value' must be specified.");
        Validate.notNull((Object)documentMetadata.getFormatCode(), (String)"'documentMetadata.templateId' must be specified.");
        Validate.notEmpty((String)documentMetadata.getEntryUuid(), (String)"'documentMetadata.documentId' must be specified.");
        Validate.notNull((Object)documentMetadata.getDocumentHash(), (String)"'documentMetadata.documentHash' must be specified.");
        Validate.notNull((Object)documentMetadata.getCreationTime(), (String)"'documentMetadata.documentCreationTime' must be specified.");
        Validate.notNull((Object)documentMetadata.getServiceStartTime(), (String)"'documentMetadata.serviceStartTime' must be specified.");
        Validate.notNull((Object)documentMetadata.getServiceStopTime(), (String)"'documentMetadata.serviceStopTime' must be specified.");
        Validate.isTrue((documentMetadata.getServiceStartTime().compareTo(documentMetadata.getServiceStopTime()) >= 0 ? 1 : 0) != 0, (String)"'documentMetadata.serviceStopTime' must be greater than or equal to 'documentMetadata.serviceStartTime'.");
        Validate.notNull((Object)documentMetadata.getHealthcareFacilityType(), (String)"'documentMetadata.healthcareFacilityType' must be specified.");
        Validate.notEmpty((String)documentMetadata.getHealthcareFacilityType().getCodeSystem(), (String)"'documentMetadata.healthcareFacilityType.codeSystem' must be specified.");
        Validate.notEmpty((String)documentMetadata.getHealthcareFacilityType().getValue(), (String)"'documentMetadata.healthcareFacilityType.value' must be specified.");
        Validate.notEmpty((String)documentMetadata.getHealthcareFacilityType().getDisplayName(), (String)"'documentMetadata.healthcareFacilityType.displayName' must be specified.");
        Validate.notNull((Object)documentMetadata.getPracticeSetting(), (String)"'documentMetadata.clinicalSpecialty' must be specified.");
        Validate.notEmpty((String)documentMetadata.getPracticeSetting().getCodeSystem(), (String)"'documentMetadata.clinicalSpecialty.codeSystem' must be specified.");
        Validate.notEmpty((String)documentMetadata.getPracticeSetting().getValue(), (String)"'documentMetadata.clinicalSpecialty.value' must be specified.");
        Validate.notEmpty((String)documentMetadata.getPracticeSetting().getDisplayName(), (String)"'documentMetadata.clinicalSpecialty.displayName' must be specified.");
    }

    public static void validate(SubmissionMetadata submissionMetadata) {
        Validate.notNull((Object)submissionMetadata, (String)"'submissionMetadata' must be specified.");
        Validate.notNull((Object)submissionMetadata.getSubmissionTime(), (String)"'submissionMetadata.submissionTime' must be specified.");
    }
}

