/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.util;

import java.math.BigInteger;
import java.util.UUID;
import org.apache.commons.lang.Validate;

public final class OIDUtil {
    static final int HEX_RADIX = 16;
    static final String OID_PREFIX = "2.25";
    private static final String UUID_PREFIX = "urn:uuid:";
    private static final String REPLACEMENT = "";
    private static final String SEPERATOR = "-";

    private OIDUtil() {
    }

    public static String convertUUIDToOIDIntegerPair(String uuid) {
        return OIDUtil.convertUUIDToOIDIntegerPair(OID_PREFIX, uuid);
    }

    public static String convertUUIDToOIDIntegerPair(String oid, String uuid) {
        Validate.notEmpty((String)oid);
        Validate.notEmpty((String)uuid);
        OIDUtil.validateUUID(uuid.replace(UUID_PREFIX, REPLACEMENT));
        String cleanUuid = OIDUtil.cleanUuid(uuid);
        BigInteger result = new BigInteger(String.valueOf(0));
        for (int i = 0; i < cleanUuid.length(); ++i) {
            result = result.multiply(new BigInteger(String.valueOf(16))).add(new BigInteger(String.valueOf(Integer.parseInt(String.valueOf(cleanUuid.charAt(i)), 16))));
        }
        return oid + '.' + result;
    }

    private static void validateUUID(String uuid) {
        UUID.fromString(uuid);
    }

    private static String cleanUuid(String uuid) {
        return uuid.replace(UUID_PREFIX, REPLACEMENT).replace(SEPERATOR, REPLACEMENT);
    }
}

