/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.ws;

import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.net.SocketFactory;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.AddressingFeature;

public final class WebServiceClientUtil {
    private static final String REQUEST_CONTEXT_SSL_SOCKET_FACTORY_PROPERTY_NAME = "com.sun.xml.ws.transport.https.client.SSLSocketFactory";
    private static final String INTERNAL_REQUEST_CONTEXT_SSL_SOCKET_FACTORY_PROPERTY_NAME = "com.sun.xml.internal.ws.transport.https.client.SSLSocketFactory";

    private WebServiceClientUtil() {
    }

    public static <T> T getPort(Class<T> serviceInterface, Class<? extends Service> serviceClass, SocketFactory sslSocketFactory, String endpoint, List<Handler> handlerChain) {
        T port = WebServiceClientUtil.getPort(serviceInterface, serviceClass, sslSocketFactory, endpoint);
        WebServiceClientUtil.addHandlerChain(port, handlerChain);
        return port;
    }

    public static <T> T getPort(Class<T> serviceInterface, Class<? extends Service> serviceClass, SocketFactory sslSocketFactory, String endpoint) {
        WebServiceClient annotation = serviceClass.getAnnotation(WebServiceClient.class);
        String wsdlFileLoc = annotation.wsdlLocation();
        Service service = WebServiceClientUtil.getService(annotation, wsdlFileLoc);
        Object port = service.getPort(serviceInterface);
        WebServiceClientUtil.configurePortWithEndpoint(port, endpoint);
        WebServiceClientUtil.configurePortWithSslSocketFactory(port, sslSocketFactory);
        return (T)port;
    }

    public static <T> T getPort(Class<T> serviceInterface, Class<? extends Service> serviceClass, SocketFactory sslSocketFactory, String endpoint, List<Handler> handlerChain, boolean addressingFeature) {
        WebServiceClient annotation = serviceClass.getAnnotation(WebServiceClient.class);
        String wsdlFileLoc = annotation.wsdlLocation();
        Service service = WebServiceClientUtil.getService(annotation, wsdlFileLoc);
        Object port = service.getPort(serviceInterface, new WebServiceFeature[]{new AddressingFeature(addressingFeature)});
        WebServiceClientUtil.configurePortWithEndpoint(port, endpoint);
        WebServiceClientUtil.configurePortWithSslSocketFactory(port, sslSocketFactory);
        WebServiceClientUtil.addHandlerChain(port, handlerChain);
        return (T)port;
    }

    public static <T> T getPort(Class<T> serviceInterface, Class<? extends Service> serviceClass, SocketFactory sslSocketFactory, List<Handler> handlerChain) {
        T port = WebServiceClientUtil.getPort(serviceInterface, serviceClass, sslSocketFactory);
        WebServiceClientUtil.addHandlerChain(port, handlerChain);
        return port;
    }

    public static <T> T getPort(Class<T> serviceInterface, Class<? extends Service> serviceClass, SocketFactory sslSocketFactory) {
        WebServiceClient annotation = serviceClass.getAnnotation(WebServiceClient.class);
        String wsdlFileLoc = annotation.wsdlLocation();
        Service service = WebServiceClientUtil.getService(annotation, wsdlFileLoc);
        Object port = service.getPort(serviceInterface);
        WebServiceClientUtil.configurePortWithSslSocketFactory(port, sslSocketFactory);
        return (T)port;
    }

    private static Service getService(WebServiceClient annotation, String wsdlFileLoc) {
        URL wsdlURL = WebServiceClientUtil.retrieveWsdlUrl(wsdlFileLoc);
        QName serviceQName = new QName(annotation.targetNamespace(), annotation.name());
        return Service.create((URL)wsdlURL, (QName)serviceQName);
    }

    private static URL retrieveWsdlUrl(String filePath) {
        URL result = null;
        if (filePath != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            result = classLoader.getResource(filePath);
        }
        return result;
    }

    private static void configurePortWithSslSocketFactory(Object servicePort, SocketFactory sslSocketFactory) {
        BindingProvider bindingProvider = (BindingProvider)servicePort;
        Map requestContext = bindingProvider.getRequestContext();
        requestContext.put(REQUEST_CONTEXT_SSL_SOCKET_FACTORY_PROPERTY_NAME, sslSocketFactory);
        requestContext.put(INTERNAL_REQUEST_CONTEXT_SSL_SOCKET_FACTORY_PROPERTY_NAME, sslSocketFactory);
    }

    private static void configurePortWithEndpoint(Object servicePort, String endpoint) {
        BindingProvider bindingProvider = (BindingProvider)servicePort;
        Map requestContext = bindingProvider.getRequestContext();
        requestContext.put("javax.xml.ws.service.endpoint.address", endpoint.trim());
    }

    private static void addHandlerChain(Object servicePort, List<Handler> handlerChain) {
        BindingProvider bindingProvider = (BindingProvider)servicePort;
        bindingProvider.getBinding().setHandlerChain(handlerChain);
    }
}

