/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.handler.IMTOMHandler;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.handler.SecurityHandler;
import au.gov.nehta.vendorlibrary.ws.WebServiceClientUtil;
import au.gov.nehta.vendorlibrary.ws.handler.LoggingHandler;
import au.gov.nehta.xsp.CertificateVerificationException;
import au.gov.nehta.xsp.CertificateVerifier;
import au.gov.nehta.xsp.XspException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.commons.lang.Validate;

public abstract class Client<PortType> {
    private LoggingHandler loggingHandler;
    private List<Handler> handlerChain;
    private final PortType port;

    public Client(Class<? extends Service> serviceClass, Class<PortType> portClass, SSLSocketFactory sslSocketFactory, X509Certificate x509Certificate, CertificateVerifier certificateVerifier, PrivateKey privateKey, String endpointAddress, boolean setLoggingEnabled) {
        Validate.notNull(serviceClass, (String)"'serviceClass' cannot be null.");
        Validate.notNull(portClass, (String)"'portClass' cannot be null.");
        Validate.notNull((Object)sslSocketFactory, (String)"'sslSocketFactory' cannot be null.");
        Validate.notNull((Object)x509Certificate, (String)"'x509Certificate' cannot be null.");
        Validate.notNull((Object)certificateVerifier, (String)"'certificateVerifier' cannot be null.");
        Validate.notNull((Object)privateKey, (String)"'privateKey' cannot be null.");
        Validate.notEmpty((String)endpointAddress, (String)"'endpointAddress' cannot be null nor empty.");
        this.loggingHandler = new LoggingHandler(setLoggingEnabled);
        SecurityHandler securityHandler = new SecurityHandler(x509Certificate, privateKey, certificateVerifier);
        this.handlerChain = new ArrayList<Handler>();
        this.handlerChain.add((Handler)securityHandler);
        this.handlerChain.add((Handler)this.loggingHandler);
        this.port = WebServiceClientUtil.getPort(portClass, serviceClass, (SocketFactory)sslSocketFactory, (String)endpointAddress, this.handlerChain, (boolean)true);
    }

    public Client(Class<? extends Service> serviceClass, Class<PortType> portClass, SSLSocketFactory sslSocketFactory, X509Certificate x509Certificate, CertificateVerifier certificateVerifier, PrivateKey privateKey, String endpointAddress, boolean setLoggingEnabled, IMTOMHandler customMtomHandler) {
        Validate.notNull(serviceClass, (String)"'serviceClass' cannot be null.");
        Validate.notNull(portClass, (String)"'portClass' cannot be null.");
        Validate.notNull((Object)sslSocketFactory, (String)"'sslSocketFactory' cannot be null.");
        Validate.notNull((Object)x509Certificate, (String)"'x509Certificate' cannot be null.");
        Validate.notNull((Object)certificateVerifier, (String)"'certificateVerifier' cannot be null.");
        Validate.notNull((Object)privateKey, (String)"'privateKey' cannot be null.");
        Validate.notEmpty((String)endpointAddress, (String)"'endpointAddress' cannot be null nor empty.");
        this.loggingHandler = new LoggingHandler(setLoggingEnabled);
        SecurityHandler securityHandler = new SecurityHandler(x509Certificate, privateKey, certificateVerifier);
        IMTOMHandler mtomHandler = customMtomHandler;
        this.handlerChain = new ArrayList<Handler>();
        this.handlerChain.add((Handler)securityHandler);
        this.handlerChain.add((Handler)mtomHandler);
        this.handlerChain.add((Handler)this.loggingHandler);
        this.port = WebServiceClientUtil.getPort(portClass, serviceClass, (SocketFactory)sslSocketFactory, (String)endpointAddress, this.handlerChain, (boolean)true);
        this.setMTOMEnabled();
    }

    public Client(Class<? extends Service> serviceClass, Class<PortType> portClass, SSLSocketFactory sslSocketFactory, X509Certificate x509Certificate, PrivateKey privateKey, String endpointAddress, boolean setLoggingEnabled) {
        this(serviceClass, portClass, sslSocketFactory, x509Certificate, new CertificateVerifier(){

            public void verify(X509Certificate certificate) throws CertificateVerificationException, XspException {
            }
        }, privateKey, endpointAddress, setLoggingEnabled);
    }

    public Client(Class<? extends Service> serviceClass, Class<PortType> portClass, SSLSocketFactory sslSocketFactory, X509Certificate x509Certificate, PrivateKey privateKey, String endpointAddress, boolean setLoggingEnabled, IMTOMHandler customMtomHandler) {
        this(serviceClass, portClass, sslSocketFactory, x509Certificate, new CertificateVerifier(){

            public void verify(X509Certificate certificate) throws CertificateVerificationException, XspException {
            }
        }, privateKey, endpointAddress, setLoggingEnabled, customMtomHandler);
    }

    public final List<Handler> getHandlerChain() {
        return this.handlerChain;
    }

    public final String getLastSoapResponse() {
        if (this.loggingHandler != null) {
            return this.loggingHandler.getLastSoapResponse();
        }
        return "";
    }

    public final String getLastSoapRequest() {
        if (this.loggingHandler != null) {
            return this.loggingHandler.getLastSoapRequest();
        }
        return "";
    }

    private BindingProvider getBindingProvider() {
        return (BindingProvider)this.port;
    }

    public final void setProperty(String propertyKey, Object propertyValue) {
        Validate.notNull((Object)propertyKey, (String)"'propertyKey' must be specified.");
        Validate.notNull((Object)propertyValue, (String)"'propertyValue' must be specified.");
        this.getBindingProvider().getRequestContext().put(propertyKey, propertyValue);
    }

    public final void setMTOMEnabled() {
        SOAPBinding binding = (SOAPBinding)this.getBindingProvider().getBinding();
        binding.setMTOMEnabled(true);
    }

    public final PortType getPort() {
        return this.port;
    }
}

