/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.type;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.Author;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.CodedValue;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.DocumentMetadata;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.DocumentStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class DocumentQueryParams {
    private List<Author> authorIndividuals;
    private List<CodedValue> documentTypes;
    private List<CodedValue> documentClass;
    private List<CodedValue> templateIds;
    private String documentCreationTimeFrom;
    private String documentCreationTimeTo;
    private String serviceStartTimeFrom;
    private String serviceStartTimeTo;
    private String serviceStopTimeFrom;
    private String serviceStopTimeTo;
    private List<CodedValue> healthcareFacilityTypes;
    private List<CodedValue> clinicalSpecialties;
    private Set<String> keywords;
    private Set<DocumentStatus> statuses;

    public DocumentQueryParams() {
    }

    public DocumentQueryParams(DocumentStatus ... status) {
        if (status != null && status.length > 0) {
            this.getStatuses().addAll(Arrays.asList(status));
        }
    }

    public boolean hasAuthorIndividuals() {
        return this.authorIndividuals != null && !this.authorIndividuals.isEmpty();
    }

    public List<Author> getAuthorIndividuals() {
        if (this.authorIndividuals == null) {
            this.authorIndividuals = new ArrayList<Author>();
        }
        return this.authorIndividuals;
    }

    public boolean hasDocumentTypes() {
        return this.documentTypes != null && !this.documentTypes.isEmpty();
    }

    public List<CodedValue> getDocumentTypes() {
        if (this.documentTypes == null) {
            this.documentTypes = new ArrayList<CodedValue>();
        }
        return this.documentTypes;
    }

    public boolean hasDocumentClasses() {
        return this.documentClass != null && !this.documentClass.isEmpty();
    }

    public List<CodedValue> getDocumentClasses() {
        if (this.documentClass == null) {
            this.documentClass = new ArrayList<CodedValue>();
        }
        return this.documentClass;
    }

    public boolean hasTemplateIds() {
        return this.templateIds != null && !this.templateIds.isEmpty();
    }

    public List<CodedValue> getTemplateIds() {
        if (this.templateIds == null) {
            this.templateIds = new ArrayList<CodedValue>();
        }
        return this.templateIds;
    }

    public String getDocumentCreationTimeFrom() {
        return this.documentCreationTimeFrom;
    }

    public void setDocumentCreationTimeFrom(String documentCreationTimeFrom) {
        this.documentCreationTimeFrom = documentCreationTimeFrom;
    }

    public String getDocumentCreationTimeTo() {
        return this.documentCreationTimeTo;
    }

    public void setDocumentCreationTimeTo(String documentCreationTimeTo) {
        this.documentCreationTimeTo = documentCreationTimeTo;
    }

    public String getServiceStartTimeFrom() {
        return this.serviceStartTimeFrom;
    }

    public void setServiceStartTimeFrom(String serviceStartTimeFrom) {
        this.serviceStartTimeFrom = serviceStartTimeFrom;
    }

    public String getServiceStartTimeTo() {
        return this.serviceStartTimeTo;
    }

    public void setServiceStartTimeTo(String serviceStartTimeTo) {
        this.serviceStartTimeTo = serviceStartTimeTo;
    }

    public String getServiceStopTimeFrom() {
        return this.serviceStopTimeFrom;
    }

    public void setServiceStopTimeFrom(String serviceStopTimeFrom) {
        this.serviceStopTimeFrom = serviceStopTimeFrom;
    }

    public String getServiceStopTimeTo() {
        return this.serviceStopTimeTo;
    }

    public void setServiceStopTimeTo(String serviceStopTimeTo) {
        this.serviceStopTimeTo = serviceStopTimeTo;
    }

    public boolean hasHealthcareFacilityTypes() {
        return this.healthcareFacilityTypes != null && !this.healthcareFacilityTypes.isEmpty();
    }

    public List<CodedValue> getHealthcareFacilityTypes() {
        if (this.healthcareFacilityTypes == null) {
            this.healthcareFacilityTypes = new ArrayList<CodedValue>();
        }
        return this.healthcareFacilityTypes;
    }

    public boolean hasClinicalSpecialties() {
        return this.clinicalSpecialties != null && !this.clinicalSpecialties.isEmpty();
    }

    public List<CodedValue> getClinicalSpecialties() {
        if (this.clinicalSpecialties == null) {
            this.clinicalSpecialties = new ArrayList<CodedValue>();
        }
        return this.clinicalSpecialties;
    }

    public boolean hasKeywords() {
        return this.keywords != null && !this.keywords.isEmpty();
    }

    public Set<String> getKeywords() {
        if (this.keywords == null) {
            this.keywords = new HashSet<String>();
        }
        return this.keywords;
    }

    public boolean hasStatuses() {
        return this.statuses != null && !this.statuses.isEmpty();
    }

    public Set<DocumentStatus> getStatuses() {
        if (this.statuses == null) {
            this.statuses = new HashSet<DocumentStatus>();
        }
        return this.statuses;
    }

    public boolean matches(DocumentMetadata documentMetadata) {
        if (this.hasAuthorIndividuals()) {
            boolean found = false;
            if (documentMetadata.getAuthorPerson() != null) {
                String authorIndividual = documentMetadata.getAuthorPerson().toString();
                for (Author author : this.authorIndividuals) {
                    if (!author.toXCNFormatString().equals(authorIndividual)) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                return false;
            }
        }
        if (this.hasDocumentTypes() && !this.documentTypes.contains(documentMetadata.getDocumentClass())) {
            return false;
        }
        if (this.hasTemplateIds() && !this.templateIds.contains(documentMetadata.getFormatCode())) {
            return false;
        }
        if (this.documentCreationTimeFrom != null && (documentMetadata.getCreationTime() == null || this.documentCreationTimeFrom.compareTo(documentMetadata.getCreationTime()) > 0)) {
            return false;
        }
        if (this.documentCreationTimeTo != null && (documentMetadata.getCreationTime() == null || this.documentCreationTimeFrom.compareTo(documentMetadata.getCreationTime()) < 0)) {
            return false;
        }
        if (this.serviceStartTimeFrom != null && (documentMetadata.getServiceStartTime() == null || this.serviceStartTimeFrom.compareTo(documentMetadata.getServiceStartTime()) < 0)) {
            return false;
        }
        if (this.serviceStartTimeTo != null && (documentMetadata.getServiceStartTime() == null || this.serviceStartTimeTo.compareTo(documentMetadata.getServiceStartTime()) < 0)) {
            return false;
        }
        if (this.serviceStopTimeFrom != null && (documentMetadata.getServiceStopTime() == null || this.serviceStopTimeFrom.compareTo(documentMetadata.getServiceStopTime()) > 0)) {
            return false;
        }
        if (this.serviceStopTimeTo != null && (documentMetadata.getServiceStopTime() == null || this.serviceStopTimeTo.compareTo(documentMetadata.getServiceStopTime()) < 0)) {
            return false;
        }
        if (this.hasHealthcareFacilityTypes() && !this.healthcareFacilityTypes.contains(documentMetadata.getHealthcareFacilityType())) {
            return false;
        }
        if (this.hasClinicalSpecialties() && !this.clinicalSpecialties.contains(documentMetadata.getPracticeSetting())) {
            return false;
        }
        if (this.hasKeywords()) {
            boolean matchesAnyKeyword = false;
            for (String docKeyword : documentMetadata.getKeywords()) {
                if (!this.keywords.contains(docKeyword)) continue;
                matchesAnyKeyword = true;
                break;
            }
            if (!matchesAnyKeyword) {
                return false;
            }
        }
        return true;
    }
}

