/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.util;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.CodedValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ClassificationType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ExternalIdentifierType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.InternationalStringType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.LocalizedString;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.Slot;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ValueList;
import org.apache.commons.lang.Validate;

public final class XDSFactory {
    private XDSFactory() {
    }

    public static Slot createSlot(String slotName, String ... values) {
        Validate.notEmpty((String)slotName, (String)"'slotName' must be specified.");
        Validate.isTrue((values.length > 0 ? 1 : 0) != 0, (String)"'values' must contain at least one value.");
        Slot slot = new Slot();
        slot.setName(slotName);
        ValueList valueList = new ValueList();
        for (String value : values) {
            valueList.getValues().add(value);
        }
        slot.setValueList(valueList);
        return slot;
    }

    public static Slot createSingleValuedSlot(String slotName, String ... values) {
        Validate.notEmpty((String)slotName, (String)"'slotName' must be specified.");
        Validate.isTrue((values.length == 1 ? 1 : 0) != 0, (String)"'values' must contain at least one value.");
        Slot slot = new Slot();
        slot.setName(slotName);
        ValueList valueList = new ValueList();
        valueList.getValues().add("'" + values[0] + "'");
        slot.setValueList(valueList);
        return slot;
    }

    public static Slot createQuerySlot(String slotName, String ... values) {
        Validate.notEmpty((String)slotName, (String)"'slotName' must be specified.");
        Validate.isTrue((values.length > 0 ? 1 : 0) != 0, (String)"'values' must contain at least one value.");
        Slot slot = new Slot();
        slot.setName(slotName);
        ValueList valueList = new ValueList();
        for (String value : values) {
            valueList.getValues().add("('" + value + "')");
        }
        slot.setValueList(valueList);
        return slot;
    }

    public static List<Slot> createQuerySlots(String slotName, CodedValue ... values) {
        Validate.notEmpty((String)slotName, (String)"'slotName' must be specified.");
        Validate.isTrue((values.length > 0 ? 1 : 0) != 0, (String)"'values' must contain at least one value.");
        ArrayList<Slot> slots = new ArrayList<Slot>();
        if (values.length > 0) {
            Slot valueSlot = new Slot();
            valueSlot.setName(slotName);
            ValueList valueList = new ValueList();
            for (CodedValue value : values) {
                valueList.getValues().add("('" + value.getValue() + "^^" + value.getCodeSystem() + "')");
            }
            valueSlot.setValueList(valueList);
            slots.add(valueSlot);
        }
        return slots;
    }

    public static Slot createQuerySlot(String slotName, Collection<String> values) {
        return XDSFactory.createQuerySlot(slotName, values.toArray(new String[values.size()]));
    }

    public static List<Slot> createQuerySlots(String slotName, Collection<CodedValue> values) {
        return XDSFactory.createQuerySlots(slotName, values.toArray(new CodedValue[values.size()]));
    }

    public static InternationalStringType createInternationalString(String value) {
        Validate.notEmpty((String)value, (String)"'value' must be specified.");
        LocalizedString ls = new LocalizedString();
        ls.setValue(value);
        InternationalStringType is = new InternationalStringType();
        is.getLocalizedStrings().add(ls);
        return is;
    }

    public static ClassificationType createClassification(String classificationScheme, String classifiedObject, String nodeRepresentation, int idNum) {
        Validate.notEmpty((String)classificationScheme, (String)"'classificationScheme' must be specified.");
        Validate.notEmpty((String)classifiedObject, (String)"'classifiedObject' must be specified.");
        Validate.isTrue((idNum > 0 ? 1 : 0) != 0, (String)"'idNum' must be a positive integer.");
        ClassificationType classification = new ClassificationType();
        classification.setNodeRepresentation(nodeRepresentation);
        classification.setClassificationScheme(classificationScheme);
        classification.setClassifiedObject(classifiedObject);
        classification.setObjectType("urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Classification");
        classification.setId(XDSFactory.toClassificationIdString(idNum));
        return classification;
    }

    public static ExternalIdentifierType createExternalIdentifier(String identificationScheme, String registryObject, String name, String value, int idNum) {
        ExternalIdentifierType externalId = new ExternalIdentifierType();
        externalId.setObjectType("urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:ExternalIdentifier");
        externalId.setIdentificationScheme(identificationScheme);
        externalId.setRegistryObject(registryObject);
        externalId.setName(XDSFactory.createInternationalString(name));
        externalId.setValue(value);
        externalId.setId(XDSFactory.toExternalIdentifierIdString(idNum));
        return externalId;
    }

    public static String toClassificationIdString(int idNum) {
        return String.format("cl%02d", idNum);
    }

    public static String toExternalIdentifierIdString(int idNum) {
        return String.format("ei%02d", idNum);
    }

    public static String toAssociationIdentifierString(int idNum) {
        return String.format("as%02d", idNum);
    }
}

