/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.util;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.Author;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.CodedValue;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.DocumentMetadata;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.DocumentQueryParams;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.DocumentStatus;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.SubmissionMetadata;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.DateUtils;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.MetadataUtils;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.XDSFactory;
import au.net.electronichealth.ns.pcehr.xsd.common.commoncoreelements._1.PCEHRHeader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.ws.Holder;
import oasis.names.tc.ebxml_regrep.xsd.lcm._3.SubmitObjectsRequest;
import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryRequest;
import oasis.names.tc.ebxml_regrep.xsd.query._3.ResponseOption;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.AdhocQueryType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.AssociationType1;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ClassificationType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ExternalIdentifierType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ExtrinsicObjectType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.InternationalStringType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.LocalizedString;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ObjectFactory;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.RegistryObjectList;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.RegistryPackageType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.Slot;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.time.FastDateFormat;

public final class XDSMapper {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int EIGHT_DATE_FORMAT = 8;
    private static final int TWELVE_DATE_FORMAT = 12;
    private static final FastDateFormat DATETIME_FORMATTER = FastDateFormat.getInstance((String)"yyyyMMddHHmmss");

    private XDSMapper() {
    }

    public static SubmitObjectsRequest toSubmitObjectsRequest(PCEHRHeader commonHeader, SubmissionMetadata submissionMetadata, DocumentMetadata documentMetadata, String replacesDocumentId) {
        Validate.notNull((Object)commonHeader, (String)"'commonHeader' must be specified.");
        Validate.notNull((Object)submissionMetadata, (String)"'submissionMetadata' must be specified.");
        Validate.notNull((Object)documentMetadata, (String)"'documentMetadata' must be specified.");
        SubmitObjectsRequest sor = new SubmitObjectsRequest();
        RegistryObjectList rol = new RegistryObjectList();
        sor.setRegistryObjectList(rol);
        Holder idClCounter = new Holder((Object)0);
        Holder idAsCounter = new Holder((Object)0);
        Holder idEiCounter = new Holder((Object)0);
        ExtrinsicObjectType xdsDocumentEntry = XDSMapper.toXDSDocumentEntry(commonHeader, documentMetadata, (Holder<Integer>)idClCounter, (Holder<Integer>)idEiCounter);
        rol.getIdentifiables().add(new ObjectFactory().createExtrinsicObject(xdsDocumentEntry));
        RegistryPackageType xdsSubmissionSet = XDSMapper.toXDSSubmissionSet(submissionMetadata, documentMetadata, (Holder<Integer>)idClCounter, (Holder<Integer>)idEiCounter);
        rol.getIdentifiables().add(new ObjectFactory().createRegistryPackage(xdsSubmissionSet));
        ClassificationType classification = new ClassificationType();
        classification.setClassifiedObject(submissionMetadata.getEntryUuid());
        classification.setClassificationNode("urn:uuid:a54d6aa5-d40d-43f9-88c5-b4633d873bdd");
        classification.setObjectType("urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Classification");
        Holder holder = idClCounter;
        holder.value = (Integer)holder.value + 1;
        classification.setId(XDSFactory.toClassificationIdString((Integer)holder.value));
        rol.getIdentifiables().add(new ObjectFactory().createClassification(classification));
        AssociationType1 association = new AssociationType1();
        Holder holder2 = idAsCounter;
        holder2.value = (Integer)holder2.value + 1;
        association.setId(XDSFactory.toAssociationIdentifierString((Integer)holder2.value));
        association.setAssociationType("urn:oasis:names:tc:ebxml-regrep:AssociationType:HasMember");
        association.setObjectType("urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Association");
        association.setSourceObject(xdsSubmissionSet.getId());
        association.setTargetObject(xdsDocumentEntry.getId());
        association.getSlots().add(XDSFactory.createSlot("SubmissionSetStatus", "Original"));
        rol.getIdentifiables().add(new ObjectFactory().createAssociation(association));
        if (StringUtils.isNotBlank((String)replacesDocumentId)) {
            association = new AssociationType1();
            holder2 = idAsCounter;
            holder2.value = (Integer)holder2.value + 1;
            association.setId(XDSFactory.toAssociationIdentifierString((Integer)holder2.value));
            association.setAssociationType("urn:ihe:iti:2007:AssociationType:RPLC");
            association.setObjectType("urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Association");
            association.setSourceObject(xdsDocumentEntry.getId());
            association.setTargetObject(replacesDocumentId);
            association.setName(XDSFactory.createInternationalString("Replace Document"));
            rol.getIdentifiables().add(new ObjectFactory().createAssociation(association));
        }
        return sor;
    }

    public static ExtrinsicObjectType toXDSDocumentEntry(PCEHRHeader commonHeader, DocumentMetadata documentMetadata, Holder<Integer> idClCounter, Holder<Integer> idEiCounter) {
        ExternalIdentifierType externalId;
        Holder<Integer> holder;
        ClassificationType classification;
        Holder<Integer> holder2;
        byte[] documentHash;
        ExtrinsicObjectType xo = new ExtrinsicObjectType();
        xo.setId(documentMetadata.getEntryUuid());
        xo.setObjectType("urn:uuid:7edca82f-054d-47f2-a032-9b2a5b5186c1");
        xo.setMimeType("application/zip");
        if (documentMetadata.getCreationTime() != null) {
            xo.getSlots().add(XDSFactory.createSlot("creationTime", documentMetadata.getCreationTime()));
        }
        xo.getSlots().add(XDSFactory.createSlot("languageCode", documentMetadata.getLanguageCode()));
        if (documentMetadata.getRepositoryUniqueId() != null) {
            xo.getSlots().add(XDSFactory.createSlot("repositoryUniqueId", documentMetadata.getRepositoryUniqueId()));
        }
        if (documentMetadata.getServiceStartTime() != null) {
            xo.getSlots().add(XDSFactory.createSlot("serviceStartTime", documentMetadata.getServiceStartTime()));
        }
        if (documentMetadata.getServiceStopTime() != null) {
            xo.getSlots().add(XDSFactory.createSlot("serviceStopTime", documentMetadata.getServiceStopTime()));
        }
        if (StringUtils.isNotBlank((String)documentMetadata.getSourcePatientId().toString())) {
            xo.getSlots().add(XDSFactory.createSlot("sourcePatientId", documentMetadata.getSourcePatientId().toString()));
        }
        if (StringUtils.isNotBlank((String)documentMetadata.getDocumentClass().toString())) {
            xo.setName(XDSFactory.createInternationalString(documentMetadata.getDocumentClass().getDisplayName()));
        }
        if ((documentHash = documentMetadata.getDocumentHash()) != null && documentHash.length > 0) {
            xo.getSlots().add(XDSFactory.createSlot("hash", Base64.encodeBase64String((byte[])documentHash)));
        }
        if (documentMetadata.getDocumentSize() != null) {
            xo.getSlots().add(XDSFactory.createSlot("size", documentMetadata.getDocumentSize().toString()));
        }
        if (StringUtils.isNotBlank((String)documentMetadata.getAuthorPerson().toString()) || StringUtils.isNotBlank((String)documentMetadata.getAuthorInstitution().toString())) {
            holder2 = idClCounter;
            holder2.value = (Integer)holder2.value + 1;
            classification = XDSFactory.createClassification("urn:uuid:93606bcf-9494-43ec-9b4e-a7748d1a838d", documentMetadata.getEntryUuid(), "", (Integer)holder2.value);
            if (StringUtils.isNotBlank((String)documentMetadata.getAuthorInstitution().toString())) {
                classification.getSlots().add(XDSFactory.createSlot("authorInstitution", documentMetadata.getAuthorInstitution().toString()));
            }
            if (StringUtils.isNotBlank((String)documentMetadata.getAuthorPerson().toString())) {
                classification.getSlots().add(XDSFactory.createSlot("authorPerson", documentMetadata.getAuthorPerson().toString()));
            }
            if (StringUtils.isNotBlank((String)documentMetadata.getAuthorSpecialty())) {
                classification.getSlots().add(XDSFactory.createSlot("authorSpecialty", documentMetadata.getAuthorSpecialty()));
            }
            xo.getClassifications().add(classification);
        }
        if (documentMetadata.getDocumentClass() != null) {
            holder2 = idClCounter;
            holder2.value = (Integer)holder2.value + 1;
            classification = XDSFactory.createClassification("urn:uuid:41a5887f-8865-4c09-adf7-e362475b143a", documentMetadata.getEntryUuid(), documentMetadata.getDocumentClass().getValue(), (Integer)holder2.value);
            classification.getSlots().add(XDSFactory.createSlot("codingScheme", documentMetadata.getDocumentClass().getCodeSystem()));
            if (StringUtils.isNotBlank((String)documentMetadata.getDocumentClass().getDisplayName())) {
                classification.setName(XDSFactory.createInternationalString(documentMetadata.getDocumentClass().getDisplayName()));
            }
            xo.getClassifications().add(classification);
        }
        holder2 = idClCounter;
        holder2.value = (Integer)holder2.value + 1;
        classification = XDSFactory.createClassification("urn:uuid:f4f85eac-e6cb-4883-b524-f2705394840f", documentMetadata.getEntryUuid(), "1.3.6.1.4.1.21367.2006.7.101", (Integer)holder2.value);
        classification.getSlots().add(XDSFactory.createSlot("codingScheme", documentMetadata.getConfidentialityCode().getCodedValue().getCodeSystem()));
        classification.setName(XDSFactory.createInternationalString(documentMetadata.getConfidentialityCode().getCodedValue().getDisplayName()));
        xo.getClassifications().add(classification);
        if (documentMetadata.getFormatCode() != null) {
            holder2 = idClCounter;
            holder2.value = (Integer)holder2.value + 1;
            classification = XDSFactory.createClassification("urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d", documentMetadata.getEntryUuid(), documentMetadata.getFormatCode().getValue(), (Integer)holder2.value);
            classification.getSlots().add(XDSFactory.createSlot("codingScheme", documentMetadata.getFormatCode().getCodeSystem()));
            classification.setName(XDSFactory.createInternationalString(documentMetadata.getFormatCode().getDisplayName()));
            xo.getClassifications().add(classification);
        }
        if (documentMetadata.getHealthcareFacilityType() != null) {
            holder2 = idClCounter;
            holder2.value = (Integer)holder2.value + 1;
            classification = XDSFactory.createClassification("urn:uuid:f33fb8ac-18af-42cc-ae0e-ed0b0bdb91e1", documentMetadata.getEntryUuid(), documentMetadata.getHealthcareFacilityType().getValue(), (Integer)holder2.value);
            classification.getSlots().add(XDSFactory.createSlot("codingScheme", documentMetadata.getHealthcareFacilityType().getCodeSystem()));
            if (StringUtils.isNotBlank((String)documentMetadata.getHealthcareFacilityType().getDisplayName())) {
                classification.setName(XDSFactory.createInternationalString(documentMetadata.getHealthcareFacilityType().getDisplayName()));
            }
            xo.getClassifications().add(classification);
        }
        if (documentMetadata.getPracticeSetting() != null) {
            holder2 = idClCounter;
            holder2.value = (Integer)holder2.value + 1;
            classification = XDSFactory.createClassification("urn:uuid:cccf5598-8b07-4b77-a05e-ae952c785ead", documentMetadata.getEntryUuid(), documentMetadata.getPracticeSetting().getValue(), (Integer)holder2.value);
            classification.getSlots().add(XDSFactory.createSlot("codingScheme", documentMetadata.getPracticeSetting().getCodeSystem()));
            if (StringUtils.isNotBlank((String)documentMetadata.getPracticeSetting().getDisplayName())) {
                classification.setName(XDSFactory.createInternationalString(documentMetadata.getPracticeSetting().getDisplayName()));
            }
            xo.getClassifications().add(classification);
        }
        if (StringUtils.isNotBlank((String)commonHeader.getIhiNumber())) {
            holder = idEiCounter;
            holder.value = (Integer)holder.value + 1;
            externalId = XDSFactory.createExternalIdentifier("urn:uuid:58a6f841-87b3-4a3e-92fd-a8ffeff98427", documentMetadata.getEntryUuid(), "XDSDocumentEntry.patientId", documentMetadata.getPatientId().toString(), (Integer)holder.value);
            xo.getExternalIdentifiers().add(externalId);
        }
        if (StringUtils.isNotBlank((String)documentMetadata.getEntryUuid())) {
            holder = idEiCounter;
            holder.value = (Integer)holder.value + 1;
            externalId = XDSFactory.createExternalIdentifier("urn:uuid:2e82c1f6-a085-4c72-9da3-8640a32e42ab", documentMetadata.getEntryUuid(), "XDSDocumentEntry.uniqueId", documentMetadata.getUniqueId(), (Integer)holder.value);
            xo.getExternalIdentifiers().add(externalId);
        }
        if (documentMetadata.hasKeywords()) {
            for (String keyword : documentMetadata.getKeywords()) {
                Holder<Integer> holder3 = idClCounter;
                holder3.value = (Integer)holder3.value + 1;
                classification = XDSFactory.createClassification("urn:uuid:2c6b8cb7-8b2a-4051-b291-b1ae6a575ef4", documentMetadata.getEntryUuid(), keyword, (Integer)holder3.value);
                classification.getSlots().add(XDSFactory.createSlot("codingScheme", "NA"));
                classification.setName(XDSFactory.createInternationalString(keyword));
                xo.getClassifications().add(classification);
            }
        }
        if (documentMetadata.getDocumentClass() != null) {
            holder2 = idClCounter;
            holder2.value = (Integer)holder2.value + 1;
            classification = XDSFactory.createClassification("urn:uuid:f0306f51-975f-434e-a61c-c59651d33983", documentMetadata.getEntryUuid(), documentMetadata.getDocumentType().getValue(), (Integer)holder2.value);
            classification.getSlots().add(XDSFactory.createSlot("codingScheme", documentMetadata.getDocumentClass().getCodeSystem()));
            if (StringUtils.isNotBlank((String)documentMetadata.getDocumentType().getDisplayName())) {
                classification.setName(XDSFactory.createInternationalString(documentMetadata.getDocumentType().getDisplayName()));
            }
            xo.getClassifications().add(classification);
        }
        return xo;
    }

    public static RegistryPackageType toXDSSubmissionSet(SubmissionMetadata submissionMetadata, DocumentMetadata documentMetadata, Holder<Integer> idClCounter, Holder<Integer> idEiCounter) {
        ClassificationType classification;
        Holder<Integer> holder;
        RegistryPackageType rp = new RegistryPackageType();
        rp.setObjectType("urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:RegistryPackage");
        rp.setId(submissionMetadata.getEntryUuid());
        if (submissionMetadata.getSubmissionTime() != null) {
            rp.getSlots().add(XDSFactory.createSlot("submissionTime", XDSMapper.toDateTimeString(submissionMetadata.getSubmissionTime())));
        }
        if (StringUtils.isNotBlank((String)submissionMetadata.getComments())) {
            rp.setDescription(XDSFactory.createInternationalString(submissionMetadata.getComments()));
        }
        if (StringUtils.isNotBlank((String)documentMetadata.getAuthorPerson().toString()) || StringUtils.isNotBlank((String)documentMetadata.getAuthorInstitution().toString())) {
            holder = idClCounter;
            holder.value = (Integer)holder.value + 1;
            classification = XDSFactory.createClassification("urn:uuid:a7058bb9-b4e4-4307-ba5b-e3f0ab85e12d", submissionMetadata.getEntryUuid(), "", (Integer)holder.value);
            if (StringUtils.isNotBlank((String)documentMetadata.getAuthorInstitution().toString())) {
                classification.getSlots().add(XDSFactory.createSlot("authorInstitution", documentMetadata.getAuthorInstitution().toString()));
            }
            if (StringUtils.isNotBlank((String)documentMetadata.getAuthorPerson().toString())) {
                classification.getSlots().add(XDSFactory.createSlot("authorPerson", documentMetadata.getAuthorPerson().toString()));
            }
            if (StringUtils.isNotBlank((String)documentMetadata.getAuthorSpecialty())) {
                classification.getSlots().add(XDSFactory.createSlot("authorSpecialty", documentMetadata.getAuthorSpecialty()));
            }
            rp.getClassifications().add(classification);
        }
        if (documentMetadata.getDocumentType() != null) {
            holder = idClCounter;
            holder.value = (Integer)holder.value + 1;
            classification = XDSFactory.createClassification("urn:uuid:aa543740-bdda-424e-8c96-df4873be8500", submissionMetadata.getEntryUuid(), documentMetadata.getDocumentClass().getValue(), (Integer)holder.value);
            classification.getSlots().add(XDSFactory.createSlot("codingScheme", documentMetadata.getDocumentClass().getCodeSystem()));
            if (StringUtils.isNotBlank((String)documentMetadata.getDocumentClass().getDisplayName())) {
                classification.setName(XDSFactory.createInternationalString(documentMetadata.getDocumentClass().getDisplayName()));
            }
            rp.getClassifications().add(classification);
        }
        holder = idEiCounter;
        holder.value = (Integer)holder.value + 1;
        ExternalIdentifierType externalId = XDSFactory.createExternalIdentifier("urn:uuid:96fdda7c-d067-4183-912e-bf5ee74998a8", submissionMetadata.getEntryUuid(), "XDSSubmissionSet.uniqueId", documentMetadata.getUniqueId(), (Integer)holder.value);
        rp.getExternalIdentifiers().add(externalId);
        if (StringUtils.isNotBlank((String)documentMetadata.getAuthorInstitution().toString())) {
            holder = idEiCounter;
            holder.value = (Integer)holder.value + 1;
            externalId = XDSFactory.createExternalIdentifier("urn:uuid:554ac39e-e3fe-47fe-b233-965d2a147832", submissionMetadata.getEntryUuid(), "XDSSubmissionSet.sourceId", documentMetadata.getAuthorInstitution().getOrganisationIdentifier(), (Integer)holder.value);
            rp.getExternalIdentifiers().add(externalId);
        }
        if (StringUtils.isNotBlank((String)documentMetadata.getPatientId().toString())) {
            holder = idEiCounter;
            holder.value = (Integer)holder.value + 1;
            externalId = XDSFactory.createExternalIdentifier("urn:uuid:6b5aea1a-874d-4603-a4bc-96a0a7b38446", submissionMetadata.getEntryUuid(), "XDSSubmissionSet.patientId", documentMetadata.getPatientId().toString(), (Integer)holder.value);
            rp.getExternalIdentifiers().add(externalId);
        }
        return rp;
    }

    public static AdhocQueryRequest toAdhocQueryRequest(PCEHRHeader commonHeader, String queryId, DocumentQueryParams queryParams) {
        Validate.notNull((Object)commonHeader, (String)"'commonHeader' must be specified.");
        Validate.notNull((Object)queryParams, (String)"'queryParams' must be specified.");
        Validate.notNull((Object)queryId, (String)"'queryId' must be specified.");
        AdhocQueryRequest request = new AdhocQueryRequest();
        ResponseOption responseOption = new ResponseOption();
        responseOption.setReturnComposedObjects(Boolean.TRUE);
        responseOption.setReturnType("LeafClass");
        request.setResponseOption(responseOption);
        AdhocQueryType query = new AdhocQueryType();
        query.setId(queryId);
        request.setAdhocQuery(query);
        if (StringUtils.isNotBlank((String)commonHeader.getIhiNumber())) {
            query.getSlots().add(XDSFactory.createSingleValuedSlot("$XDSDocumentEntryPatientId", String.format("%s%s", commonHeader.getIhiNumber(), "^^^&1.2.36.1.2001.1003.0&ISO")));
        }
        if (queryParams.hasAuthorIndividuals()) {
            ArrayList<String> authors = new ArrayList<String>();
            for (Author author : queryParams.getAuthorIndividuals()) {
                authors.add(author.toXCNFormatString());
            }
            query.getSlots().add(XDSFactory.createQuerySlot("$XDSDocumentEntryAuthorPerson", authors));
        }
        if (queryParams.hasDocumentTypes()) {
            query.getSlots().addAll(XDSFactory.createQuerySlots("$XDSDocumentEntryTypeCode", queryParams.getDocumentTypes()));
        }
        if (queryParams.hasDocumentClasses()) {
            query.getSlots().addAll(XDSFactory.createQuerySlots("$XDSDocumentEntryTypeCode", queryParams.getDocumentClasses()));
        }
        if (queryParams.hasTemplateIds()) {
            query.getSlots().addAll(XDSFactory.createQuerySlots("$XDSDocumentEntryFormatCode", queryParams.getTemplateIds()));
        }
        if (queryParams.getDocumentCreationTimeFrom() != null) {
            query.getSlots().add(XDSFactory.createSlot("$XDSDocumentEntryCreationTimeFrom", queryParams.getDocumentCreationTimeFrom()));
        }
        if (queryParams.getDocumentCreationTimeTo() != null) {
            query.getSlots().add(XDSFactory.createSlot("$XDSDocumentEntryCreationTimeTo", queryParams.getDocumentCreationTimeTo()));
        }
        if (queryParams.getServiceStartTimeFrom() != null) {
            query.getSlots().add(XDSFactory.createSlot("$XDSDocumentEntryServiceStartTimeFrom", queryParams.getServiceStartTimeFrom()));
        }
        if (queryParams.getServiceStartTimeTo() != null) {
            query.getSlots().add(XDSFactory.createSlot("$XDSDocumentEntryServiceStartTimeTo", queryParams.getServiceStartTimeTo()));
        }
        if (queryParams.getServiceStopTimeFrom() != null) {
            query.getSlots().add(XDSFactory.createSlot("$XDSDocumentEntryServiceStopTimeFrom", queryParams.getServiceStopTimeFrom()));
        }
        if (queryParams.getServiceStopTimeTo() != null) {
            query.getSlots().add(XDSFactory.createSlot("$XDSDocumentEntryServiceStopTimeTo", queryParams.getServiceStopTimeTo()));
        }
        if (queryParams.hasHealthcareFacilityTypes()) {
            query.getSlots().addAll(XDSFactory.createQuerySlots("$XDSDocumentEntryHealthcareFacilityTypeCode", queryParams.getHealthcareFacilityTypes()));
        }
        if (queryParams.hasClinicalSpecialties()) {
            query.getSlots().addAll(XDSFactory.createQuerySlots("$XDSDocumentEntryPracticeSettingCode", queryParams.getClinicalSpecialties()));
        }
        if (queryParams.hasKeywords()) {
            query.getSlots().add(XDSFactory.createQuerySlot("$XDSDocumentEntryEventCodeList", queryParams.getKeywords()));
        }
        if (queryParams.hasStatuses()) {
            HashSet<String> statusCodes = new HashSet<String>();
            for (DocumentStatus status : queryParams.getStatuses()) {
                statusCodes.add(status.getCode());
            }
            query.getSlots().add(XDSFactory.createQuerySlot("$XDSDocumentEntryStatus", statusCodes));
        }
        return request;
    }

    public static DocumentQueryParams getDocumentQueryParams(PCEHRHeader commonHeader, AdhocQueryRequest queryRequest) {
        List<String> keywords;
        List<CodedValue> clinicalSpecialties;
        List<CodedValue> healthcareFacilityTypes;
        String serviceStopTimeTo;
        String serviceStopTimeFrom;
        String serviceStartTimeTo;
        String serviceStartTimeFrom;
        String documentCreationTimeTo;
        String documentCreationTimeFrom;
        List<CodedValue> templateIds;
        List<CodedValue> documentTypeCodes;
        Validate.notNull((Object)commonHeader, (String)"'commonHeader' must be specified.");
        Validate.notNull((Object)queryRequest, (String)"'queryRequest' must be specified.");
        Validate.notNull((Object)queryRequest.getAdhocQuery(), (String)"'queryRequest.adhocQuery' must be specified.");
        DocumentQueryParams queryParams = new DocumentQueryParams();
        AdhocQueryType query = queryRequest.getAdhocQuery();
        String patientId = XDSMapper.getQuerySlotValue(query.getSlots(), "$XDSDocumentEntryPatientId");
        Validate.notEmpty((String)patientId, (String)String.format("'%s' must be specified in the AdhocQuery.", "$XDSDocumentEntryPatientId"));
        if (!StringUtils.equals((String)commonHeader.getIhiNumber(), (String)patientId)) {
            throw new IllegalArgumentException(String.format("The PCEHRHeader.IHINumber [%s] does not equal the %s parameter in the AdhocQuery [%s].", commonHeader.getIhiNumber(), "$XDSDocumentEntryPatientId", patientId));
        }
        List<String> authorIndividuals = XDSMapper.getQuerySlotValues(query.getSlots(), "$XDSDocumentEntryAuthorPerson");
        if (!authorIndividuals.isEmpty()) {
            for (String a : authorIndividuals) {
                Author author = new Author(a);
                queryParams.getAuthorIndividuals().add(author);
            }
        }
        if (!(documentTypeCodes = XDSMapper.getQuerySlotCodedValues(query.getSlots(), "$XDSDocumentEntryClassCode")).isEmpty()) {
            queryParams.getDocumentTypes().addAll(documentTypeCodes);
        }
        if (!(templateIds = XDSMapper.getQuerySlotCodedValues(query.getSlots(), "$XDSDocumentEntryFormatCode")).isEmpty()) {
            queryParams.getTemplateIds().addAll(templateIds);
        }
        if ((documentCreationTimeFrom = XDSMapper.getQuerySlotDateTimeValue(query.getSlots(), "$XDSDocumentEntryCreationTimeFrom")) != null) {
            queryParams.setDocumentCreationTimeFrom(documentCreationTimeFrom);
        }
        if ((documentCreationTimeTo = XDSMapper.getQuerySlotDateTimeValue(query.getSlots(), "$XDSDocumentEntryCreationTimeTo")) != null) {
            queryParams.setDocumentCreationTimeTo(documentCreationTimeTo);
        }
        if ((serviceStartTimeFrom = XDSMapper.getQuerySlotDateTimeValue(query.getSlots(), "$XDSDocumentEntryServiceStartTimeFrom")) != null) {
            queryParams.setServiceStartTimeFrom(serviceStartTimeFrom);
        }
        if ((serviceStartTimeTo = XDSMapper.getQuerySlotDateTimeValue(query.getSlots(), "$XDSDocumentEntryServiceStartTimeTo")) != null) {
            queryParams.setServiceStartTimeTo(serviceStartTimeTo);
        }
        if ((serviceStopTimeFrom = XDSMapper.getQuerySlotDateTimeValue(query.getSlots(), "$XDSDocumentEntryServiceStopTimeFrom")) != null) {
            queryParams.setServiceStopTimeFrom(serviceStopTimeFrom);
        }
        if ((serviceStopTimeTo = XDSMapper.getQuerySlotDateTimeValue(query.getSlots(), "$XDSDocumentEntryServiceStopTimeTo")) != null) {
            queryParams.setServiceStopTimeTo(serviceStopTimeTo);
        }
        if (!(healthcareFacilityTypes = XDSMapper.getQuerySlotCodedValues(query.getSlots(), "$XDSDocumentEntryHealthcareFacilityTypeCode")).isEmpty()) {
            queryParams.getHealthcareFacilityTypes().addAll(healthcareFacilityTypes);
        }
        if (!(clinicalSpecialties = XDSMapper.getQuerySlotCodedValues(query.getSlots(), "$XDSDocumentEntryPracticeSettingCode")).isEmpty()) {
            queryParams.getClinicalSpecialties().addAll(clinicalSpecialties);
        }
        if (!(keywords = XDSMapper.getQuerySlotValues(query.getSlots(), "$XDSDocumentEntryEventCodeList")).isEmpty()) {
            queryParams.getKeywords().addAll(keywords);
        }
        List<String> statusCodes = XDSMapper.getQuerySlotValues(query.getSlots(), "$XDSDocumentEntryStatus");
        Validate.notEmpty(statusCodes, (String)"'$XDSDocumentEntryStatus' must be specified in the AdhocQuery.");
        for (String statusCode : statusCodes) {
            queryParams.getStatuses().add(DocumentStatus.fromCode(statusCode));
        }
        return queryParams;
    }

    public static List<SubmissionMetadata> getSubmissionMetadata(RegistryObjectList registryObjectList) {
        Validate.notNull((Object)registryObjectList, (String)"'registryObjectList' must be specified.");
        ArrayList<SubmissionMetadata> metadata = new ArrayList<SubmissionMetadata>();
        for (JAXBElement identifiable : registryObjectList.getIdentifiables()) {
            if (!(identifiable.getValue() instanceof RegistryPackageType)) continue;
            RegistryPackageType rp = (RegistryPackageType)identifiable.getValue();
            metadata.add(XDSMapper.getSubmissionMetadata(rp));
        }
        return metadata;
    }

    public static SubmissionMetadata getSubmissionMetadata(RegistryPackageType registryPackage) {
        SubmissionMetadata sm = new SubmissionMetadata();
        sm.setSubmissionTime(XDSMapper.getSlotDate(registryPackage.getSlots(), "submissionTime"));
        sm.setComments(XDSMapper.getString(registryPackage.getDescription()));
        return sm;
    }

    private static ClassificationType getClassfication(List<ClassificationType> classifications, String classificationScheme) {
        for (ClassificationType c : classifications) {
            if (!StringUtils.equals((String)c.getClassificationScheme(), (String)classificationScheme)) continue;
            return c;
        }
        return null;
    }

    private static Slot getSlot(List<Slot> slots, String slotName) {
        for (Slot slot : slots) {
            if (!StringUtils.equals((String)slot.getName(), (String)slotName)) continue;
            return slot;
        }
        return null;
    }

    private static String getSlotValue(List<Slot> slots, String slotName) {
        Slot slot = XDSMapper.getSlot(slots, slotName);
        if (slot != null) {
            return XDSMapper.getSlotValue(slot);
        }
        return null;
    }

    private static String getSlotValue(Slot slot) {
        if (slot.getValueList() != null && !slot.getValueList().getValues().isEmpty()) {
            return (String)slot.getValueList().getValues().get(0);
        }
        return null;
    }

    private static List<String> getQuerySlotValues(Slot slot) {
        ArrayList<String> values = new ArrayList<String>();
        for (String queryValue : slot.getValueList().getValues()) {
            if (!StringUtils.isNotBlank((String)queryValue)) continue;
            if (queryValue.startsWith("('")) {
                queryValue = queryValue.substring(2);
            }
            if (queryValue.endsWith("')")) {
                queryValue = queryValue.substring(0, queryValue.length() - 2);
            }
            values.add(queryValue);
        }
        return values;
    }

    private static List<String> getQuerySlotValues(List<Slot> slots, String slotName) {
        Slot slot = XDSMapper.getSlot(slots, slotName);
        if (slot != null) {
            return XDSMapper.getQuerySlotValues(slot);
        }
        return Collections.emptyList();
    }

    private static List<CodedValue> getQuerySlotCodedValues(List<Slot> slots, String slotName) {
        Slot valueSlot = XDSMapper.getSlot(slots, slotName);
        Slot codeSystemSlot = XDSMapper.getSlot(slots, slotName + "Scheme");
        List<CodedValue> codedValues = Collections.emptyList();
        if (valueSlot != null) {
            List<String> values = XDSMapper.getQuerySlotValues(valueSlot);
            List<Object> codeSystems = Collections.emptyList();
            if (codeSystemSlot != null) {
                codeSystems = XDSMapper.getQuerySlotValues(codeSystemSlot);
            }
            codedValues = new ArrayList<CodedValue>(values.size());
            for (int i = 0; i < values.size(); ++i) {
                if (codeSystems.size() >= i + 1) {
                    codedValues.add(new CodedValue((String)codeSystems.get(i), values.get(i), null));
                    continue;
                }
                codedValues.add(new CodedValue(null, values.get(i), null));
            }
        }
        return codedValues;
    }

    private static String getQuerySlotValue(List<Slot> slots, String slotName) {
        List<String> values = XDSMapper.getQuerySlotValues(slots, slotName);
        if (!values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    private static String getQuerySlotDateTimeValue(List<Slot> slots, String slotName) {
        String value = XDSMapper.getQuerySlotValue(slots, slotName);
        if (StringUtils.isNotBlank((String)value)) {
            return DateUtils.toUtcDate(value);
        }
        return null;
    }

    private static Date getSlotDate(List<Slot> slots, String slotName) {
        String strValue = XDSMapper.getSlotValue(slots, slotName);
        if (strValue != null) {
            return MetadataUtils.parseDate(strValue);
        }
        return null;
    }

    private static String getString(InternationalStringType internationalString) {
        StringBuilder sb = new StringBuilder();
        if (internationalString != null) {
            for (LocalizedString ls : internationalString.getLocalizedStrings()) {
                if (sb.length() > 0) {
                    sb.append(LINE_SEPARATOR);
                }
                sb.append(ls.getValue());
            }
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    private static String toDateTimeString(Date date) {
        return DATETIME_FORMATTER.format(date);
    }
}

