/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.registration;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.Client;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.constant.XMLNamespaces;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.handler.ConfigurableMTOMHandler;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.CommonHeaderValidator;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.DateUtils;
import au.gov.nehta.xsp.CertificateVerifier;
import au.net.electronichealth.ns.pcehr.svc.registerpcehr._2.RegisterPCEHRPortType;
import au.net.electronichealth.ns.pcehr.svc.registerpcehr._2.RegisterPCEHRService;
import au.net.electronichealth.ns.pcehr.svc.registerpcehr._2.StandardErrorMsg;
import au.net.electronichealth.ns.pcehr.xsd.common.commoncoreelements._1.PCEHRHeader;
import au.net.electronichealth.ns.pcehr.xsd.interfaces.registerpcehr._2.RegisterPCEHR;
import au.net.electronichealth.ns.pcehr.xsd.interfaces.registerpcehr._2.RegisterPCEHRResponse;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.ws.Holder;
import org.apache.commons.lang.Validate;

public class RegisterPCEHRClient
extends Client<RegisterPCEHRPortType> {
    public RegisterPCEHRClient(SSLSocketFactory sslSocketFactory, X509Certificate x509Certificate, PrivateKey privateKey, String endpointAddress, boolean setLoggingEnabled) {
        super(RegisterPCEHRService.class, RegisterPCEHRPortType.class, sslSocketFactory, x509Certificate, privateKey, endpointAddress, setLoggingEnabled, new ConfigurableMTOMHandler("registerPCEHR", XMLNamespaces.REGISTER.getNamespace(), "signedConsentForm"));
    }

    public RegisterPCEHRClient(SSLSocketFactory sslSocketFactory, X509Certificate x509Certificate, CertificateVerifier certificateVerifier, PrivateKey privateKey, String endpointAddress, boolean setLoggingEnabled) {
        super(RegisterPCEHRService.class, RegisterPCEHRPortType.class, sslSocketFactory, x509Certificate, certificateVerifier, privateKey, endpointAddress, setLoggingEnabled, new ConfigurableMTOMHandler("registerPCEHR", XMLNamespaces.REGISTER.getNamespace(), "signedConsentForm"));
    }

    public final RegisterPCEHRResponse registerPCEHR(PCEHRHeader commonHeader, RegisterPCEHR registrationDetails) throws StandardErrorMsg {
        Validate.notNull((Object)commonHeader, (String)"'commonHeader' must be specified.");
        Validate.notNull((Object)registrationDetails, (String)"'registrationDetails' must be specified.");
        CommonHeaderValidator.validate(commonHeader, false);
        Holder responseHolder = new Holder();
        Holder signatureHolder = null;
        ((RegisterPCEHRPortType)this.getPort()).registerPCEHR(registrationDetails, responseHolder, DateUtils.generateTimestamp(), signatureHolder, commonHeader);
        return (RegisterPCEHRResponse)responseHolder.value;
    }
}

