/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.template;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.Client;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.TemplateServiceRequestorOption;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.CommonHeaderValidator;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.DateUtils;
import au.gov.nehta.xsp.CertificateVerifier;
import au.net.electronichealth.ns.pcehr.xsd.common.commoncoreelements._1.PCEHRHeader;
import au.net.electronichealth.ns.tplt.svc.gettemplate._1.GetTemplatePortType;
import au.net.electronichealth.ns.tplt.svc.gettemplate._1.GetTemplateService;
import au.net.electronichealth.ns.tplt.svc.gettemplate._1.StandardErrorMsg;
import au.net.electronichealth.ns.tplt.xsd.interfaces.gettemplate._1.GetTemplate;
import au.net.electronichealth.ns.tplt.xsd.interfaces.gettemplate._1.GetTemplateResponse;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.ws.Holder;
import org.apache.commons.lang.Validate;

public final class GetTemplateClient
extends Client<GetTemplatePortType> {
    public GetTemplateClient(SSLSocketFactory sslSocketFactory, X509Certificate x509Certificate, PrivateKey privateKey, String endpointAddress, boolean setLoggingEnabled) {
        super(GetTemplateService.class, GetTemplatePortType.class, sslSocketFactory, x509Certificate, privateKey, endpointAddress, setLoggingEnabled);
    }

    public GetTemplateClient(SSLSocketFactory sslSocketFactory, X509Certificate x509Certificate, CertificateVerifier certificateVerifier, PrivateKey privateKey, String endpointAddress, boolean setLoggingEnabled) {
        super(GetTemplateService.class, GetTemplatePortType.class, sslSocketFactory, x509Certificate, certificateVerifier, privateKey, endpointAddress, setLoggingEnabled);
    }

    public GetTemplateResponse getTemplate(PCEHRHeader commonHeader, String templateId, TemplateServiceRequestorOption requestorOption) throws StandardErrorMsg {
        Validate.notNull((Object)commonHeader, (String)"'commonHeader' must be specified.");
        Validate.notEmpty((String)templateId, (String)"'templateId' must be specified.");
        Validate.notNull((Object)((Object)requestorOption), (String)"'requestorOption' must be specified.");
        CommonHeaderValidator.validate(commonHeader, false);
        return this.getTemplate(commonHeader, templateId, requestorOption.name());
    }

    public GetTemplateResponse getTemplate(PCEHRHeader commonHeader, String templateId, String requestorOption) throws StandardErrorMsg {
        Validate.notNull((Object)commonHeader, (String)"'commonHeader' must be specified.");
        Validate.notEmpty((String)templateId, (String)"'templateId' must be specified.");
        Validate.notNull((Object)requestorOption, (String)"'requestorOption' must be specified.");
        CommonHeaderValidator.validate(commonHeader, false);
        Holder responseHolder = new Holder();
        Holder signatureHolder = null;
        GetTemplate getTemplate = new GetTemplate();
        getTemplate.setTemplateID(templateId);
        getTemplate.setServiceRequestorOption(requestorOption);
        ((GetTemplatePortType)this.getPort()).getTemplate(getTemplate, responseHolder, DateUtils.generateTimestamp(), signatureHolder, commonHeader);
        return (GetTemplateResponse)responseHolder.value;
    }
}

