/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.constant;

public enum DateParsePatterns {
    YEAR("yyyy", "yyyy"),
    YEAR_MONTH("yyyyMM", "yyyyMM"),
    YEAR_MONTH_DAY("yyyyMMdd", "yyyyMMdd"),
    YEAR_MONTH_DAY_HOUR("yyyyMMddHH", "yyyyMMddHH"),
    YEAR_MONTH_DAY_HOUR_MINUTE("yyyyMMddHHmm", "yyyyMMddHHmm"),
    YEAR_MONTH_DAY_HOUR_MINUTE_SECOND("yyyyMMddHHmmss", "yyyyMMddHHmmss"),
    YEAR_MONTH_DAY_HOUR_MINUTE_SECOND_MILLISECOND("yyyyMMddHHmmss.SSSS", "yyyyMMddHHmmss'.'SSSS");

    private final String matchPattern;
    private final String patternValue;

    private DateParsePatterns(String matchPattern, String patternValue) {
        this.matchPattern = matchPattern;
        this.patternValue = patternValue;
    }

    public String getMatchPattern() {
        return this.matchPattern;
    }

    public String getPatternValue() {
        return this.patternValue;
    }

    public int getMatchPatternLength() {
        return this.matchPattern.length();
    }

    public int getPatternValueLength() {
        return this.patternValue.length();
    }

    public static DateParsePatterns findByMatchPatternLength(String matchPattern) {
        for (DateParsePatterns v : DateParsePatterns.values()) {
            if (v.getMatchPatternLength() != matchPattern.length()) continue;
            return v;
        }
        throw new IllegalArgumentException(String.format("'matchPattern' - %s does not match an expected match pattern length.", matchPattern.length()));
    }

    public static DateParsePatterns findByPatternValueLength(String patternValue) {
        for (DateParsePatterns v : DateParsePatterns.values()) {
            if (v.getPatternValueLength() != patternValue.length()) continue;
            return v;
        }
        throw new IllegalArgumentException(String.format("'patternValue' - %s does not match an expected pattern value length.", patternValue.length()));
    }

    public static DateParsePatterns findByMatchPattern(String matchPattern) {
        for (DateParsePatterns v : DateParsePatterns.values()) {
            if (v.getMatchPattern().compareTo(matchPattern) != 0) continue;
            return v;
        }
        throw new IllegalArgumentException(String.format("'matchPattern' - %s does not match an expected match pattern.", matchPattern));
    }

    public static DateParsePatterns findByPatternValue(String patternValue) {
        for (DateParsePatterns v : DateParsePatterns.values()) {
            if (v.getPatternValue().compareTo(patternValue) != 0) continue;
            return v;
        }
        throw new IllegalArgumentException(String.format("'patternValue' - %s does not match an expected pattern value.", patternValue));
    }
}

